%Copyright (2005) by Alexander Karaivanov
%==========================================
%Main program that computes the MLE scores to use for Vuong test
%============================================
%(a) loads a vector of MLE estimates - MLEpar.mat
%(b) evaluates the likelihood to compute the MLE scores
%==================================
%data files used: Datmle2.mat (main Thai dataset); eduls.mat (education
%spline - see paper)
%functions called: mlescore.m
%output: MLEsc.mat - vector of scores

clear all

load Datmle2     %Thai data - structure file S. S(1) is whole sample, S(2) is Central region, S(3) is NE region

for i=[1]    %pick stratification to estimate: 1-WS, 2-C, 3-NE, 4-below med. wealth, 5-above med. wealth
   
eval(['load MLEpar',num2str(i)]);       %load MLE estimates

%for lines below - see descriptions in mainMLE.m
mw=max(S(1).bsp);
A=S(i).bsp/mw;
E=S(i).bus;

load eduls
edu=eduls;

global zzq ppp j1 j2 q L1 zzq1 br

%Assign the rest of the parameters (see paper) - uncomment if necessary
param1=[zzq1,1,0.92248,0.06,0.124684];         %mor.haz. "income" spec.

%param1=[zzq1,1,1.295,0.06,0.124684];          %mor.haz. "% entrepreneur" spec.
%param1=[0,zzq1,1,1.295,0.06,0.124684];        %mor.haz. "%entr.", risk neutral
%param1=[0,zzq1,1,0.92248,0.06,0.124684];      %mor.haz. "income", risk neutral          
%param1=[zzq1(1:4),1,zzq1(5:7)];              %mor.haz. "estimated delta"

%param1=[zzq1(1:4),1,0.92248,0.06,0.124684,zzq1(5)];  %lim. liab. "income"
%add the rest by same logic as mor. haz. if needed

%Compute the MLE scores at the parameter vector             
lvec=feval('mlescore',param0,A,E,edu);

eval(['save MLEsc',num2str(i),' lvec']);    %save results
end







