%Copyright (2005) by Alexander Karaivanov
%this function performs a Vuong test for two model regimes

%inputs: strMLEsc files for 2 regimes generated by scores_join.m

%output: Vuong test statistics (see Vuong paper)
%CV - Z-stats
%prob - p-values (Normal)
%probchi - p-values (Chi^2)
%vstat - variance stats

clear all

%load the score vectors (replace file names if necessary)
load strMLEsc1
strA=str;
load strMLEsc2
strB=str;

for i=1:3           %set of stratifications - change as needed
    L1=strB(i).lv;
    L2=strA(i).lv;  
  
    %normalized likelihood values
    L1v(i)=sum(L1)/length(L1);
    L2v(i)=sum(L2)/length(L2);

    N(i)=length(L1);

    O(i)= sum((L2-L1).^2)/N(i)-(sum(L2-L1)/N(i))^2;

    LR(i)= sum(L2-L1);

    %The Vuong z-statistic
    CV(i)=N(i)^(-.5)*LR(i)/sqrt(O(i));

    %Normal p-values
    prob(i)=2*normcdf(-abs(CV(i)));

    %Chi^2 p-values (optional)
    %probchi(i)=chi2cdf(vstat(i),12);
    %vstat(i)=N(i)*O(i);
    %pchi(i)=1-chi2cdf(2*abs(LR(i)),1);
end
