%Copyright (2005) Alexander Karaivanov
%code that computes the linear program for the lim.liab. case
%called by: mlestep2.m
%calls: linprog (Matlab LP routine - slow) or lpcplex (CPLEX routine - fast but commercial!)

%inputs: 
%eta - talent random variable, eta (see paper)
%AA - wealth grid, edu - education
%output: F - probability of business, weighted by normal pdf

function [F]=lpcomputeLL(eta,AA,edu)

global  g g2 ka qqmax ww r l del0 del1 del2 la

%grid bounds
kmax=5;         %max capital
zmax=5;         %max effort
zmin=10^-4;     %min effort
cmax=10;        %max consumption

%Grid sizes
nk=16;      %capital
nz=10;      %effort
nq=2;       %output
nc=10;      %consumption
n=nk*nz*nq*nc;      %overall dimension

t=exp(del0+del1*log(AA)+del2*log(edu+1)+eta);   %construct talent variable

%Construct the grids
gridk=[0,logspace(-4,log10(la*AA),nk-1)];   %capital
gridz=linspace(zmin,zmax,nz);       %effort
gridc=linspace(10^-8,cmax,nc);      %consumption

qmax = qqmax*t;         %high output - ents
w = qqmax;              %high output - workers

options=optimset('Display','off','TolFun',10^-9,'MaxIter',150,'TolX',10^-8);

%output grids
gridqw=[0,w];
gridqe=[0,qmax];

%Create the vectors - see MHmatlab.pdf write-up
cc=kron(ones(1,nk*nz*nq),gridc)';  %consumptions

qq=[kron(ones(1,nz),kron(gridqw,ones(1,nc))),...
        kron(ones(1,nz*(nk-1)),kron(gridqe,ones(1,nc)))]';  %outputs

zz=kron(ones(1,nk),kron(gridz,ones(1,nc*nq)))';     %efforts
zz2=kron(ones(1,nk-1),gridz)';

kk=kron(gridk,kron(1,ones(1,nc*nq*nz)))';        %capital
kk2=kron(gridk(2:nk),kron(1,ones(1,nz)))';

uu=(1-g)^-1*cc.^(1-g)-ka*(g2^-1)*zz.^g2;  %utilities

prt=(kk2.^l.*zz2.^(1-l))./(1+kk2.^l.*zz2.^(1-l));   %prob. of success - ents
ppe=[1-prt,prt]';

ppw=[1-gridz./(1+gridz);gridz./(1+gridz)];  %prob. of success - workers

%construct the production function (probabilities)
pp=zeros(n,1);
pp(1:nq*nz*nc)=kron(ppw(:),ones(nc,1));
pp(nc*nz*nq+1:n)=kron(ppe(:),ones(nc,1));

%Constructing the constraints
%1. Zero profit constraint (equality)
zp=(cc-qq-r*(AA-kk))';	%coefs on the ZPC

%2. Adding up constraint (equality)
au=ones(1,n);

%3. Mother nature constraints (nq*nz*nk) (equalities)
%preparation
tm2=repmat(nc*nq*[0:nk*nz-1],nq,1);
ppos11=tm2(:);
ppos3=nc*[0:nq*nz*nk-1]';

for j=1:nk*nz*nq
   pos3=ppos3(j);
   pos1=ppos11(j);
    MN(j,:)=sparse([zeros(1,pos3),ones(1,nc),zeros(1,n-nc-pos3)]-...
            [zeros(1,pos1),pp(pos3+1)*ones(1,nc*nq),zeros(1,n-nc*nq-pos1)]);
end

%Constructing the vector of free coefs b
beq=[0;1;zeros(nk*nz*nq,1)];        %only equality consraints

%Constructing the matrix of coefs on pi's
Aeq=[zp;au;MN];      %equality constr.

%the objective (the LP problem is min)
f=-uu;

%Actual linear programming
%Can use either Matlab's linprog or CPLEX - results may differ a little

x0=zeros(n,1);

%matrices used by CPLEX
A1=[Aeq];
b1=[beq];
le=[];

%if use linprog
%[x,fval,eflag,nnn,lagr]=linprog(f,[],[],Aeq,beq,zeros(n,1),ones(n,1),[],options);
%the pi's (from the paper) are in the vector x (here)

%if use cplex
[v1,x,lambda,flag1,colstat,it] = lpcplex(f,A1,b1,zeros(n,1),ones(n,1),le); 

%compute prob. of business implied by LP solution
prob=1-sum(x(1:nc*nq*nz));

F=prob.*normpdf(eta,0,1);       %weight by normal pdf for the quadrature
