%Copyright (2005) by Alexander Karaivanov
%==========================================
%Main program that does the ML estimation
%============================================
%(a) loads a vector of parameters (also can be given directly) - in_guess.mat
%(b) loads the data
%(c) iterates on a likelihood maximization routine to find MLE estimates
%==================================
%data files used: Datmle2.mat (main Thai dataset); eduls.mat (education spline - see paper)
%functions called: mlestep1.m
%output: MLEpar.mat - vector of estimates

clear all

load Datmle2      %Thai data - structure file S. S(1) is whole sample, S(2) is Central region, S(3) is NE region

for i1=[1];         %pick stratification to estimate: 1-WS, 2-C, 3-NE, 4-below med. wealth, 5-above med. wealth

eval(['load in_guess',num2str(i1)])    %initial guess, obtained from grid search
%the file in_guess should contain 2 variables:
%1. vector, zzq1 of size 1x4 for the mor. haz. regime or 1x5 for lim. liab.
%1x3 or 1x4 respectively for risk neutral
%2. likelihood value, L1
%order of parameters: gamma1, gamma2, kappa, alpha, (lambda, for LL only)

mw=max(S(1).bsp);       %max wealth in data

A=S(i1).bsp/mw;         %normalize wealth on [0,1], S(i1).bsp is wealth 

E=S(i1).bus;            %occupational status

load eduls              %education spline (see paper)
edu=eduls;

global zzq ppp j1 j2 q L1 zzq1 br
options=optimset('display','iter','maxiter',300,'maxfunevals',300);
br=0;

disp(L1)        %display initial LL

param0=zzq1     %display initial parameters

%Call the MLE routine, maximization done by "amoeba" simplex method (see
%paper)
         
[x,fval]=fminsearch('mlestep1',param0,options,A,E,edu);
     
load par_est      %get current best param. estimate (zzq1) and LL (L1), saved in mlestep1

eval(['save MLEpar',num2str(i1),' L1 zzq1'])        %save the estimates and LL
end













