%Copyright (2005) by Alexander Karaivanov
%==========================================
%Main program that generates simulated data at given parameters (expected
%values of consumption, effort, investment, etc) for each wealth
%============================================
%(a) loads a vector of MLE estimates - MLEpar.mat
%(b) generates simulated data - SIMmat.mat
%==================================
%data files used: Datmle2.mat (main Thai dataset); eduls.mat (education spline - see paper)
%functions called: simcomputeMH.m (for mor.haz.) or simcomputeLL.m (for lim.liab)
%output: SIMmat.mat - matrix of simulated data

%NOTE: see mainMLE.m, mlestep1.m, mlestep2.m for instructions on many of the lines that follow
%(they are the same)
clear all

load Datmle2        %Thai data

for yy=[1]      %data stratifications to compute

mw=max(S(1).bsp);
AA=S(yy).bsp/mw;        %normalized wealth
E=S(yy).bus;            %occ. status, 1=entrepreneur, 0=worker
edu=S(yy).edy;          %education level

clear datvec
eval(['load MLEpar',num2str(yy)])    %vector of MLE estimates - zzq1; separate file for each stratification
%eval(['load in_guessMH',num2str(yy)])    %vector of MLE estimates - zzq1; separate file for each stratification

Par=[zzq1(1:4),1,0.92248,0.06,0.124684];             %mor.haz. "income" spec.; see mlestep1.m for how to do other cases
%Par=[zzq1(1:4),1,0.92248,0.06,0.124684,zzq1(5)];    %lim. liab. "income"


global  g g2 ka qqmax r l m kk1 ww del0 del1 del2 la

%Assign parameters
r = 1.1;        %interest rate

g = max(0,Par(1));      %gamma1
g2 =max(1,Par(2));      %gamma2
ka =max(0,Par(3));      %kappa
l=Par(4);               %alpha
qqmax=Par(5);           %output if success
del0=Par(6);            %delta0
del1=Par(7);            %delta1
del2=Par(8);            %delta2

%la=max(0,Par(9));       %lambda (for lim. liab. only! - comment otherwise)

%Loop over all agents 
for j=1:length(AA)
    A=AA(j);
    edj=edu(j);

    %Display progress
    if j/50==floor(j/50)
    disp(j)
    end
   
   arg=0;       %evaluate at expected talent - i.e. set eta=0 (see paper)
   
   [ek,ez,ec,epr,eu,euc,icc]=simcomputeMH(arg,A,edj);       %replace with simcomputeLL if lim.liab.
   %this function returns simulated expected values of all variables (see
   %code for description)
   
   etal=exp(del0+del1*log(A)+del2*log(edj+1));      %expected talent
   
   datvec(j,:)=[A,etal,ek,ez,ec,epr,eu,euc,icc];   %stack up simulated data for current person
end

eval(['save SIMmat',num2str(yy),' datvec Par'])      %save output, separate file for each stratification

end
