%Copyright (2005) by Alexander Karaivanov
%function that computes the MLE score vector to be used in the Vuong test
%called by: MLEtest1.m
%calls: mlestep2.m
%inputs: param - current MLE estimates; A,E,edu - data on wealth,
%occupation, education

function[lvec]=mlescore(param,A,E,edu)
global zzq j1 j2 ppp L1 zzq1 br kkk

zzq=param;

%see the descriptions in mlestep1.m for details on the lines below
ppp=mlestep2(param,edu);        %spline

j1=ppval(ppp,A(E==1));
j2=1-ppval(ppp,A(E==0));

j1(j1<=0)=10^-6;
j2(j2<=0)=10^-6;
j1(j1>1)=1;
j2(j2>1)=1;


L=ones(1,sum(E))*(log(j1))+ones(1,sum(1-E))*log(j2);
L=L/length(A);

%compute the score vectors
lvec(E==1)=log(j1);
lvec(E==0)=log(j2);
lvec=lvec';

%visualization/check
disp('params&Result')
disp(param)
disp(L)









