%Copyright (2005) Alexander Karaivanov
%MLE maximization routine step 1
%called by: mainMLE.m
%calls: mlestep2.m

%inputs: 
%param - current parameters at which MLE is computed
%A, E, edu - data on wealth, occ. status, education
%output: L - log likelihood value


function [L]=mlestep1(param,A,E,edu)
global zzq j1 j2 ppp br L1 zzq1

zzq=param;      %current parameters

%Assign the rest of the parameters (see paper) - uncomment if necessary
param1=[param,1,0.92248,0.06,0.124684];         %mor.haz. "income" spec.

%param1=[param,1,1.295,0.06,0.124684];          %mor.haz. "% entrepreneur" spec.
%param1=[0,param,1,1.295,0.06,0.124684];        %mor.haz. "%entr.", risk neutral
%param1=[0,param,1,0.92248,0.06,0.124684];      %mor.haz. "income", risk neutral          
%param1=[param(1:4),1,param(5:7)];              %mor.haz. "estimated delta"

%param1=[param(1:4),1,0.92248,0.06,0.124684,param(5)];  %lim. liab. "income"
%add the rest by same logic as mor. haz. if needed

%call second stage MLE routine that computes the probability of entrepreneurship spline on wealth (see paper)
ppp=mlestep2(param1,edu);

%evaluate the spline at all wealths for ents (E=1) and workers (E=0) -
%generate probability of being in business for each A predicted by the model
j1=ppval(ppp,A(E==1));
j2=1-ppval(ppp,A(E==0));

%eliminate impossible events
j1(j1<=0)=10^-6;
j2(j2<=0)=10^-6;
j1(j1>1)=1;
j2(j2>1)=1;

%construct the log likelihood
L=ones(1,sum(E))*log(j1)+ones(1,sum(1-E))*log(j2);
L=-L/length(A)      %normalize the LL

%store current best
if L<L1
L1=L;
zzq1=zzq;
end

br=br+1;        %iteration counter

%Display on-going information on screen
disp(['This iteration, no. ',num2str(br)])
disp(L)
disp('Current min is:')
disp(L1);
disp(['Current Params' 'Optimal Params'])
disp([param' zzq1'])

save par_est br L1 zzq1         %save current best









