%Copyright (2005) Alexander Karaivanov
%MLE maximization routine step 2
%called by: mlestep1.m
%calls: lpcomputeMH.m - for mor.haz. (or lpcomputeLL for lim. liab.), glw.m

%inputs: 
%Par - current parameters at which MLE is computed
%edu - education spline values
%output: pp - spline of prob. of entrepreneurship

function[pp]=mlestep2(Par,edu)

global  g g2 ka qqmax r l m kk1 ww del0 del1 del2 la

%Assign parameter values
r = 1.1;        %interest rate

g = max(0,Par(1));      %gamma1
g2 =max(1,Par(2));      %gamma2
ka =max(0,Par(3));      %kappa
l=Par(4);               %alpha
qqmax=Par(5);           %output if success
del0=Par(6);            %delta0
del1=Par(7);            %delta1
del2=Par(8);            %delta2

%la=max(0,Par(9));       %lambda (for lim. liab. only! - comment otherwise)

np=20;      %number of points in the wealth spline

AA=logspace(-4,0,np)';      %wealth spline grid

q=zeros(length(AA),1);

%loop over each wealth point
for j=1:length(AA)
    A=AA(j);
    edj=edu(j);
  
  %Gauss-Legendre quadrature to compute expected prob. of business
  %integrating over talent
    aa=-3;      %lower bound
    bb=3;       %upped bound
    nn=5;       %number of nodes

[xi,wi]=glw(nn);    %GL weights and nodes

xi=sort(xi);
su=0;

%Call the linear programming routine for each wealth/talent combo
for i=1:nn
    arg=(xi(i)+1)*(bb-aa)/2+aa;        %value for talent eta
    su=su+wi(i)*lpcomputeMH(arg,A,edj);   %sum to compute the integral (change to lpcomputeLL for lim.liab)
end

%Gauss-Legendre quadrature
q(j)=((bb-aa)/2)*su;

end

pp=spline(AA,q);        %generate the spline on the wealth grid

