%Copyright (2005) Alexander Karaivanov
%code that computes the linear program for the lim.liab. case and generates
%simulated data (expected values)
%called by: mainsim.m
%calls: linprog (Matlab LP routine - slow) or lpcplex (CPLEX routine - fast but commercial!)

%inputs: 
%eta - talent random variable, eta (see paper)
%AA - wealth, edu - education
%outputs: ek - expected investment, ez - expected effort, ec - exp. cons.,
%epr - exp. prob. of business, eu - exp. utility, euc - exp. utility (cons.
%part only), icc - empty

%NOTE: this program is very similar to lpcomputeLL.m - see there for more
%details

function [ek,ez,ec,epr,eu,euc,icc]=simcomputeLL(eta,AA,edu)

global  g g2 ka qqmax ww r l del0 del1 del2 la

kmax=5;
zmax=5;
zmin=10^-4;
cmax=10;

%Grid sizes
nk=16;      
nz=10;
nq=2;  
nc=10;     

t=exp(del0+del1*log(AA)+del2*log(edu+1)+eta);       %talent

gridk=[0,logspace(-4,log10(la*AA),nk-1)];       %

n=nk*nz*nq*nc;

gridz=linspace(zmin,zmax,nz);
gridc=linspace(10^-8,cmax,nc);

qmax = qqmax*t;
w = qqmax;

options=optimset('Display','off','TolFun',10^-9,'MaxIter',150,'TolX',10^-8);

gridqw=[0,w];
gridqe=[0,qmax];

%Create the vectors
cc=kron(ones(1,nk*nz*nq),gridc)';  %consumptions

qq=[kron(ones(1,nz),kron(gridqw,ones(1,nc))),...
        kron(ones(1,nz*(nk-1)),kron(gridqe,ones(1,nc)))]';

zz=kron(ones(1,nk),kron(gridz,ones(1,nc*nq)))';
zz2=kron(ones(1,nk-1),gridz)';

kk=kron(gridk,kron(1,ones(1,nc*nq*nz)))';
kk2=kron(gridk(2:nk),kron(1,ones(1,nz)))';

uu=(1-g)^-1*cc.^(1-g)-ka*(g2^-1)*zz.^g2;  %utilities
uuc=(1-g)^-1*cc.^(1-g);

prt=(kk2.^l.*zz2.^(1-l))./(1+kk2.^l.*zz2.^(1-l));

ppe=[1-prt,prt]';
ppw=[1-gridz./(1+gridz);gridz./(1+gridz)];

pp=zeros(n,1);

pp(1:nq*nz*nc)=kron(ppw(:),ones(nc,1));
pp(nc*nz*nq+1:n)=kron(ppe(:),ones(nc,1));

%Constructing the constraints
%1. Zero profit constraint (equality)
zp=(cc-qq-r*(AA-kk))';

%2. Adding up constraint (equality)
au=ones(1,n);

%3. Mother nature constraints (nq*nz*nk) (equalities)
tm2=repmat(nc*nq*[0:nk*nz-1],nq,1);
ppos11=tm2(:);
ppos3=nc*[0:nq*nz*nk-1]';

for j=1:nk*nz*nq
   pos3=ppos3(j);
   pos1=ppos11(j);
    MN(j,:)=sparse([zeros(1,pos3),ones(1,nc),zeros(1,n-nc-pos3)]-...
            [zeros(1,pos1),pp(pos3+1)*ones(1,nc*nq),zeros(1,n-nc*nq-pos1)]);
end

%Constructing the vector of free coefs b
beq=[0;1;zeros(nk*nz*nq,1)];

%Constructing the matrix of coefs on pi's
Aeq=[zp;au;MN];

%Actual linear programming
x0=zeros(n,1);

%needed for CPLEX
A1=[Aeq];
b1=[beq];
le=[];

f=-uu;

%if use liprog
%[x,fval,eflag,nnn,lambda]=linprog(f,[],[],Aeq,beq,zeros(n,1),ones(n,1),[],options);

%if use cplex
[v1,x,lambda,flag1,colstat,it] = lpcplex(f,A1,b1,zeros(n,1),ones(n,1),le); 

%COMPUTE EXPECTED VALUES of simulated data (expectation taken over
%lotteries at lin.prog. solution - i.e. over the pi's)
%the pi's (from the paper) are in the vector x (here)
ek=kk'*x;           %investment
ez=zz'*x;           %effort
ec=cc'*x;           %consumption
epr=1-sum(x(1:nc*nq*nz));  %prob. of being entrepreneur
eu=uu'*x;           %expected utility
euc=uuc'*x;         %Eu(c)

icc=0;  %empty, needed for function call
