/* ========================================================================= */
/* Description: main() for decoding 3D subband coefficients                  */
/* Author: Shih-Ta Hsiang                                                    */
/* Version: v0.a                                                             */
/* Last Revised: Aug. 15, 2000                                               */
/* ========================================================================= */
#include "..\\TempSub\\structN.h"
#include "general.h"
#include "image_bw.h"
#include "subband.h"
#include "ar_code.h"
#include "dwt_bitplane_enc.h"
#include "video_utils.h"
#include "ezbc_dec_3d.h"
 
 

//void ezbc3d_dec(int curr, YUVimage *pyrFrs,  videoinfo info, int mvBytes,
//				EzbcDec3d& video_dec, DECODER_TYPE& decoder)


void ezbc3d_dec(YUVimage *pyrFrs,  videoinfo info, long int total_bytes_past, long int GOP_counter)
{
  DECODER_TYPE decoder;
  long int overflow;
  static int num = 0; 
  FILE *fp_stat;

  /* IVB 2003/6/19 ------------- */
  FILE *fpbyte_budget;
  char byte_budget_name[100];
  int received_bytes;
  /* IVB 2003/6/19 ----- end --- */


  Chronometer code_time, total_time;

  total_time.start();

  


  EzbcDec3d video_dec(info, &decoder);
  SubbandCodec::setup_luts();







        //for(i = 0; i < nGOP; i++, curr += info.GOPsz){

   //printf("GOPnumber= %d\n", GOP_counter); 

 
 //   video_dec.set_byte_budget(info.GOPbytes - mvBytes );

    //sprintf(tmpname, "%s_G%02d_%02d", info.bitname, info.GOPsz, stream);

    //decoder.open_file(tmpname);
    //printf("bytes_past %d  \n", total_bytes_past);
    decoder.new_open_file(info.bitname, total_bytes_past);


    
	video_dec.decode_GOP_header();  

    video_dec.reset_pyrs();

      video_dec.initialization();
//      video_dec.reset_GOP_dec();


	/* IVB 2003/6/19 -------------------------- */
    //video_dec.set_byte_budget(info.GOPbytes );
	sprintf(byte_budget_name,"%s_bytes_received",info.bitname);
	if ((fpbyte_budget = fopen(byte_budget_name,"rb")) == NULL)
	{
		printf("cannot open %s, assuming all bytes received in EL\n",byte_budget_name);   
		video_dec.set_byte_budget(info.GOPbytes );
	}
	else
	{
		fscanf(fpbyte_budget,"%d", &received_bytes);
		video_dec.set_byte_budget(received_bytes);
		fclose(fpbyte_budget);
	}
	/* IVB 2003/6/19 ------------ end --------- */




    video_dec.decode_GOP();

	overflow = decoder.bytes_used()-info.GOPbytes;
    if(!(fp_stat = fopen(info.statname, "at+"))){
      printf("Can not open %s\n", info.statname);
	  exit(1);
	}

    //fprintf(fp_stat,
    //        "GOP %02d: coding = %d, budget = %d, overflow = %d\n",
    //         GOP_counter, decoder.bytes_used(), info.GOPbytes, overflow);
	fclose(fp_stat);

    /*printf("GOP %02d: coding = %d, budget = %d, overflow = %d\n", 
		GOP_counter, decoder.bytes_used(), info.GOPbytes, overflow);*/


    video_dec.reconstruct_subbands();

    video_dec.free_lists();

    alloc_pyr_frames(pyrFrs, info);

    video_dec.reconstruct_images(pyrFrs);

    decoder.close_file();


	SubbandCodec::delete_cxt_tables();

	num++;
    //total_time.display("\n  Total execution time (I/O included) =");
    //puts(" ");

}
/*****************************************************************************/
/*                                usage()                                    */
/*****************************************************************************/
void
usage(char *cmd)
{
  printf("\n* Usage: %s bitfile tsubprefix headfile last Kbps [mvinfofile]\n"
         , cmd);
  exit(1);
}


// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

// end of file < CodeTree.C >

