/* ========================================================================= */
/* Description: main() for encoding 3D subband coefficients                  */
/* Author: Shih-Ta Hsiang                                                    */
/* Version: v0.a                                                             */
/* Last Revised: Aug. 15, 2000                                               */
/* ========================================================================= */

#include <iostream.h>
#include "general.h"
#include "image_bw.h"
#include "..\\TempSub\\structN.h"
#include "subband.h"
#include "ar_code.h"
#include "dwt_bitplane_enc.h"
#include "video_utils.h"
#include "ezbc_enc_3d.h"


//----------------------------------------------------------------------------

//  3dezbc_enc()

//----------------------------------------------------------------------------
//void ezbc3d_enc(int curr, YUVimage *Frs, videoinfo info, float kpbs, int mvbits, char *bitname,
//		   EzbcEnc3d& video_enc, ENCODER_TYPE& encoder)
long int ezbc3d_enc(int curr, YUVimage *Frs, videoinfo info, long int GOP_counter)
{

  //  char tsubname[80];   /* prefix of temporal subband files */
//  char bitname[80];    /* prefix of the encoded bit files*/
//  char headname[80];   /* header file */
//  char *mvstatname = NULL; /* number of bytes spent for individual GOPs*/
  ENCODER_TYPE encoder;  //  EZBC0a/dwt_bitplane_enc.h:typedef  Encoder  ENCODER_TYPE; Utils/ar_code.h:class Encoder

  Chronometer code_time, total_time;


//    strcpy(tsubname, arg[1]); 
//	strcpy(bitname, arg[2]);
//    strcpy(headname, arg[3]); 
//	last = atoi(arg[4]);
//	kbps = atof(arg[5]);
//    if((numb_arg == 7))
//      mvstatname = arg[6];
//  }


  /*curr = info.start; last = info.last;
  nGOP = (last - curr + 1) / info.GOPsz;
  printf("info.GOPsz = %d\n", info.GOPsz);
  if((last - curr + 1) != (info.GOPsz * nGOP)){
    fprintf(stderr, "error:  number of frames (%d - %d) is not a multiple of GOP size\n", curr, last);
    exit(1);
  }
  if(last > info.last){
    fprintf(stderr, "error: input last frame no %d  >  info.last %d\n",
            last, info.last);
    exit(1);
  }
  */


  /*if(mvstatname){
    if(!(fp_mv = fopen(mvstatname, "rt"))){
      fprintf(stderr, "Error: can not open file %s\n", mvstatname);
      exit(1);
    }
  }else
    mvBytes = 0;*/   



  total_time.start();



  EzbcEnc3d video_enc(info, &encoder); /*"class EzbcEnc3d: public EzbcCodec3d" in ezbc_enc_3d.h, class EzbcCodec3d defined in ezbc_codec_3d.h*/
  SubbandCodec::setup_luts(); // defined in EZBC0a/dwt_bitplane_codec.h





//  for(i = 0; i < nGOP; i++, curr += info.GOPsz){

    //printf("curr= %d, GOPnumber= %d\n", curr, GOP_counter);

    /*if(mvstatname)
      mvBytes = get_mvBytes(fp_mv);*/

  
    encoder.new_open_file(info.bitname);
  
    //sprintf(tmpname, "%s_G%02d_%02d", info.bitname, info.GOPsz, GOP_counter);
    //encoder.new_open_file(tmpname);// EzbcEnc3d video_enc(info, &encoder); 

    //alloc_pyr_frames(Frs, info); //video_utils.C APR25

    //input_temp_subs(Frs, curr, tsubname, info);
    video_enc.load_images(Frs); // transform EzbcEnc3d video_enc(info, &encoder);  load_images defined in ezbc_enc_3d.C

    free_frames(Frs, info.GOPsz); //APR25



 	video_enc.set_byte_budget(info.GOPbytes);
    video_enc.encode_GOP_header();
	
	video_enc.initialization();
/*
    if(num == 0)
      video_enc.initialization();
    else
      video_enc.reset_GOP_enc();
*/




    video_enc.encode_GOP();

	video_enc.write_rd(GOP_counter, info.bitname);  //chen

    video_enc.free_lists();

    encoder.close_file();

	
	SubbandCodec::delete_cxt_tables();//same as release_3dezbc_enc() below.





    //total_time.display("\n  Total execution time (I/O included) =");
    //puts(" ");

  //encoder.close_file();
  //if(mvstatname)
  //  fclose(fp_mv);

  //DELETE_VECTOR(Frs);


  return(video_enc.get_byte_used());
}



void release_3dezbc_enc()
{
  SubbandCodec::delete_cxt_tables();
}


// = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =


/*****************************************************************************/
/*                                usage()                                    */
/*****************************************************************************/
void
usage(char *cmd)
{
  printf("\n* Usage: %s tsubprefix  bitfile headfile last Kbps [mvinfofile]\n"
         , cmd);
  exit(1);
}


// end of file < CodeTree.C >

