/* ========================================================================= */
/* Description: definition of class EzbcEnc3d                                */
/* Author: Shih-Ta Hsiang                                                    */
/* Version: v0.a                                                             */
/* Last Revised: Aug. 15, 2000                                               */
/* ========================================================================= */

#ifndef __EZBC_ENC_3D_H__
#define __EZBC_ENC_3D_H__

#include "dwt_bitplane_enc.h"
#include "ezbc_codec_3d.h"

class EzbcEnc3d: public EzbcCodec3d
{

 protected:

  int GOP_max_msb;  // chen
  long int *byte_upto_bitplane; // allocated in encode_GOP_RD_passes, released in ~EzbcEnc3d


//  long int total_byte_used;

  ENCODER_TYPE *encoder;
  ENC_SUBBAND_TREE_TYPE *encY, *encU, *encV; // typedef EncSubbandTree ENC_SUBBAND_TREE_TYPE; in EZBC0a/dwt_bitplane_enc.h

 public:
  EzbcEnc3d(void);
  EzbcEnc3d(videoinfo &info, ENCODER_TYPE *enc);
  ~EzbcEnc3d(void);
  void load_images(YUVimage *Frs);
  void initialization(void);
  void reset_GOP_enc(void);
  void encode_GOP_header(void);
  void encode_GOP_subbitplane_passes(void);
  //  void encode_GOP_single_pass(void);
  void encode_GOP_RD_passes(void); 
  void encode_GOP_RD_passes2(void); 
  void encode_GOP(void);
  void free_lists(void);
  long int get_byte_used(void) {return encoder->bytes_used();};
  void write_rd(long int GOP_counter, char *bitname);
};

#endif
