/* ========================================================================= */
/* Description: member functions for class EncSubbandTree                    */
/* Author: Shih-Ta Hsiang                                                    */
/* Version: v0.a                                                             */
/* Last Revised: Aug. 15, 2000                                               */
/* ========================================================================= */


#include <math.h>
#include <assert.h>
#include <string.h>
#include "dwt_bitplane_enc.h"

//=============================================================================
//-----------------------------------------------------------------------------

// EncSubbandTree
// class EncSubbandTree:public SubbandTreeCodec
//-----------------------------------------------------------------------------

EncSubbandTree::
EncSubbandTree(SUBBAND_TREE_TYPE *subs, ENCODER_TYPE *enc)
  : SubbandTreeCodec(subs), encoder(enc)
{
  tree_msb = subband_tree->get_max_msb();
  tree_lsb = subband_tree->get_band_ptr(0)->get_lsb();

  NEW_VECTOR(enc_subs, subband_tree->get_nband(), ENC_SUBBAND_TYPE,
            "SubbandEnc");
  int nbands = subband_tree->get_nband();
  for(int k = 0; k < nbands; k++){
    enc_subs[k].initialize(subband_tree->get_band_ptr(k), this, enc);
  }
}

void EncSubbandTree::
initialize(SUBBAND_TREE_TYPE *subs, ENCODER_TYPE *enc)
{
  SubbandTreeCodec::initialize(subs);
  encoder = enc;

  tree_msb = subband_tree->get_max_msb();  // SUBBAND_TREE_TYPE *subband_tree; 
  tree_lsb = subband_tree->get_band_ptr(0)->get_lsb();

  NEW_VECTOR(enc_subs, subband_tree->get_nband(), ENC_SUBBAND_TYPE,
             "SubbandEnc");
  int nbands = subband_tree->get_nband();

  for(int k = 0; k < nbands; k++){
    enc_subs[k].initialize(subband_tree->get_band_ptr(k), this, encoder);
  }

}
void EncSubbandTree::
reset_tree_enc(SUBBAND_TREE_TYPE *subs)
{
  reset_tree_codec(subs);
  tree_msb = subband_tree->get_max_msb();
  int nbands = subband_tree->get_nband();
  for(int k = 0; k < nbands; k++){
    enc_subs[k].reset_band_enc(subband_tree->get_band_ptr(k));
  }
}


//-----------------------------------------------------------------------------

//   enc_subbitplane_passes(void)

//-----------------------------------------------------------------------------
void EncSubbandTree::
enc_subbitplane_passes(void)
{
  assert(subband_tree);

  int n, k, i, pass_idx;
  int nbands =  subband_tree->get_nband();
  int max_msb = subband_tree->get_max_msb();
  EncSubband *enc_band;


  for(k = 0; k <nbands; k++)
    enc_subs[k].start_enc_subband();

  for(n = max_msb + EXTRA_BIT; n >= EXTRA_BIT; n--){

    for(pass_idx = 0, k = 0; k < nbands; k++){
      enc_band = &(enc_subs[k]);
      if(n < enc_band->max_bit_idx){
        enc_band->bit_idx = n;
        enc_band->cur_pass = pass_idx;
        enc_band->set_mag_mask();
        enc_band->set_bit_idx_mask();
        enc_band->update_node_cxts();
        (enc_band->*(enc_band->encode_LIP))();

        if(encoder->bytes_used() > total_byte_budget)
          return;
      }
    }

    for(pass_idx++, k = 0; k < nbands; k++){
      enc_band = &(enc_subs[k]);
      if(n < enc_band->max_bit_idx){
        enc_band->cur_pass = pass_idx;
        (enc_band->*(enc_band->encode_LIS_leaves))();
        if(encoder->bytes_used() > total_byte_budget)
          return;
      }
    }

    int lev, max_depth = enc_subs[nbands-1].qtree.depth;

    for(lev = 2; lev <= max_depth; lev++){
      for(pass_idx++, k = 0; k < nbands; k++){
        enc_band = &(enc_subs[k]);

        if((n == enc_band->max_bit_idx) && (lev == enc_band->qtree.depth)){
          enc_band->bit_idx = n;
          enc_band->cur_pass = pass_idx;
          enc_band->set_mag_mask();
          enc_band->set_bit_idx_mask();

#ifdef GET_PARENT_MODELS

    if(enc_band->par_cxt_qtree){


#ifdef INITIALIZE_SIGN_MODELS_FROM_PAR
     MODEL_TYPE *par_sign_models, *sign_models;

     sign_models =  enc_band->cxt_qtree.cxt_models +
       enc_band->cxt_qtree.sign_offset;
     par_sign_models = enc_band->par_cxt_qtree->cxt_models +
       enc_band->par_cxt_qtree->sign_offset;
     for(i = enc_band->cxt_qtree.sign_cxts - 1; i >= 0;){
       sign_models[i].reset(par_sign_models[i]);
       sign_models[i--].taub_scale();
     }
#endif

#ifdef INITIALIZE_JSIG_MODELS_FROM_PAR

     MODEL_TYPE *par_jsig_models, *jsig_models;
     int cxts, par_cxts;

     cxts = par_cxts = 0;
     for(i = enc_band->qtree.depth - 2; i >= 0; i--){
       //parent band with depth = qtree.depth - 1
       cxts += enc_band->cxt_qtree.sig_cxts[i];
       par_cxts += enc_band->par_cxt_qtree->sig_cxts[i];
       assert(cxts == par_cxts);
     }
     jsig_models = enc_band->cxt_qtree.cxt_models +
       enc_band->cxt_qtree.sig_offsets[0];
     par_jsig_models = enc_band->par_cxt_qtree->cxt_models +
       enc_band->par_cxt_qtree->sig_offsets[0];
     for(i = cxts-1; i >=0;){
       jsig_models[i].reset(par_jsig_models[i]);
       jsig_models[i--].taub_scale();
     }
#endif
    }   //par_cxt_qtree
#endif  //GET_PARENT_MODELS

#ifdef LSP_BIT_IDX
    //empty lists in the top plane
    for(i = enc_band->qtree.depth-1; i >=0; i--)
      enc_band->node_list.LSP_ids[n][i] = enc_band->node_list.LSP_end;
#endif

         (enc_band->*(enc_band->encode_sig_node))(0, lev-1); //root node


          enc_band->encode_LIS_stack();


          enc_band->coding_stats.bitplanes[n].passes[pass_idx].cumulative_bytes
            = enc_band->sub_encoder->bytes_used();

       if(encoder->bytes_used() > total_byte_budget)
         return;

        }else if((n < enc_band->max_bit_idx)&&(lev < enc_band->qtree.depth)){
          enc_band->cur_pass = pass_idx;
          enc_band->cur_lev = lev;
          (enc_band->*(enc_band->encode_cur_qtree_level))();

          if(encoder->bytes_used() > total_byte_budget)
            return;
        }

      }
    }
    // for(pass_idx++, k = 0; k < nbands; k++){
    for(pass_idx++, k = nbands - 1; k >= 0; k--){
      enc_band = &(enc_subs[k]);
      if(n <= enc_band->max_bit_idx){
        enc_band->cur_pass = pass_idx;
        (enc_band->*(enc_band->encode_LSP))();

        if(encoder->bytes_used() > total_byte_budget)
          return;
        enc_band->reset_cxt_models();
      }//if(n <= enc_band->max_bit_idx){
    }
  }
}



