void analscheme1(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info);
void analscheme2(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info);
void analscheme4(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info);




void synscheme1(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info);
void synscheme2(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info);
void synscheme4(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info);


int mc_anal(int curr, videoinfo info)
{
char name[100];
/*breakpoint*/
  switch(info.scheme){
  default:
    printf("more parameters are specified\n");
    exit(1);
  case 1:
    analscheme1(curr, info.tPyrLev, info.ywidth, info.yheight, info.cwidth, info.cheight, info);
    break;
  case 2:
    analscheme2(curr, info.tPyrLev, info.ywidth, info.yheight, info.cwidth, info.cheight, info);
    break;
  case 3:
    analscheme3(curr, info.tPyrLev, info.ywidth, info.yheight, info.cwidth, info.cheight, info);
    break;
  case 4:
    analscheme4(curr, info.tPyrLev, info.ywidth, info.yheight, info.cwidth, info.cheight, info);
    break;
  }
  

  printf("done.....................\n");
  return(0);
}



/******************************************************************************
                                 analscheme1
******************************************************************************/
void analscheme1(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info)
{
  int i, j, x, y, k, pos, half_len, dist, bi_flag;
  unsigned char *ypused, *cpused, *ypusedtemp, *cpusedtemp;  /* flag */


  float c5;

  c5 = (float)sqrt(2.);

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");

  dist = 1;
  half_len = info.GOPsz / 2;

  for(i = 0; i < nPyrLev - 1; i++){ 



    for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
    for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;





    printf("temporal pyramid level %d\n", i+1);
    for(j = 0; j < half_len; j++){
      /*block_matching(&mvtop[j+half_len], yfmv[j+half_len], pyrTemp[i][2*j+1],
                     pyrTemp[i][2*j], info, dist, info.half); APR23*/ 
		block_matching(yfmv[j+half_len], pyrTemp[i][2*j+1],
			pyrTemp[i][2*j], info, dist, info.half);


      find_uncovered_block(yfmv[j+half_len], pyrTemp[i][2*j+1], pyrTemp[i][2*j], info);
      if(j != half_len-1){
        Fore_block_matching(yfmv[j+half_len], pyrTemp[i][2*j+1], pyrTemp[i][2*j+2], info, dist, info.half);
      }
      if(PRUNE && info.ME==1){
        /*bi_flag = (j == half_len-1) ? 0 : 1;*/ /* 0: There is no bidirectional map*/
        bi_flag = 1;   /* June19 */
        /*mv_prune(&mvtop[j+half_len], yfmv[j+half_len], info, dist, info.half, bi_flag, curr, j); APR23*/
		mv_prune(yfmv[j+half_len], info, dist, info.half, bi_flag, curr, j);

      }







      for(k = 0; k < yhor*yver ; k++) ypusedtemp[k]=ypused[k];
      for(k = 0; k < chor*cver ; k++) cpusedtemp[k]=cpused[k];



      temporal_analysis(&pyrTemp[i+1][j], &pyrFrs[j+half_len],
              pyrTemp[i][2*j+1], pyrTemp[i][2*j], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, info);
      /*write_quad_tree(pyrFrs[j+half_len], info, "pyrFrs", (i*2)*10+j, yfmv[j+half_len], i, 1);*/

      if(j != half_len-1){
        for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;



        copyframe(&(pyrTemp[i][2*j+2]), &nfr, info);
        copyframe(&(pyrFrs[j+half_len]), &cfr, info);


        if(Invert == 1){
                                   /*   high         , low,    current,next*/ 
          local_temporal_analysis2(pyrFrs[j+half_len], pyrTemp[i][2*j+2], cfr, nfr, yfmv[j+half_len], ypused, cpused, info);
        }
        else{
          local_temporal_analysis(pyrFrs[j+half_len], pyrTemp[i][2*j+2], yfmv[j+half_len], ypused, cpused, info);
        }

        for(y=0; y<yver; y++){
          for(x=0; x<yhor; x++){
            pos = y*yhor + x;
            if(ypused[pos] == USED)
              pyrTemp[i][2*j+2].Y[pos] = pyrTemp[i][2*j+2].Y[pos] / c5; /* be careful !!! */
          }
        }
        if(info.cwidth && info.cheight){  /* Mar4*/
          for(y=0; y<cver; y++){
            for(x=0; x<chor; x++){
              pos = y*chor + x;
              if(cpused[pos] == USED){
                pyrTemp[i][2*j+2].U[pos] = pyrTemp[i][2*j+2].U[pos] / c5;
                pyrTemp[i][2*j+2].V[pos] = pyrTemp[i][2*j+2].V[pos] / c5;
              }
            }
          }
        }

      } /* if(j != half_len-1) */
      else{ /* June19 */

        for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];   /* get the status generated in temporal_analysis */
        for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];



        copyframe(&(pyrFrs[j+half_len]), &cfr, info);


        if(Invert == 1){          /*   high         , low            , current,previous*/
         local_temporal_analysis2(pyrFrs[j+half_len], pyrTemp[i+1][j], cfr, pyrTemp[i][2*j], yfmv[j+half_len], ypused, cpused, info); 
		 /* the low band coefficients are put in pyrTemp[i+1][j]*/

        }
        else{
          local_temporal_analysis(pyrFrs[j+half_len], nfr, yfmv[j+half_len], ypused, cpused, info);
        }
      }

#ifdef COMPUTE_CODING_GAIN
        computegain(pyrTemp[i+1][j], pyrFrs[j+half_len], info); 
#endif

      printf("j = %d\n", j);
    }
    dist *= 2;
    half_len /= 2;
  }

 /* the last level */
  printf("temporal pyramid level %d\n", nPyrLev);

  /*block_matching(&mvtop[1], yfmv[1], pyrTemp[nPyrLev - 1][1],
                     pyrTemp[nPyrLev - 1][0], info, dist, info.half); APR23 */

  block_matching(yfmv[1], pyrTemp[nPyrLev - 1][1],
                     pyrTemp[nPyrLev - 1][0], info, dist, info.half);


  find_uncovered_block(yfmv[1], pyrTemp[nPyrLev - 1][1],
                     pyrTemp[nPyrLev - 1][0], info);

  if(PRUNE && info.ME==1){
    /*bi_flag = 0;*/
    bi_flag = 1;   /* June19 */
    /*mv_prune(&mvtop[1], yfmv[1], info, dist, info.half, bi_flag, curr, 0); APR23*/
    mv_prune(yfmv[1], info, dist, info.half, bi_flag, curr, 0);


  }

  for(k = 0; k < yhor*yver ; k++) ypusedtemp[k]=UNUSED;
  for(k = 0; k < chor*cver ; k++) cpusedtemp[k]=UNUSED;

  temporal_analysis(&pyrFrs[0], &pyrFrs[1], pyrTemp[nPyrLev - 1][1], 
                    pyrTemp[nPyrLev - 1][0], yfmv[1], ypusedtemp, cpusedtemp, nPyrLev-1, info);

/* { June19 */
        for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];
        for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];


        copyframe(&(pyrFrs[1]), &cfr, info);


        if(Invert == 1){          /*   high         , low            , current,previous*/ 
         local_temporal_analysis2(pyrFrs[1], pyrFrs[0], cfr, pyrTemp[nPyrLev - 1][0], yfmv[1], ypused, cpused, info);

        }
        else{
          local_temporal_analysis(pyrFrs[j+half_len], nfr, yfmv[j+half_len], ypused, cpused, info);
        }
/* June19 } */


#ifdef COMPUTE_CODING_GAIN
		computegain(pyrFrs[0], pyrFrs[1], info);
#endif
  /*  write_quad_tree(pyrFrs[j+half_len], info, "pyrFrs", ((nPyrLev-1)*2)*10, yfmv[1], nPyrLev-1, 1);
*/
  free(ypused); free(ypusedtemp); free(cpused); free(cpusedtemp);

}



/******************************************************************************
                                 analscheme2
******************************************************************************/
/*void analscheme2(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, mvnode_ptr mvtop) APR*/
void analscheme2(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info)
{
  int i, j, k, half_len, dist, bi_flag;
  unsigned char *ypused, *cpused, *ypusedtemp, *cpusedtemp;  /* flag */
  /*float gain, pert; */
  /*  float var0 var1; */ /* were made global*/

  float c5;

  c5 = (float)sqrt(2.);

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");


  dist = 1;
  half_len = info.GOPsz / 2;

  for(i = 0; i < nPyrLev - 1; i++){
    for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
    for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;

    printf("temporal pyramid level %d\n", i+1);
    for(j = 0; j < half_len; j++){

      block_matching(yfmv[j+half_len], pyrTemp[i][2*j+1],
                     pyrTemp[i][2*j], info, dist, info.half);

      find_uncovered_block(yfmv[j+half_len], pyrTemp[i][2*j+1], pyrTemp[i][2*j], info);
      if(j != half_len-1){
        Fore_block_matching(yfmv[j+half_len], pyrTemp[i][2*j+1], pyrTemp[i][2*j+2], info, dist, info.half);
      }

      if(PRUNE && info.ME==1){
        /*bi_flag = (j == half_len-1) ? 0 : 1;*/
        bi_flag = 1;   /* June19 */
        mv_prune(yfmv[j+half_len], info, dist, info.half, bi_flag, curr, j);
      }

      for(k = 0; k < yhor*yver ; k++) ypusedtemp[k]=ypused[k];
      for(k = 0; k < chor*cver ; k++) cpusedtemp[k]=cpused[k];

      temporal_analysis(&pyrTemp[i+1][j], &pyrFrs[j+half_len],
              pyrTemp[i][2*j+1], pyrTemp[i][2*j], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, info);
/*
      write_quad_tree(pyrFrs[j+half_len], info, "pyrFrs", (i*2)*10+j, yfmv[j+half_len], i, 1);
*/


      if(j != 0){

        for(k = 0; k < yhor * yver; k++)
          if(ypused[k] == USED){
            pyrTemp[i+1][j].Y[k] = nfr.Y[k];
          }
        if(info.cwidth && info.cheight){
          for(k = 0; k < chor * cver; k++)
            if(cpused[k] == USED){
              pyrTemp[i+1][j].U[k] = nfr.U[k];
              pyrTemp[i+1][j].V[k] = nfr.V[k];
            }
        }

      }



      if(j != half_len-1){

        for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;



        copyframe(&(pyrFrs[j+half_len]), &cfr, info);


        if(Invert == 1){
                                   /*   high         , low, current,next*/ 
          local_temporal_analysis2(pyrFrs[j+half_len], nfr, cfr, pyrTemp[i][2*j+2], yfmv[j+half_len], ypused, cpused, info); 
        }
        else{
          local_temporal_analysis(pyrFrs[j+half_len], nfr, yfmv[j+half_len], ypused, cpused, info);
        }
      }/*j != half_len-1*/
      else{

        for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];   /* get the status generated in temporal_analysis */
        for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];



        copyframe(&(pyrFrs[j+half_len]), &cfr, info);

        if(Invert == 1){          /*   high         , low            , current,previous*/ 
         local_temporal_analysis2(pyrFrs[j+half_len], pyrTemp[i+1][j], cfr, pyrTemp[i][2*j], yfmv[j+half_len], ypused, cpused, info);
		 /* the low band coefficients are put in pyrTemp[i+1][j]*/

        }
        else{
          local_temporal_analysis(pyrFrs[j+half_len], nfr, yfmv[j+half_len], ypused, cpused, info);
        }

      }

#ifdef COMPUTE_CODING_GAIN
      computegain(pyrTemp[i+1][j], pyrFrs[j+half_len], info);
#endif
      printf("j = %d\n", j);
    }
    dist *= 2;
    half_len /= 2;
  }
 /* the last level */
  printf("temporal pyramid level %d\n", nPyrLev);

  block_matching(yfmv[1], pyrTemp[nPyrLev - 1][1],
                     pyrTemp[nPyrLev - 1][0], info, dist, info.half);

  find_uncovered_block(yfmv[1], pyrTemp[nPyrLev - 1][1],
                     pyrTemp[nPyrLev - 1][0], info);

  if(PRUNE && info.ME==1){
    /*bi_flag = 0;*/
    bi_flag = 1;   /* June19 */
    mv_prune(yfmv[1], info, dist, info.half, bi_flag, curr, 0);
  }

  for(k = 0; k < yhor*yver ; k++) ypusedtemp[k]=UNUSED;
  for(k = 0; k < chor*cver ; k++) cpusedtemp[k]=UNUSED;


  temporal_analysis(&pyrFrs[0], &pyrFrs[1], pyrTemp[nPyrLev - 1][1], 
                    pyrTemp[nPyrLev - 1][0], yfmv[1], ypusedtemp, cpusedtemp, nPyrLev-1, info);
/* { June19 */
  for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];
  for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];


  copyframe(&(pyrFrs[1]), &cfr, info);


  if(Invert == 1){          /*   high         , low    , current,previous*/
    local_temporal_analysis2(pyrFrs[1], pyrFrs[0], cfr, pyrTemp[nPyrLev - 1][0], yfmv[1], ypused, cpused, info);
  }
  else{
    local_temporal_analysis(pyrFrs[j+half_len], nfr, yfmv[j+half_len], ypused, cpused, info);
  }
  /* June19 } */

#ifdef COMPUTE_CODING_GAIN
  computegain(pyrFrs[0], pyrFrs[1], info);
#endif
/*  write_quad_tree(pyrFrs[j+half_len], info, "pyrFrs", ((nPyrLev-1)*2)*10, yfmv[1], nPyrLev-1, 1);
*/
 free(ypused); free(ypusedtemp); free(cpused); free(cpusedtemp);

}





/******************************************************************************
                                 analscheme4
******************************************************************************/
void analscheme4(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info)
{ 
  int i, j, k, half_len, dist, bi_flag;
  unsigned char *ypused, *cpused, *ypusedtemp, *cpusedtemp;  /* flag */
  YUVimage frame;



  frame_alloc(&frame, info);

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");


  dist = 1;
  half_len = info.GOPsz / 2;

  for(i = 0; i < nPyrLev - 1; i++){
    for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
    for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;

    printf("temporal pyramid level %d\n", i+1);

    for(j=half_len-1; j>=0; j--){
      block_matching(yfmv[j+half_len], pyrTemp[i][2*j+1],
                     pyrTemp[i][2*j], info, dist, info.half);



      find_uncovered_block(yfmv[j+half_len], pyrTemp[i][2*j+1], pyrTemp[i][2*j], info);

      if(j != half_len-1){
        for(k=0; k<yhor*yver; k++)
          frame.Y[k] = pyrTemp[i+1][j+1].Y[k]/(float)sqrt(2.);
        if(info.cwidth && info.cheight){
          for(k = 0; k < chor * cver; k++){
            frame.U[k] = pyrTemp[i+1][j+1].U[k]/(float)sqrt(2.);
            frame.V[k] = pyrTemp[i+1][j+1].V[k]/(float)sqrt(2.);
          }
        }


        Fore_block_matching(yfmv[j+half_len], pyrTemp[i][2*j+1], frame, info, dist, 0);
      }

      if(PRUNE && info.ME==1){
        /*bi_flag = (j == half_len-1) ? 0 : 1;*/
        bi_flag = 1;   /* June19 */
        mv_prune(yfmv[j+half_len], info, dist, info.half, bi_flag, curr, j);
      }


      for(k = 0; k < yhor*yver ; k++) ypusedtemp[k]=ypused[k];
      for(k = 0; k < chor*cver ; k++) cpusedtemp[k]=cpused[k];

      temporal_analysis(&pyrTemp[i+1][j], &pyrFrs[j+half_len],
              pyrTemp[i][2*j+1], pyrTemp[i][2*j], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, info);
/*
      write_quad_tree(pyrFrs[j+half_len], info, "pyrFrs", (i*2)*10+j, yfmv[j+half_len], i, 1);
*/
      if(j != half_len-1){
        for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;


        copyframe(&frame, &nfr, info);

        copyframe(&(pyrFrs[j+half_len]), &cfr, info);


        if(Invert == 1){         /*   high           , low, current,next*/ 
          local_temporal_analysis2(pyrFrs[j+half_len], nfr, cfr, frame, yfmv[j+half_len], ypused, cpused, info);
		  /* nfr is not used here */
        }
        else{
          local_temporal_analysis(pyrFrs[j+half_len], frame, yfmv[j+half_len], ypused, cpused, info);
        }

        for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;
      }
      else{
        for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];   /* get the status generated in temporal_analysis */
        for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];



        copyframe(&(pyrFrs[j+half_len]), &cfr, info);



        if(Invert == 1){          /*   high         , low            , current,previous*/ 
         local_temporal_analysis2(pyrFrs[j+half_len], pyrTemp[i+1][j], cfr, pyrTemp[i][2*j], yfmv[j+half_len], ypused, cpused, info);
		 /* the low band coefficients are put in pyrTemp[i+1][j]*/

        }
        else{
          local_temporal_analysis(pyrFrs[j+half_len], nfr, yfmv[j+half_len], ypused, cpused, info);
        }

        for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;
      }

#ifdef COMPUTE_CODING_GAIN
	  computegain(pyrTemp[i+1][j], pyrFrs[j+half_len], info);
#endif
      printf("j = %d\n", j);
    }
    dist *= 2;
    half_len /= 2;
  }


  /* the last level */
  printf("temporal pyramid level %d\n", nPyrLev);


  block_matching(yfmv[1], pyrTemp[nPyrLev - 1][1],
                     pyrTemp[nPyrLev - 1][0], info, dist, info.half);

  find_uncovered_block(yfmv[1], pyrTemp[nPyrLev - 1][1],
                     pyrTemp[nPyrLev - 1][0], info);

  if(PRUNE && info.ME==1){
    /*bi_flag = 0;*/
    bi_flag = 1;   /* June19 */
    mv_prune(yfmv[1], info, dist, info.half, bi_flag, curr, 0);
  }

  for(k=0 ; k<yhor*yver ; k++) ypusedtemp[k]=UNUSED;
  for(k=0 ; k<chor*cver ; k++) cpusedtemp[k]=UNUSED;

  temporal_analysis(&pyrFrs[0], &pyrFrs[1], pyrTemp[nPyrLev - 1][1],
                    pyrTemp[nPyrLev - 1][0], yfmv[1], ypusedtemp, cpusedtemp, nPyrLev-1, info);


  copyframe(&(pyrFrs[1]), &cfr, info);


        for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];
        for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];


        if(Invert == 1){ /*   high         , low      , current,previous*/ 
         local_temporal_analysis2(pyrFrs[1], pyrFrs[0], cfr, pyrTemp[nPyrLev - 1][0], yfmv[1], ypused, cpused, info);

        }
        else{
          local_temporal_analysis(pyrFrs[j+half_len], nfr, yfmv[j+half_len], ypused, cpused, info);
        }
/* June19 } */

#ifdef COMPUTE_CODING_GAIN
		computegain(pyrFrs[0], pyrFrs[1], info);
#endif
		/*  write_quad_tree(pyrFrs[j+half_len], info, "pyrFrs", ((nPyrLev-1)*2)*10, yfmv[1], nPyrLev-1, 1);
*/
  free(ypused); free(ypusedtemp); free(cpused); free(cpusedtemp);
  free(&frame);
}







/******************************************************************************
                                      mc_syn
******************************************************************************/
int mc_syn(int curr, videoinfo info)
{
  YUVimage  frame[16];
  int i;
  char name[100];
  int TestScalable = 0;

  printf("synthesis.....................\n");
/*
  if(info.GOPsz != 16){
    printf("error in frame number in mctfN.c\n");
    exit(0);
  }
*/
  if(TestScalable == 1){
    for(i=0; i<info.GOPsz; i++){
      frame_alloc(&frame[i], info);
      copyframe(&(pyrTemp[0][i]), &(frame[i]), info);  /* Save for judge the quality of low frame rate data in Judge_Scalable */
    }
  }


/*
  printf("reconstruction with two levels\n");
  for(i=info.GOPsz/8; i<info.GOPsz; i++){
    for(j=0; j<yhor*yver; j++)
      pyrFrs[i].Y[j]=0.;
    if(info.cwidth && info.cheight){
      for(j = 0; j < chor * cver; j++){
        pyrFrs[i].U[j]=0.;
        pyrFrs[i].V[j]=0.;
      }
    }
  }

*/

  switch(info.scheme){
  default:
    printf("more parameters are specified\n");
    exit(1);
  case 1:
    synscheme1(curr, info.tPyrLev, info.ywidth, info.yheight, info.cwidth, info.cheight, info);
    break;
  case 2:
    synscheme2(curr, info.tPyrLev, info.ywidth, info.yheight, info.cwidth, info.cheight, info);
    break;
  case 3:
    synscheme3(curr, info.tPyrLev, info.ywidth, info.yheight, info.cwidth, info.cheight, info);
    break;
  case 4:
    synscheme4(curr, info.tPyrLev, info.ywidth, info.yheight, info.cwidth, info.cheight, info);
    break;
  }


  if(TestScalable == 1){
    sprintf(name, "Test\\RL");
    Judge_Scalable(pyrTemp, frame, name, info);

    for(i=0; i<info.GOPsz; i++)
      free_frame_interior(frame[i]);
  }

  return(0);
}






/******************************************************************************
                                 scheme 1
******************************************************************************/
void synscheme1(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info)
{
  YUVimage tempfr, frame, hfr;
  int i, j, k, half_len;
  unsigned char *ypused, *ypusedtemp, *cpused, *cpusedtemp;  /* flag */

  frame_alloc(&tempfr, info);
  frame_alloc(&frame, info);
  frame_alloc(&hfr, info);


  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");


  half_len = 1;
  printf("temporal pyramid level %d\n", nPyrLev);

  for(i=0 ; i<yhor*yver ; i++) ypusedtemp[i]=UNUSED;
  for(i=0 ; i<chor*cver ; i++) cpusedtemp[i]=UNUSED;

              /* pyrTemp[nPyrLev-1][1] pyrTemp[nPyrLev-1][0] --reconstructed*/
  temporal_synthesis(&pyrTemp[nPyrLev-1][1], &pyrTemp[nPyrLev-1][0], pyrFrs[0],
                     pyrFrs[1], yfmv[1], ypusedtemp, cpusedtemp, info);

  for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];   /* get the status generated in temporal_synthesis */
  for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];

  if(Invert == 1){       /*       current          , previous             , high     ,low   */
    local_temporal_synthesis2(pyrTemp[nPyrLev-1][1], pyrTemp[nPyrLev-1][0], pyrFrs[1], pyrFrs[0], yfmv[1], ypused, cpused, info);
  }
  else{
    local_temporal_synthesis(pyrFrs[j-1+half_len], frame, tempfr, yfmv[j-1+half_len], ypused, cpused, info);
  }


  for(i = nPyrLev-2; i >=0; i--){
    printf("temporal pyramid level %d\n", i+1);
    half_len *= 2;

    for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
    for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;

    for(j = 0; j < half_len; j++){  /*for scheme 1 &2 */

      for(k=0 ; k<yhor*yver ; k++) ypusedtemp[k] = ypused[k]; /* pused kept for 111 */
      for(k=0 ; k<chor*cver ; k++) cpusedtemp[k] = cpused[k];

      temporal_synthesis(&pyrTemp[i][2*j+1], &pyrTemp[i][2*j], pyrTemp[i+1][j],
                pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, info);

      if(j != 0){
        for(k=0; k < yhor*yver ; k++){
          if(ypused[k] == USED){
            pyrTemp[i][2*j].Y[k] = frame.Y[k];
          }
        }
        if(info.cwidth && info.cheight){
          for(k=0; k < chor*cver ; k++){
            if(cpused[k] == USED){
              pyrTemp[i][2*j].U[k] = frame.U[k];
              pyrTemp[i][2*j].V[k] = frame.V[k];
            }
          }
        }
      }

      if(j != half_len-1){
        for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;


        copyframe(&(pyrTemp[i][2*j+1]), &hfr, info);

        if(Invert == 1){           /*current         , next  , high,low   */
          local_temporal_synthesis2(pyrTemp[i][2*j+1], frame, hfr, pyrTemp[i+1][j+1], yfmv[j+half_len], ypused, cpused, info);
        }
        else{
          local_temporal_synthesis(pyrTemp[i][2*j+1], frame, pyrTemp[i+1][j+1], yfmv[j+half_len], ypused, cpused, info);
        }
      }/*j != half_len-1*/
      else{

        for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];   /* get the status generated in temporal_synthesis */
        for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];

        if(Invert == 1){       /*   current          , previous       , high,low   */
          local_temporal_synthesis2(pyrTemp[i][2*j+1], pyrTemp[i][2*j], pyrFrs[j+half_len], pyrTemp[i+1][j], yfmv[j+half_len], ypused, cpused, info);
        }
        else{
          local_temporal_synthesis(pyrFrs[j-1+half_len], frame, tempfr, yfmv[j+half_len], ypused, cpused, info);
        }

        for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;

      }
      printf("j = %d\n", j);
    } /* j */

  } /* i */


  free(ypused);
  free(ypusedtemp);
  free(cpused);
  free(cpusedtemp);
  free_frame_interior(tempfr); free_frame_interior(frame); free_frame_interior(hfr);
}


/******************************************************************************
                                       scheme 2
******************************************************************************/
void synscheme2(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info)
{
  YUVimage tempfr, frame, lfr, hfr;
  int i, j, k, half_len;
  unsigned char *ypused, *ypusedtemp, *cpused, *cpusedtemp;  /* flag */

  frame_alloc(&tempfr, info);
  frame_alloc(&frame, info);
  frame_alloc(&lfr, info);
  frame_alloc(&hfr, info);


  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");



  half_len = 1;
  nPyrLev = info.tPyrLev;
  printf("temporal pyramid level %d\n", nPyrLev);

  for(i=0 ; i<yhor*yver ; i++) ypusedtemp[i]=UNUSED;
  for(i=0 ; i<chor*cver ; i++) cpusedtemp[i]=UNUSED;

              /* pyrTemp[nPyrLev-1][1] pyrTemp[nPyrLev-1][0] --reconstructed*/
  temporal_synthesis(&pyrTemp[nPyrLev-1][1], &pyrTemp[nPyrLev-1][0], pyrFrs[0],
                     pyrFrs[1], yfmv[1], ypusedtemp, cpusedtemp, info);


  for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];   /* get the status generated in temporal_synthesis */
  for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];

  if(Invert == 1){       /*       current          , previous             , high     ,low   */
    local_temporal_synthesis2(pyrTemp[nPyrLev-1][1], pyrTemp[nPyrLev-1][0], pyrFrs[1], pyrFrs[0], yfmv[1], ypused, cpused, info);
  }
  else{
    local_temporal_synthesis(pyrFrs[j-1+half_len], frame, tempfr, yfmv[j-1+half_len], ypused, cpused, info);
  }


  for(i = nPyrLev-2; i >=0; i--){
    printf("temporal pyramid level %d\n", i+1);
    half_len *= 2;

    for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
    for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;

    for(j = 0; j < half_len; j++){   /*for scheme 1 &2 */

      for(k=0 ; k<yhor*yver ; k++) ypusedtemp[k] = ypused[k]; /* pused kept for 111 */
      for(k=0 ; k<chor*cver ; k++) cpusedtemp[k] = cpused[k];

      temporal_synthesis(&pyrTemp[i][2*j+1], &pyrTemp[i][2*j], pyrTemp[i+1][j],
                pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, info);

      if(j != half_len-1){
        for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;


        copyframe(&(pyrTemp[i][2*j+1]), &hfr, info);

        copyframe(&(pyrTemp[i+1][j+1]), &lfr, info);


        if(Invert == 1){       /*current             , next , high,low*/
          local_temporal_synthesis2(pyrTemp[i][2*j+1], pyrTemp[i][2*j+2], hfr, lfr, yfmv[j+half_len], ypused, cpused, info);
        }
        else{
          local_temporal_synthesis(pyrTemp[i][2*j+1], frame, pyrTemp[i+1][j+1], yfmv[j+half_len], ypused, cpused, info);
        }

        for(k=0; k < yhor*yver ; k++){
          if(ypused[k] == USED){
            pyrTemp[i+1][j+1].Y[k] = pyrTemp[i][2*j+2].Y[k] * (float)sqrt(2.);
          }
        }
        if(info.cwidth && info.cheight){
          for(k=0; k < chor*cver ; k++){
            if(cpused[k] == USED){
              pyrTemp[i+1][j+1].U[k] = pyrTemp[i][2*j+2].U[k] * (float)sqrt(2.);
              pyrTemp[i+1][j+1].V[k] = pyrTemp[i][2*j+2].V[k] * (float)sqrt(2.);
            }
          }
        }

      }/*j != half_len-1*/
      else{

        for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];   /* get the status generated in temporal_synthesis */
        for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];

        if(Invert == 1){       /*   current          , previous       , high,low   */
          local_temporal_synthesis2(pyrTemp[i][2*j+1], pyrTemp[i][2*j], pyrFrs[j+half_len], pyrTemp[i+1][j], yfmv[j+half_len], ypused, cpused, info);
        }
        else{
          local_temporal_synthesis(pyrFrs[j-1+half_len], frame, tempfr, yfmv[j+half_len], ypused, cpused, info);
        }

      }
      printf("j = %d\n", j);


    } /* j */

  } /* i */
  free(ypused);
  free(ypusedtemp);
  free(cpused);
  free(cpusedtemp);
  free_frame_interior(tempfr); free_frame_interior(frame); free_frame_interior(hfr); free_frame_interior(lfr);
}


/******************************************************************************
                                  synscheme4
******************************************************************************/
void synscheme4(int curr, int nPyrLev, int yhor, int yver, int chor, int cver, videoinfo info)
{
  YUVimage tempfr, frame, hfr;
  int i, j, k, half_len;
  unsigned char *ypused, *ypusedtemp, *cpused, *cpusedtemp;  /* flag */
  float c5;

  c5 = (float)sqrt(2.);


  frame_alloc(&tempfr, info);
  frame_alloc(&frame, info);
  frame_alloc(&hfr, info);

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");

  half_len = 1;
  printf("temporal pyramid level %d\n", nPyrLev);

  for(i=0 ; i<yhor*yver ; i++) ypusedtemp[i]=UNUSED;
  for(i=0 ; i<chor*cver ; i++) cpusedtemp[i]=UNUSED;

              /* pyrTemp[nPyrLev-1][1] pyrTemp[nPyrLev-1][0] --reconstructed*/
  temporal_synthesis(&pyrTemp[nPyrLev-1][1], &pyrTemp[nPyrLev-1][0], pyrFrs[0],
                     pyrFrs[1], yfmv[1], ypusedtemp, cpusedtemp, info);


  for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];   /* get the status generated in temporal_synthesis */
  for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];

  if(Invert == 1){  /*       current          , previous   , high     ,low   */
    local_temporal_synthesis2(pyrTemp[nPyrLev-1][1], pyrTemp[nPyrLev-1][0], pyrFrs[1], pyrFrs[0], yfmv[1], ypused, cpused, info);
  }
  else{
    local_temporal_synthesis(pyrFrs[j-1+half_len], frame, tempfr, yfmv[j-1+half_len], ypused, cpused, info);
  }


  for(i = nPyrLev-2; i >=0; i--){
    printf("temporal pyramid level %d\n", i+1);
    half_len *= 2;

    for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
    for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;

    for(j = 0; j < half_len; j++){

      for(k=0 ; k<yhor*yver ; k++) ypusedtemp[k] = ypused[k]; /* pused kept for 111 */
      for(k=0 ; k<chor*cver ; k++) cpusedtemp[k] = cpused[k];

      temporal_synthesis(&pyrTemp[i][2*j+1], &pyrTemp[i][2*j], pyrTemp[i+1][j],
                pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, info);

      if(j != half_len-1){
        for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;


        copyframe(&(pyrTemp[i+1][j+1]), &frame, info);
 

        for(k = 0; k < yhor*yver; k++){
          if(ypused[k] == USED)
            tempfr.Y[k] = frame.Y[k] / c5;
        }
        if(info.cwidth && info.cheight){
          for(k = 0; k < chor*cver; k++){
            if(cpused[k] == USED){
              tempfr.U[k] = frame.U[k] / c5;
              tempfr.V[k] = frame.V[k] / c5;
            }
          }
        }

        copyframe(&(pyrTemp[i][2*j+1]), &hfr, info);

        if(Invert == 1){          /*current          , next  , high,low   */
          local_temporal_synthesis2(pyrTemp[i][2*j+1], tempfr, hfr, frame, yfmv[j+half_len], ypused, cpused, info);
        }
        else{
          local_temporal_synthesis(pyrTemp[i][2*j+1], tempfr, frame, yfmv[j+half_len], ypused, cpused, info);
        }
        for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;
      }
      else{

        for(k=0 ; k<yhor*yver ; k++) ypused[k]=ypusedtemp[k];   /* get the status generated in temporal_synthesis */
        for(k=0 ; k<chor*cver ; k++) cpused[k]=cpusedtemp[k];

        if(Invert == 1){       /*   current          , previous       , high,low   */
          local_temporal_synthesis2(pyrTemp[i][2*j+1], pyrTemp[i][2*j], pyrFrs[j+half_len], pyrTemp[i+1][j], yfmv[j+half_len], ypused, cpused, info);
        }
        else{
          local_temporal_synthesis(pyrFrs[j-1+half_len], frame, tempfr, yfmv[j+half_len], ypused, cpused, info);
        }



        for(k=0 ; k<yhor*yver ; k++) ypused[k]=UNUSED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=UNUSED;

      }
      printf("j = %d\n", j);
    } /* j */

  } /* i */


  free(ypused);
  free(ypusedtemp);
  free(cpused);
  free(cpusedtemp);
  free_frame_interior(tempfr); free_frame_interior(frame); free_frame_interior(hfr);
}


