#define Code_value_bits  16
#define Top_value        65535         /* largest code value */
#define Max_frequency    16383         /* largest frequency count */
#define First_qtr        Top_value/4+1
#define Half             2*First_qtr
#define Third_qtr        3*First_qtr


EXTERN int  low, high, value, *freq, *cmf, *int2sym, *sym2int;
EXTERN int  buffer, bits_to_go, bits_to_follow, garbage_bits, outbyte, inbyte;
EXTERN FILE *fptmp;
extern FILE *fpbit;


void ardecode_init(int num_symbol);
void ardecode_end();
void arencode_init(int num_symbol, videoinfo info);
void arencode_end(int num_symbol, int with, videoinfo info);
void encode_init(videoinfo info);
void encode_end(int with, videoinfo info);
void decode_init();
void decode_end();


int decode_symbol();

/****************************************************************************/
/*                             output_bit()                                 */
/****************************************************************************/
#define output_bit(bit)                                                      \
 /**  int bit;  **/                                                          \
{                                                                            \
  buffer >>=1;                                                               \
  if(bit) buffer |= 0x80;     /* put bit in top of buffer */                 \
    bits_to_go--;                                                            \
    if(!bits_to_go){            /* output buffer if it is full */            \
      putc(buffer, fptmp);                                                   \
      bits_to_go=8;                                                          \
      outbyte++;                                                             \
    }                                                                        \
}

/****************************************************************************/
/*                             input_bit()                                  */
/****************************************************************************/
#define input_bit(bit)                                                       \
/*** int bit ***/                                                            \
{                                                                            \
  if(!bits_to_go){   /* Read the next byte if no bits are left in buffer */  \
    if(inbyte>0) {   /* prevent reading for continous one bit files */       \
      buffer=getc(fpbit);                                                    \
      inbyte--;                                                              \
    }                                                                        \
    else{                                                                    \
      buffer = EOF;                                                          \
      garbage_bits++;                        /* return arbitrary bits */     \
      if(garbage_bits>Code_value_bits-2){    /*  after EOF, but check */     \
	printf("Bad input file\n");          /*  for too many such */        \
        exit(1);                                                             \
      }                                                                      \
    }                                                                        \
    bits_to_go = 8;                                                          \
  }                                                                          \
  bit = buffer&1;     /* return the next bit from */                         \
  buffer>>=1;         /*  the bottom of the byte */                          \
  bits_to_go--;                                                              \
}
