#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <malloc.h>
/*#include "dpx.h"*/
#include "rasterfile.h"
#include "basic.h"
#define EXTERN extern
#include "coderN.h"
#include "memoryN.h"
#include "display.h"
#include "miscN.h"
#include "ras_util.h" /* New */
#include "dpx.h"
#include "unix_pc.h"
#include "memoryN.h"
#include "ioN.h"
#include "analsyn.h"
void copyframe(YUVimage *source, YUVimage *dest, videoinfo info);
void snr_frame(float *ysnr, float *usnr, float *vsnr, YUVimage_ptr codeframe, YUVimage_ptr inframe, videoinfo info);
void write_frame(YUVimage frame, videoinfo info, char *inname, int index, enum FORMAT format);
void yuv2RGB(unsigned char *RGBframe, int yhor, int yver, float *Yframe, int chor, int cver, float *Uframe, float *Vframe);
void block2pixel3(float *mvx, float *mvy, vector_ptr fmv, int cx, int cy, int xblk, int yblk, int hor, int ver);
struct rasterfile *exchange_rasheader(struct rasterfile *rhead);
struct rasterfile make_header(int hor, int ver, int depth);
void write_ras(char *filename, struct rasterfile header, unsigned char *frame);

void Judge_Scalable(YUVimage_ptr *Lowpass_frame, YUVimage_ptr Lowrate_frame, int curr, char *fn, videoinfo info)
{
  int i, j, yhor, yver, chor, cver, dist, half_len, GOPIndex, FrameIndex;
  float ysnr, usnr, vsnr;
  YUVimage    tempfr;
  char name[100];

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  frame_alloc(&tempfr, info);
/*-------------------- output the low band  and psnr--------------------*/
/* the psnr is between the original frame and the lowband */
  /*printf("psnr of low temporal band :\n");*/



  //GOPIndex = (info.last+info.GOPsz-1)/info.GOPsz - curr/info.GOPsz;//REVERSE_SEQ
  GOPIndex = curr/info.GOPsz+1;

  half_len = info.GOPsz / 2;
  dist = 1;
  for(i = 1; i < info.tPyrLev; i++){
    for(j = 0; j < half_len; j++){

	  //FrameIndex = half_len-1-j; //REVERSE_SEQ
	  FrameIndex = j;

      wcopyframe(&(Lowpass_frame[i][j]), &tempfr, (float)(1/pow(2.,i/2.)), info);
	  //info.cwidth = 0; info.cheight =0; 

	  
	  sprintf(name, "Test\\%.2sG%02d%s%01df%03d.ras", info.bitname, GOPIndex, fn, i, FrameIndex+1);

	  write_frame(tempfr, info, name, FrameIndex, RAS);
	  //info.cwidth = 176; info.cheight = 120;

      //write_lowband(tempfr, info, name, FrameIndex, i);
      snr_frame(&ysnr, &usnr, &vsnr, &tempfr, &Lowrate_frame[(j*2+2)*dist-1], info);


	  printf("ysnr = %0.2f\n", ysnr);

      avgpsnr[0][half_len+FrameIndex] += ysnr;
      avgpsnr[1][half_len+FrameIndex] += usnr;
      avgpsnr[2][half_len+FrameIndex] += vsnr;
    }
    half_len /= 2;
	dist *= 2;
  }



  wcopyframe(&(pyrFrs[0]), &tempfr, (float)(1/pow(2,i/2.)), info);

  sprintf(name, "Test\\%.2sG%02dL%01df%03d.ras", info.bitname, GOPIndex, info.tPyrLev, 1); 

  write_frame(tempfr, info, name, 0, RAS);
  //write_lowband(tempfr, info, name, 0, info.tPyrLev);
  snr_frame(&ysnr, &usnr, &vsnr, &tempfr, &Lowrate_frame[info.GOPsz-1], info);

  
  printf("ysnr = %0.2f\n", ysnr);


  avgpsnr[0][1] += ysnr;
  avgpsnr[1][1] += usnr;
  avgpsnr[2][1] += vsnr;

  free_frame_interior(tempfr);

}

void draw_block(unsigned char *frame, vector_ptr fmv, int cx, int cy, int xblk, int yblk, int hor, int ver, enum BlockMode mode)
{
  int i, j, xblock, yblock, pos;

  xblock = (cx+xblk<=hor)?  xblk : hor-cx;
  yblock = (cy+yblk<=ver)?  yblk : ver-cy;

  if(xblock<=0 || yblock<=0){
    return;
  }

  if(fmv->child){
    draw_block(frame, fmv->child0,cx,       cy,       xblk/2,yblk/2,hor,ver,mode);
    draw_block(frame, fmv->child1,cx+xblk/2,cy,       xblk/2,yblk/2,hor,ver,mode);
    draw_block(frame, fmv->child2,cx,       cy+yblk/2,xblk/2,yblk/2,hor,ver,mode);
    draw_block(frame, fmv->child3,cx+xblk/2,cy+yblk/2,xblk/2,yblk/2,hor,ver,mode);
  }
  else{  
    if(fmv->mode == mode){


	  /*if(cx==192 && cy == 128 && xblock == 32 && yblock == 32 && fmv->mode == REVERSE)
        printf(" xblk %d yblk %d (display.c)\n", xblk, yblk);*/


      i = cy;
      for(j=cx ; j<=cx+xblock ; j++){
        if(j<hor){
          pos = i*hor+j;
          frame[pos] = 255;

		  if(i+yblock<ver){
            pos = (i+yblock)*hor +j;
            frame[pos] = 255;
          }
		}
	  }
      j = cx;
      for(i=cy ; i<=cy+yblock ; i++){
        if(i<ver){
          pos = i*hor+j;
          frame[pos] = 255;

          if(j+xblock<hor){
            frame[pos+xblock] = 255;
          }
		}
	  }

	}
  }/* fmv->child != 1 */
  return;
}


void draw_quad_tree(unsigned char *frame, vector_ptr fmv, enum BlockMode mode, videoinfo info)
{
  int x, y, X, Y, yhor, yver, chor, cver;
  int   xnum, ynum, xblk, yblk;

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblk = info.xblk;   yblk = info.yblk;

  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      draw_block(frame, &fmv[Y*xnum+X], x, y, xblk, yblk, yhor, yver, mode);
    }
  }
  return;
}




void write_quad_tree(YUVimage frame, videoinfo info, char *frame_name, vector_ptr fmv, int level, enum BlockMode mode)
{
  int   x, y, yhor, yver, chor, cver, pos;
  int   xnum, ynum, xblk, yblk;
  float weight;
  YUVimage temp;
  unsigned char *RGBframe;
  unsigned char *data;
  struct rasterfile header;

  frame_alloc(&temp, info);

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblk = info.xblk;   yblk = info.yblk;

  RGBframe  = (unsigned char*) getarray(yhor*yver*3, sizeof(unsigned char), "RGBframe");
  data  = (unsigned char*) getarray(yhor*yver*3, sizeof(unsigned char), "data");

  weight = (float)pow(sqrt(2.), (float)level);
  if(info.format == DPX) weight *= 4;


  for(y = 0; y < yver; y++){
    for(x = 0; x < yhor; x++){
      pos = y * yhor + x;
      temp.Y[pos] = frame.Y[pos]/weight;
    }
  }

  if(info.cwidth && info.cheight){
    for(y = 0; y < cver; y++){
      for(x = 0; x < chor; x++){
        pos = y * chor + x;
        temp.U[pos] = frame.U[pos]/weight;
        temp.V[pos] = frame.V[pos]/weight;
      }
    }
  }

  if(info.cwidth && info.cheight){
    yuv2RGB(RGBframe, yhor, yver, temp.Y, chor, cver, temp.U, temp.V);

    for(y = 0; y < yver; y++){
      for(x = 0; x < yhor; x++){
        pos = y * yhor + x;
        data[pos] = RGBframe[pos*3];  
        data[pos+yver*yhor] = RGBframe[pos*3+1];  
        data[pos+yver*yhor*2] = RGBframe[pos*3+2];  
      }
    }
  }
  else{
    for(y = 0; y < yver; y++){
      for(x = 0; x < yhor; x++){
        pos = y * yhor + x;
         data[pos] = (unsigned char)nint(temp.Y[pos]);
      }
    }
  }

  draw_quad_tree(data, fmv, mode, info);

  if(info.cwidth && info.cheight){
    draw_quad_tree(data+yhor*yver, fmv, mode, info);
    draw_quad_tree(data+yhor*yver*2, fmv, mode, info);
  }

  if(chor*cver){
    for(y = 0; y < yver; y++){
      for(x = 0; x < yhor; x++){
        pos = y * yhor + x;
        RGBframe[pos*3] = data[pos]; 
        RGBframe[pos*3+1] = data[pos+yver*yhor];  
        RGBframe[pos*3+2] = data[pos+yver*yhor*2] ;  
      }
    }

    header = make_header(yhor, yver, RGBDATA);
    write_ras(frame_name, header, RGBframe);
  }
  else{
    header = make_header(yhor, yver, GRAYDATA);
    write_ras(frame_name, header, data); /* the gray level is saved at the first yhor*ver of RGBframe*/
  }



 free_frame_interior(temp);

 free(RGBframe); free(data);

}




void write_FMC(YUVimage frame, videoinfo info, char *inname, int index, int level)
{
  int   x, y, yhor, yver, chor, cver, pos;
  int   xnum, ynum, xblk, yblk;
  float weight;
  YUVimage temp;

  weight = (float)pow(sqrt(2.), (float)level);

  frame_alloc(&temp, info);

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblk = info.xblk;   yblk = info.yblk;

  for(y = 0; y < yver; y++){
    for(x = 0; x < yhor; x++){
      pos = y * yhor + x;
        temp.Y[pos] = frame.Y[pos]/weight;
    }
  }


 /* QUEST */
  if(info.cwidth && info.cheight){
    for(y = 0; y < cver; y++){
      for(x = 0; x < chor; x++){
        pos = y * chor + x;
        temp.U[pos] = frame.U[pos]/weight;
        temp.V[pos] = frame.V[pos]/weight;
      }
    }
  }

/*  draw_quad_tree(&temp, fmv, 1);*/

  if(info.cwidth && info.cheight){
    for(y = 0; y < cver; y++){
      for(x = 0; x < chor; x++){
        pos = y * chor + x;
        temp.U[pos] = 128.;
        temp.V[pos] = 128.;
      }
    }
  }
 /* QUEST */

  write_frame(temp, info, inname, index, info.format);

 free_frame_interior(temp);
}






void write_lowband(YUVimage frame, videoinfo info, char *inname, int index, int level) /* STATISTIC */
{
  int   x, y, yhor, yver, chor, cver, pos;
  float weight;
  YUVimage temp;

  weight = (float)pow(sqrt(2.), (float)level);

  frame_alloc(&temp, info);

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;

  for(y = 0; y < yver; y++){
    for(x = 0; x < yhor; x++){
      pos = y * yhor + x;
      temp.Y[pos] = frame.Y[pos]/weight;
    }
  }

  if(info.cwidth && info.cheight){
    for(y = 0; y < cver; y++){
      for(x = 0; x < chor; x++){
        pos = y * chor + x;
        temp.U[pos] = frame.U[pos]/weight;
        temp.V[pos] = frame.V[pos]/weight;
      }
    }
  }

  write_frame(temp, info, inname, index, RAS);


 free_frame_interior(temp);
}
 




void writefloatimg4(char *name, struct rasterfile *rhead, float *data)
{
  FILE *fp;
  int i, nn;
  U32 *p;
  struct rasterfile temphead;

  rhead->ras_depth = 32;
  rhead->ras_length = rhead->ras_height * rhead->ras_width * sizeof(float);
  rhead->ras_maptype = RMT_NONE;
  rhead->ras_maplength = 0;

  if (!name) {
    fp = stdout;
  }else if((fp = fopen(name, "wb")) == NULL) {
    (void)fprintf(stderr, "write_floatimg4: can't open %s for write\n", name);
    exit(-1);
  }
  nn = rhead->ras_width * rhead->ras_height;


  /* write the file header */
  temphead = *rhead;
  p =(U32 *)&temphead;
  for(i=0; i<8; i++){
	  p[i] = exchange_4byte_order(p[i]);
  }
  if(fwrite(p, sizeof(U32), 8, fp) != 8) {
    printf("write_ras: can't write header to %s\n", name);
    exit(1);
  }

  p = (U32 *)data;
  for(i=0; i<nn; i++){
	  p[i] = exchange_4byte_order(p[i]);
  }

  if(fwrite(p, sizeof(U32), nn, fp) != (unsigned)nn) {
    printf("write_ras: can't write header to %s\n", name);
    exit(1);
  }



 (void)fclose(fp);
  return;
}


void write_densemotionfield(char *name, vector_ptr fmv, videoinfo info)
{
  int i, x, y, X, Y, yhor, yver;
  int   xnum, ynum, xblk, yblk;
  float *mvx, *mvy;
  struct rasterfile header;
  char motionfieldname[100];

  header.ras_type = RT_STANDARD;
  header.ras_depth = 32;
  header.ras_width = info.ywidth;
  header.ras_height = info.yheight;

  yhor = info.ywidth; yver = info.yheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblk = info.xblk;   yblk = info.yblk;

 /* allocate the memory and initialization */
  mvx = (float *) getarray(yhor*yver, sizeof(float), "mvx");
  mvy = (float *) getarray(yhor*yver, sizeof(float), "mvy");

  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      block2pixel3(mvx, mvy, &fmv[Y*xnum+X], x, y, xblk, yblk, yhor, yver);
    }
  }

  for(i=0; i<yhor*yver; i++){
    mvx[i] = -mvx[i];
  } /* QUEST */

  sprintf(motionfieldname, "%s%s", name, "x");
  writefloatimg4(motionfieldname, &header, mvx);

  for(i=0; i<yhor*yver; i++){
    mvy[i] = -mvy[i];
  }/* QUEST */

  sprintf(motionfieldname, "%s%s", name, "y");
  writefloatimg4(motionfieldname, &header, mvy);

  free(mvx); free(mvy);

}


void unconnected_pel(int curr, int index, videoinfo info)
{
  int i, j, k, yhor, yver, chor, cver, rx, ry, connect, unconnect;
  char name[100];
  unsigned char *state, *cstate, *Y, *U, *V;
  double diff, ymse_connect, ymse_unconnect, umse_connect, umse_unconnect, vmse_connect, vmse_unconnect, mse, psnr;
  struct rasterfile *header;
  YUVimage orig;
  FILE *fpstat;
   
  fpstat = fopen(info.statname, "at+");

  frame_alloc(&orig, info);

  yhor = info.ywidth; yver = info.yheight; 
  chor = info.cwidth; cver = info.cheight;
  rx=yhor/chor;
  ry=yver/cver;

  cstate = (unsigned char *)getarray(chor*cver, sizeof(unsigned char), "U");
  Y = (unsigned char *)getarray(yhor*yver, sizeof(unsigned char), "Y");
  U = (unsigned char *)getarray(chor*cver, sizeof(unsigned char), "U");
  V = (unsigned char *)getarray(chor*cver, sizeof(unsigned char), "V");

  for(i = 0; i < info.GOPsz/2; i++){
	  // read in state map
	if(index == 0){
	  sprintf(name, "HcasemapLev%1dH%1d.ras", 0, i);  
	  fprintf(fpstat, "Current frame\n");
	}
	else{
	  sprintf(name, "LcasemapLev%1dH%1d.ras", 0, i);  
	  fprintf(fpstat, "Reference frame\n");
	}
	header = read_ras(name, &state);      // read in original frame
    read_frame(&orig, info, info.inname, curr+i*2+index, info.format);


//Y
	  connect = 0; unconnect = 0;
	  ymse_connect = 0; ymse_unconnect = 0;
      for(j=0; j<yhor*yver; j++){       		  
		  diff = pyrTemp[0][i*2+index].Y[j] - orig.Y[j]; 

		  Y[j] = nint(diff+128);

          if(state[j] == UN){
			  ymse_unconnect += diff*diff;
			  unconnect++;
		  }
		  else{
			  ymse_connect += diff*diff;
			  connect++;
		  }
	  }
	  mse = (ymse_unconnect+ymse_connect)/(unconnect+connect);
      psnr = 10*log10(info.max*info.max/mse);
 
      ymse_unconnect /= unconnect;
	  ymse_connect /= connect;
	  fprintf(fpstat, "frame %3d, ymse_unconnect(%d) = %.2f ymse_connect(%d) = %.2f, mse = %.2f, psnr = %.2f\n", curr+i*2, unconnect, ymse_unconnect, connect, ymse_connect, mse, psnr);
 
	  sprintf(name, "Y%02d.ras", i*2);
	  write_ras(name, *header, Y);     



	  for(j=0;j<cver;j++){
		for(k=0;k<chor;k++){
		  cstate[j*chor+k] = state[j*ry*yhor+k*rx];
		}
	  }

//U
	  connect = 0; unconnect = 0;
	  umse_connect = 0; umse_unconnect = 0;
      for(j=0; j<chor*cver; j++){       		  
		  diff = pyrTemp[0][i*2+index].U[j] - orig.U[j]; 

		  U[j] = nint(diff+128);

          if(cstate[j] == UN){
			  umse_unconnect += diff*diff;
			  unconnect++;
		  }
		  else{
			  umse_connect += diff*diff;
			  connect++;
		  }
	  }
	  mse = (umse_unconnect+umse_connect)/(unconnect+connect);
      psnr = 10*log10(info.max*info.max/mse);
 
      umse_unconnect /= unconnect;
	  umse_connect /= connect;
	  fprintf(fpstat, "frame %3d, umse_unconnect(%d) = %.2f umse_connect(%d) = %.2f, mse = %.2f, psnr = %.2f\n", curr+i*2, unconnect, umse_unconnect, connect, umse_connect, mse, psnr);
 
	  //sprintf(name, "U%02d.ras", i*2);
	  //write_ras(name, *header, U);     

//V
	  connect = 0; unconnect = 0;
	  vmse_connect = 0; vmse_unconnect = 0;
      for(j=0; j<chor*cver; j++){       		  
		  diff = pyrTemp[0][i*2+index].V[j] - orig.V[j]; 

		  V[j] = nint(diff+128);

          if(cstate[j] == UN){
			  vmse_unconnect += diff*diff;
			  unconnect++;
		  }
		  else{
			  vmse_connect += diff*diff;
			  connect++;
		  }
	  }
	  mse = (vmse_unconnect+vmse_connect)/(unconnect+connect);
      psnr = 10*log10(info.max*info.max/mse);
 
      vmse_unconnect /= unconnect;
	  vmse_connect /= connect;
	  fprintf(fpstat, "frame %3d, vmse_unconnect(%d) = %.2f vmse_connect(%d) = %.2f, mse = %.2f, psnr = %.2f\n", curr+i*2, unconnect, vmse_unconnect, connect, vmse_connect, mse, psnr);
 
	  //sprintf(name, "V%02d.ras", i*2);
	  //write_ras(name, *header, V);     



	  free(header);
	  free(state);
  }

  free(cstate);
  fclose(fpstat);
  free(Y); free(U); free(V);
  free_frame_interior(orig);
}