#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "rasterfile.h"
#include "ras_util.h"
#include "basic.h"
#include "structN.h"
#include "dpx.h"

#define Detector 0xffc00000


char  rasseq[100], dpxseq[100];
int   start, last, yhor, yver, chor, cver, ci, cj;


void dpx2ras(char *dpxname, char *outname);
void read_command(int argc, char ** argv);
void usage();
void dpx2dpx(char *dpxname, char *outname);
YUVimage **pyrTemp;    // useless
YUVimage *pyrFrs;      // useless


void main (int argc, char *argv[])
{
  int i;
  char rasname[80], dpxname[80];
  videoinfo info;
  /*U16 *RGBframe;
  struct dpx *dpxheader;*/

  /* command-line processing */
  read_command(argc, argv);    
  info.start = 0;

  sprintf(info.inname, "%s", dpxseq);



  for(i=start; i<=last; i++){
	  printf(" frame %d is converting ......\n", i);

      sprintf(dpxname, "%s%04d%s", dpxseq, i, ".dpx");
      sprintf(rasname, "%s%04d%s", rasseq, i, ".dpx");
	
	  save_dpx_header(info, i); // save the header from the original dpx file for the reconstructed frame

	  dpx2dpx(dpxname, rasname);
  }
}





/****************************************************************************/
/*                               read_command()                             */
/****************************************************************************/
void read_command(int argc, char ** argv)
{
  int argnum=1, i;

  /* setting the default value */
 // yhor=1920; yver=1080; chor=1920; cver=1080;
  start=0; last=0;
  
  /* read the argument and set the value */
  for(i=1; i<argc ; i++){
    if(*(argv[i])=='-'){
      switch(*(++argv[i])){
      default:
	printf("-%c such an option is not available\n", *(argv[i]));
	usage(); exit(1);
   //   case 's':
//	yhor = atoi(argv[++i]); yver = atoi(argv[++i]); 
//	chor = atoi(argv[++i]); cver = atoi(argv[++i]); 
//	break;
      case 'h':
	usage(); exit(1);
      }
    }
    else{
      switch(argnum){
      default:
	printf("more parameters are specified\n");
	usage(); exit(1);
      case 1:
	strcpy(dpxseq, argv[i]); 
	argnum++; break;
      case 2:
	strcpy(rasseq, argv[i]);
	argnum++; break;
      case 3:
	start = atoi(argv[i]);
	argnum++; break;
      case 4:
	last = atoi(argv[i]);
	argnum++; break;
      }
    }
  }
  
  ci = (cver)? yver/cver : 0;
  cj = (chor)? yhor/chor : 0;

  if(argnum==1){       /* print the usage */
    usage(); exit(1);
  }
  if(start<0 || start>last){
    printf("start %d last %d\n", start, last);
    printf("0<= start, last <1000 and start<=last\n");
    exit(1);
  }
}

/****************************************************************************/
/*                                  usage()                                 */
/****************************************************************************/
void usage()
{
  printf("dpx2ras: dpxfile rasterfile start last\n");
  printf("-h for help\n");
  //printf("-s yhor yver chor cver (def. 1920 1080 1920 1080)\n");
}
