/***************************************************************************
 This program extends Choi's coder to process more than 2 levels of temporal
 decomposition.


 Shih-Ta Hsiang
 May 21, 1998
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h> 
#include <math.h>  
#include <string.h> 
#include <time.h>
#define EXTERN  
#include "basic.h"   
#include "coderN.h" 
#include "encN.h" 
#include "init_encN.h"
#include "initN.h"
#include "ioN.h"
#include "mvcodingN.h"
#include "memoryN.h"
#include "analsyn.h"
#include "miscN.h"
#include "dpx.h"
#include "pstatN.h"
#include "chrom.h"
#include "..\\EZBC0a\\dwt_bitplane_enc.h"
#include "..\\3dCodec\\ezbc_enc_3d.h"

  
//void release_3dezbc_enc();


/*****************************************************************************/
/*                                usage()                                    */
/*****************************************************************************/
void usage()
{
  printf("3DSBCen parameter_file \n");
}


void main(int argc, char **argv)
{
  int    curr, last, i, j, len,downsamp, remaining_frs;//
  int    *mvbits;
  int    default_GOPsz;
  int    header_bytes, GOPheader_bytes;
  long   mark, elp;   // initial and elapsed time
  double duration;
  float  sqrt2;
  long int num_of_GOP, GOP_counter;
  long int overflow = 0;
  long int *output_GOP_bytes;
  short int default_tPyrLev;
  videoinfo   info;
  videoinfo   info2; // only used in info.denoise_flag == YES this case

  ENCODER_TYPE encoder;  //  EZBC0a/dwt_bitplane_enc.h:typedef  Encoder  ENCODER_TYPE; Utils/ar_code.h:class Encoder
  FILE *fpio;
  enum FLAG DENOISE;
  YUVimage  *spatial_high[3], *FourGOP, tempfr, tmpfr; // only used in info.denoise_flag == YES this case

  sqrt2 = (float)sqrt(2.0);
  mark = clock();

  read_command(argc, argv, &info);
  error_check(info);

  DENOISE = info.denoise_flag;

  if(DENOISE == YES){
    info.ywidth /= 2;  info.yheight /= 2;
    info.cwidth /= 2;  info.cheight /= 2;

    FourGOP = (YUVimage *)getarray(4*info.GOPsz, sizeof(YUVimage), "FourGOP");
    for(i=0; i<3; i++){
      spatial_high[i] = (YUVimage *)getarray(info.GOPsz, sizeof(YUVimage), "spatial_high[i]");
	}
  }


  init_enc(&info); // in init_encN.c     

  default_GOPsz = info.GOPsz;
  default_tPyrLev = info.tPyrLev;

  info2header(&header, info);
  write_header(info.bitname, header);  header_bytes = sizeof(videoheader);

  /*
   *4:4:4->4:2:0
   */
  downsamp = 0;
  if( (YUV420 == 1) && (info.yheight == info.cheight) && (info.ywidth == info.cwidth)){
	  downsamp = 1;
  }




  // leave some space for keeping the GOP byte size 
  
  num_of_GOP = (info.last-info.start+1)/info.GOPsz; 
  remaining_frs = (info.last-info.start+1) - num_of_GOP * info.GOPsz; 
  if(remaining_frs != 0){
    for(i=info.tPyrLev-1; i>=0; i--){ 
   	  if(((remaining_frs >> i) & 1) == 1){
		 num_of_GOP += 1;
		 remaining_frs -= 0x1 << i;
	  }
	}
  }
  //printf("info.start= %d, info.last= %d, info.GOPsz= %d, number of GOPs= %d \n", info.start, info.last, info.GOPsz, num_of_GOP);
  //num_of_GOP = (info.last-info.start+1+info.GOPsz-1)/info.GOPsz; 




  output_GOP_bytes = (long int *)getarray(num_of_GOP, sizeof(long int), "output_GOP_bytes");
  for(i=0; i<num_of_GOP; i++) output_GOP_bytes[i] = 0;
  if(!(fpio = fopen(info.bitname, "a+b"))){
    printf("can not open: %s\n", info.bitname); exit(1);
  }
  fwrite(output_GOP_bytes, sizeof(long int), num_of_GOP, fpio); 
  fclose(fpio);
  header_bytes += num_of_GOP*sizeof(long int);
  //printf("total number of GOP= %d, header_bytes = %d\n", num_of_GOP, header_bytes);



//NEW_VECTOR(pyrFrs, info.GOPsz, YUVimage, "YUVimage"); APR25 /*#define NEW_VECTOR(X,N,TYPE,MSG) Test_Pointer(X = new TYPE[N], MSG) Test_Pointer is defined in general.C*/
//  EzbcEnc3d video_enc(info, &encoder); /*"class EzbcEnc3d: public EzbcCodec3d" in ezbc_enc_3d.h, class EzbcCodec3d defined in ezbc_codec_3d.h*/
//  SubbandCodec::setup_luts(); // defined in EZBC0a/dwt_bitplane_codec.h

  curr = info.start; last = info.last;
  GOP_counter = 0;
  switch(info.intra){
  case YES:


	if(DENOISE == YES){
	  printf("can not handle this case\n");	
	  exit(1);
	}


	while(curr<=last){
	  if(curr + info.GOPsz-1 > last){				  
		remaining_frs = last - curr + 1; //printf("remaining frames = %d\n", remaining_frs); 				  
		for(i=info.tPyrLev-1; i>=0; i--){ 		
		  if(((remaining_frs >> i) & 1) == 1){		
			info.tPyrLev = i; //printf("tPyrLev = %d\n", i);// restored after MC-EZBC 			
			break;			
		  }		
		}
        
		info.GOPsz = 0x1 << info.tPyrLev;			 // restored after MC-EZBC  
		
	  } 

			

	  printf(" frame %d ~ frame %d\n", curr, curr+info.GOPsz-1);

	  alloc_pyrFrs_interior(info);

#ifdef THREE_D
		
	  alloc_pyrTemp_interior(info);	
	  for(i = 0; i < info.GOPsz; i++){  	
		read_frame(&pyrTemp[0][i], info, info.inname, curr+i, info.format);  		
	    /*if( downsamp == 1){	    		
		  f444_420(info, &pyrTemp[0][i]);					  
		  info.cwidth /= 2;		
		  info.cheight /= 2;
		}*/
	  }	

	  if(info.GOPsz == 1){	
		copyframe(&pyrTemp[0][0], &pyrFrs[0], info);		
	  }	
	  else{	
		t_anal(info);		
	  }	
	  free_pyrTemp_interior(info);
#else
		
	  for(i = 0; i < info.GOPsz; i++){	    	    
		read_frame(&pyrFrs[i], info, info.inname, curr+i, info.format);  /*ioN.c*/				    

		/*if( downsamp == 1){	    		
		  f444_420(info, &pyrFrs[i]);					  
		  info.cwidth /= 2;		
		  info.cheight /= 2;
		}*/
	  }
#endif  

	  if(info.CBR == YES){	
		info.GOPbytes = (long)((info.bitrate * 1000.0 /8.0) * info.GOPsz/info.framerate)- overflow; 				  		
		if(GOP_counter == 0) info.GOPbytes -= header_bytes;		
	  }	
	  else	
		info.GOPbytes = MAX_STD_INT;
       		
	  output_GOP_bytes[GOP_counter] = ezbc3d_enc(curr, pyrFrs, info, GOP_counter); 
				  
	  if(info.CBR == YES){
		overflow = output_GOP_bytes[GOP_counter] - info.GOPbytes;					  
		printf("GOP %d, overflow = %ld\n", GOP_counter, overflow);
	  }
		
	  /*if( downsamp == 1){
		info.cwidth *= 2;
		info.cheight *= 2;
	  }*/
	
	  GOP_counter++;  
	  curr += info.GOPsz;
	} /* while */
			
	info.GOPsz = default_GOPsz;  // restore default GOP size 	
	info.tPyrLev = default_tPyrLev; // restore default pyramid levels
		
	break;
		


  case NO:




    mvbits = (int *)getarray(num_of_GOP, sizeof(int), "mvbits");
 


	if(DENOISE == YES){
	  info2 = info;
      info2.ywidth *= 2;  info2.yheight *= 2;
      info2.cwidth *= 2;  info2.cheight *= 2;  
	}
 			
	while(curr<=last){
	  if(curr + info.GOPsz-1 > last){				  
		remaining_frs = last - curr + 1; //printf("remaining frames = %d\n", remaining_frs); 				  
		for(i=info.tPyrLev-1; i>=0; i--){ 					  
		  if(((remaining_frs >> i) & 1) == 1){						 
			info.tPyrLev = i; //printf("tPyrLev = %d\n", i);// restored after MC-EZBC 						  
			break;
		  }
		}        
		info.GOPsz     = 0x1 << info.tPyrLev;			 // restored after MC-EZBC  
	  }
			  	
	  printf(" frame %d - %d frame .......\n", curr, curr+info.GOPsz-1);
				  
	  alloc_pyrFrs_interior(info);			  
	  alloc_pyrTemp_interior(info);
 

	  if(DENOISE == YES){
	
  	    for(i=0; i<3; i++){	
  		  for(j = 0; j < info.GOPsz; j++){		
		    frame_alloc(&spatial_high[i][j], info); 		
		  }		
		}
//                  frame_alloc(&tmpfr, info2);  
	  }
	
	  for(i = 0; i < info.GOPsz; i++){ 


		if(DENOISE == YES){


		  int filterType = 2;
/*******
 spatial 
analysis
********/        
		  frame_alloc(&tempfr, info2); // info2 		
		  read_frame(&tempfr, info2, info.inname, curr+i, info.format);  
				  
				
		  if( downsamp == 1){	    
				
			f444_420(info2, &tempfr); 
					 
			info2.cwidth /= 2;
			info2.cheight /= 2;
			info.cwidth /= 2;
			info.cheight /= 2;

		    spatial_anal(tempfr.Y, info2.ywidth, info2.yheight, pyrTemp[0][i].Y, 		
		      spatial_high[0][i].Y, spatial_high[0][i].U, spatial_high[0][i].V, filterType);
				
		  }
		  else{
		    spatial_anal(tempfr.Y, info2.ywidth, info2.yheight, pyrTemp[0][i].Y, 		
		      spatial_high[0][i].Y, spatial_high[1][i].Y, spatial_high[2][i].Y, filterType);
		
		    if(info2.cwidth && info2.cheight){			
  		      spatial_anal(tempfr.U, info2.cwidth, info2.cheight, pyrTemp[0][i].U, 			
			    spatial_high[0][i].U, spatial_high[1][i].U, spatial_high[2][i].U, filterType);     		
		      spatial_anal(tempfr.V, info2.cwidth, info2.cheight, pyrTemp[0][i].V,    				
  			    spatial_high[0][i].V, spatial_high[1][i].V, spatial_high[2][i].V, filterType);					
			}
		  }
/*******
 spatial   
synthesis
********/					
/*					spatial_syn(tmpfr.Y, info2.ywidth, info2.yheight, pyrTemp[0][i].Y, 
						spatial_high[0][i].Y, spatial_high[1][i].Y, spatial_high[2][i].Y);
					if(info2.cwidth && info2.cheight){
						spatial_syn(tmpfr.U, info2.cwidth, info2.cheight, pyrTemp[0][i].U, 
							spatial_high[0][i].U, spatial_high[1][i].U, spatial_high[2][i].U);
     				    spatial_syn(tmpfr.V, info2.cwidth, info2.cheight, pyrTemp[0][i].V, 
   						    spatial_high[0][i].V, spatial_high[1][i].V, spatial_high[2][i].V);
					}
                    snr_frame(&ysnr, &usnr, &vsnr, &tempfr, &tmpfr, info2);
                    printf("%f %f %f\n", ysnr, usnr, vsnr);
*/
		}
		else{
  	        		//read_frame(&pyrTemp[0][i], info, info.inname, info.last+1-(curr+i), info.format);  //ioN.c					
		  read_frame(&pyrTemp[0][i], info, info.inname, curr+i, info.format);  
		}

  
#ifdef STATISTICS                    
		float yvar, uvar, vvar;							
		yvar = variance(pyrTemp[0][i].Y, info.ywidth, info.yheight, info.ywidth); 		
		uvar = variance(pyrTemp[0][i].U, info.cwidth, info.cheight, info.cwidth); 		
		vvar = variance(pyrTemp[0][i].V, info.cwidth, info.cheight, info.cwidth); 		
		printf("yvar = %f, uvar = %f, vvar = %f\n", yvar, uvar, vvar);
#endif
			        /*write_frame(pyrTemp[0][i], info, info.decname, curr+i, info.format); exit(0);*/ 



	
		if(DENOISE == YES){
//                  free_frame_interior(tmpfr);                 
		  free_frame_interior(tempfr);
		}
	  }
			  
/******
  MCTF
*******/

	
	  if(info.tPyrLev >= 1){
	    	       //reset(info);  not needed. Its work is done in init_enc() and free_mvs()     
		mc_anal(curr, info);   		
		GOPheader_bytes = write_GOPheader(scene_change, info);                   
		mvbits[GOP_counter] = mv_encoding(info, FrsRate, yfmv);      
		free_mvs(yfmv, info);
	  }	
	  else{       
		mvbits[GOP_counter] = 0;
					  // no GOPheader output		
		copyframe(&pyrTemp[0][0], &pyrFrs[0], info);
	  }

#ifdef STATISTICS      
	  varianceGOP(pyrFrs, info, &FrsRate);  // in miscN.c       
	  for(j=0; j<info.GOPsz; j++){	 
		printf("yvar= %0.2f\n", FrsRate.yvar[j]);        
		avgvar[0][j] += FrsRate.yvar[j];        
		avgvar[1][j] += FrsRate.uvar[j];        
		avgvar[2][j] += FrsRate.vvar[j];				 		
	  }
                   //pstat(&FrsRate, &info, info.GOPsz); // pstatN.c 
#endif				 
	  if(info.bi_flag == YES){ 
		//copyframe(&pyrTemp[0][info.GOPsz-1], &end_of_lastGOP, info);	
		wcopyframe(&pyrFrs[0], &end_of_lastGOP, (float)(1./pow(2., info.tPyrLev/2.)), info); //When we realize adaptive gop size, pyrFrs[0] may not have info.tPyrLev mctf.
	  }				 
	  free_pyrTemp_interior(info);
/******
  EZBC
******/	
	  // rate control
	
	  if(info.CBR == YES){	
		info.GOPbytes = (long)((info.bitrate * 1000.0 /8.0) * info.GOPsz/info.framerate) - overflow;				 		
		if(GOP_counter == 0) info.GOPbytes -= header_bytes;                 		
		info.GOPbytes -= (GOPheader_bytes + mvbits[GOP_counter]/8);  // mvbits/8 may be a little different from the true number.		
	  }	
	  else	
		info.GOPbytes = MAX_STD_INT;


	  if(DENOISE == YES){
		if(downsamp == 1){

        for(j=0; j<info.GOPsz; j++){	
		  FourGOP[j] = pyrFrs[j];		
		}      
	    for(i=0; i<1; i++){	
		  for(j=0; j<info.GOPsz; j++){		
		    FourGOP[(i+1)*info.GOPsz+j] = spatial_high[i][j];		
		  }		
		}  	
	    info.GOPsz *= 2;   	
	    output_GOP_bytes[GOP_counter] = ezbc3d_enc(curr, FourGOP, info, GOP_counter); 	
	    info.GOPsz /= 2;

		}
		else{

        for(j=0; j<info.GOPsz; j++){	
		  FourGOP[j] = pyrFrs[j];		
		}      
	    for(i=0; i<3; i++){	
		  for(j=0; j<info.GOPsz; j++){		
		    FourGOP[(i+1)*info.GOPsz+j] = spatial_high[i][j];		
		  }		
		}  	
	    info.GOPsz *= 4;   	
	    output_GOP_bytes[GOP_counter] = ezbc3d_enc(curr, FourGOP, info, GOP_counter); 	
	    info.GOPsz /= 4;

		}


	  }
	  else{
	    output_GOP_bytes[GOP_counter] = ezbc3d_enc(curr, pyrFrs, info, GOP_counter); 
	  }	
	  overflow = output_GOP_bytes[GOP_counter] - info.GOPbytes;
//				 alloc_pyrTemp_interior(info);
//				 mc_syn(curr); /* pyrFrs may be changed in mc_syn() */
// 				 free_pyrTemp_interior();



	  if( downsamp == 1) {
		info2.cwidth *= 2;
		info2.cheight *= 2;
		info.cwidth *= 2;
		info.cheight *= 2;
	  }
	
	  GOP_counter++;	
	  curr += info.GOPsz;				 
     } /* while */
			
	 info.GOPsz = default_GOPsz;	 // restore default GOP size	
	 info.tPyrLev = default_tPyrLev; // restore default pyramid level


            //calsnr(&cfr, &pfr, info.start, info.last, info);
					 /* pstatN.c */ /* cfr and pfr are just used as the memory in calsnr, and the data in cfr and pfr is not used in calsnr */

#ifdef STATISTICS
	 print_stat(info);
#endif
         
	 print_mvbits(info, num_of_GOP, mvbits); //pstatN.c
	 free(mvbits);
				 
		 
	 break;     

  default:
	printf("error (encoderN.c)\n");	
	exit(1);
   }
 

//    release_3dezbc_enc();

//    for(i = 0; i < nFrsPyr; i++){
//      free_frame_interior(pyrFrs[i]);
//    }

   
  
  if(!(fpio = fopen(info.bitname, "r+b"))){
    printf("can not open: %s\n", info.bitname); exit(1);
  }
  fseek(fpio, sizeof(videoheader), SEEK_SET);
  fwrite(output_GOP_bytes, sizeof(long int), num_of_GOP, fpio); 
  fclose(fpio);
  //for(i=0; i<num_of_GOP; i++) printf("%d\n", output_GOP_bytes[i]);
  free(output_GOP_bytes);

  
#ifdef STATISTICS
  free(unconnectedL);
#endif

  free_memory(info);

  if(DENOISE == YES){
    for(i=0; i<3; i++)
	  free(spatial_high[i]);
    free(FourGOP);
  }

	 
  for(i = 0; i < info.tPyrLev; i++){       
	   free(GOPscene[i]-1);
	   free(scene_change[i]);
  }     
  free(GOPscene);      
  free(scene_change);
  free(video_scene_change);

  free_frame_interior(pfr);
  free_frame_interior(cfr);

  elp = clock() - mark;   
  duration = (double)elp / CLOCKS_PER_SEC;
  print_time(duration);

  printf("finished.\n");

  return;
}






