#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "basic.h"
#define EXTERN extern
#include "coderN.h"
#include "init_encN.h"
#include "memoryN.h"
#include "dpx.h"
extern U16 colorLUT[1024];

#define  Yes      1
#define  No       0


extern long int totalY[5], totalU[5], totalV[5], totalmap[5], totalMV[5];

int rateAlloc(Rate_ptr FrsRate, int nfrs);
void  interpolate_filter();

/*****************************************************************************/
/*                             init()                                        */
/*****************************************************************************/
void init_enc(videoinfo *info)
{
  int   i, j, xnum, ynum, xblk, yblk, hor, ver, len, cut;
  char name[100];
  FILE  *fpstat, *fpbit, *fp;

  interpolate_filter();

  for(i=0; i<5; i++){
    totalY[i]=0;
    totalU[i]=0;
    totalV[i]=0;
    totalmap[i]=0;
    totalMV[i]=0;
  }

  /************ initialize the sequence information ***************/
  if(info->level){
    hor = info->ywidth;  ver = info->yheight;
    xblk = info->xblk;   yblk = info->yblk;
    xnum = (!(hor%xblk))? hor/xblk : hor/xblk+1;
    ynum = (!(ver%yblk))? ver/yblk : ver/yblk+1;
    info->xnum = xnum;   info->ynum = ynum;
  }



  //info->maxx  =  info->maxx*info->search;
  //info->maxy  =  info->maxy*info->search;


  /************ allocate the 1st layer motion vectors *************/
  if(info->level){
    /*mvtop = (mvnode_ptr)getarray(info.GOPsz, sizeof(mvnode), "mvtop");   APR23*/
    yfmv = (vector_ptr*) getarray(info->GOPsz, sizeof(vector_ptr), "yfmv_ptr");
    for(j = 1; j <  info->GOPsz; j++){
      yfmv[j] = (vector_ptr) getarray(xnum*ynum, sizeof(vector), "yfmv");

      for(i=0 ; i<xnum*ynum ; i++){
        yfmv[j][i].child=0; yfmv[j][i].parent=NULL; 
		yfmv[j][i].mode = DEFAULT;
		yfmv[j][i].merge = YES;
      }
    }
  }

  /************ allocate the frame *************/
  if(info->level){
    frame_alloc(&pfr, *info);  /* in memoryN.c */
    frame_alloc(&cfr, *info);
//    frame_alloc(&nfr, *info);
    frame_alloc(&end_of_lastGOP, *info); 

  }
  else{
	frame_alloc(&cfr, *info);
  }

  if(info->tPyrLev >= 1){

    pyrFrs = (YUVimage_ptr)getarray(info->GOPsz, sizeof(YUVimage), "pyrFrs_ptr");
//    for(i = 0; i < info.GOPsz; i++){
//      frame_alloc(&pyrFrs[i], info);
//    }    
	
	pyrTemp = (YUVimage_ptr*)getarray(info->tPyrLev, sizeof(YUVimage_ptr), 
                                      "pyrTemp");
    len = info->GOPsz;               /*Chen Jan 27,00*/
    for(i = 0; i < info->tPyrLev; i++){  /*Chen Jan 27,00*/
      pyrTemp[i] = (YUVimage_ptr)getarray(len, sizeof(YUVimage), 
                                       "pyrTemp[]");
//      for(j = 0; j < len; j++){
//        frame_alloc(&pyrTemp[i][j], info);
//      }
      len /= 2;
	}
  }
  else{
    pyrFrs = (YUVimage_ptr)getarray(info->GOPsz, sizeof(YUVimage), "pyrFrs_ptr");
	pyrTemp = (YUVimage_ptr*)getarray(1, sizeof(YUVimage_ptr), 
                                      "pyrTemp");
	pyrTemp[0] = (YUVimage_ptr)getarray(1, sizeof(YUVimage), 
                                       "pyrTemp[]");
  }



  /********************* rate allocation **********************/

  rateAlloc(&FrsRate, info->GOPsz);

  frY = (float**)getarray(info->GOPsz, sizeof(float*), "*frY");
  frU = (float**)getarray(info->GOPsz, sizeof(float*), "*frU");
  frV = (float**)getarray(info->GOPsz, sizeof(float*), "*frV");
//  info->prate = (1000.*info->bitrate)/info->framerate;
//  info->GOPbit = info->prate*info->GOPsz;

  info->buff_max = (int)(2.*info->prate + 0.5); /* not sure???? */
  info->generated = 0;
  info->diff = 0;
  info->buff_full = 0;

  /******************** initialize the statefile **************/
  if(!(fpstat=fopen(info->statname,"wb"))){
    printf("init: %s\n", info->statname);
    exit(1);
  }
  fprintf(fpstat, "-------------------------------------------------\n");
  fprintf(fpstat, " Input sequence : %s\n", info->inname);
  //fprintf(fpstat, " Coded sequence : %s\n", info->decname);
  fprintf(fpstat, " Motion vectors : %s\n", info->mvname);
  fprintf(fpstat, " Bit file       : %s\n", info->bitname);
  fprintf(fpstat, " Status log     : %s\n\n", info->statname);
  if(info->level==1){
    fprintf(fpstat, " Motion : FSBM with Bx %d By %d and",info->xblk,info->yblk);
    if(info->subpel == 4) fprintf(fpstat, " 1/16-pixel accuracy\n");
    else if(info->subpel == 3) fprintf(fpstat, " 1/8-pixel accuracy\n");
    else if(info->subpel == 2) fprintf(fpstat, " quater-pixel accuracy\n");
    else if(info->subpel == 1) fprintf(fpstat, " half-pixel accuracy\n");
	else  fprintf(fpstat, " full-pixel accuracy\n");
  }
  else if(info->level==5){
    fprintf(fpstat, " Motion : HVSBM with lambda %.1f and", info->lambda);
    if(info->subpel == 4) fprintf(fpstat, " 1/16-pixel accuracy\n");
    else if(info->subpel == 3) fprintf(fpstat, " 1/8-pixel accuracy\n");
    else if(info->subpel == 2) fprintf(fpstat, " quater-pixel accuracy\n");
    else if(info->subpel == 1) fprintf(fpstat, " half-pixel accuracy\n");
	else  fprintf(fpstat, " full-pixel accuracy\n");

  }
  fprintf(fpstat, " search : %4d\n", info->search);
  fprintf(fpstat, " start  : %4d\n", info->start);
  fprintf(fpstat, " last   : %4d\n", info->last);
  fprintf(fpstat, " size   : (Y) %d x %d  (C) %d x %d\n", 
	  info->ywidth, info->yheight, info->cwidth, info->cheight);
  fprintf(fpstat, " framerate : %d (frames/sec)\n", info->framerate);
  fprintf(fpstat, " rate   : %d (kbits/sec)\n", info->bitrate);
//  fprintf(fpstat, "   initial bits for GOP = %d bits\n", info->GOPbit); 

  fprintf(fpstat, "-------------------------------------------------\n");
  fclose(fpstat);

  /******************* newly open the bitfile ******************/
  if(!(fpbit = fopen(info->bitname, "wb"))){
    printf("init: %s\n",info->bitname); exit(1);
  }
  fclose(fpbit);

  sprintf(name, "%s_rd_sample.dat", info->bitname); // this file will be open for write in video_enc.write_rd() of 3d_enc_main.cpp
  if(!(fp=fopen(name, "wb"))){
	  printf("init: can not open %s\n", name);
	  exit(1);
  }
  fclose(fp);



  // scene change description
   
	// If we have scene change detection, we could keep the information in video_scene_change.
	video_scene_change = (enum FLAG *)getarray(info->last+1, sizeof(enum FLAG), "video_scene_change"); // add 1 in case info.start=0  
	scene_change = (enum FLAG **)getarray(info->tPyrLev, sizeof(enum Flag *), "scene_change"); 
	GOPscene = (int **)getarray(info->tPyrLev, sizeof(int *), "GOPscene");

    len = info->GOPsz;         
    for(i = 0; i < info->tPyrLev; i++){  
      GOPscene[i] = (int *)getarray(len+1, sizeof(int), "GOPscene");
	  GOPscene[i] = GOPscene[i] + 1;// So the GOPscene[-1] is for the last frame of the previous GOP.
      scene_change[i] = (enum FLAG *)getarray(len, sizeof(enum FLAG), "scene_change");
      len /= 2; 
	}


    video_scene_change[info->start] = YES;    //printf("%d\n", video_scene_change[1]);
    for(i=info->start+1; i<=info->last; i++){
      video_scene_change[i] = NO; //printf("%d\n", video_scene_change[i]);
	}

    if(info->CUT == YES){
    //cut = 67;
	  cut = 198; //cut = 162;  //"cut" indicates the last frame of current scene.
	  video_scene_change[cut+1] = YES;
	  cut = 345;
	  video_scene_change[cut+1] = YES;
      cut = 586;
	  video_scene_change[cut+1] = YES;	
	}



  #ifdef STATISTICS        
	        unconnectedL = (long int *)getarray(info->tPyrLev, sizeof(long int), "unconnectedL");
			for(i=0; i<info->tPyrLev; i++)
               unconnectedL[i]=0;
			for(i=0; i<3; i++){
				for(j=0; j<info->GOPsz; j++){
                   avgpsnr[i][j]=0.;
                   //avgpsnr_cod[i][j]=0.;
                   avgvar[i][j] = 0.;
				}
			}
  #endif



}



/*****************************************************************************/
/*                                error_check()                              */
/*****************************************************************************/
void error_check(videoinfo info)
{
  if(!strcmp(info.inname,"NULL")){
    printf("error in read_command(): specify -inname input\n");  exit(1);
  }
  /*if(!strcmp(info.decname,"NULL")){
    printf("error in read_command(): specify -decname coded_file\n");  exit(1);
  }*/
  if(!strcmp(info.bitname,"NULL")){
    printf("error in read_command(): specify -bitname bitfile\n");  exit(1);
  }
  if(!strcmp(info.statname,"NULL")){
    printf("error in read_command(): specify -statname statusfile\n"); exit(1);
  }
  if(info.level==-1){
    printf("error in read_command(): specity -motion fsbm(hvsbm)\n"); exit(1);  }
  if(info.start<0 || info.start>info.last){
    printf("error in read_command(): start %d last %d\n",info.start,info.last);
    printf("0<= start, last <1000 and start<=last\n");
    exit(1);
  }
  if(info.ywidth<0 || info.yheight<0 || info.cwidth<0 || info.cheight<0){
    printf("error in read_command(): image size\n");
    printf(" Y: %d x %d, C: %d x %d\n", info.ywidth, info.yheight, 
           info.cwidth, info.cheight); 
    exit(1);
  }
  if(info.start < 0){
	  printf("can not handle this case (encoderN.c)\n");
	  exit(1);
  }

  if(info.ywidth%8){
    printf("error: Y width %d should be multiple of 8.(encoderN.c)\n", info.ywidth); exit(1);
  }
  if(info.yheight%8){
    printf("error: Y height %d should be multiple of 8.(encoderN.c)\n", info.yheight); 
	exit(1);
  }
  if(info.cwidth%8){
    printf("C width %d should be multiple of 8.\n", info.cwidth); //exit(1);
  }
  if(info.cheight%8){
    printf("C height %d should be multiple of 8.\n", info.cheight);// exit(1);
  }
  if(info.bitrate<0){
    printf("error in read_command(): rate %d\n", info.bitrate);
    exit(1);
  }
  if(info.intra == YES && info.denoise_flag == YES){
    printf("error in read_command(): both info.intra == YES && info.denoise_flag == YES \n");
    exit(1);
  }

#ifndef LIFTING
  if(info.subpel != 0 && info.subpel != 1){
	printf("can not support subpixel accuracy MCTF\n");
	exit(1);
  }
#endif

}
  /* quad tree structured should be cleaned before starting the next */
  /* so, clean the structure except 1st layer */
  /* fmv->child and fmv->mode should be initialized to 0 */

/*****************************************************************************/
/*                              read_command()                               */
/*****************************************************************************/
void read_command(int argc, char **argv, videoinfo *info)
{
  int   i, argnum=1;
  char  iline[256], token[80], istring[80], strtmp[80]; 
  FILE  *fppar;

  /********** setting the initial or default values ************/
  strcpy(info->inname,  "NULL");
  //strcpy(info->decname, "NULL");
  strcpy(info->bitname, "NULL");
  strcpy(info->statname,"NULL");
  strcpy(info->tmpname, "mvbit.tmp"); 

  info->level = -1;  info->lambda = 24.; //
  info->ME    = 1;  /* ???? not output to bitstream */
  info->subpel  = 2;
  info->start = -1;  info->last   = -1;
  info->ywidth= 352; info->yheight= 240; 
  info->cwidth= 176; info->cheight= 120; 
  info->framerate = 24; 
  info->bitrate=0;
  info->verbose  =0;
  info->nFrsGOP  = 8;  
  info->adapt_flag = YES;
  info->bi_flag  = YES;
  info->OPEN_GOP = YES;
  info->CUT      = NO;
  info->MCP_flag = NO;
  info->tPyrLev  = 3;
  info->GOPsz    = 0x1 << info->tPyrLev;
  //nFrsPyr = 16; 

  info->CBR      = NO;
  info->format   = DPX;
  info->intra    = NO;
  info->denoise_flag = NO;
  info->coding_domain = LOG;
 
  /************* read the argument and set the value ********/
  //info->bitrate = atoi(argv[2]); 

  //if(argc==5 && !strcmp(argv[4], "-verbose")) info->verbose=1;

  if(argc == 1){    
	usage(); exit(1);
  }

  for(i=1; i<argc ; i++){
	if(*(argv[i])=='-'){

      switch(*(++argv[i])){
      default:
	    printf("-%c such an option is not available\n", *(argv[i]));
    	usage(); exit(1);
      case 'h':	 
		usage(); exit(1);
	    break;
	  }
	}
    else{
      switch(argnum){
      default:
	    printf("more parameters are specified\n");
 	    usage(); exit(1);
      case 1:
	    fppar = fopen(argv[i], "rt");
		if(fppar == NULL){
		  printf("can not open file %s\n", argv[i]);
		  usage();
          exit(1);
		}
	    argnum++; break;
	  /*case 2:
		info->lambda  = (float)atof(argv[i]); printf("lambda = %f\n", info->lambda);
	    argnum++; break;*/

      }
    }
  }





  while(fgets(iline, 254, fppar)){      /* read one line */
    sscanf(iline, "%s", token); 

	if(!strcmp(token, "-inname")){
      sscanf(iline, "%s%s", token, info->inname);  
    }
    else if(!strcmp(token, "-decname")){
      sscanf(iline, "%s%s", token, info->decname);  
    }
    else if(!strcmp(token, "-bitname")){
      sscanf(iline, "%s%s", token, info->bitname);  
      strncpy(strtmp, info->bitname, 2);
	  // --- IVB: 2003/10/4
      //sprintf(info->mvstatname, "%.2s%s", strtmp, "_mvby");
	  sprintf(info->mvstatname, "%s%s", info->bitname, "_mvby");
	  // -------- 2003/10/4
      sprintf(info->tsubname, "Temp/%.2s%s", strtmp, "_t");
    }
    else if(!strcmp(token, "-statname")){
      sscanf(iline, "%s%s", token, info->statname);  
    }
    else if(!strcmp(token, "-start")){
      sscanf(iline, "%s%d", token, &(info->start)); 
    }
    else if(!strcmp(token, "-last")){
      sscanf(iline, "%s%d", token, &(info->last));
    }
    else if(!strcmp(token, "-size")){
      sscanf(iline, "%s%d%d%d%d", token, &(info->ywidth), &(info->yheight),
             &(info->cwidth), &(info->cheight));
    }
    else if(!strcmp(token, "-framerate")){
      sscanf(iline, "%s%d", token, &(info->framerate));
    }
    else if(!strcmp(token, "-search")){
      sscanf(iline, "%s%d", token, &(info->search));
      info->maxx  =  info->search;
      info->maxy  =  info->search;

    }
	else if(!strcmp(token, "-format")){
		sscanf(iline, "%s%s", token, istring);
		if(!strcmp(istring, "DPX")){
			info->format = DPX; 
            //sscanf(iline, "%s%s%d%d", token, istring, &(info->min), &(info->max));		
			sscanf(iline, "%s%s", token, istring);	
			info->min = 0;
			info->max = 1023;
			info->pixeldepth = 10;
		}
		else if(!strcmp(istring, "RAS")){
			info->format = RAS; 
			info->pixeldepth = 8;
		}
		else if(!strcmp(istring, "YUV")){
			info->format = YUV;
			info->pixeldepth = 8;
		}
		/* IVB 2004/4/7 ---------------- */
		else if(!strcmp(istring, "FLT")){
			info->format = FLT;
			info->pixeldepth = 32;  // 4 Bytes (?)
		}
		/* IVB 2004/4/7 ------ end ----- */
		else{
			printf("-format options error\n");
			exit(1);
		}
	}
	/*else if(!strcmp(token, "-log")){    //-log
		sscanf(iline, "%s%s", token, istring);
		if(!strcmp(istring, "YES")){
			info->log = YES;
		}
		else if(!strcmp(istring, "NO")){
			info->log = NO;
		}
		else{
			printf("-log options error\n");
			exit(1);
		}
	}*/
	else if(!strcmp(token, "-data")){  //-data
		sscanf(iline, "%s%s", token, istring);
		if(!strcmp(istring, "LOG")){
			info->coding_domain = LOG;
		}
		else if(!strcmp(istring, "LINEAR")){
			info->coding_domain = LINEAR;
		}
		else if(!strcmp(istring, "VIDEO")){
			info->coding_domain = VIDEO;
		}
		else{
			printf("-data options error\n");
			exit(1);
		}
	}   
	else if(!strcmp(token, "-intra")){
     	sscanf(iline, "%s%s", token, istring);
		if(!strcmp(istring, "YES")){
			info->intra = YES;
		}
		else if(!strcmp(istring, "NO")){
			info->intra = NO;
		}
		else{
			printf("-intra options error\n");
			exit(1);
		}
	}
	else if(!strcmp(token, "-denoise")){
     	sscanf(iline, "%s%s", token, istring);
		if(!strcmp(istring, "YES")){
			info->denoise_flag = YES;
		}
		else if(!strcmp(istring, "NO")){
			info->denoise_flag = NO;
		}
		else{
			printf("-denoise options error\n");
			exit(1);
		}
	}

    else if(!strcmp(token, "-motion")){
      sscanf(iline, "%s%s", token, istring);
      if(!strcmp(istring, "fsbm")){
        info->xblk  = 16; info->yblk  = 16;
        info->maxx  =  8; info->maxy  =  8;
        info->level =  1;
        info->ME = 0;
      }
      else if(!strcmp(istring, "hvsbm")){
        info->xblk  = 64; info->yblk  = 64;
        //info->maxx  =  1; info->maxy  = 1;
        info->level =  5;
        info->ME = 1;
      }
      else if(!strcmp(istring, "mrf")){
        info->xblk = info->yblk = 4;
        info->maxx  =  7; info->maxy  =  7;
        info->level =  1;
        info->search = 1;
        info->ME = 2;
      }
      else{
        printf("-motion options error (fsbm or hvsbm)\n");
        exit(1);
      }
    }
    else if(!strcmp(token, "-lambda")){
      sscanf(iline, "%s%f", token, &(info->lambda));
    }
    else if(!strcmp(token, "-accuracy")){
      sscanf(iline, "%s%s", token, istring);
      if(!strcmp(istring, "sixteenth"))   info->subpel=4;
      else if(!strcmp(istring, "eighth")) info->subpel=3;
      else if(!strcmp(istring, "quater")) info->subpel=2;
      else if(!strcmp(istring, "half"))   info->subpel=1;
      else if(!strcmp(istring, "full"))   info->subpel=0;
      else{
        printf("-accuracy options error (full, half, quater, eighth, or sixteenth)\n");
        exit(1);
      }
    }

    else if(!strcmp(token, "-CBR")){
      sscanf(iline, "%s%s", token, istring);
	  if(!strcmp(istring, "YES")){
		info->CBR = YES;
	  }
	  else if(!strcmp(istring, "NO")){
	  	info->CBR = NO;
	  }
	  else{
		printf("-CBR options error\n");
		exit(1);
	  }
	}
    else if(!strcmp(token, "-adapt_flag")){
      sscanf(iline, "%s%s", token, istring);
	  if(!strcmp(istring, "YES")){
		info->adapt_flag = YES;
	  }
	  else if(!strcmp(istring, "NO")){
	  	info->adapt_flag = NO;
	  }
	  else{
		printf("-adapt_flag options error\n");
		exit(1);
	  }
	}

    else if(!strcmp(token, "-bi_flag")){
      sscanf(iline, "%s%s", token, istring);
	  if(!strcmp(istring, "YES")){
		info->bi_flag = YES;
	  }
	  else if(!strcmp(istring, "NO")){
	  	info->bi_flag = NO;
	  }
	  else{
		printf("-bi_flag options error\n");
		exit(1);
	  }
	}

    else if(!strcmp(token, "-OPEN_GOP")){
      sscanf(iline, "%s%s", token, istring);
	  if(!strcmp(istring, "YES")){
		info->OPEN_GOP = YES;
	  }
	  else if(!strcmp(istring, "NO")){
	  	info->OPEN_GOP = NO;
	  }
	  else{
		printf("-OPEN_GOP options error\n");
		exit(1);
	  }
	}

    else if(!strcmp(token, "-CUT")){
      sscanf(iline, "%s%s", token, istring);
	  if(!strcmp(istring, "YES")){
		info->CUT = YES;
	  }
	  else if(!strcmp(istring, "NO")){
	  	info->CUT = NO;
	  }
	  else{
		printf("-CUT options error\n");
		exit(1);
	  }
	}
    else if(!strcmp(token, "-MCP")){
      sscanf(iline, "%s%s", token, istring);
	  if(!strcmp(istring, "YES")){
		info->MCP_flag = YES;
	  }
	  else if(!strcmp(istring, "NO")){
	  	info->MCP_flag = NO;
	  }
	  else{
		printf("-MCP options error\n");
		exit(1);
	  }
	}

    else if(!strcmp(token, "-tPyrLev")){
      sscanf(iline, "%s%d", token, &(info->tPyrLev));
      if(info->tPyrLev < 0 || info->tPyrLev > 4){
        printf("illegal temporal pyr. layer number(0 - 6)\n");
        exit(1);
      }else{
//	    nFrsPyr = (int)pow(2.0, (double)info->tPyrLev);
        info->GOPsz     = 0x1 << info->tPyrLev;

      }
    }
    else if(!strcmp(token, "-nFrsGOP")){
      sscanf(iline, "%s%d", token, &(info->nFrsGOP));
    }   
    else if(token[0]=='-'){
      printf("%s such a token is not available\n", token);
      usage(); exit(1);
    }
    else {
    }
  }
  fclose(fppar);


  sprintf(info->mvname, "MV\\%.2smv", info->bitname);

  error_check(*info);


}

