#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "basic.h"
#define EXTERN extern
#include "encoderN.h"
#include "bmeN.h"
#include "analsyn.h"
 

 /*****************************************************************************/
/*                              local_mc_analysis()                           */
/* fr1--current, fr0 --reference                                              */
/******************************************************************************/
void local_mc_analysis(float *lfr, float *hfr, float *fr1, float *fr0, float *mvx, float *mvy, int hor, int ver, int level, 
				 int pair,  int local) /* fr1 - current frame fr0 - previous frame */
{
  int cx, cy, cpos;
  float c1, c2, c3, c4, c5, pfx, pfy, ptmp;
  //unsigned char *pused;

  /* temporal filtering */
  c1=1./sqrt(2.); c2=c1;  c3=c1;  c4=c1;  c5=sqrt(2.);  /* orthonormal */


  /* generate temporal high subband */
  for(cy=0 ; cy<ver ; cy++){
    for(cx=0 ; cx<hor ; cx++){
      cpos = cy*hor+cx; 

      if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ 
        pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
		ptmp = interpolate(pfx, pfy, fr0, hor, ver, TYPE);
		hfr[cpos] = c1*fr1[cpos] - c2*ptmp;
	  }	        
    }
  }

}

/*****************************************************************************/
/*                              mc_analysis()                                */
/* fr1--current, fr0 --reference (next)                                      */
/*****************************************************************************/
void mc_analysis(float *lfr, float *hfr, float *fr1, float *fr0, float *mvx, float *mvy, int hor, int ver, int level, 
				 int pair,  int local) /* fr1 - current frame fr0 - previous frame */
{
  int i;
  int cx, cy, px, py, cpos, ppos, case1, case2;
  float c1, c2, c3, c4, c5, cfx, cfy, pfx, pfy, ctmp, ptmp;
  unsigned char *pused;

  /* temporal filtering */
  c1=1./sqrt(2.); c2=c1;  c3=c1;  c4=c1;  c5=sqrt(2.);  /* orthonormal */


  /* generate temporal high subband */
  for(cy=0 ; cy<ver ; cy++){
    for(cx=0 ; cx<hor ; cx++){
      cpos = cy*hor+cx; 

      if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ 
        pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
		ptmp = interpolate(pfx, pfy, fr0, hor, ver, TYPE);
		hfr[cpos] = c1*fr1[cpos] - c2*ptmp;
	  }	        
    }
  }


  /* generate temporal low subband */
  pused = (unsigned char *) getarray(hor*ver, sizeof(unsigned char), "pused");
  for(i=0 ; i<hor*ver ; i++) pused[i]=0;
  case1=0; case2=0;

  for(cy=0 ; cy<ver ; cy++){
    for(cx=0 ; cx<hor ; cx++){
      cpos = cy*hor+cx; 

      if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ 

        pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];

        position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver);
        ppos = py*hor+px;
        cfx = px+mvx[cpos]; cfy = py+mvy[cpos];

        if(pused[ppos]!=USED && inbound(cfx, cfy, hor, ver)){  /* filtering */
	      case1++;
	      pused[ppos]=USED;

	      ctmp = interpolate(cfx, cfy, hfr, hor, ver, TYPE);
	      lfr[ppos] = ctmp + c5*fr0[ppos];
		}
	  }

    }
  }

  /* step 2 -- unconnected pixel */        
  if(local == Global){
    for(py=0 ; py<ver ; py++){
      for(px=0 ; px<hor ; px++){
        ppos = py*hor+px;
	    
        if(!pused[ppos]){
	      case2++;
	      lfr[ppos] = c5*fr0[ppos];
		}
	  }
	}
  }

  /* checking */
  if(case1+case2!=hor*ver){
    printf("error in mctf() covered: %d, uncovered: %d\n", case1, case2);
    exit(1);
  }


  free(pused);
}


/*****************************************************************************/
/*                              local_mc_synthesis()                               */
/* fr1--current, fr0--reference                                              */
/*****************************************************************************/
void local_mc_synthesis(float *fr1, float *fr0, float *lfr, float *hfr, float *mvx, float *mvy, int hor, int ver, 
				   int local, int level, int pair, videoinfo info)
{
  int cx, cy, cpos, case3;
  float c1, c2, c3, c4, c5, pfx, pfy, ptmp;

  /* temporal synthesis */
  c1=1./sqrt(2.); c2=c1;  c3=1.;  c4=sqrt(2.); c5=1./sqrt(2.);/*orthonormal*/

  /* reconstruct fr1 */
  case3=0;
  for(cy=0 ; cy<ver ; cy++){
    for(cx=0 ; cx<hor ; cx++){
      cpos = cy*hor+cx; 

	  if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ 

        pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
	    case3++;

		// IVB 2004/3/22 --------------------------
		if (pfx < 0.0) pfx = 0.0; if (pfy < 0.0) pfy = 0.0;
		if (pfx > (float)(hor-1)) pfx = (float)(hor-1); 
		if (pfy > (float)(ver-1)) pfy = (float)(ver-1);
		//printf("rounded pfx = %d, pfy = %d\n",((int)(pfx*16))%16, ((int)(pfy*16))%16);
		if (((int)(pfx*16))%16 < 0 || ((int)(pfy*16))%16 < 0)
		{
			printf("Error pfx or pfy!\n");
			printf("rounded pfx = %d, pfy = %d\n",((int)(pfx*16))%16, ((int)(pfy*16))%16);
			printf("pfx = %10.2f, pfy = %10.2f\n",pfx, pfy);
		}
		// IVB 2004/3/22 ------- end --------------

	    ptmp = interpolate(pfx, pfy, fr0, hor, ver, TYPE);
	    fr1[cpos] = ptmp + c4*hfr[cpos];
	  }
    }
  }
  

}




/*****************************************************************************/
/*                              mc_synthesis()                               */
/* fr1--current, fr0--reference                                              */
/*****************************************************************************/
void mc_synthesis(float *fr1, float *fr0, float *lfr, float *hfr, float *mvx, float *mvy, int hor, int ver, 
				   int local, int level, int pair, videoinfo info)
{
  int i;
  int cx, cy, px, py, cpos, ppos, case1, case2, case3;
  float c1, c2, c3, c4, c5, cfx, cfy, pfx, pfy, ctmp, ptmp;
  unsigned char *pused;

  /* temporal synthesis */
  c1=1./sqrt(2.); c2=c1;  c3=1.;  c4=sqrt(2.); c5=1./sqrt(2.);/*orthonormal*/

  /* flag */
  pused = (unsigned char *) getarray(hor*ver, sizeof(unsigned char), "pused");
  for(i=0 ; i<hor*ver ; i++) pused[i]=0;
  case1=0; case2=0;

  /* reconstruct fr0 */
  for(cy=0 ; cy<ver ; cy++){
    for(cx=0 ; cx<hor ; cx++){
      cpos = cy*hor+cx; 

	  if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ 

        pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];

        position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver);
        ppos = py*hor+px;
        cfx = px+mvx[cpos]; cfy = py+mvy[cpos];

        if(pused[ppos]!=USED && inbound(cfx, cfy, hor, ver)){  /* filtering */
	      case1++;
	      pused[ppos]=USED;

	      ctmp = interpolate(cfx, cfy, hfr, hor, ver, TYPE);
	      fr0[ppos] = c1*lfr[ppos] - c2*ctmp;
		} 
	  }
    }
  }

  /* step 2 -- unconnected pixel in fr0*/
  for(py=0 ; py<ver ; py++){
    for(px=0 ; px<hor ; px++){
      ppos = py*hor+px;
 	    
      if(!pused[ppos]){
	    case2++;
	    fr0[ppos] = c5*lfr[ppos];
      }
    }
  }
  /* checking */
  if(case1+case2!=hor*ver){
    printf("error in mctf() covered: %d, uncovered: %d\n", case1, case2);
    exit(1);
  }



  /* reconstruct fr1 */
  for(i=0 ; i<hor*ver ; i++) pused[i]=0;
  case3=0;
  for(cy=0 ; cy<ver ; cy++){
    for(cx=0 ; cx<hor ; cx++){
      cpos = cy*hor+cx; 

	  if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ 

        pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
	    case3++;
		// IVB 2004/3/22 --------------------------
		if (pfx < 0.0) pfx = 0.0; if (pfy < 0.0) pfy = 0.0;
		if (pfx > (float)(hor-1)) pfx = (float)(hor-1); 
		if (pfy > (float)(ver-1)) pfy = (float)(ver-1);
		//printf("rounded pfx = %d, pfy = %d\n",((int)(pfx*16))%16, ((int)(pfy*16))%16);
		if (((int)(pfx*16))%16 < 0 || ((int)(pfy*16))%16 < 0)
		{
			printf("Error pfx or pfy!\n");
			printf("rounded pfx = %d, pfy = %d\n",((int)(pfx*16))%16, ((int)(pfy*16))%16);
			printf("pfx = %10.2f, pfy = %10.2f\n",pfx, pfy);
		}
		// IVB 2004/3/22 ------- end --------------
	    ptmp = interpolate(pfx, pfy, fr0, hor, ver, TYPE);

	    fr1[cpos] = ptmp + c4*hfr[cpos];
	  }
    }
  }
  

  free(pused);
}


/*****************************************************************************/
/*                              mc_synthesis_IVB()                           */
/* fr1--current, fr0--reference                                              */
/*****************************************************************************/
void mc_synthesis_IVB(float *fr1, float *fr0, float *lfr, float *hfr, float *mvx, float *mvy, int hor, int ver, 
				   unsigned char *pused1, int local, int level, int pair, videoinfo info)
{
  int i;
  int cx, cy, px, py, cpos, ppos, case1, case2, case3;
  float c1, c2, c3, c4, c5, cfx, cfy, pfx, pfy, ctmp, ptmp;
  unsigned char *pused;
  
  /* temporal synthesis */
  c1=1./sqrt(2.); c2=c1;  c3=1.;  c4=sqrt(2.); c5=1./sqrt(2.);/*orthonormal*/

  /* flag */
  pused = (unsigned char *) getarray(hor*ver, sizeof(unsigned char), "pused");
  for(i=0 ; i<hor*ver ; i++) pused[i]=0;
  // pused1 is initialized in mctfN.c
  case1=0; case2=0;

  /* reconstruct fr0 */
  for(cy=0 ; cy<ver ; cy++){
    for(cx=0 ; cx<hor ; cx++){
      cpos = cy*hor+cx; 

	  if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ 

        pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];

        position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver);
        ppos = py*hor+px;
        cfx = px+mvx[cpos]; cfy = py+mvy[cpos];

        if(pused[ppos]!=USED && inbound(cfx, cfy, hor, ver)){  /* filtering */
	      case1++;
	      pused[ppos]=USED; // USED = 1

	      //ctmp = interpolate(cfx, cfy, hfr, hor, ver, TYPE);
		  ctmp = interpolate(cfx, cfy, fr1, hor, ver, TYPE);
	      //fr0[ppos] = c1*lfr[ppos] - c2*ctmp;
		  fr0[ppos] = ctmp;
		}
		else
			pused1[ppos]=0;
	  }
    }
  }

  /* step 2 -- unconnected pixel in fr0*/
  for(py=0 ; py<ver ; py++){
    for(px=0 ; px<hor ; px++){
      ppos = py*hor+px;
 	    
      if(!pused[ppos]){
	    case2++;
	    //fr0[ppos] = c5*lfr[ppos];
		fr0[ppos] = Infinity;
      }
    }
  }
  /* checking */
  if(case1+case2!=hor*ver){
    printf("error in mctf() covered: %d, uncovered: %d\n", case1, case2);
    exit(1);
  }



  /* reconstruct fr1 */
  //for(i=0 ; i<hor*ver ; i++) pused[i]=0;
  /* IVB 2004/3/23 no need for this
  case3=0;
  for(cy=0 ; cy<ver ; cy++){
    for(cx=0 ; cx<hor ; cx++){
      cpos = cy*hor+cx; 

	  if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ 

        pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
	    case3++;
		// IVB 2004/3/22 --------------------------
		if (!inbound(pfx,pfy,hor,ver)) 
			pused1[cpos]=0;
		if (pfx < 0.0) pfx = 0.0; if (pfy < 0.0) pfy = 0.0;
		if (pfx > (float)(hor-1)) pfx = (float)(hor-1); 
		if (pfy > (float)(ver-1)) pfy = (float)(ver-1);
		//printf("rounded pfx = %d, pfy = %d\n",((int)(pfx*16))%16, ((int)(pfy*16))%16);
		if (((int)(pfx*16))%16 < 0 || ((int)(pfy*16))%16 < 0)
		{
			printf("Error pfx or pfy!\n");
			printf("rounded pfx = %d, pfy = %d\n",((int)(pfx*16))%16, ((int)(pfy*16))%16);
			printf("pfx = %10.2f, pfy = %10.2f\n",pfx, pfy);
		}
		// IVB 2004/3/22 ------- end --------------
	    ptmp = interpolate(pfx, pfy, fr0, hor, ver, TYPE);

	    fr1[cpos] = ptmp + c4*hfr[cpos];
	  }
    }
  } */

  free(pused);
  
}

/*****************************************************************************/
/*                              local_mc_synthesis_IVB()                     */
/* fr1--current, fr0--reference                                              */
/*****************************************************************************/
void local_mc_synthesis_IVB(float *fr1, float *fr0, float *lfr, float *hfr, float *mvx, float *mvy, int hor, int ver, 
				   unsigned char *pused1, int local, int level, int pair, videoinfo info)
{
  int cx, cy, cpos, case3;
  float c1, c2, c3, c4, c5, pfx, pfy, ptmp;

  /* temporal synthesis */
  c1=1./sqrt(2.); c2=c1;  c3=1.;  c4=sqrt(2.); c5=1./sqrt(2.);/*orthonormal*/

  /* reconstruct fr1 */
  case3=0;
  for(cy=0 ; cy<ver ; cy++){
    for(cx=0 ; cx<hor ; cx++){
      cpos = cy*hor+cx; 

	  if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ 

        pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
	    case3++;

		// IVB 2004/3/22 --------------------------
		if (!inbound(pfx,pfy,hor,ver)) 
			pused1[cpos]=0;
		if (pfx < 0.0) pfx = 0.0; if (pfy < 0.0) pfy = 0.0;
		if (pfx > (float)(hor-1)) pfx = (float)(hor-1); 
		if (pfy > (float)(ver-1)) pfy = (float)(ver-1);
		//printf("rounded pfx = %d, pfy = %d\n",((int)(pfx*16))%16, ((int)(pfy*16))%16);
		if (((int)(pfx*16))%16 < 0 || ((int)(pfy*16))%16 < 0)
		{
			printf("Error pfx or pfy!\n");
			printf("rounded pfx = %d, pfy = %d\n",((int)(pfx*16))%16, ((int)(pfy*16))%16);
			printf("pfx = %10.2f, pfy = %10.2f\n",pfx, pfy);
		}
		// IVB 2004/3/22 ------- end --------------

	    ptmp = interpolate(pfx, pfy, fr0, hor, ver, TYPE);
	    fr1[cpos] = ptmp + c4*hfr[cpos];
	  }
    }
  }
  

}




 
 
