#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "rasterfile.h"
#include "basic.h"
#define  EXTERN extern
#include "coderN.h"
#include "analsyn.h"
#include "display.h"
#include "ras_util.h"
#include "miscN.h"
#include "bmeN.h"
#include "bme_pruneN.h"
#include "FME.h"
#include "memoryN.h"
#include "Choisubband.h"
#include "ioN.h"
#include "arcodemv.h"
#include "util_filtering.h"

/* IVB 2003/6/23 ----------------------- */
#define EC         0  /* 0 = no error concealment; 1 = unidirectional (backward) MC error concealment; 2 = bidirectional MCEC */
#define PREDICTION 0  /* 0 = no prediction, 1 = "replacement", 2 = "prediction" */
void synconc(int curr, videoinfo info);
void syn_right(int curr, videoinfo info, int ii, int jj, int **syn_done);
void syn_left(int curr, videoinfo info, int ii, int jj, int **syn_done);
void syn_right2(int curr, videoinfo info, int ii, int jj, int **syn_done);
void syn_left2(int curr, videoinfo info, int ii, int jj, int **syn_done);
void copypredframe(YUVimage *destframe, videoinfo info, int i);
void copypredframe2(YUVimage *destframe, videoinfo info);
void syn_new_tH(YUVimage *newtH, YUVimage *oldtH, int i, int j, int half_len, videoinfo info);
/* IVB 2003/6/23 ------ end ------------ */

int write_GOPheader(enum FLAG **scene_change, videoinfo info);
int filter_sqrt2(float *low_ftr, float *high_ftr, int N);
void print_time(double sc);
void RemoveMean(YUVimage_ptr frame, YUVimage_ptr high, vector_ptr fmv, int tPyrLev, videoinfo info);
void PutbackMean(YUVimage_ptr high, YUVimage_ptr frame, vector_ptr fmv, int tPyrLev, videoinfo info);

/******************************************************************************
                                    mc_anal
******************************************************************************/
void mc_anal(int curr, videoinfo info)
{
  FILE *fpstat;               

  if(!(fpstat = fopen(info.statname, "at+"))){   		
	printf("Can not open %s\n", info.statname);		    		
	exit(1);
  }  
  fprintf(fpstat, " frame %d - %d .......\n\n", curr, curr+info.GOPsz-1);	
  fclose(fpstat);

  analscheme3(curr, info);
  
#ifdef STATISTICS
    Judge_Scalable(pyrTemp, pyrTemp[0], curr, "L", info);
#endif
}



/******************************************************************************
                               analscheme3
we use scene_change to reflect open_GOP, cut_flag, and MCP_flag.
******************************************************************************/
void analscheme3(int curr, videoinfo info)
{
  int i, j, k, half_len,tPyrLev, dist;
  enum FLAG ADAPTIVE, bi_flag, OPEN_GOP, MCP_flag, MCTF_flag;
  int yhor, yver, chor, cver;
  unsigned char *ypused, *cpused, *ypusedtemp, *cpusedtemp;  /* flag */
  float c5 = (float)sqrt(2.);
//  int GOPIndex, FrameIndex;

  //char frame_name[100];
  YUVimage dumb;

  frame_alloc(&dumb, info);


  ADAPTIVE = info.adapt_flag;
  bi_flag = info.bi_flag;  // this parameter only makes sense when ADAPTIVE = YES
  OPEN_GOP = info.OPEN_GOP; // this parameter only makes sense when bi_flag = YES
  MCP_flag = info.MCP_flag; // this parameter only makes sense when bi_flag = YES


  if(ADAPTIVE == YES){
    //scene_change[i][j] shows whether frame i has scene change compared with its previous frame i-1
    // So whether we can do mctf depends on entries at odd-index places.
    for(i = 0; i < info.GOPsz; i++){	
	  scene_change[0][i] = video_scene_change[curr+i]; //if( scene_change[0][i] == NO) printf("NO\n");
	}
    if(curr != info.start && bi_flag == YES && OPEN_GOP == YES)
	  scene_change[0][0] = NO; // So in the following, we do not need test OPEN_GOP only test scene_change[][0].
    else
	  scene_change[0][0] = YES;
  }

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  tPyrLev = info.tPyrLev;

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");


  dist = 1; // frame difference of a pair of frames
  half_len = info.GOPsz / 2;

  for(i = 0; i < tPyrLev - 1; i++){
    printf("temporal pyramid level %d (mc_anal)\n", i+1);

	if(ADAPTIVE == YES && i!=0){  
	  // based on the result of MCTF at the previous leve, find scene_change information in current level	 
	  for(j=0;j<half_len*2; j++){ //BUG substitute half_len*2 for info.GOPsz
  	    if(GOPscene[i][j] != GOPscene[i][j-1])
		{scene_change[i][j] = YES; }
	    else
		{scene_change[i][j] = NO; }
	  }
	}

	for(j = 0; j < half_len; j++){
	  if(ADAPTIVE == NO){
          block_matching(yfmv[j+half_len], pyrTemp[i][2*j], pyrTemp[i][2*j+1], info, i, dist, info.subpel);
	  }
	  else{ // ADAPTIVE == YES
		if(scene_change[i][j*2+1] == NO){ //nex_scene == cur_scene
          block_matching(yfmv[j+half_len], pyrTemp[i][2*j], pyrTemp[i][2*j+1], info, i, dist, info.subpel);

          if(bi_flag == YES)
			MCTF_flag = find_uncovered_block(yfmv[j+half_len], pyrTemp[i][2*j], pyrTemp[i][2*j+1], dist, info); /* APR*/
		  else
            MCTF_flag = Whether_do_MCTF(yfmv[j+half_len], pyrTemp[i][2*j], pyrTemp[i][2*j+1], dist, info);


		  if(MCTF_flag == NO){ // we just found a scene change
  	        free_vector(yfmv[j+half_len], info);

	  	    //update GOP scene flags, and reflect MCP_flag in scene_change
		    if(bi_flag == NO || MCP_flag == NO){
              scene_change[i][j*2]= YES;
			  scene_change[i][j*2+1] = YES;
			  if(j != half_len-1)
				  scene_change[i][j*2+2] = YES;
			}
            else{
			  scene_change[i][j*2+1] = YES;
			}
		  }
		  else{ //MCTF_flag == YES
			if(bi_flag == YES){
              /***
              backward motion estimation
              ***/
			  if(scene_change[i][2*j] == NO){	 //pre_scene == cur_scene //OPEN_GOP is reflected from scene_change[i][0]
				// do we need to test scene change here ? Nov0501				                
  			    if(j==0){
		          wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);
                  Back_block_matching(yfmv[j+half_len], pyrTemp[i][2*j], pfr, info, i, dist);
				}
			    else{
                  Back_block_matching(yfmv[j+half_len], pyrTemp[i][2*j], pyrTemp[i][2*j-1], info, i, dist); /*June24, 2000*/ /*nonoverlap*/
				}
			  }
			}
		  }
		} 
	    else{//scene_change[i][j*2+1] == YES
	  	  //revise GOP scene flags
		  if(MCP_flag == NO || bi_flag == NO){
            scene_change[i][j*2]= YES;
			//scene_change[i][j*2+1] = YES; // this is already YES
			if(j != half_len-1)
			 scene_change[i][j*2+2] = YES;		  
		  }
		}

   	    // do MCP for current frame  MCP_GOP is represented by scene_change[i][j*2] == NO && scene_change[i][j*2+1] == YES 	   	  	   
		if(bi_flag == YES){
		  if(scene_change[i][j*2] == NO && scene_change[i][j*2+1] == YES){
  		    if(j != 0){
              block_matching(yfmv[j+half_len], pyrTemp[i][2*j], pyrTemp[i][2*j-1], info, i, dist, 0);
              MCTF_flag = Whether_do_MCTF(yfmv[j+half_len], pyrTemp[i][2*j], pyrTemp[i][2*j-1], dist, info);
			}
	        else{
  	          wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);
              block_matching(yfmv[j+half_len], pyrTemp[i][2*j], pfr, info, i, dist, 0);
              MCTF_flag = Whether_do_MCTF(yfmv[j+half_len], pyrTemp[i][2*j], pfr, dist, info);
			}		

            if(MCTF_flag == NO){
              free_vector(yfmv[j+half_len], info);
	          scene_change[i][j*2] = YES;
			}
	        else{
              set_bi(yfmv[j+half_len], info);		  
			}	
		  }  
		} 
	  }
      		 
	   

	  // up to now, we have represent MCP_flag and OPEN_GOP by using scene_change[][]
	  if(ADAPTIVE == NO || scene_change[i][j*2] == NO || scene_change[i][j*2+1] == NO){      
		if(PRUNE && info.ME==1){
		  
#ifdef BEST_TEMP_SCALABILITY
		  stop_merge(yfmv[j+half_len], pyrTemp[i][2*j].Y, info);
#endif
		  
          mv_prune(yfmv[j+half_len], info, dist, info.subpel, curr, j); 
		}
	  }	  
				
#ifdef STATISTICS	  
	  char frame_name[100];

	  //GOPIndex = (info.last+info.GOPsz-1)/info.GOPsz - curr/info.GOPsz;//REVERSE_SEQ
	  GOPIndex = curr/info.GOPsz+1;

	  //FrameIndex = half_len-1-j; //REVERSE_SEQ
	  FrameIndex = j;
    
	  sprintf(frame_name, "%s%s%s%02d%s%01d%s%03d.ras", info.mvname, "Fmvmap",
                "G", GOPIndex, "L", i+1, "f", FrameIndex+1);
      write_quad_tree(pyrTemp[i][2*j], info, frame_name, yfmv[j+half_len], i, DEFAULT);
//        write_FMC(pyrFrs[j+half_len], info, "pyrFrs%03d", (i*2)*10+j, yfmv[j+half_len], i);
      sprintf(frame_name, "%s%s%s%02d%s%01d%s%03d.ras", info.mvname, 
                "Bmvmap", "G", GOPIndex, "L", i+1, "f", FrameIndex+1);
      write_quad_tree(pyrTemp[i][2*j], info, frame_name, yfmv[j+half_len], i, REVERSE);

      sprintf(frame_name, "%s%s%s%02d%s%01d%s%03d.ras", info.mvname, 
                "Intra", "G", GOPIndex, "L", i+1, "f", FrameIndex+1);
      write_quad_tree(pyrTemp[i][2*j], info, frame_name, yfmv[j+half_len], i, INTRABLOCK);

      sprintf(frame_name, "%s%s%s%02d%s%01d%s%03d.ras", info.mvname, 
                "mv", "G", GOPIndex, "L", i+1, "f", FrameIndex+1);
      write_densemotionfield(frame_name, yfmv[j+half_len], info);

#endif

      printf("j = %d (mctfN.c)\n", j);		
    }// j



	for(j = 0; j < half_len; j++){ //printf("j= %d (doing filtering)\n", j);
	  if(ADAPTIVE == NO){
          temporal_analysis(&pyrTemp[i+1][j], &pyrFrs[j+half_len],
              pyrTemp[i][2*j], pyrTemp[i][2*j+1], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
              // ypusedtemp and cpusedtemp return the status of pixels: used or unused, in previous frame after filtering 
	  }        
	  else{//ADAPTIVE == YES
		if(scene_change[i][j*2+1] == NO || scene_change[i][j*2] == NO){

#ifdef INTRA_CODED_BLOCK
 		  RemoveMean(&pyrTemp[i][2*j], &pyrFrs[j+half_len], yfmv[j+half_len], i+1, info);
#else
          for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
          for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;   

		  local_temporal_analysis2(pyrFrs[j+half_len], dumb, pyrTemp[i][2*j],      
			pyrTemp[i][2*j+1], yfmv[j+half_len], ypused, cpused, info, INTRABLOCK);
         
#endif
		}


		if(bi_flag == YES){
	      if(scene_change[i][j*2+1] == NO ){//forward MCTF	   
			
            for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
            for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;         
 	        if(scene_change[i][j*2] == NO){//backward MCTF                                            
		      if(j != 0){  	      
				/* dumb is no use here becaues the pixels in reference frame are marked USED */
                                   /*   high         , low, current,previous*/ 
                local_temporal_analysis2(pyrFrs[j+half_len], dumb, pyrTemp[i][2*j], pyrTemp[i][2*j-1], yfmv[j+half_len], ypused, cpused, info, REVERSE);
			  }
              else{ 
                wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);			    
                                   /*   high         , low, current,previous*/ 
                local_temporal_analysis2(pyrFrs[j+half_len], dumb, pyrTemp[i][2*j],    pfr, yfmv[j+half_len], ypused, cpused, info, REVERSE);
			  }
			}
  	        else{ //scne_change[i][j*2] == YES
			  /*   high         , low            , current,  next*/ 
			  local_temporal_analysis2(pyrFrs[j+half_len], dumb, pyrTemp[i][2*j],      pyrTemp[i][2*j+1], yfmv[j+half_len], ypused, cpused, info, REVERSE);
              /*local_temporal_analysis2(pyrFrs[j+half_len], pyrTemp[i+1][j], pyrTemp[i][2*j],      pyrTemp[i][2*j+1], yfmv[j+half_len], ypusedtemp, cpusedtemp, info);
		       the low band coefficients are put in pyrTemp[i+1][j]*/
			}


          
			temporal_analysis(&pyrTemp[i+1][j], &pyrFrs[j+half_len],
                pyrTemp[i][2*j], pyrTemp[i][2*j+1], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
		  


		  } // scene_change[i][j*2+1] == NO
		  else{//scene_change[i][j*2+1] == YES 
 	        if(scene_change[i][j*2] == NO){//backward MCTF
              for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
              for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;         
		      if(j != 0){
                local_temporal_analysis2(pyrFrs[j+half_len], dumb, pyrTemp[i][2*j],    pyrTemp[i][2*j-1], yfmv[j+half_len], ypused, cpused, info, REVERSE);
			  }
              else{ 
                wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info); // for MCP coded frame no need for scale down, so I scale up. BUG
                local_temporal_analysis2(pyrFrs[j+half_len], dumb, pyrTemp[i][2*j],    pfr, yfmv[j+half_len], ypused, cpused, info, REVERSE);
			  }
			}		  
			else{ //scene_change[i][j*2] == YES
		      copyframe(&pyrTemp[i][2*j], &pyrFrs[j+half_len], info);
			}
					      
		    //move unprocessed next frame into next level 
			if(j!= half_len-1){
			  if(scene_change[i][j*2+2]==NO) //BUG 
			    wcopyframe(&pyrTemp[i][2*j+1], &pyrTemp[i+1][j], (float)pow(2.,1/2.), info);		
			  else
 	            copyframe(&pyrTemp[i][2*j+1], &pyrTemp[i+1][j], info);	
			}
		    else
 	          copyframe(&pyrTemp[i][2*j+1], &pyrTemp[i+1][j], info);			
		  } // scene_change[i][j*2+1] ==YES


		}// bi_flag == YES
		else{// bi_flag == NO
	      if(scene_change[i][j*2+1] == NO ){			
            temporal_analysis(&pyrTemp[i+1][j], &pyrFrs[j+half_len],
              pyrTemp[i][2*j], pyrTemp[i][2*j+1], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
		  }
		  else{
		      copyframe(&pyrTemp[i][2*j], &pyrFrs[j+half_len], info);
 	          copyframe(&pyrTemp[i][2*j+1], &pyrTemp[i+1][j], info);
		  }
		}// bi_flag == NO
	  }
		  
		 /*for(k = 0; k < yhor * yver; k++){
         if(ypused[k]==USED && ypusedtemp[k]==UNUSED)
           pyrTemp[i+1][j].Y[k] *= c5;
        }
        if(chor && cver){
          for(k = 0; k < chor * cver; k++){
            if(ypused[k]==USED && ypusedtemp[k]==UNUSED){
              pyrTemp[i+1][j].U[k] *= c5;
              pyrTemp[i+1][j].V[k] *= c5;
            }
          }
        }*/ 
  
	
#ifdef STATISTICS
	  char frame_name[100];

	  //FrameIndex = half_len-1-j; //REVERSE_SEQ
	  FrameIndex = j;

       sprintf(frame_name, "Test\\%.2s%s%02d%s%01d%s%03d.ras", info.bitname, "G", GOPIndex, "H", i+1, "f", FrameIndex+1);
       write_highband(pyrFrs[j+half_len], info, frame_name, i+1);
#endif



#ifdef STATISTICS

        computegain(pyrTemp[i+1][j], pyrFrs[j+half_len], info);
#endif
		/*int cx, cy;
		for(cy=140;cy<144;cy++){
		  for(cx=0;cx<4;cx++){
			printf("%f ",pyrFrs[j+half_len].Y[cy*yhor+cx]);
		  }
		  printf("\n");
		}
	    getchar();*/

       // printf("j = %d\n", j);		
    } //j
	
	if(ADAPTIVE == YES){  
	  GOPscene[i][-1]=0;
	  //get the scenes of this level
	  for(j=0; j<half_len*2; j++){
	    if(scene_change[i][j] == YES)
	   	  GOPscene[i][j] = GOPscene[i][j-1]+1; // thus frames before (including) j-1 and after j-1 belong to different scenes
		else
		  GOPscene[i][j] = GOPscene[i][j-1];	  
	  } 
	  //get the scenes of next level
      GOPscene[i+1][-1] = GOPscene[i][-1];
	  for(j=0; j<half_len; j++){
         GOPscene[i+1][j] = GOPscene[i][j*2+1];
	  }
	}


    dist *= 2;
    half_len /= 2;
  }  //i
  

// the last level 
  printf("temporal pyramid level %d\n", tPyrLev);

  if(ADAPTIVE == YES){
    if(tPyrLev != 1){
      for(j=0; j<2; j++){
	    if(GOPscene[tPyrLev - 1][j] != GOPscene[tPyrLev - 1][j-1])
		  scene_change[tPyrLev - 1][j] = YES;
	    else
		  scene_change[tPyrLev - 1][j] = NO;
	  }
	}
  }


  if(ADAPTIVE == NO){   
    block_matching(yfmv[1], pyrTemp[tPyrLev - 1][0], pyrTemp[tPyrLev - 1][1],
                   info, tPyrLev-1, dist, info.subpel);	
  }
  else{
	if(scene_change[tPyrLev - 1][1] == NO){//cur_scene == nex_scene
      block_matching(yfmv[1], pyrTemp[tPyrLev - 1][0], pyrTemp[tPyrLev - 1][1],
                 info, tPyrLev-1, dist, info.subpel);
      if(bi_flag == YES)
		MCTF_flag = find_uncovered_block(yfmv[1], pyrTemp[tPyrLev - 1][0], pyrTemp[tPyrLev - 1][1],
                           dist, info);	  
	  else
	    MCTF_flag = Whether_do_MCTF(yfmv[1], pyrTemp[tPyrLev-1][0], pyrTemp[tPyrLev - 1][1], dist, info);
	  

	  if(MCTF_flag == NO){
		  free_vector(yfmv[1], info);
		  if(MCP_flag == NO || bi_flag == NO){
			  scene_change[tPyrLev - 1][0] = YES;
			  scene_change[tPyrLev - 1][1] = YES;
		  }
		  else{
			  scene_change[tPyrLev - 1][1] = YES;
		  }			  
	  }
	  else{ //MCTF_flag == YES 
		if(bi_flag == YES){
          if(scene_change[tPyrLev-1][0] == NO){//pre_scene == cur_scene
             wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., (tPyrLev-1)/2.), info);
             Back_block_matching(yfmv[1], pyrTemp[tPyrLev-1][0], pfr, info, tPyrLev-1, dist);// do we need to test scene change?			 
		  } // scene_change[tPyrLev-1][0] == NO
		}
	  }//MCTF_flag == YES


	}//scene_change[tPyrLev - 1][1] == NO
	else{
	  if(bi_flag == NO || MCP_flag == NO){
	    scene_change[tPyrLev - 1][0] = YES;
	  }
	}

	
	// do MCP for current frame   	   	  	   
	if(bi_flag == YES){
	  if(scene_change[tPyrLev-1][0] == NO && scene_change[tPyrLev-1][1] == YES){
        wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., (tPyrLev-1)/2.), info);
        block_matching(yfmv[1], pyrTemp[tPyrLev-1][0], pfr, info, tPyrLev-1, dist, 0);
	    MCTF_flag = Whether_do_MCTF(yfmv[1], pyrTemp[tPyrLev-1][0], pfr, dist, info);


	    if(MCTF_flag == NO){
		  free_vector(yfmv[1], info);
		  scene_change[tPyrLev-1][0] = YES;
		}
	    else{
          set_bi(yfmv[1], info);
		}
	  }
	}
  }   



//	  print_mv(&yfmv[1][378], 1344,960, 64,64, 1920, 1080);



 
  if(ADAPTIVE == NO || scene_change[tPyrLev-1][0] == NO || scene_change[tPyrLev-1][1] == NO){
    if(PRUNE && info.ME==1){

	  
#ifdef BEST_TEMP_SCALABILITY
	  stop_merge(yfmv[1], pyrTemp[tPyrLev - 1][0].Y, info);
#endif
      
      mv_prune(yfmv[1], info, dist, info.subpel, curr, 0); 
	}
  }

/********
*display*
********/
#ifdef STATISTICS
    char frame_name[100];


    sprintf(frame_name, "%s%s%s%02d%s%01d%s%03d.ras", info.mvname, "Fmvmap",
            "G", GOPIndex, "L", tPyrLev, "f", 1);
    write_quad_tree(pyrTemp[tPyrLev - 1][0], info, frame_name,
                    yfmv[1], tPyrLev-1, DEFAULT);
//    write_FMC(pyrFrs[1], info, "pyrFrs%03d", ((tPyrLev-1)*2)*10, yfmv[1], tPyrLev-1);
    sprintf(frame_name, "%s%s%s%02d%s%01d%s%03d.ras", info.mvname,
            "Bmvmap", "G", GOPIndex, "L", tPyrLev, "f", 1);
    write_quad_tree(pyrTemp[tPyrLev - 1][0], info, frame_name,
                    yfmv[1], tPyrLev-1, REVERSE);

    sprintf(frame_name, "%s%s%s%02d%s%01d%s%03d.ras", info.mvname,
            "Intra", "G", GOPIndex, "L", tPyrLev, "f", 1);
    write_quad_tree(pyrTemp[tPyrLev - 1][0], info, frame_name,
                    yfmv[1], tPyrLev-1, INTRABLOCK);

    sprintf(frame_name, "%s%s%s%02d%s%01d%s%03d.ras", info.mvname,
            "mv", "G", GOPIndex, "L", tPyrLev, "f", 1);
    write_densemotionfield(frame_name, yfmv[1], info);
#endif


	if(ADAPTIVE == NO){
                 /* L band      H band      current   next */
      temporal_analysis(&pyrFrs[0], &pyrFrs[1], pyrTemp[tPyrLev - 1][0],
                    pyrTemp[tPyrLev - 1][1], yfmv[1], ypusedtemp, cpusedtemp, tPyrLev-1, 0, info);
	}
	else{

	  if(scene_change[tPyrLev-1][1] == NO || scene_change[tPyrLev-1][0] == NO){
#ifdef INTRA_CODED_BLOCK

 		RemoveMean(&pyrTemp[tPyrLev - 1][0], &pyrFrs[1], yfmv[1], tPyrLev, info);
#else
        for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
        for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;

		local_temporal_analysis2(pyrFrs[1], dumb, pyrTemp[tPyrLev - 1][0], 
		  pyrTemp[tPyrLev - 1][1], yfmv[1], ypused, cpused, info, INTRABLOCK);


#endif
	  }

      if(bi_flag == YES){
		if(scene_change[tPyrLev-1][1] == NO){ // forward MCTF


          for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
          for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
		  if(scene_change[tPyrLev-1][0] == NO){//pre_scene == cur_scene
            wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., (tPyrLev-1)/2.), info);	        
                                   /*   high         , low, current,previous*/ 
            local_temporal_analysis2(pyrFrs[1], dumb, pyrTemp[tPyrLev - 1][0], pfr, yfmv[1], ypused, cpused, info, REVERSE);
		  }
	      else{
                                /*high     , low      , current,next*/
			local_temporal_analysis2(pyrFrs[1], dumb, pyrTemp[tPyrLev - 1][0],    pyrTemp[tPyrLev - 1][1], yfmv[1], ypused, cpused, info, REVERSE);
            //local_temporal_analysis2(pyrFrs[1], pyrFrs[0], pyrTemp[tPyrLev - 1][0],    pyrTemp[tPyrLev - 1][1], yfmv[1], ypusedtemp, cpusedtemp, info);
		  }


		  temporal_analysis(&pyrFrs[0], &pyrFrs[1], pyrTemp[tPyrLev - 1][0],
                    pyrTemp[tPyrLev - 1][1], yfmv[1], ypusedtemp, cpusedtemp, tPyrLev-1, 0, info);
 

		
		}//scene_change[tPyrLev-1][1] == NO
		else{//scene_change[tPyrLev-1][1] == YES
		  if(scene_change[tPyrLev-1][0] == NO){//pre_scene == cur_scene
            for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
            for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
            wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., (tPyrLev-1)/2.), info);
                                   /*   high         , low, current,previous*/ 
            local_temporal_analysis2(pyrFrs[1], dumb, pyrTemp[tPyrLev - 1][0], pfr, yfmv[1], ypused, cpused, info, REVERSE);
		  }
		  else{
	  	    copyframe(&pyrTemp[tPyrLev - 1][0], &pyrFrs[1], info);
		    copyframe(&pyrTemp[tPyrLev - 1][1], &pyrFrs[0], info);
		  }
		}
	  }
	  else{ //bi_flag =NO
		if(scene_change[tPyrLev-1][1] == NO){ // forward MCTF
		  temporal_analysis(&pyrFrs[0], &pyrFrs[1], pyrTemp[tPyrLev - 1][0],
                    pyrTemp[tPyrLev - 1][1], yfmv[1], ypusedtemp, cpusedtemp, tPyrLev-1, 0, info);
		}
		else{
	      copyframe(&pyrTemp[tPyrLev - 1][0], &pyrFrs[1], info);
	      copyframe(&pyrTemp[tPyrLev - 1][1], &pyrFrs[0], info);

		}
	  }
	}
 
#ifdef STATISTICS

    sprintf(frame_name, "Test\\%.2s%s%02d%s%01d%s%03d.ras", info.bitname, "G",
            GOPIndex, "H", tPyrLev, "f", +1);
    write_highband(pyrFrs[1], info, frame_name, tPyrLev);
#endif

#ifdef STATISTICS
  computegain(pyrFrs[0], pyrFrs[1], info);
#endif


  free_frame_interior(dumb);
  free(ypused); free(ypusedtemp); free(cpused); free(cpusedtemp);
}




/******************************************************************************
                                      mc_syn
******************************************************************************/
void mc_syn(int curr, videoinfo info)
{

/*#ifdef STATISTICS
    int i;
    YUVimage  frame[16];
    for(i=0; i<info.GOPsz; i++){
      frame_alloc(&frame[i], info);
      copyframe(&(pyrTemp[0][i]), &(frame[i]), info);   Save for judge the quality of low frame rate data in Judge_Scalable 
    }
#endif*/    

/*  int i, j;
  printf("reconstruction with two levels\n");
  for(i=info.GOPsz/8; i<info.GOPsz; i++){
    for(j=0; j<info.ywidth*info.yheight; j++)
      pyrFrs[i].Y[j]=0.;
    if(info.cwidth && info.cheight){
      for(j = 0; j < info.cwidth*info.cheight; j++){
        pyrFrs[i].U[j]=0.;
        pyrFrs[i].V[j]=0.;
      }
    }
  }*/

    synscheme3(curr, info);

#ifdef STATISTICS

//    Judge_Scalable(pyrTemp, pyrTemp[0], curr, "RL", info);

    /*for(i=0; i<info.GOPsz; i++)
      free_frame_interior(frame[i]);*/
#endif

  return;
}








/******************************************************************************
                                 synscheme 3
******************************************************************************/
void synscheme3(int curr, videoinfo info)
{
  YUVimage dumb, frame;
  int i, j, k, half_len, tPyrLev, dist;
  int yhor, yver, chor, cver;
  enum FLAG ADAPTIVE , bi_flag;
  unsigned char *ypused, *ypusedtemp, *cpused, *cpusedtemp;  /* flag */
  /* IVB 2003/6/23 -------------- */
  YUVimage predframe, tempframe, predframe2, frameH;
  FILE *fppred;
  int size;
  /* IVB 2003/6/23 --- end ------ */


  ADAPTIVE = info.adapt_flag;
  bi_flag = info.bi_flag;
  yhor = info.ywidth; yver =  info.yheight;
  chor = info.cwidth; cver =  info.cheight;
  tPyrLev = info.tPyrLev;


  /* IVB 2003/6/23 -------------- */
  //printf("synscheme3\n");
  if (EC && bi_flag == NO && ADAPTIVE == YES)  
  {
	//printf("EC and bi_flag = NO and ADAPTIVE = YES\n");
	synconc(curr, info);  // handles variable GOP size
	return;
  }
  /* IVB 2003/6/23 --- end ------ */


  frame_alloc(&dumb, info);
  frame_alloc(&frame, info);


  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");


  dist = 1 << (tPyrLev -1);
  half_len = 1;
  //printf("temporal pyramid level %d\n", tPyrLev);
  if(ADAPTIVE == NO){
           /* reconstructed current frame,   next frame*/
    temporal_synthesis(&pyrTemp[tPyrLev-1][0], &pyrTemp[tPyrLev-1][1], pyrFrs[0],
                     pyrFrs[1], yfmv[1], ypusedtemp, cpusedtemp, tPyrLev-1, 0, info);
  }
  else{

    if(bi_flag == YES){
	  if(scene_change[tPyrLev-1][1] == NO){    

		temporal_synthesis(&pyrTemp[tPyrLev-1][0], &pyrTemp[tPyrLev-1][1], pyrFrs[0],
                     pyrFrs[1], yfmv[1], ypusedtemp, cpusedtemp, tPyrLev-1, 0, info);
		
        for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
	    for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
		if(scene_change[tPyrLev-1][0] == NO){//pre_scene == cur_scene
	      wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., (tPyrLev-1)/2.), info);  
		
		  /* dumb is no use here becaues the pixels in reference frame are marked USED */
                         /*       current              ,next, high     ,low   */
          local_temporal_synthesis2(pyrTemp[tPyrLev-1][0], pfr, pyrFrs[1], dumb, yfmv[1], ypused, cpused, info, REVERSE);
		}
	    else{ 
	                              /*       current          , next                 , high     ,low   */
		  local_temporal_synthesis2(pyrTemp[tPyrLev-1][0], pyrTemp[tPyrLev-1][1], pyrFrs[1], dumb, yfmv[1], ypused, cpused, info, REVERSE);
          //local_temporal_synthesis2(pyrTemp[tPyrLev-1][0], pyrTemp[tPyrLev-1][1], pyrFrs[1], pyrFrs[0], yfmv[1], ypusedtemp, cpusedtemp, info);
		}
	  }//scene_change[tPyrLev-1][1] == NO
	  else{//scene_change[tPyrLev-1][1] == YES
		if(scene_change[tPyrLev-1][0] == NO){//pre_scene == cur_scene
          for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
	      for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
	      wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., (tPyrLev-1)/2.), info);
          
                         /*       current              ,next, high     ,low   */
          local_temporal_synthesis2(pyrTemp[tPyrLev-1][0], pfr, pyrFrs[1], dumb, yfmv[1], ypused, cpused, info, REVERSE);
		}
	    else{ 
		  copyframe(&pyrFrs[1], &pyrTemp[tPyrLev - 1][0], info);	 	
		  copyframe(&pyrFrs[0], &pyrTemp[tPyrLev - 1][1], info);
		}
	  }//scene_change[tPyrLev-1][1] == YES
	}	//bi_flag == YES
	else{ //bi_flag == NO
	  if(scene_change[tPyrLev-1][1] == NO){    
		temporal_synthesis(&pyrTemp[tPyrLev-1][0], &pyrTemp[tPyrLev-1][1], pyrFrs[0],
                     pyrFrs[1], yfmv[1], ypusedtemp, cpusedtemp, tPyrLev-1, 0, info);
	  }
	  else{ 
		copyframe(&pyrFrs[1], &pyrTemp[tPyrLev - 1][0], info);	 	
		copyframe(&pyrFrs[0], &pyrTemp[tPyrLev - 1][1], info);
	  }
	}





	if(scene_change[tPyrLev-1][1] == NO || scene_change[tPyrLev-1][0] == NO){
#ifdef INTRA_CODED_BLOCK
	  PutbackMean(&pyrFrs[1], &pyrTemp[tPyrLev-1][0], yfmv[1], tPyrLev, info);
#else
      for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
	  for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
	  local_temporal_synthesis2(pyrTemp[tPyrLev-1][0], pyrTemp[tPyrLev-1][1], pyrFrs[1], dumb, yfmv[1], 
		ypused, cpused, info, INTRABLOCK);

#endif
	}


  }

  for(i = tPyrLev-2; i >=0; i--){

     //printf("temporal pyramid level %d\n", i+1);
	 dist = 1 << i;
     half_len *= 2;

     for(j = 0; j < half_len; j++){  /* for scheme 3 */

	   if(ADAPTIVE == NO){
           /* reconstructed current frame, next frame*/
         temporal_synthesis(&pyrTemp[i][2*j], &pyrTemp[i][2*j+1], pyrTemp[i+1][j],
                pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
	   }
	   else{//ADAPTIVE == YES

		 if(bi_flag == YES){   	 
		   if(scene_change[i][j*2+1] == NO ){                    
			 temporal_synthesis(&pyrTemp[i][2*j], &pyrTemp[i][2*j+1], pyrTemp[i+1][j],
                pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
	  
               
			 for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;             
			 for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			 if(scene_change[i][j*2] == NO){
		       if(j == 0){
                 wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);
			     //write_lowband(frame, info, "end", i, i);
                                  /*   current        , next             , high              ,low   */
                 local_temporal_synthesis2(pyrTemp[i][2*j], pfr, pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
			   }
               else{
                                    /*   current      , previous , high,low   */
                 local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j-1], pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
			   } 		 
			 }//scene_change[i][j*2] == NO		   
			 else{//scene_change[i][j*2] == YES
			   local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
			   //local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], pyrTemp[i+1][j], yfmv[j+half_len], ypusedtemp, cpusedtemp, info);
			 }	//scene_change[i][j*2] == YES   

		   }//scene_change[i][j*2+1] == NO		
		   else{//scene_change[i][j*2+1] == YES
			 if(scene_change[i][j*2] == NO){			                 
			   for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
               for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;

		       if(j == 0){
                 wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);
			     //write_lowband(frame, info, "end", i, i);
                                  /*   current        , next             , high              ,low   */
                 local_temporal_synthesis2(pyrTemp[i][2*j], pfr, pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
			   }
               else{
                                    /*   current      , previous , high,low   */
                 local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j-1], pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE); 
			   } 
			 }
			 else{
			   copyframe(&pyrFrs[j+half_len], &pyrTemp[i][2*j], info);

			   if(j!= half_len-1){
				 if(scene_change[i][j*2+2]==NO) //BUG 
				   wcopyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], (float)pow(2.,-1/2.), info);
				 else
				   copyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], info);
			   }
			   else
				 copyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], info);
			 }
		   }
		 } //bi_flag == YES		  
		 else{//bi_flag == NO
			 //printf("i = %d, j = %d\n",i,j);
		   if(scene_change[i][j*2+1] == NO ){                    
			 temporal_synthesis(&pyrTemp[i][2*j], &pyrTemp[i][2*j+1], pyrTemp[i+1][j],
                pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
		   }
		   else{
		     copyframe(&pyrFrs[j+half_len], &pyrTemp[i][2*j], info);
 	         copyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], info);
		   }		 
		 }		

		 
		 
		 if(scene_change[i][j*2+1] == NO || scene_change[i][j*2] == NO){	
#ifdef INTRA_CODED_BLOCK		   
		   PutbackMean(&pyrFrs[j+half_len], &pyrTemp[i][2*j], yfmv[j+half_len], i+1, info);
#else			   
		   for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
		   for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;		
		   local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			 ypused, cpused, info, INTRABLOCK);


#endif
		 }


	   }//ADAPTIVE == YES
	 
       //printf("j = %d\n", j);
	 } /* j */
  } /* i */



    /* IVB 2003/6/23 ------------------------------------------------------ */
if (PREDICTION)
{
	printf("about to allocate memory for predframe(s)... ");
	frame_alloc(&predframe, info);
	frame_alloc(&tempframe, info);
	frame_alloc(&predframe2, info); // 2004/3/17  prediction from other side of GOP
	frame_alloc(&frameH, info); // 2004/3/18
	printf("done\n");

if (PREDICTION == 1 )
{
	/* 1 = "replacement" */

	printf("copying frame(s)... ");
	copyframe(&pyrTemp[0][0], &predframe, info);
	i = 0;
	half_len = (int)pow(2.0, (double)(tPyrLev-1-i));
	j = half_len-1;
	wcopyframe(&pyrTemp[i][j+half_len], &predframe2, -1.0, info); // change sign
	printf("done\n");
}
else
{
	/* 2 = "prediction" */

	/* scale frame */
	wcopyframe(&pyrTemp[0][0], &frame, (float)sqrt(2.0), info);

	i = 0; j = 0;
	half_len = (int)pow(2.0, (double)(tPyrLev-1-i));

	if(ADAPTIVE == NO)
	//if(1)
	{
		printf("ADAPTIVE == NO\n");
		/* reconstructed current frame, next frame*/
		temporal_synthesis(&predframe, &tempframe, frame,
                pyrFrs[half_len], yfmv[half_len], ypusedtemp, cpusedtemp, 0, 0, info);
	}
	else  /* IVB - do we need this ?? */
	{    //ADAPTIVE == YES
		printf("ADAPTIVE == YES\n");
		if(bi_flag == YES)
		{   	 
			printf("bi_flag == YES\n");
			if(scene_change[0][1] == NO )
			{
				printf("scene_change[0][1] == NO\n");
				temporal_synthesis(&predframe, &tempframe, frame,
                     pyrFrs[half_len], yfmv[half_len], ypusedtemp, cpusedtemp, 0, 0, info);

				for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
				for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
				if(scene_change[0][0] == NO)
				{
					printf("scene_change[0][0] == NO\n");
					wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);
					//write_lowband(frame, info, "end", i, i);
					/*   current        , next             , high              ,low   */
					local_temporal_synthesis2(predframe, pfr, pyrFrs[half_len], dumb, yfmv[half_len], ypused, cpused, info, REVERSE);
				}//scene_change[0][0] == NO
				else
				{  //scene_change[0][0] == YES
					printf("scene_change[0][0] == YES\n");
					/* IVB: this gets executed for football GOP0 @ 1200 kbps */
					/* IVB same as above, what else ? */
					local_temporal_synthesis2(predframe, tempframe, pyrFrs[half_len], dumb, yfmv[half_len], ypused, cpused, info, REVERSE);
					//local_temporal_synthesis2(predframe, pfr, pyrFrs[half_len], dumb, yfmv[half_len], ypused, cpused, info, REVERSE);
					//local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
				}	//scene_change[0][0] == YES   	
			}//scene_change[0][1] == NO
			else
			{  //scene_change[0][1] == YES
				printf("scene_change[0][1] == YES\n");
				if(scene_change[0][0] == NO)
				{
			        printf("scene_change[0][0] == NO\n");
					for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
					for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;

					wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);
					//write_lowband(frame, info, "end", i, i);
					/*   current        , next             , high              ,low   */
					local_temporal_synthesis2(predframe, pfr, pyrFrs[half_len], dumb, yfmv[half_len], ypused, cpused, info, REVERSE);
				}
				else
				{
					printf("scene_change[0][0] == YES\n");
					copyframe(&pyrFrs[half_len], &predframe, info);
				}
			}
		} //bi_flag == YES
		else
		{  //bi_flag == NO
			printf("bi_flag == NO\n");
			if(scene_change[0][1] == NO )
			{
				printf("scene_change[0][1] == NO\n");
				temporal_synthesis(&predframe, &tempframe, frame,
					pyrFrs[half_len], yfmv[half_len], ypusedtemp, cpusedtemp, i, j, info);
			}
			else
			{
				printf("scene_change[0][1] == YES\n");
				copyframe(&pyrFrs[half_len], &predframe, info);
			}
		}

		if(scene_change[0][1] == NO || scene_change[0][0] == NO)
		{
			printf("scene_change[0][1] == NO or scene_change[0][0] == NO\n");
			
#ifdef INTRA_CODED_BLOCK		   
		    PutbackMean(&pyrFrs[half_len], &predframe, yfmv[half_len], 1, info);
#else			   
		    for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
			for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			local_temporal_synthesis2(predframe, tempframe, pyrFrs[half_len], dumb, yfmv[half_len],
				ypused, cpused, info, INTRABLOCK);
#endif
		}
	}//ADAPTIVE == YES

	// --------------- predicting frame from the other side of GOP ---------------
	
    i = 0;
	half_len = (int)pow(2.0, (double)(tPyrLev-1-i));
	j = half_len-1;

	/* scale and invert sign of low freq. frame */
	wcopyframe(&pyrTemp[i][j+half_len], &frame, -(float)sqrt(2.0), info);
	//wcopyframe(&pyrTemp[i][j+half_len], &frame, (float)sqrt(2.0), info);

	weighMV(yfmv[j+half_len], -1.0, info);

	//wcopyframe(&pyrFrs[j+half_len], &frameH, -1.0, info);
	//wcopyframe(&pyrFrs[j+half_len], &frameH, 1.0, info);
	syn_new_tH(&frameH, &pyrFrs[j+half_len], i, j, half_len, info); //2004/3/20


	if(ADAPTIVE == NO)
	//if(1)
	{
		//printf("ADAPTIVE == NO\n");
		/* reconstructed current frame, next frame*/
		//temporal_synthesis(&predframe2, &tempframe, frame,
        //        pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
		temporal_synthesis(&predframe2, &tempframe, frame,
                frameH, yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
	}
	else  /* IVB - do we need this ?? */
	{    //ADAPTIVE == YES
		//printf("ADAPTIVE == YES\n");
		if(bi_flag == YES)
		{   	 
			//printf("bi_flag == YES\n");
			if(scene_change[i][j*2+1] == NO )
			{
				//printf("scene_change[%d][%d] == NO\n",i,j*2+1);
				//temporal_synthesis(&predframe2, &tempframe, frame,
                //     pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
				temporal_synthesis(&predframe2, &tempframe, frame,
                     frameH, yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);

				for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
				for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
				if(scene_change[i][j*2] == NO)
				{
					//printf("scene_change[%d][%d] == NO\n",i,j*2);
					wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);
					//write_lowband(frame, info, "end", i, i);
					/*   current        , next             , high              ,low   */
					//local_temporal_synthesis2(predframe2, pfr, pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
					local_temporal_synthesis2(predframe2, pfr, frameH, dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
				}//scene_change[i][j*2] == NO
				else
				{  //scene_change[i][j*2] == YES
					//printf("scene_change[%d][%d] == YES\n",i,j*2);
					//local_temporal_synthesis2(predframe2, tempframe, pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
					local_temporal_synthesis2(predframe2, tempframe, frameH, dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
					//local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
				}	//scene_change[i][j*2] == YES   	
			}//scene_change[i][j*2+1] == NO
			else
			{  //scene_change[i][j*2+1] == YES
				//printf("scene_change[%d][%d] == YES\n",i,j*2+1);
				if(scene_change[i][j*2] == NO)
				{
			        //printf("scene_change[%d][%d] == NO\n",i,j*2);
					for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
					for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;

					wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);
					//write_lowband(frame, info, "end", i, i);
					/*   current        , next             , high              ,low   */
					//local_temporal_synthesis2(predframe2, pfr, pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
					local_temporal_synthesis2(predframe2, pfr, frameH, dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
				}
				else
				{
					//printf("scene_change[%d][%d] == YES\n",i,j*2);
					//copyframe(&pyrFrs[j+half_len], &predframe2, info);
					// reverse the sign, since it will be reversed again when writing to file
					wcopyframe(&pyrFrs[j+half_len], &predframe2, -1.0, info);
					//copyframe(&frameH, &predframe2, info);
				}
			}
		} //bi_flag == YES
		else
		{  //bi_flag == NO
			printf("bi_flag == NO\n");
			if(scene_change[i][j*2+1] == NO )
			{
				//printf("scene_change[%d][%d] == NO\n",i,j*2+1);
				//temporal_synthesis(&predframe2, &tempframe, frame,
				//	pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
				temporal_synthesis(&predframe2, &tempframe, frame,
					frameH, yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
			}
			else
			{
				//printf("scene_change[%d][%d] == YES\n",i,j*2+1);
				//copyframe(&pyrFrs[j+half_len], &predframe2, info);
				// reverse the sign, since it will be reversed again when writing to file
				wcopyframe(&pyrFrs[j+half_len], &predframe2, -1.0, info);
				//copyframe(&frameH, &predframe2, info);
			}
		}

		if(scene_change[i][j*2+1] == NO || scene_change[i][j*2] == NO)
		{
			printf("scene_change[%d][%d] == NO or scene_change[%d][%d] == NO\n",i,j*2+1,i,j*2);
			
#ifdef INTRA_CODED_BLOCK		   
		    //PutbackMean(&pyrFrs[j+half_len], &predframe2, yfmv[j+half_len], i+1, info);
			PutbackMean(&frameH, &predframe2, yfmv[j+half_len], i+1, info);
#else			   
		    for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
			for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			//local_temporal_synthesis2(predframe2, tempframe, pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			//	ypused, cpused, info, INTRABLOCK);
			local_temporal_synthesis2(predframe2, tempframe, frameH, dumb, yfmv[j+half_len],
				ypused, cpused, info, INTRABLOCK);
#endif
		}
	}//ADAPTIVE == YES

	weighMV(yfmv[j+half_len], -1.0, info);

	// ------------- end predicting frame from the other side of GOP -------------

} /* PREDICTION = 2 */
	
	/* open file for predicted frame */
	if (!(fppred = fopen("PredFrame","wb")))
	{
		printf("synscheme3() in syn.c : cannot open PredFrame\n");
		exit(1);
	}

	/* scale and write */

	wcopyframe(&predframe, &tempframe, (float)pow(2.0, (float)tPyrLev/2.0), info);

	size = yhor*yver;
	if (fwrite(tempframe.Y, sizeof(float), size, fppred) != (unsigned)size)
	{
		printf("synscheme3() in syn.c : cannot write tempframe.Y\n");
		exit(1);
	}
	
	size = chor*cver;
	if (size)
	{
		if (fwrite(tempframe.U, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.U\n");
			exit(1);
		}
		if (fwrite(tempframe.V, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.V\n");
			exit(1);
		}
	}
	fclose(fppred);

	/* open file for predicted frame from other side of GOP */
	if (!(fppred = fopen("PredFrame2","wb")))
	{
		printf("synscheme3() in syn.c : cannot open PredFrame2\n");
		exit(1);
	}

	/* scale and write */

	// no need to scale this frame, since predicting original frames (pyramid level 0)
	// only invert sign
	wcopyframe(&predframe2, &tempframe, -1.0, info);
	//copyframe(&predframe2, &tempframe, info);

	size = yhor*yver;
	if (fwrite(tempframe.Y, sizeof(float), size, fppred) != (unsigned)size)
	{
		printf("synscheme3() in syn.c : cannot write tempframe.Y\n");
		exit(1);
	}
	
	size = chor*cver;
	if (size)
	{
		if (fwrite(tempframe.U, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.U\n");
			exit(1);
		}
		if (fwrite(tempframe.V, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.V\n");
			exit(1);
		}
	}
	fclose(fppred);

	free_frame_interior(predframe);
    free_frame_interior(tempframe);
	free_frame_interior(predframe2);
	free_frame_interior(frameH);

} /* if (PREDICTION) */
  /* IVB 2003/6/23  ----------------- end -------------------------- */




   
//  free(GOPscene-1);
  free(ypused);
  free(ypusedtemp);
  free(cpused);
  free(cpusedtemp);

  free_frame_interior(dumb);
  free_frame_interior(frame);
}







/*****************************************************************************/
/*                            temporal_analysis                              */
/*****************************************************************************/
void temporal_analysis(YUVimage_ptr lfr, YUVimage_ptr hfr, YUVimage fr1, YUVimage fr0, vector_ptr fmv, unsigned char *ypused, unsigned char *cpused, int level, int pair, videoinfo info)
 /* fr1--current, fr0 --reference (next) */
 /*ypused  flag of Y, cpused flag of UV */
{
  int   i, x, y, X, Y, yhor, yver, chor, cver;
  int   xnum, ynum, xblk, yblk;
  float c5;
  float *ymvx, *ymvy, *cmvx, *cmvy;
  unsigned char *used;
  FILE  *fpstat;

  c5=(float)sqrt(2.);

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblk = info.xblk;   yblk = info.yblk;

  used = (unsigned char *)getarray(chor*cver, sizeof(unsigned char), "used");


  for(i = 0; i < yhor*yver ; i++) ypused[i]=UNUSED;
  for(i = 0; i < chor*cver ; i++) cpused[i]=UNUSED;

  /*
For scheme 3 this is unnecessary.  
  for(y=0; y<yver; y++){
    for(x=0; x<yhor; x++){
      pos = y*yhor + x;
      if(ypused[pos] == USED)
        lfr->Y[pos] = fr0.Y[pos] * c5; 
    }
  }
  if(info.cwidth && info.cheight){  
    for(y=0; y<cver; y++){
      for(x=0; x<chor; x++){
        pos = y*chor + x;
        if(cpused[pos] == USED){
          lfr->U[pos] = fr0.U[pos] * c5;
          lfr->V[pos] = fr0.V[pos] * c5;
        }
      }
    }
  }
*/


  /* allocate the memory and initialization */
  ymvx = (float *) getarray(yhor*yver, sizeof(float), "ymvx");
  ymvy = (float *) getarray(yhor*yver, sizeof(float), "ymvy");
  cmvx = (float *) getarray(chor*cver, sizeof(float), "cmvx");
  cmvy = (float *) getarray(chor*cver, sizeof(float), "cmvy");

  /* convert the block-based vectors to the pixel-based vectors */
  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      block2pixel2(ymvx, ymvy, &fmv[Y*xnum+X], x, y, xblk, yblk, yhor, yver, DEFAULT);
    }
  }

  /* get the chrominance motion vector from the luminance vector */
  if(info.cwidth && info.cheight){
    get_cvector(cmvx, cmvy, ymvx, ymvy, yhor, yver, chor, cver, info);
  }


/*
  for(cy=0 ; cy<yver ; cy++){
    for(cx=0 ; cx<yhor ; cx++){
      cpos = cy*yhor+cx;
      if(ymvx[cpos] != Infinity && ymvy[cpos] != Infinity){
        pfx = cx-ymvx[cpos]; pfy = cy-ymvy[cpos];
        position(&px, &py, pfx, pfy, ymvx[cpos], ymvy[cpos], yhor, yver);
        ppos = py*yhor+px;
        ptmp = interpolate(pfx, pfy, fr0.Y, yhor, yver, TYPE);
      }
    }
  }
*/


  /* Y, U, V */
#ifdef LIFTING
  mc_analysis(lfr->Y, hfr->Y, fr1.Y, fr0.Y, ymvx, ymvy, yhor, yver, level, pair, Global);
#else
  mc_analysis2(lfr->Y, hfr->Y, fr1.Y, fr0.Y, ymvx, ymvy, yhor, yver, level, pair, ypused, Global);
#endif


#ifdef STATISTICS          
//  unconnectedL[level] += unreferred;
#endif

  if(info.verbose){
    printf("connected = %d\t unreferred = %d\t pre_connected = %d\n", connected, unreferred, pre_connected);
    printf("connected = %d\t multi_connected = %d\t next_connected = %d\n", connected, multi_connected, next_connected);
  }

  fpstat = fopen(info.statname, "at+");
  fprintf(fpstat, "connected = %d\t unreferred = %d\t pre-connected = %d\n", connected, unreferred, pre_connected);
  fprintf(fpstat, "connected = %d\t multi_connected = %d\t next_connected = %d\n", connected, multi_connected, next_connected);
  fclose(fpstat);


  if(info.cwidth && info.cheight){

    for(i=0; i<cver*chor; i++)
      used[i] = cpused[i];
#ifdef LIFTING
    mc_analysis(lfr->U, hfr->U, fr1.U, fr0.U, cmvx, cmvy, chor, cver, -1, -1, Global);
    mc_analysis(lfr->V, hfr->V, fr1.V, fr0.V, cmvx, cmvy, chor, cver, -1, -1, Global);
#else
    mc_analysis2(lfr->U, hfr->U, fr1.U, fr0.U, cmvx, cmvy, chor, cver, -1, -1, cpused, Global);
    mc_analysis2(lfr->V, hfr->V, fr1.V, fr0.V, cmvx, cmvy, chor, cver, -1, -1, used, Global);
#endif


  }
  free(used);
  free(ymvx); free(ymvy); free(cmvx); free(cmvy);
}








/*****************************************************************************
 orientation:
   V
   C H
     D  
   ************************************************************************/
int get_orient(float mvx, float mvy)
{
  int ori;

  if(!(((int)(2. * mvx)) % 2) && !(((int)(2. * mvy)) % 2)){
    ori = CT;
  }else if((((int)(2. * mvx)) % 2) && !(((int)(2. * mvy)) % 2)){
    ori = HO;
  }else if(!(((int)(2. * mvx)) % 2) && (((int)(2. * mvy)) % 2)){
    ori = VE;
  }else{
    ori = DI;
  }
  return(ori);
}

/*********************************************

  case HO: oxoxoxox xoxoxoxo

  case VE: o        x
           x        o
           o        x
	   x        o

  case DI: o      x         o     x
            x      o       x     o
             o      x     o     x
	      x      o   x     o    

 o: pixels in prev frame
 x: pixles in current frame 

 ****************************************************************/

int getLine(float *line, float *fr0, float *fr1, int orient, int cx, int cy, float *mvx, float *mvy, int hor, int ver, int *length, unsigned char *cused, unsigned char *pused, unsigned char *pel_case, float *hfr, int local)
{
  int flag = 1, pos1, cpos, px, py, ppos;
  float c1, c2, pfx, pfy;


  c1=(float)(1./sqrt(2.)); c2=c1;
  pos1 = cx + cy * hor;
  pfx = cx-mvx[pos1]; pfy = cy-mvy[pos1];
  position(&px, &py, pfx, pfy, mvx[pos1], mvy[pos1], hor, ver);
  ppos = py*hor+px;
  *length = 1;
  if(orient == HO){
    if(mvx[pos1] < 0){       
      line[0] = fr0[ppos];
      line[1] = fr1[pos1];
    }else{
      line[0] = fr1[pos1];
      line[1] = fr0[ppos];
    }
  }else if(orient == VE || orient == DI){
    if(mvy[pos1] < 0){       
      line[0] = fr0[ppos];
      line[1] = fr1[pos1];
    }else{
      line[0] = fr1[pos1];
      line[1] = fr0[ppos];
    }
  }else{
    fprintf(stderr, "error: wrong orientation\n");
    exit(1);
  }
 
  if(orient == HO){
    
    while(flag){
      flag = 0; cx++;
      if(cx < hor){
        cpos = cx + cy * hor;
        
        if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ /*Chen Jan,27, 00*/
          if((!cused[cpos])&&(mvx[cpos]==mvx[pos1])&&(mvy[cpos]==mvy[pos1])){
            cused[cpos] = USED;
            pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
            position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver);
            ppos = py*hor+px;
            if(pused[ppos]!=USED){

              /*if(px==178 && py==119) printf("px==178 && py==119 cx = %d, cy= %d(connected mctfN.c)\n", cx, cy);
              if(px==194 && py==116) printf("px==194 && py==116 cx = %d, cy= %d(connected mctfN.c)\n", cx, cy);*/
              connected++;

              flag = 1; pel_case[cpos] = HO;
              pused[ppos] = USED;
              /*fprintf(stdout, "len = %d\n", *length); */
              if(mvx[pos1] < 0){
                line[2 * *length] = fr0[ppos];
                line[2 * *length+1] = fr1[cpos];
              }else{
                line[2 * *length] = fr1[cpos];
                line[2 * *length+1] = fr0[ppos];
              }
              (*length)++;
            }else{

              multi_connected++;

              pel_case[cpos] =  UN;

#ifdef SCALE_DOWN
              hfr[cpos] = c1*fr1[cpos] - c2*fr0[ppos];  
#else
              hfr[cpos] = fr1[cpos] - fr0[ppos];
#endif

            } 
          }  /*!cused[cpos]*/
        }/*mvx[cpos] != Infinity && mvy[cpos] != Infinity*/
        else{
          if(local == Global){
            if( cused[cpos] != USED ){
              //hfr[cpos] = fr1[cpos];
              cused[cpos] = USED;
              pel_case[cpos]= Bi; /* bi-connected or intra coded pixels in current frame */

              next_connected++;

            }
          }
        }

      }  /* cx < hor */
    } /* while */
  }else if(orient == VE){
    while(flag){
      flag = 0; cy++;
      if(cy < ver){
        cpos = cx + cy * hor;

        if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ /*Chen Jan,27, 00*/
          if((!cused[cpos])&&(mvx[cpos]==mvx[pos1])&&(mvy[cpos]==mvy[pos1])){

            pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
            position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver);
            ppos = py*hor+px;
            cused[cpos] = USED;

            if(pused[ppos]!=USED){ 

              connected++;

              flag = 1; pel_case[cpos] = VE;
              pused[ppos] = USED;
              if(mvy[pos1] < 0){
                line[2 * *length] = fr0[ppos];
                line[2 * *length+1] = fr1[cpos];
              }else{
                line[2 * *length] = fr1[cpos];
                line[2 * *length+1] = fr0[ppos];
              }
              (*length)++;
            }else{

              multi_connected++;

              pel_case[cpos] =  UN;
#ifdef SCALE_DOWN
              hfr[cpos] = c1*fr1[cpos] - c2*fr0[ppos];  
#else
              hfr[cpos] = fr1[cpos] - fr0[ppos];
#endif


            }
          } /*!cused[cpos]*/
        }/*mvx[cpos] != Infinity && mvy[cpos] != Infinity*/
        else{
          if(local == Global){
            if( cused[cpos] != USED ){
              //hfr[cpos] = fr1[cpos];
              cused[cpos] = USED;
              pel_case[cpos]= Bi; /* bi-connected or intra coded pixels in current frame */

              next_connected++;

            }
          }
        }
      } /*cy < ver*/
    } /* while */
  }else if(orient == DI){
    while(flag){
      flag = 0;
      if((mvx[pos1] * mvy[pos1]) < 0){  /* NE orientation*/ 
	cx--; cy++;
      }else{ /* SW orientation*/
	cx++; cy++;
      }
      if(cx >= 0 && cx < hor && cy < ver){
	cpos = cx + cy * hor;
        if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ /*Chen Jan,27, 00*/

          if((!cused[cpos])&&(mvx[cpos]==mvx[pos1])&&(mvy[cpos]==mvy[pos1])){

            pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
            position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver);
            ppos = py*hor+px;
            cused[cpos] = USED;

            if(pused[ppos]!=USED){ /* connected */ 

              connected++;

              flag = 1; pel_case[cpos] = DI; 
              pused[ppos] = USED;
              if(mvy[pos1] < 0){
                line[2 * *length] = fr0[ppos];
                line[2 * *length+1] = fr1[cpos];
              }else{
                line[2 * *length] = fr1[cpos];
                line[2 * *length+1] = fr0[ppos];
              }
              (*length)++;
            }else{

              multi_connected++;

              pel_case[cpos] =  UN;
#ifdef SCALE_DOWN
              hfr[cpos] = c1*fr1[cpos] - c2*fr0[ppos];  
#else
              hfr[cpos] = fr1[cpos] - fr0[ppos];
#endif
            }
          }  /*!cused[cpos]*/
        }/*mvx[cpos] != Infinity && mvy[cpos] != Infinity*/

        else{
          if(local == Global){
            if( cused[cpos] != USED ){
              //hfr[cpos] = fr1[cpos];
              cused[cpos] = USED;
              pel_case[cpos]= Bi; /* bi-connected or intra coded pixels in current frame */

              next_connected++;

            }
          }
        }
      }  /*cx >= 0 && cx < hor && cy < ver*/
    } /* while */
  }
  return(0);
}

int putLine(float *outlinel, float *outlineh, float *hfr, float *lfr, 
	    int orient, int cx, int cy, float mvx, float mvy, int hor, 
	    int ver, int length)
{
  int i, cpos, px, py, ppos;
  float pfx, pfy;


  cpos = cx + cy * hor;
  pfx = cx-mvx; pfy = cy-mvy;
  position(&px, &py, pfx, pfy, mvx, mvy, hor, ver);
  ppos = py*hor+px;

  if(orient == HO){
    for( i = 0; i < length; i++, cpos++, ppos++){
      if(mvx < 0){
        lfr[ppos] = outlinel[2*i];
        hfr[cpos] = outlineh[2*i+1];
      }else{
        lfr[ppos] = outlinel[2*i+1];
        hfr[cpos] = outlineh[2*i];
      }
    }
  }else if(orient == VE){
    for( i = 0; i < length; i++){
      if(mvy < 0){
        lfr[ppos] = outlinel[2*i];
        hfr[cpos] = outlineh[2*i+1];
      }else{
        lfr[ppos] = outlinel[2*i+1];
        hfr[cpos] = outlineh[2*i];
      }
      cpos += hor; ppos += hor;
    }
  }else if(orient == DI){
    for( i = 0; i < length; i++){
      if(mvy < 0){
        lfr[ppos] = outlinel[2*i];
        hfr[cpos] = outlineh[2*i+1];
      }else{
        lfr[ppos] = outlinel[2*i+1];
        hfr[cpos] = outlineh[2*i];
      }
      if((mvx * mvy) < 0){
        cpos = cpos + hor - 1;  
	ppos = ppos + hor - 1;
      }else{
	cpos = cpos + hor + 1;  
	ppos = ppos + hor + 1;
      }
    }
  }
  return(0);
}



/****************************************************************************/
/*                              mc_analysis2()                              */
/***************************************************************************/

/* local = 1 local filtering,  local = 0 global filtering */
void mc_analysis2(float  *lfr, float  *hfr, float  *fr1, float  *fr0, float *mvx, float *mvy, int hor, int ver, int level, int pair,  unsigned char *pused, int local)
{
  int i, nn, orient, itemp, half_length, new_length; 
  int cx, cy, px, py, cpos, ppos;
  float c1, c2, c3, c4, c5, pfx, pfy;
  unsigned char *cused, *pel_case; /* pel_case record the pixel status in current frame */
  int tmp, length, filter_length, count = 0;
  /*float mean0, mean1, gain, pert;*/
  float *line, *extension, *outlinel, *outlineh, *h0, *h1;
  double cmean[6], cvar[6];
  int cnpixels[6];

  connected=0; 
  unreferred=0;        pre_connected=0;
  multi_connected=0;   next_connected=0;

  c1=(float)(1./sqrt(2.)); c2=c1;  c3=c1;  c4=c1;  c5=(float)sqrt(2.);  /* orthonormal */

  filter_length = filter_coeff(&h0, &h1, 2, ANAL);
  h0 = &h0[filter_length/2];
  h1 = &h1[filter_length/2];
  filter_sqrt2(h0, h1, (int) filter_length/2);


  for(cy=0 ; cy<ver ; cy++){
    for(cx=0 ; cx<hor ; cx++){
      ppos = cy*hor+cx;
      if(pused[ppos] == USED)
        pre_connected++;
    }
  }


  /* flag */
  cused = (unsigned char *)getarray(hor*ver, sizeof(unsigned char), "cused");

  pel_case = (unsigned char *)getarray(hor*ver, sizeof(unsigned char), "pel_case");
  
  for(i=0 ; i<hor*ver ; i++) {
    /*pused[i] = 0;*/ cused[i] = 0; pel_case[i] = ER;
  }

  line = (float *)getarray(2 * MY_MAX(hor, ver), sizeof(float), "line");




  half_length = (filter_length - 1) / 2; /* assume odd length */
  new_length = 2 * MY_MAX(hor, ver) + 2 * half_length;
  extension = (float *)getarray(new_length, sizeof(float), "extension");
  extension = &extension[half_length];

  
  outlinel = (float *)getarray(2 * MY_MAX(hor, ver), sizeof(float), "outlinel");
  outlineh = (float *)getarray(2 * MY_MAX(hor, ver), sizeof(float), "outlineh");

  /* temporal filtering */

  for(cy=0 ; cy < ver ; cy++){
    tmp = cy*hor;
    for(cx = 0; cx < hor; cx++){
      cpos = tmp + cx;

      if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ /*Chen Jan,27, 00*/

        /*if(local == 1)
          printf("mvx %f\n", mvx[cpos] );*/
        if(!cused[cpos]){
          cused[cpos] = 1;
          pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
          position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver);
          ppos = py*hor+px;
          /*if(local ==1){
            printf("px%d py%d\n", px, py); 
            printf("fr0%f\n",fr0[ppos]);
          }*/

          if(pused[ppos]!=USED){ /* connected pixel*/
            connected++;
			
            pused[ppos] = USED;
            pel_case[cpos] = orient = get_orient(mvx[cpos], mvy[cpos]);

            if(orient == CT){/* full-pixel motion*/
              hfr[cpos] = c1*fr1[cpos] - c2*fr0[ppos];
              lfr[ppos] = c1*fr1[cpos] + c2*fr0[ppos];
            }else{ /* half-pixel motion*/
              getLine(line, fr0, fr1, orient, cx, cy,
                      mvx, mvy, hor, ver, &length, cused, pused, pel_case, hfr, local);
              line_convolve(line, extension, 2*length, h0, filter_length, ANAL, outlinel);
              line_convolve(line, extension, 2*length, h1, filter_length, ANAL, outlineh);
              putLine(outlinel, outlineh, hfr, lfr, orient, cx, cy, mvx[cpos],
                      mvy[cpos], hor, ver, length);

            }
          }else{/* unconnected pixel*/

            multi_connected++;

            pel_case[cpos] = UN;

#ifdef SCALE_DOWN
            hfr[cpos] = c1*fr1[cpos] - c2*fr0[ppos];  
#else
            hfr[cpos] = fr1[cpos] - fr0[ppos];
#endif

          }
        }   /*!cused[cpos]*/
      }  /*mvx[cpos] != Infinity && mvy[cpos] != Infinity*/

      else{
        if(local == Global){
          if( cused[cpos] != USED ){
            //hfr[cpos] = fr1[cpos];
            cused[cpos] = USED;
            pel_case[cpos]= Bi; /* bi-connected or intra coded pixels in current frame */

            next_connected++;

          }
        }
      }
    } /* end of for(cx) */
  }/* end of for(cy)*/


  if(local == Global){

    nn = hor * ver; 
    itemp = 0;
    for(cpos=0 ; cpos < nn; cpos++){
      if(pel_case[cpos] == ER){
        itemp++;
      }
    }
    if(itemp){
      fprintf(stderr, "error: %d pixels not processed\n", itemp);
      exit(1);
    }

    for(i = 0; i < 6; i++){
      cmean[i] = 0.0; cvar[i] = 0.0;
      cnpixels[i] = 0;
    }

    for(ppos=0 ; ppos < nn; ppos++){

      if(!pused[ppos]){
        unreferred++;
        lfr[ppos] = c5*fr0[ppos];
      }
      cnpixels[pel_case[ppos]]++;     /* estimate avg energy of hfr for 5 cases*/
      cmean[pel_case[ppos]] += hfr[ppos];
      cvar[pel_case[ppos]] += (hfr[ppos] * hfr[ppos]);
    }
    /*check*/



 if(connected+unreferred+pre_connected != hor*ver || 
     connected+multi_connected+next_connected != hor*ver){
    printf("error in mctf() connected: %d, unconecteed: %d, pre-conected: %d\n", connected, unreferred, pre_connected);
    printf("error in mctf() connected: %d, multi_connected: %d, next_conected: %d\n", connected, multi_connected, next_connected);

    exit(1);
  }

 if(multi_connected != cnpixels[UN] || next_connected != cnpixels[Bi]){
   printf("error in mctf() %d, multi_connected: %d, next_conected: %d\n", multi_connected, next_connected);
   exit(0);
 }

    count = 0;
    for(i = 0; i < 6; i++){
      count += cnpixels[i];
/*
      cmean[i] /= cnpixels[i];
      cvar[i] /= cnpixels[i];
      fprintf(stdout, "case %d: n = %d m = %f eng = %f\n", i, cnpixels[i], cmean[i], cvar[i]); 
*/
    }
    if(count != nn){
      fprintf(stderr, "error in matching two frames: missing %d pixels\n",
              nn - count);
      exit(1);
    }

    // output connection case map
    /*if(level >= 0){
      header = make_header(hor, ver, GRAYDATA);
      for(i=0; i<hor*ver; i++)
		  if(pel_case[i] == UN || pel_case[i] == Bi)
			  pel_case[i] = 128;
		  else
			  pel_case[i] = 0;
	  sprintf(name, "casemapLev%1dH%1d.ras", level, pair);  
      write_ras(name, header, pel_case);
    }*/

  } /* local == Global */
  free((char *)line);
  free(outlinel); free(outlineh);
  free((char *)&extension[-half_length]);
  free((char *)&h0[-filter_length/2]); free((char *)&h1[-filter_length/2]); 

  free(pel_case);
  free(cused);
}



/****************************************************************************/
/*                        local_temporal_analysis2                          */
/****************************************************************************/
void local_temporal_analysis2(YUVimage hfr, YUVimage lfr, YUVimage fr1, YUVimage fr0, vector_ptr fmv, unsigned char *ypused, unsigned char *cpused, videoinfo info, enum BlockMode block_mode) /* June19*/
   /* fr1--current  fr0--next */
/* the original data is in fr1 and fr0, the result is in lfr and hfr */
{
  int   i, x, y, X, Y, yhor, yver, chor, cver;
  int   xnum, ynum, xblk, yblk;
  float *ymvx, *ymvy, *cmvx, *cmvy;
  unsigned char *used;
  float c5;

  c5 = (float)sqrt(2.);

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblk = info.xblk;   yblk = info.yblk;

  /* allocate the memory and initialization */
  used = (unsigned char *)getarray(chor*cver, sizeof(unsigned char), "used");

  ymvx = (float *) getarray(yhor*yver, sizeof(float), "ymvx");
  ymvy = (float *) getarray(yhor*yver, sizeof(float), "ymvy");
  cmvx = (float *) getarray(chor*cver, sizeof(float), "cmvx");
  cmvy = (float *) getarray(chor*cver, sizeof(float), "cmvy");



  /* convert the block-based vectors to the pixel-based vectors */
  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      block2pixel2(ymvx, ymvy, &fmv[Y*xnum+X], x, y, xblk, yblk, yhor, yver, block_mode);
    }
  }
  /* get the chrominance motion vector from the luminance vector */
  if(info.cwidth && info.cheight){
    get_cvector(cmvx, cmvy, ymvx, ymvy, yhor, yver, chor, cver, info);
  }

#ifdef LIFTING
  local_mc_analysis(lfr.Y, hfr.Y, fr1.Y, fr0.Y, ymvx, ymvy, yhor, yver, -1, -1, Local);
#else
  mc_analysis2(lfr.Y, hfr.Y, fr1.Y, fr0.Y, ymvx, ymvy, yhor, yver, -1, -1, ypused, Local);
#endif

      /* scale down the coefficients in next frame */
  /*for(i = 0; i < yhor*yver; i++){
    if(ypused[i] == USED)
      lfr.Y[i] = lfr.Y[i] / c5;
  }*/ /* June19*/


  if(info.cwidth && info.cheight){

    for(i = 0; i < chor*cver; i++)
      used[i] = cpused[i];

#ifdef LIFTING
    local_mc_analysis(lfr.U, hfr.U, fr1.U, fr0.U, cmvx, cmvy, chor, cver, -1, -1, Local);
    local_mc_analysis(lfr.V, hfr.V, fr1.V, fr0.V, cmvx, cmvy, chor, cver, -1, -1, Local);
#else
    mc_analysis2(lfr.U, hfr.U, fr1.U, fr0.U, cmvx, cmvy, chor, cver, -1, -1, cpused, Local);
      /* scale down the coefficients in next frame */
    /*for(i = 0; i < chor*cver; i++){
      if(cpused[i] == USED)
        lfr.U[i] = lfr.U[i] / c5;
    }*/ /* June19 */


    mc_analysis2(lfr.V, hfr.V, fr1.V, fr0.V, cmvx, cmvy, chor, cver, -1, -1, used, Local);
      /* scale down the coefficients in next frame */
    /*for(i = 0; i < chor*cver; i++){
      if(cpused[i] == USED)
        lfr.V[i] = lfr.V[i] / c5;
    }*/ /* June19 */
#endif

  }

  free(used);

  free(ymvx); free(ymvy); free(cmvx); free(cmvy);
}


/*****************************************************************************/
/*                            temporal_synthesis                             */
/*****************************************************************************/
void temporal_synthesis(YUVimage_ptr fr1, YUVimage_ptr fr0, YUVimage lfr, YUVimage hfr, vector_ptr fmv, unsigned char *ypused, unsigned char *cpused, int level, int pair, videoinfo info)
/* fr1--current, fr0--reference */
{
  int   i, x, y, X, Y, yhor, yver, chor, cver;
  int   xnum, ynum, xblk, yblk;
  float c5;
  float *ymvx, *ymvy, *cmvx, *cmvy;
  unsigned char *used;
  //long mark, elp;   // initial and elapsed time
  //double duration;


  c5=(float)(1./sqrt(2.));

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblk = info.xblk;   yblk = info.yblk;
  used = (unsigned char *)getarray(chor*cver, sizeof(unsigned char), "used");

  for(i=0 ; i<yhor*yver ; i++) ypused[i] = UNUSED;   /* June19 */  
  for(i=0 ; i<chor*cver ; i++) cpused[i] = UNUSED;

/*
  for(y=0; y<yver; y++){
    for(x=0; x<yhor; x++){
      pos = y*yhor + x;
      if(ypused[pos] == USED)
        fr0->Y[pos] = lfr.Y[pos] * c5;
    }
  }

  if(info.cwidth && info.cheight){
    for(y=0; y<cver; y++){
      for(x=0; x<chor; x++){
        pos = y*chor + x;
        if(cpused[pos] == USED){
          fr0->U[pos] = lfr.U[pos] * c5;
          fr0->V[pos] = lfr.V[pos] * c5;
        }
      }
    }
  }
*/
  /* allocate the memory and initialization */

  ymvx = (float *) getarray(yhor*yver, sizeof(float), "ymvx");
  ymvy = (float *) getarray(yhor*yver, sizeof(float), "ymvy");
  cmvx = (float *) getarray(chor*cver, sizeof(float), "cmvx");
  cmvy = (float *) getarray(chor*cver, sizeof(float), "cmvy");


  /* convert the block-based vectors to the pixel-based vectors */
  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      block2pixel2(ymvx, ymvy, &fmv[Y*xnum+X], x, y, xblk, yblk, yhor, yver, DEFAULT);
    }
  }

  /* get the chrominance motion vector from the luminance vector */
  if(info.cwidth && info.cheight){
    get_cvector(cmvx, cmvy, ymvx, ymvy, yhor, yver, chor, cver, info);
  }



//  mark = clock();



  /* Y U V */
#ifdef LIFTING
  mc_synthesis(fr1->Y, fr0->Y, lfr.Y, hfr.Y, ymvx, ymvy, yhor, yver, Global, level, pair, info); 
#else
  mc_synthesis2(fr1->Y, fr0->Y, lfr.Y, hfr.Y, ymvx, ymvy, yhor, yver, ypused, Global, level, pair, info); 
#endif



//  elp = clock() - mark;   
//  duration = (double)elp / CLOCKS_PER_SEC;
//  print_time(duration);


  if(info.cwidth && info.cheight){

      for(i=0; i<cver*chor; i++)
        used[i] = cpused[i];
#ifdef LIFTING
      mc_synthesis(fr1->U, fr0->U, lfr.U, hfr.U, cmvx, cmvy, chor, cver, Global, -1, -1, info);
      mc_synthesis(fr1->V, fr0->V, lfr.V, hfr.V, cmvx, cmvy, chor, cver, Global, -1, -1, info);
#else
      mc_synthesis2(fr1->U, fr0->U, lfr.U, hfr.U, cmvx, cmvy, chor, cver, cpused, Global, -1, -1, info);
      mc_synthesis2(fr1->V, fr0->V, lfr.V, hfr.V, cmvx, cmvy, chor, cver, used, Global, -1, -1, info);
#endif

  }

  
//  elp = clock() - mark;   
//  duration = (double)elp / CLOCKS_PER_SEC;
//  print_time(duration);

  free(used); free(ymvx); free(ymvy); free(cmvx); free(cmvy);
}







/******************************************************************************
            getIntLacedLine()          fr0 -> lfr, fr1-> hfr
  ****************************************************************************/

int getIntLacedLine(float *outline, float *extension, float *outL, float *outH, float *linel, float *lineh, float *lineL, float *lineH, float *lfr, float *hfr, float *h0, float *h1, int filter_length, int orient, int cx, int cy, float *mvx, float *mvy, int hor, int ver, int *length, unsigned char *cused, unsigned char *pused, unsigned char *pel_case, float *fr0, float *fr1, int local)
{
  
  int i, flag = 1, pos1, cpos, px, py, ppos;
  float c3, c4, pfx, pfy;

  c3=1.;  c4=(float)sqrt(2.); 
 

  pos1 = cx + cy * hor;

  if(orient == HO){ 
    while(flag){
      flag = 0; cx++; 
      if(cx < hor){
        cpos = cx + cy * hor;

        if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ /*Chen Jan,27, 00*/
          if((!cused[cpos])&&(mvx[cpos]==mvx[pos1])&&(mvy[cpos]==mvy[pos1])){
            pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
            position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver); 
            ppos = py*hor+px;
            cused[cpos] = USED;
            if(pused[ppos]!=USED){
              flag = 1; pel_case[cpos] = HO;
              pused[ppos] = USED;
              lineL[*length] = lfr[ppos];
              lineH[*length] = hfr[cpos];
              (*length)++;
            }else{
              pel_case[cpos] =  UN;

#ifdef SCALE_DOWN
              fr1[cpos] = c3*fr0[ppos] + c4*hfr[cpos]; 
#else
			  fr1[cpos] = fr0[ppos] + hfr[cpos];
#endif
            }
          }  /*!cused[cpos]*/
        }/*mvx[cpos] != Infinity && mvy[cpos] != Infinity*/
        else{
          if(local == Global){
            if( cused[cpos] != USED ){
              //fr1[cpos] = hfr[cpos];
              cused[cpos] = USED;
              pel_case[cpos]= Bi; /* bi-connected or intra coded pixels in current frame */
            }
          }
        }
      }/* cx < hor */
    } /*while */
    for(i = 0; i < *length; i++){
      if(mvx[pos1] < 0){
	    linel[2*i] = lineL[i]; linel[2*i+1] = 0.0;
	    lineh[2*i+1] = lineH[i]; lineh[2*i] = 0.0;
      }else{
	    linel[2*i+1] = lineL[i]; linel[2*i] = 0.0;
	    lineh[2*i] = lineH[i]; lineh[2*i+1] = 0.0;
      }
    } 
  }else if(orient == VE){ 
    while(flag){
      flag = 0; cy++;
      if(cy < ver){
        cpos = cx + cy * hor;

        if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ /*Chen Jan,27, 00*/
          if((!cused[cpos])&&(mvx[cpos]==mvx[pos1])&&(mvy[cpos]==mvy[pos1])){
            pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
            position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver);
            ppos = py*hor+px;
            cused[cpos] = USED;

            if(pused[ppos]!=USED){
              flag = 1; pel_case[cpos] = VE;
              pused[ppos] = USED;
              lineL[*length] = lfr[ppos];
              lineH[*length] = hfr[cpos];
              (*length)++;
            }else{
              pel_case[cpos] =  UN;
#ifdef SCALE_DOWN
              fr1[cpos] = c3*fr0[ppos] + c4*hfr[cpos]; 
#else
			  fr1[cpos] = fr0[ppos] + hfr[cpos];
#endif
            }
          } /* !cused[cpos] */
        } /* mvx[cpos] != Infinity && mvy[cpos] != Infinity  */
        else{
          if(local == Global){
            if( cused[cpos] != USED ){
              //fr1[cpos] = hfr[cpos];
              cused[cpos] = USED;
              pel_case[cpos]= Bi; /* bi-connected or intra coded pixels in current frame */
            }
          }
        }
      } /* cy < ver */
    } /* while */
    for(i = 0; i < *length; i++){
      if(mvy[pos1] < 0){
	linel[2*i] = lineL[i]; linel[2*i+1] = 0.0;
	lineh[2*i+1] = lineH[i]; lineh[2*i] = 0.0;
      }else{
	linel[2*i+1] = lineL[i]; linel[2*i] = 0.0;
	lineh[2*i] = lineH[i]; lineh[2*i+1] = 0.0;
      }
    }
  }else if(orient == DI){ 
    while(flag){
      flag = 0;
      if((mvx[pos1] * mvy[pos1]) < 0){  /* NE orientation*/ 
        cx--; cy++;
      }else{ /* SW orientation*/
        cx++; cy++;
      }
      if(cx >= 0 && cx < hor && cy < ver){
        cpos = cx + cy * hor;

        if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ /*Chen Jan,27, 00*/
          if((!cused[cpos])&&(mvx[cpos]==mvx[pos1])&&(mvy[cpos]==mvy[pos1])){

            pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
            position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver);
            ppos = py*hor+px;
            cused[cpos] = USED;

            if(pused[ppos]!=USED){ /* connected */
              flag = 1; pel_case[cpos] = DI;
              pused[ppos] = USED;
              lineL[*length] = lfr[ppos];
              lineH[*length] = hfr[cpos];
              (*length)++;
            }else{
              pel_case[cpos] =  UN;
#ifdef SCALE_DOWN
              fr1[cpos] = c3*fr0[ppos] + c4*hfr[cpos]; 
#else
			  fr1[cpos] = fr0[ppos] + hfr[cpos];
#endif

            }
          } /*!cused[cpos]*/
        } /*mvx[cpos] != Infinity && mvy[cpos] != Infinity*/
        else{ 
          if(local == Global){
            if( cused[cpos] != USED ){
              //fr1[cpos] = hfr[cpos];
              cused[cpos] = USED;
              pel_case[cpos]= Bi; /* bi-connected or intra coded pixels in current frame */
            }
          }
        }
      } /* cx >= 0 && cx < hor && cy < ver */
    } /* while */



    for(i = 0; i < *length; i++){
      if(mvy[pos1] < 0){
        linel[2*i] = lineL[i]; linel[2*i+1] = 0.0;
        lineh[2*i+1] = lineH[i]; lineh[2*i] = 0.0;
	  }else{
	    linel[2*i+1] = lineL[i]; linel[2*i] = 0.0;
	    lineh[2*i] = lineH[i]; lineh[2*i+1] = 0.0;
	  }
	}
     
  }

  line_convolve(linel, extension, 2 * *length, h0, filter_length, SYN, outL);
  line_convolve(lineh, extension, 2 * *length, h1, filter_length, SYN, outH);
  for(i = 0; i < 2 * *length; i++){
    outline[i] = outL[i] + outH[i];
  }

  return(0);
}

/******************************************************************************
           DeIntLacedLine()        hfr->fr1  lfr->fr0
******************************************************************************/
int DeIntLacedLine(float *outline, float *fr1, float *fr0, int orient, 
	 int cx, int cy, float mvx, float mvy, int hor, int ver, int length)
{
  int i, cpos, px, py, ppos;
  float pfx, pfy;


  cpos = cx + cy * hor;
  pfx = cx-mvx; pfy = cy-mvy;
  position(&px, &py, pfx, pfy, mvx, mvy, hor, ver);
  ppos = py*hor+px;

  if(orient == HO){
    for( i = 0; i < length; i++, cpos++, ppos++){
      if(mvx < 0){
        fr0[ppos] = outline[2*i];
        fr1[cpos] = outline[2*i+1];
      }else{
        fr0[ppos] = outline[2*i+1];
        fr1[cpos] = outline[2*i];
      }
    }
  }else if(orient == VE){
    for( i = 0; i < length; i++){
      if(mvy < 0){
        fr0[ppos] = outline[2*i];
        fr1[cpos] = outline[2*i+1];
      }else{
        fr0[ppos] = outline[2*i+1];
        fr1[cpos] = outline[2*i];
      }
      cpos += hor; ppos += hor;
    }
  }else if(orient == DI){
    for( i = 0; i < length; i++){
      if(mvy < 0){
        fr0[ppos] = outline[2*i];
        fr1[cpos] = outline[2*i+1];
      }else{
        fr0[ppos] = outline[2*i+1];
        fr1[cpos] = outline[2*i];
      }
      if((mvx * mvy) < 0){
        cpos = cpos + hor - 1;  
        ppos = ppos + hor - 1;
      }else{
        cpos = cpos + hor + 1;  
        ppos = ppos + hor + 1;
      }
    } 
  }
  return(0);
}



/*****************************************************************************/
/*                                 mc_synthesis2                             */
/*pel_case: pixel cases in the current frame                                 */
/* level = -1 means no output for casemap                                    */ 
/*****************************************************************************/
void mc_synthesis2(float *fr1, float *fr0, float *lfr, float *hfr, float *mvx, float *mvy, int hor, int ver, 
				   unsigned char *pused,  int local, int level, int pair, videoinfo info)
{
  int i, nn, orient, itemp, pos; 
  int cx, cy, px, py, cpos, ppos;
  float c1, c2, c3, c4, c5, pfx, pfy;
  unsigned char *cused, *pel_case;
  int tmp, length, new_length, filter_length, half_length, count = 0;
  /*float mean0, mean1, gain, pert;*/
  float *line, *extension, *linel, *lineh, *lineL, *lineH, *outL, *outH, *h0, *h1;
  int  cnpixels[6];
//  long mark, elp;   // initial and elapsed time
//  double duration;


  connected=0;
  unreferred=0;        pre_connected=0;
  multi_connected=0;   next_connected=0;


  /* temporal filtering */
  c1=(float)(1./sqrt(2.)); c2=c1;  c3=(float)1.;  c4=(float)sqrt(2.); c5=(float)(1./sqrt(2.));/*orthonormal*/

  filter_length = filter_coeff(&h0, &h1, 2, SYN);
  h0 = &h0[filter_length/2];
  h1 = &h1[filter_length/2];
  filter_sqrt2(h0, h1, (int) filter_length/2);



  /* flag */
  cused = (unsigned char *) getarray(hor*ver, sizeof(unsigned char), "cused");
  pel_case = (unsigned char *) getarray(hor*ver, sizeof(unsigned char), "pel_case");
  for(i=0 ; i<ver*hor; i++) {
 /*   fr0[i] = fr1[i] = 0.0; */ /* commented on Feb 9 */
   /* pused[i] = 0;*/ cused[i] = 0; pel_case[i] = ER;
      if(pused[i] == USED)
        pre_connected++;
  }
  line = (float *)getarray(2 * MY_MAX(hor, ver), sizeof(float), "line");
  lineL = (float *)getarray(2 * MY_MAX(hor, ver), sizeof(float), "lineL");
  lineH = (float *)getarray(2 * MY_MAX(hor, ver), sizeof(float), "lineH");
  linel = (float *)getarray(2 * MY_MAX(hor, ver), sizeof(float), "linel");
  lineh = (float *)getarray(2 * MY_MAX(hor, ver), sizeof(float), "lineh");
  outL = (float *)getarray(2 * MY_MAX(hor, ver), sizeof(float), "outL");
  outH = (float *)getarray(2 * MY_MAX(hor, ver), sizeof(float), "outH");



  half_length = (filter_length - 1) / 2; 
  new_length = 2 * MY_MAX(hor, ver) + 2 * half_length;
  extension = (float *)getarray(new_length, sizeof(float), "extension");
  extension = &extension[half_length];





//  mark = clock();

  for(cy=0 ; cy < ver ; cy++){ 
    tmp = cy*hor;

    for(cx = 0; cx < hor; cx++){
      cpos = tmp + cx;
      
	  
	  if(mvx[cpos] != Infinity && mvy[cpos] != Infinity ){ /*Chen Jan,27, 00*/

        /*if(local == 1)
          printf("mvx %f\n", mvx[cpos] );*/
        if(!cused[cpos]){
          cused[cpos] = 1;
          pfx = cx-mvx[cpos]; pfy = cy-mvy[cpos];
          position(&px, &py, pfx, pfy, mvx[cpos], mvy[cpos], hor, ver);
          ppos = py*hor+px;
          /*if(local ==1){
            printf("px%d py%d\n", px, py); 
            printf("fr0%f\n",fr0[ppos]);
          }*/
          if(pused[ppos]!=USED){ /* connected pixel*/
            pused[ppos] = USED;
            pel_case[cpos] = orient = get_orient(mvx[cpos], mvy[cpos]);
            if(orient == CT){/* full-pixel motion*/
              fr1[cpos] = c1*lfr[ppos] + c2*hfr[cpos];
              fr0[ppos] = c1*lfr[ppos] - c2*hfr[cpos];

            }else{ /* half-pixel motion*/
              lineL[0] = lfr[ppos];
              lineH[0] = hfr[cpos];
              length = 1;
              getIntLacedLine(line, extension, outL, outH, linel, lineh, lineL, lineH, lfr, hfr, h0, h1, filter_length, orient, cx, cy, 
                              mvx, mvy, hor, ver, &length, cused, pused, pel_case, fr0, fr1, local);

              DeIntLacedLine(line, fr1, fr0, orient, cx, cy, mvx[cpos],
                             mvy[cpos], hor, ver, length);
            }
          }else{/* unconnected pixel*/
            pel_case[cpos] = UN;

#ifdef SCALE_DOWN
            fr1[cpos] = c3*fr0[ppos] + c4*hfr[cpos]; 
#else
			fr1[cpos] = fr0[ppos] + hfr[cpos];
#endif
          }
        } /*!cused[cpos]*/
      } /*mvx[cpos] != Infinity && mvy[cpos] != Infinity*/
      else{
        if(local == Global){
          if(cused[cpos] != USED){
            //fr1[cpos] = hfr[cpos];
            cused[cpos] = USED;
            pel_case[cpos]= Bi; /* bi-connected or intra coded pixels in current frame */
          }
        }
      }
    } /* cx */
  }/* end of for(cy)*/

  
//  elp = clock() - mark;   
//  duration = (double)elp / CLOCKS_PER_SEC;
//  print_time(duration);




 if(local == Global){


#ifdef CASEMAP

    //printf("hor %d ver %d\n", hor, ver);
    // output connection case map
    char name[100];
	unsigned char *casemap;
	casemap = (unsigned char *)getarray(hor*ver, sizeof(unsigned char), "casemap");
    struct rasterfile header; 
    if(level >= 0){
      header = make_header(hor, ver, GRAYDATA);
      for(i=0; i<hor*ver; i++){
		  if(pel_case[i] == UN ||pel_case[i] == Bi) 
			  casemap[i] = UN;
		  else
			  casemap[i] = 128;
	  }
	  sprintf(name, "HcasemapLev%1dH%1d.ras", level, pair);  
      write_ras(name, header, casemap);


      for(i=0; i<hor*ver; i++){
		  if(!pused[i]) 
			  casemap[i] = UN;
		  else
			  casemap[i] = 128;
	  }
	  sprintf(name, "LcasemapLev%1dH%1d.ras", level, pair);  
      write_ras(name, header, casemap);
    }
	free(casemap);
#endif


    for(i = 0; i < 6; i++){
      cnpixels[i] = 0;
    }

    nn = hor * ver;
    itemp = 0;

    for(pos=0 ; pos < nn; pos++){
      if(pel_case[pos] == ER){
        itemp++;
      }
      if(!pused[pos]){
        unreferred++;
        fr0[pos] = c5*lfr[pos];
      }
      cnpixels[pel_case[pos]]++;     /*estimate avg energy of hfr for 5 cases*/

    }

    if(itemp){
      fprintf(stderr, "error: %d pixels not processed\n", itemp);
      exit(1);
    }

    /*check*/
    if( (unreferred+pre_connected) != (cnpixels[UN]+cnpixels[Bi]) ){
      fprintf(stderr, "error in matching two frames: %d+%d in prevI %d+%d in currI\n",
              unreferred, pre_connected, cnpixels[UN], cnpixels[Bi]);
      exit(1);
    }
    count = 0;
    for(i = 0; i < 6; i++){
      count += cnpixels[i];
    }
    if(count != nn){
      fprintf(stderr, "error in matching two frames: missing %d pixels\n",
              nn - count);
      exit(1);
    }

  }


  free((char *)line);   free((char *)lineL);  free((char *)lineH);    free((char *)linel);  free((char *)lineh);
  free(outL); free(outH);
  free((char *)&extension[-half_length]);

  free((char *)&h0[-filter_length/2]); free((char *)&h1[-filter_length/2]); 
  free(pel_case);
  free(cused);
}

/*****************************************************************************/
/*                         local_temporal_synthesis2                         */
/*****************************************************************************/
void local_temporal_synthesis2(YUVimage fr1, YUVimage fr0, YUVimage hfr, YUVimage nextL, vector_ptr fmv, unsigned char *ypused, unsigned char *cpused, videoinfo info, enum BlockMode block_mode)
   /* fr1 -- current  fr0 -- next */  /* the data in hfr and nextL takes part int computation, and the result is put into fr1 and fr0 */
{
  int   i, x, y, X, Y, yhor, yver, chor, cver;
  int   xnum, ynum, xblk, yblk;
  float *ymvx, *ymvy, *cmvx, *cmvy;
  unsigned char *used;
  float c5;

  c5 = (float)sqrt(2.);

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblk = info.xblk;   yblk = info.yblk;

  /* allocate the memory and initialization */
  used=(unsigned char *)getarray(chor*cver, sizeof(unsigned char), "used");

  ymvx = (float *) getarray(yhor*yver, sizeof(float), "ymvx");
  ymvy = (float *) getarray(yhor*yver, sizeof(float), "ymvy");
  cmvx = (float *) getarray(chor*cver, sizeof(float), "cmvx");
  cmvy = (float *) getarray(chor*cver, sizeof(float), "cmvy");

  /* convert the block-based vectors to the pixel-based vectors */
  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      block2pixel2(ymvx, ymvy, &fmv[Y*xnum+X], x, y, xblk, yblk, yhor, yver, block_mode);
    }
  }
  /* get the chrominance motion vector from the luminance vector */
  if(info.cwidth && info.cheight){
    get_cvector(cmvx, cmvy, ymvx, ymvy, yhor, yver, chor, cver, info);
  }



/*   June19
  for(i = 0; i < yhor*yver; i++){
    if(ypused[i] == USED)
      fr0.Y[i] = nextL.Y[i] / c5;
  }
  if(info.cwidth && info.cheight){
    for(i = 0; i < chor*cver; i++){
      if(cpused[i] == USED){
        fr0.U[i] = nextL.U[i] / c5;
        fr0.V[i] = nextL.V[i] / c5;
      }
    }
  }
*/



/*
  Y
*/
#ifdef LIFTING
  local_mc_synthesis(fr1.Y, fr0.Y, nextL.Y, hfr.Y, ymvx, ymvy, yhor, yver, Local, -1, -1, info);
#else
  mc_synthesis2(fr1.Y, fr0.Y, nextL.Y, hfr.Y, ymvx, ymvy, yhor, yver, ypused, Local, -1, -1, info);
      /* scale down the coefficients in next frame */
#endif


  if(info.cwidth && info.cheight){

    for(i = 0; i < chor*cver; i++)
      used[i] = cpused[i];
#ifdef LIFTING
    local_mc_synthesis(fr1.U, fr0.U, nextL.U, hfr.U, cmvx, cmvy, chor, cver, Local, -1, -1, info);
    local_mc_synthesis(fr1.V, fr0.V, nextL.V, hfr.V, cmvx, cmvy, chor, cver, Local, -1, -1, info);
#else
      /*
       U
       */

    mc_synthesis2(fr1.U, fr0.U, nextL.U, hfr.U, cmvx, cmvy, chor, cver, cpused, Local, -1, -1, info);

    /*
     V
     */
    mc_synthesis2(fr1.V, fr0.V, nextL.V, hfr.V, cmvx, cmvy, chor, cver, used, Local, -1, -1, info);
#endif
  }

  free(used);
  free(ymvx); free(ymvy); free(cmvx); free(cmvy);
}







/****************************************************************************/
/*                                t_analysis                                */
/****************************************************************************/
void t_analysis(float *lfr, float *hfr, float *fr1, float *fr0, int hor, int ver)
{
  int cx, cy, cpos, tmp;
  float c1, c2;


  /* temporal filtering */
  c1=(float)(1./sqrt(2.)); c2=c1;   /* orthonormal */

  for(cy=0 ; cy < ver ; cy++){
    tmp = cy*hor;
    for(cx = 0; cx < hor; cx++){
      cpos = tmp + cx;

      hfr[cpos] = c1*fr1[cpos] - c2*fr0[cpos];
      lfr[cpos] = c1*fr1[cpos] + c2*fr0[cpos];
    }
  }/* end of for(cy)*/

}



/***************************************************************/
/*                           t_synthesis                       */
/***************************************************************/
void t_synthesis(float *lfr, float *hfr, float *fr1, float *fr0, int hor, int ver)
{
  int cx, cy, cpos, tmp;
  float c1, c2;

  /* temporal filtering */
  c1=(float)(1./sqrt(2.)); c2=c1;   /*orthonormal*/

  for(cy=0 ; cy < ver ; cy++){
    tmp = cy*hor;
    for(cx = 0; cx < hor; cx++){
      cpos = tmp + cx;

      fr1[cpos] = c1*lfr[cpos] + c2*hfr[cpos];
      fr0[cpos] = c1*lfr[cpos] - c2*hfr[cpos];
    }
  }/* end of for(cy)*/
}


void t_anal(videoinfo info)
{
  int nPyrLev, i, j, half_len, dist;
  int yhor, yver, chor, cver;


  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  nPyrLev = info.tPyrLev;


  printf("temporal pyramid level 1\n");
  dist = 1;
  half_len = info.GOPsz / 2;

  for(i = 0; i < nPyrLev - 1; i++){
    printf("temporal pyramid level %d\n", i+1);
    for(j = 0; j < half_len; j++){
      t_analysis(pyrTemp[i+1][j].Y, pyrFrs[j+half_len].Y, pyrTemp[i][2*j].Y, pyrTemp[i][2*j+1].Y, yhor, yver);
      if(info.cwidth && info.cheight){
        t_analysis(pyrTemp[i+1][j].U, pyrFrs[j+half_len].U, pyrTemp[i][2*j].U, pyrTemp[i][2*j+1].U, chor, cver);
        t_analysis(pyrTemp[i+1][j].V, pyrFrs[j+half_len].V, pyrTemp[i][2*j].V, pyrTemp[i][2*j+1].V, chor, cver);
	  }
	}
    half_len /= 2;
    dist *= 2;
  }

  printf("temporal pyramid level %d\n", nPyrLev);
  
  t_analysis(pyrFrs[0].Y, pyrFrs[1].Y, pyrTemp[nPyrLev - 1][0].Y, pyrTemp[nPyrLev - 1][1].Y, yhor, yver);
  if(info.cwidth && info.cheight){
    t_analysis(pyrFrs[0].U, pyrFrs[1].U, pyrTemp[nPyrLev - 1][0].U, pyrTemp[nPyrLev - 1][1].U, chor, cver);
    t_analysis(pyrFrs[0].V, pyrFrs[1].V, pyrTemp[nPyrLev - 1][0].V, pyrTemp[nPyrLev - 1][1].V, chor, cver);
  }
}
 


void t_syn(videoinfo info) 
{
  int i, j, nPyrLev, half_len, yhor, yver, chor, cver;

  printf("synthesis.....................\n");

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  nPyrLev = info.tPyrLev;

  half_len = 1;

  t_synthesis(pyrFrs[0].Y, pyrFrs[1].Y, pyrTemp[nPyrLev-1][0].Y, pyrTemp[nPyrLev-1][1].Y, yhor, yver);
  if(info.cwidth && info.cheight){
    t_synthesis(pyrFrs[0].U, pyrFrs[1].U, pyrTemp[nPyrLev-1][0].U, pyrTemp[nPyrLev-1][1].U, chor, cver);
    t_synthesis(pyrFrs[0].V, pyrFrs[1].V, pyrTemp[nPyrLev-1][0].V, pyrTemp[nPyrLev-1][1].V, chor, cver);
  }

  for(i = nPyrLev-2; i >= 0; i--){
    half_len *= 2;
    for(j = 0; j < half_len; j++){
      t_synthesis(pyrTemp[i+1][j].Y, pyrFrs[j+half_len].Y, pyrTemp[i][2*j].Y, pyrTemp[i][2*j+1].Y, yhor, yver);
      if(info.cwidth && info.cheight){
        t_synthesis(pyrTemp[i+1][j].U, pyrFrs[j+half_len].U, pyrTemp[i][2*j].U, pyrTemp[i][2*j+1].U, chor, cver);
        t_synthesis(pyrTemp[i+1][j].V, pyrFrs[j+half_len].V, pyrTemp[i][2*j].V, pyrTemp[i][2*j+1].V, chor, cver);

	  }
	}
  }
}




/*
 *    SubtractMean()   
 *  Substract mean from a sub_block inside a frame.
 *  frame : a pointer pointing the upper-left corner of this block
 *  high  : place where we put the mean removed block.
 *  lenx  : width of sub_block.
 *  leny  : height of sub_block.
 *  hor   : width of the original frame
 */

void SubtractMean(float *frame, float *high, float mean, int xblk, int yblk, int hor)
{
  int x, y, m;

  m=0;
  for(y=0 ; y<yblk ; y++){  
    for(x=0 ; x<xblk ; x++){
      high[m] = frame[m] - mean;
	  //if(high[m] > 120){ printf("xblk %d yblk %d high %f frame %f mean %f\n", xblk, yblk, high[m], frame[m], mean); getchar();}
      m++;
	}
	m += hor-xblk;
  }
}


int quantize_Ymean(float mean, unsigned char depth, float *recon_mean)
{
  int quant_mean, max;
  
  mean /= pow(2., BlockShift);
  quant_mean = nint(mean);
  
  max = (1 << (depth-BlockShift)) - 1;
  if(quant_mean < 0){
	quant_mean = 0;
  }
  else if(quant_mean > max ){
	quant_mean = max ;
  }

  *recon_mean = quant_mean << BlockShift;

  return quant_mean;
}

int quantize_Cmean(float mean, unsigned char depth, float *recon_mean)
{
  int quant_mean, max;

  mean /= pow(2., BlockShift);
  quant_mean = (mean > 0)? nint(mean): -nint(mean);

  max = (1 << (depth-1-BlockShift)) -1;
  if(quant_mean > max ){
	quant_mean = max;
  }

  *recon_mean = quant_mean << BlockShift;
  if(mean < 0){
    *recon_mean = -(*recon_mean);
    quant_mean = -quant_mean;
  }
  return quant_mean;
}

/*
 * rec_RemoveMean
 * The dynamic range is determined by  "fmv->meandepth = info.pixeldepth + (tPyrLev+1)/2";
 * For U and V, the origin is shifted to 0. The amount of shifting is weighted by the temporal decomposition level.
 */
void rec_RemoveMean(YUVimage_ptr frame, YUVimage_ptr high, vector_ptr fmv, int tPyrLev, int cx, int cy, int xblock, int yblock, int hor, int ver, videoinfo info)
{
  int m;
  int xblk, yblk;
  float meanshift, mean, recon_mean;

  if(fmv->child){
	rec_RemoveMean(frame, high, fmv->child0, tPyrLev,cx,         cy,         xblock/2,yblock/2,hor,ver, info);
	rec_RemoveMean(frame, high, fmv->child1, tPyrLev,cx+xblock/2,cy,         xblock/2,yblock/2,hor,ver, info);
	rec_RemoveMean(frame, high, fmv->child2, tPyrLev,cx,         cy+yblock/2,xblock/2,yblock/2,hor,ver, info);
	rec_RemoveMean(frame, high, fmv->child3, tPyrLev,cx+xblock/2,cy+yblock/2,xblock/2,yblock/2,hor,ver, info);
  }
  else{
	if(fmv->mode == INTRABLOCK){
      xblk = (cx+xblock<=hor)?  xblock : hor-cx;
      yblk = (cy+yblock<=ver)?  yblock : ver-cy;
      if(xblk<=0 || yblk<=0){
        return;
	  }
      fmv->meandepth = info.pixeldepth + (tPyrLev+1)/2; 

      //Y
	  m = cy*hor+cx;
      mean = get_mean(&(frame->Y[m]), xblk, yblk, hor);
      fmv->Ymean = quantize_Ymean(mean, fmv->meandepth, &recon_mean);
	  SubtractMean(&(frame->Y[m]), &(high->Y[m]), recon_mean, xblk, yblk, hor);

	  /*if(cx == 0 && cy == 140){
		for(i=cy;i<yblk+cy;i++){
		  for(j=cx;j<xblk+cx;j++){
			printf("%f ",high->Y[i*hor+j]);
		  }
		  printf("\n");
		}
	  getchar();
	  }*/

	  
	  if(info.cwidth && info.cheight){
		if(info.ywidth == 2*info.cwidth && info.yheight == 2*info.cheight){
	      hor /= 2; 
	      cx /= 2;  cy /= 2;
		  xblk /= 2;yblk /= 2;
          if(xblk<=0 || yblk<=0){
            /*printf("xblk<=0 || yblk<=0 in blk2pixel() !\n");*/
            return;
		  }
		}

 
	    switch(info.format){
	    case YUV:
	    case RAS:
	 	  meanshift=128.;
		  break;
	    case DPX:	 
	  	  meanshift=512.;	 
		  break;
		/* IVB 2004/4/7 ---------------- */
        case FLT:
	      meanshift = 0.0; // prediction error is zero mean
	      break;
        /* IVB 2004/4/7 ---- end ------- */
	    default:	
		  printf("image format error format = %d(mctfN.c)\n", info.format);
		  exit(1);
		}
        meanshift *= pow(2, (float)tPyrLev/2.);	  
        m = cy*hor+cx;

		//U
	    mean =  get_mean((frame->U)+m, xblk, yblk, hor);
        mean -= meanshift;
	    fmv->Umean =  quantize_Cmean(mean, fmv->meandepth, &recon_mean);
	    recon_mean +=  meanshift;
	    SubtractMean((frame->U)+m, (high->U)+m, recon_mean, xblk, yblk, hor);
    
		//V
	    mean =  get_mean((frame->V)+m, xblk, yblk, hor);
        mean -= meanshift;
	    fmv->Vmean = quantize_Cmean(mean, fmv->meandepth, &recon_mean);
	    recon_mean += meanshift;
	    SubtractMean((frame->V)+m, (high->V)+m, recon_mean, xblk, yblk, hor);
	  } 
	}
  }
}

/*
 * RemoveMean
 * remove mean values (Y, U, V) from intra blocks
 */
void RemoveMean(YUVimage_ptr frame, YUVimage_ptr high, vector_ptr fmv, int tPyrLev, videoinfo info)
{
  int   x, y, X, Y, yhor, yver, chor, cver;
  int   xnum, ynum, xblock, yblock;
 
  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblock = info.xblk;   yblock = info.yblk;


/*printf("RemoveMeanMean\n"); APR24 */
  for(y=0, Y=0 ; Y<ynum ; y+=yblock, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblock, X++){
      rec_RemoveMean(frame, high, &fmv[Y*xnum+X], tPyrLev, x, y, xblock, yblock, yhor, yver, info);
    }
  }
}

void AddMean(float *high, float *frame, float mean, int xblk, int yblk, int hor)
{
  int x, y, m;

  m=0;
  for(y=0 ; y<yblk ; y++){  
    for(x=0 ; x<xblk ; x++){
      frame[m] = high[m] + mean;
      m++;
	}
	m += hor-xblk;
  }
}

void rec_AddMean(YUVimage_ptr high, YUVimage_ptr frame, vector_ptr fmv, int tPyrLev, int cx, int cy, int xblock, int yblock, int hor, int ver, videoinfo info)
{
  int m;
  int xblk, yblk;
  float meanshift, mean;
  if(fmv->child){
	rec_AddMean(high, frame, fmv->child0, tPyrLev,cx,         cy,         xblock/2,yblock/2,hor,ver, info);
	rec_AddMean(high, frame, fmv->child1, tPyrLev,cx+xblock/2,cy,         xblock/2,yblock/2,hor,ver, info);
	rec_AddMean(high, frame, fmv->child2, tPyrLev,cx,         cy+yblock/2,xblock/2,yblock/2,hor,ver, info);
	rec_AddMean(high, frame, fmv->child3, tPyrLev,cx+xblock/2,cy+yblock/2,xblock/2,yblock/2,hor,ver, info);
  }
  else{
	if(fmv->mode == INTRABLOCK){
      xblk = (cx+xblock<=hor)?  xblock : hor-cx;
      yblk = (cy+yblock<=ver)?  yblock : ver-cy;
      if(xblk<=0 || yblk<=0){
  	    return;
	  }
      //Y
	  mean = fmv->Ymean << BlockShift;
	  m = cy*hor+cx;
      AddMean((high->Y)+m, (frame->Y)+m, mean, xblk, yblk, hor);




	  if(info.cwidth && info.cheight){
		if(info.ywidth == 2*info.cwidth && info.yheight == 2*info.cheight){
	      hor /= 2; 
	      cx /= 2;  cy /= 2;
		  xblk /= 2;yblk /= 2;
          if(xblk<=0 || yblk<=0){
            /*printf("xblk<=0 || yblk<=0 in blk2pixel() !\n");*/
            return;
		  }
		}

	    switch(info.format){
	    case YUV:
	    case RAS:
	 	  meanshift=128.;
		  break;
	    case DPX:	 
	  	  meanshift=512.;	 
		  break;
		/* IVB 2004/4/7 ---------------- */
        case FLT:
	      meanshift = 0.0; // prediction error is zero mean
	      break;
        /* IVB 2004/4/7 ---- end ------- */
	    default:	
		  printf("image format error format = %d(mctfN.c)\n", info.format);
		  exit(1);
		}
        meanshift *= pow(2, (float)tPyrLev/2.);	  
        m = cy*hor+cx;

		//U
		mean = fmv->Umean * pow(2., BlockShift); // Umean could be a negative number
        mean += meanshift;
		AddMean((high->U)+m, (frame->U)+m, mean, xblk, yblk, hor);

		//V
		mean = fmv->Vmean * pow(2., BlockShift);// Vmean could be a negative number
        mean += meanshift;
		AddMean((high->V)+m, (frame->V)+m, mean, xblk, yblk, hor);
	  }
	}
  }
}
void PutbackMean(YUVimage_ptr high, YUVimage_ptr frame, vector_ptr fmv, int tPyrLev, videoinfo info)
{
  int   x, y, X, Y, yhor, yver, chor, cver;
  int   xnum, ynum, xblock, yblock;
 
  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblock = info.xblk;   yblock = info.yblk;

  for(y=0, Y=0 ; Y<ynum ; y+=yblock, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblock, X++){
      rec_AddMean(high, frame, &fmv[Y*xnum+X], tPyrLev, x, y, xblock, yblock, yhor, yver, info);
    }
  }
}

int filter_sqrt2(float *low_ftr, float *high_ftr, int N)
{
  int i;
  float sqrt2;

  sqrt2 = sqrt(2.0);
  for(i = -N; i <=N; i++){
    low_ftr[i] *= sqrt2;
    high_ftr[i] *= sqrt2;
  }
  return(0);
}


/* ---------------------------------------------------------------------- */
/*                             synconc()                                  */
/* ---------------------------------------------------------------------- */
/* IVB 2/25/03

   MC synthesis with MC error concealment, handles variable GOP size
   ADAPTIVE == YES, bi_flag == NO
*/
void synconc(int curr, videoinfo info)
{
  YUVimage dumb, frame;
  int i, j, k, half_len, tPyrLev, dist;
  int yhor, yver, chor, cver;
  unsigned char *ypused, *ypusedtemp, *cpused, *cpusedtemp;  /* flag */
  YUVimage predframe, tempframe, predframe2, *fwdPred, frameH;
  FILE *fppred;
  int size, **syn_done;
  float w1, w2;
  unsigned char **yvalid, **cvalid;
    
  yhor = info.ywidth; yver =  info.yheight;
  chor = info.cwidth; cver =  info.cheight;
  tPyrLev = info.tPyrLev;

  int max_half_len = (int)pow(2.0, (double)(tPyrLev-1));

  syn_done = (int **) getarray(tPyrLev, max_half_len*sizeof(int), "syn_root");
  for (i = 0; i < tPyrLev; i++)
  {
	  syn_done[i] = (int *) getarray(max_half_len, sizeof(int), "syn_done");
	  for (j = 0; j < max_half_len; j++)
		  syn_done[i][j] = 0;
  }

  // 2004/3/17
  //printf("synconc\n");
  frame_alloc(&tempframe, info);
  frame_alloc(&predframe2, info);
  frame_alloc(&frameH, info);
  fwdPred = (YUVimage *)getarray(2*max_half_len, sizeof(YUVimage), "fwdPred");
  //printf("fwdPred array declared... ");
  for (i = 0; i < 2*max_half_len; i++)
  {
	  frame_alloc(&fwdPred[i], info);
  }
  //printf("memory assigned");

  frame_alloc(&dumb, info);
  frame_alloc(&frame, info);

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");

  yvalid = (unsigned char **) getarray(2*max_half_len-1, sizeof(unsigned char *), "yvalid");
  for (i = 0; i < 2*max_half_len-1; i++) // check pixel validity for all but first frame in GOP
  {
	  yvalid[i] = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "yvalid");
  }

  cvalid = (unsigned char **) getarray(2*max_half_len-1, sizeof(unsigned char *), "cvalid");
  for (i = 0; i < 2*max_half_len-1; i++)
  {
	  cvalid[i] = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cvalid");
  }

  /* synthesis */

  //i = tPyrLev - 1; for lowest temporal freq. level
  dist = 1 << (tPyrLev -1);
  half_len = 1;
  
  if(scene_change[tPyrLev-1][1] == NO)
  {
	  
	  //printf("scene_change[%d][1] == NO\n",tPyrLev-1);
	  temporal_synthesis(&pyrTemp[tPyrLev-1][0], &pyrTemp[tPyrLev-1][1], pyrFrs[0],
                     pyrFrs[1], yfmv[1], ypusedtemp, cpusedtemp, tPyrLev-1, 0, info);

	  /* Note: #ifdef part won't execute if there was a scene change (i.e. if left and
	     right halfs of GOP are to be synthesized separately). No sense in testing 
		 scene_change[tPyrLev-1][0] since bi-directional not used here.
	  */
#ifdef INTRA_CODED_BLOCK
	  //printf("INTRA_CODED_BLOCK defined!\n");
	  PutbackMean(&pyrFrs[1], &pyrTemp[tPyrLev-1][0], yfmv[1], tPyrLev, info);
#else
	  //printf("INTRA_CODED_BLOCK not defined!\n");
      for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
	  for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
	  local_temporal_synthesis2(pyrTemp[tPyrLev-1][0], pyrTemp[tPyrLev-1][1], pyrFrs[1], dumb, yfmv[1], 
		ypused, cpused, info, INTRABLOCK);
#endif
	  
	  /* continue up the pyramid until scene change found */
	  //for(i = tPyrLev-2; i >=info.t_level; i--)
	  for(i = tPyrLev-2; i >= 0; i--)
	  {
		  //printf("temporal pyramid level %d\n", i+1);
		  dist = 1 << i;
		  half_len *= 2;

		  for(j = 0; j < half_len && syn_done[i][j] != 1; j++)
		  {
			  if(scene_change[i][j*2+1] == NO )
			  {
				  temporal_synthesis(&pyrTemp[i][2*j], &pyrTemp[i][2*j+1], pyrTemp[i+1][j],
					  pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);

#ifdef INTRA_CODED_BLOCK
			 //printf("INTRA_CODED_BLOCK defined!\n");
		   PutbackMean(&pyrFrs[j+half_len], &pyrTemp[i][2*j], yfmv[j+half_len], i+1, info);
#else			   
		   //printf("INTRA_CODED_BLOCK not defined!\n");
		   for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
		   for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;		
		   local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			 ypused, cpused, info, INTRABLOCK);
#endif
			  }
			  else
			  {
				  // scene change at (i,j) => copy frames
				  copyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], info);
				  //2003/6/24 syn_right(curr, info, i, j, syn_done);
				  syn_right2(curr, info, i, j, syn_done);
				  // load predicted frame and copy it to pyrTemp
				  copypredframe(&pyrTemp[i][2*j], info, i);
				  //copyframe(&pyrFrs[j+half_len], &pyrTemp[i][2*j], info);
				  //2003/6/24 syn_left(curr, info, i, j, syn_done);
				  syn_left2(curr, info, i, j, syn_done);
			  }
			  //printf("j = %d\n", j);
		  } /* j */
	  } /* i */
  }
  else // scene change at (tPyrLev-1,0) => copy frames
  {
	  //printf("scene_change[%d][1] == YES\n",tPyrLev-1);
	  copyframe(&pyrFrs[0], &pyrTemp[tPyrLev - 1][1], info);
	  // 2003/6/24 syn_right(curr, info, tPyrLev-1, 0, syn_done);
	  syn_right2(curr, info, tPyrLev-1, 0, syn_done);
	  // load predicted frame and copy it to pyrTemp
	  copypredframe(&pyrTemp[tPyrLev - 1][0], info, tPyrLev-1);
	  //copyframe(&pyrFrs[1], &pyrTemp[tPyrLev - 1][0], info);
	  // 2003/6/24 syn_left(curr, info, tPyrLev-1, 0, syn_done);
	  syn_left2(curr, info, tPyrLev-1, 0, syn_done);
  } // end of scene_change[tPyrLev-1][1]

if (EC==2)
{
  // 2004/3/17 Forward prediction --------------------------
  copypredframe2(&fwdPred[0], info);   // read prediction from previous GOP

  //printf("First frame read...\n");

  // prediction
  i = 0;
  half_len = (int)pow(2.0, (double)(tPyrLev-1-i));
  for (j = 0; j < half_len; j++)
  {
	// predicting frame at 2*j+1
	/* scale and invert sign of low freq. frame */
	// IVB 2004/3/23 wcopyframe(&fwdPred[2*j], &frame, -(float)sqrt(2.0), info);
	  copyframe(&fwdPred[2*j], &frame, info);

	// IVB 2004/3/23 weighMV(yfmv[j+half_len], -1.0, info);

	//wcopyframe(&pyrFrs[j+half_len], &frameH, -1.0, info);
	//wcopyframe(&pyrFrs[j+half_len], &frameH, 1.0, info);
	//2004/3/20 synthesize frameH as projection of pyrFrs[j+half_len] with yfmv
	syn_new_tH(&frameH, &pyrFrs[j+half_len], i, j, half_len, info); //2004/3/20

	if (j == 0)
	{
		// all pixels assumed valid at the start of GOP
		for (k = 0; k < yhor*yver; k++)   yvalid[j*2][k] = 1;
		for (k = 0; k < chor*cver; k++)   cvalid[j*2][k] = 1;
	}
	else
	{
		// initialize with previous pixel validities to prevent error propagation
		for (k = 0; k < yhor*yver; k++)   yvalid[j*2][k] = yvalid[j*2-1][k];
	    for (k = 0; k < chor*cver; k++)   cvalid[j*2][k] = cvalid[j*2-1][k];
	}

	/*for (k = 0; k < 10; k++)
	{
		printf("yvalid[%d][%d] = %d\n",j*2,k,yvalid[j*2][k]);
	}*/
		
	if(scene_change[i][j*2+1] == NO )
	{
		//printf("scene_change[%d][%d] == NO\n",i,j*2+1);
		//temporal_synthesis(&predframe2, &tempframe, frame,
		//	pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
		//temporal_synthesis(&predframe2, &tempframe, frame,
		//	frameH, yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
		// IVB 2004/3/23 temporal_synthesis_IVB(&predframe2, &tempframe, frame,
			//frameH, yfmv[j+half_len], yvalid[j*2], cvalid[j*2], i, j, info);
		temporal_synthesis_IVB(&frame, &predframe2, tempframe,
			frameH, yfmv[j+half_len], yvalid[j*2], cvalid[j*2], i, j, info);
	
#ifdef INTRA_CODED_BLOCK		   
		    //PutbackMean(&pyrFrs[j+half_len], &predframe2, yfmv[j+half_len], i+1, info);
		    // IVB 2004/3/23 PutbackMean(&frameH, &predframe2, yfmv[j+half_len], i+1, info);
#else			   
		    //for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
			//for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			//local_temporal_synthesis2(predframe2, tempframe, pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			//	ypused, cpused, info, INTRABLOCK);
			//local_temporal_synthesis2(predframe2, tempframe, frameH, dumb, yfmv[j+half_len],
			//	ypused, cpused, info, INTRABLOCK);
			// IVB 2004/3/23 local_temporal_synthesis_IVB(predframe2, tempframe, frameH, dumb, yfmv[j+half_len],
				// yvalid[j*2], cvalid[j*2], info, INTRABLOCK);
#endif
	}
	else
	{
		//printf("scene_change[%d][%d] == YES\n",i,j*2+1);
		//copyframe(&pyrFrs[j+half_len], &predframe2, info);
		// reverse the sign, since it will be reversed again when writing to file
		//wcopyframe(&pyrFrs[j+half_len], &predframe2, -1.0, info);
		// IVB 2004/3/23 wcopyframe(&frameH, &predframe2, -1.0, info);
		wcopyframe(&fwdPred[2*j], &predframe2, Infinity , info);
	}
	// IVB 2004/3/23 wcopyframe(&predframe2, &fwdPred[2*j+1], -1.0, info);
	copyframe(&predframe2, &fwdPred[2*j+1], info);
	//printf("frame %d copied\n",2*j+1);

	/*for (k = 0; k < 10; k++)
	{
		printf("yvalid[%d][%d] = %d\n",j*2,k,yvalid[j*2][k]);
	}*/

	
	if (j < half_len-1)
	{
		// predicting frame at 2*j+2
	    /* scale and invert sign of low freq. frame */
	    // IVB 2004/3/23 wcopyframe(&fwdPred[2*j+1], &frame, -(float)sqrt(2.0), info);
		copyframe(&fwdPred[2*j+1], &frame, info);

		//2004/3/20 synthesize frameH as projection of pyrFrs[j+half_len] with yfmv
		copyframe(&frameH, &predframe2, info);
		syn_new_tH(&frameH, &predframe2, i, j, half_len, info); //2004/3/20
		
		// initialize with previous pixel validities to prevent error propagation
		for (k = 0; k < yhor*yver; k++)
		{
			yvalid[j*2+1][k] = yvalid[j*2][k];
			//if (k < 10) printf("yvalid[%d][%d] = %d, yvalid[%d][%d] = %d\n",j*2,k,yvalid[j*2][k],j*2+1,k,yvalid[j*2+1][k]);
		}
	    for (k = 0; k < chor*cver; k++)   cvalid[j*2+1][k] = cvalid[j*2][k];

	    if(scene_change[i][j*2+1] == NO )
		{
		    //printf("scene_change[%d][%d] == NO\n",i,j*2+1);
		    //temporal_synthesis(&predframe2, &tempframe, frame,
			//    pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
			// IVB 2004/3/23 temporal_synthesis_IVB(&predframe2, &tempframe, frame,
			    //frameH, yfmv[j+half_len], yvalid[j*2+1], cvalid[j*2+1], i, j, info);
			temporal_synthesis_IVB(&frame, &predframe2, tempframe,
			    frameH, yfmv[j+half_len], yvalid[j*2+1], cvalid[j*2+1], i, j, info);
	
#ifdef INTRA_CODED_BLOCK		   
		    //PutbackMean(&pyrFrs[j+half_len], &predframe2, yfmv[j+half_len], i+1, info);
			// IVB 2004/3/23 PutbackMean(&frameH, &predframe2, yfmv[j+half_len], i+1, info);
#else			   
		    //for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
			//for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			//local_temporal_synthesis2(predframe2, tempframe, pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			//	ypused, cpused, info, INTRABLOCK);
			// IVB 2004/3/23 local_temporal_synthesis_IVB(predframe2, tempframe, frameH, dumb, yfmv[j+half_len],
				//yvalid[j*2+1], cvalid[j*2+1], info, INTRABLOCK);
#endif
		}
	    else
		{
		    //printf("scene_change[%d][%d] == YES\n",i,j*2+1);
		    // reverse the sign, since it will be reversed again when writing to file
		    //wcopyframe(&pyrFrs[j+half_len], &predframe2, -1.0, info);
			//wcopyframe(&pyrTemp[i+1][j], &predframe2, -1.0, info); // this is already done in backward prediction, so no gain doing this
			//wcopyframe(&fwdPred[2*j+1], &predframe2, -1.0, info);
			// IVB 2004/3/23 wcopyframe(&frameH, &predframe2, -1.0, info);
			wcopyframe(&fwdPred[2*j], &predframe2, Infinity , info);
		}
		// IVB 2004/3/23 wcopyframe(&predframe2, &fwdPred[2*j+2], -1.0, info);
		copyframe(&predframe2, &fwdPred[2*j+2], info);
		//printf("frame %d copied\n",2*j+2);

		/*for (k = 0; k < 10; k++)
		{
			printf("yvalid[%d][%d] = %d, yvalid[%d][%d] = %d\n",j*2,k,yvalid[j*2][k],j*2+1,k,yvalid[j*2+1][k]);
		}*/

	} // j < half_len-1

	// IVB 2004/3/23 weighMV(yfmv[j+half_len], -1.0, info);

  } // j

  
  // blending with backward prediction
  copyframe(&fwdPred[0], &pyrTemp[0][0], info); // first frame simply copied from prediction (from previous GOP)
  for (j = 1; j < 2*max_half_len; j++)
  {
	  
	  /*for (k = 0; k < yhor*yver; k++)
	  if (yvalid[j][k]==1)
		  printf("yvalid[%d][%d] = 1\n", j, k); */

	  // blend fwdPred[j] and pyrTemp[0][j], store result in pyrTemp[0][j]
	  //void blendframes(YUVimage *source1, YUVimage *source2, float weight1, float weight2, YUVimage *dest, videoinfo info)
	  w1 = (float)(2*max_half_len-1-j)/(float)(2*max_half_len-1);
	  w2 = (float)(j)/(float)(2*max_half_len-1);
	  //printf("blending frames: w1 = %6.4f, w2 = %6.4f\n",w1,w2);
	  //w1 = 1.0; w2 = 1.0 - w1;
	  //w1 = 0.0; w2 = 1.0 - w1;
	  //blendframes(&fwdPred[j], &pyrTemp[0][j], w1, w2, &predframe2, info); // blend fwdPred[j] and pyrTemp[0][j] into predframe2
	  blendframes2(&fwdPred[j], &pyrTemp[0][j], w1, w2, yvalid[j-1], cvalid[j-1], &predframe2, info); // blend using pixel validity maps for fwd-predicted frames
	  copyframe(&predframe2, &pyrTemp[0][j], info); // copy the blended frame into pyrTemp[0][j]
  }

  // 2004/3/17 End Forward prediction ----------------------
} // EC==2 - bidirectional prediction

  free_frame_interior(tempframe);
  free_frame_interior(predframe2);
  free_frame_interior(frameH);



if (PREDICTION) 
{
	printf("about to allocate memory for predframe(s)... ");
	frame_alloc(&predframe, info);
	frame_alloc(&tempframe, info);
	frame_alloc(&predframe2, info);
	frame_alloc(&frameH, info);
	printf("done\n");

if (PREDICTION == 1 )
{
	/* 1 = "replacement" */

	printf("copying frame... ");
	copyframe(&pyrTemp[0][0], &predframe, info);
	i = 0;
	half_len = (int)pow(2.0, (double)(tPyrLev-1-i));
	j = half_len-1;
	wcopyframe(&pyrTemp[i][j+half_len], &predframe2, -1.0, info); // change sign
	printf("done\n");
}
else
{
	/* 2 = "prediction" */

	//printf("synconc: prediction = 2\n");

	/* scale frame */
	wcopyframe(&pyrTemp[0][0], &frame, (float)sqrt(2.0), info);

	//printf("synconc: frame wcopied\n");

	i = 0; j = 0;
	half_len = (int)pow(2.0, (double)(tPyrLev-1-i));

	if(scene_change[0][1] == NO )
	{
		//printf("scene_change[0][1] == NO\n");
		temporal_synthesis(&predframe, &tempframe, frame,
			pyrFrs[half_len], yfmv[half_len], ypusedtemp, cpusedtemp, 0, 0, info);

#ifdef INTRA_CODED_BLOCK		   
		    PutbackMean(&pyrFrs[half_len], &predframe, yfmv[half_len], 1, info);
#else			   
		    for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
			for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			local_temporal_synthesis2(predframe, tempframe, pyrFrs[half_len], dumb, yfmv[half_len],
				ypused, cpused, info, INTRABLOCK);
#endif
	}
	else
	{
		//printf("scene_change[0][1] == YES\n");
		copyframe(&pyrFrs[half_len], &predframe, info);
	}

	// --------------- predicting frame from the other side of GOP ---------------
    i = 0;
	half_len = (int)pow(2.0, (double)(tPyrLev-1-i));
	j = half_len-1;

	/* scale and invert sign of low freq. frame */
	wcopyframe(&pyrTemp[i][j+half_len], &frame, -(float)sqrt(2.0), info);
	//wcopyframe(&pyrTemp[i][j+half_len], &frame, (float)sqrt(2.0), info);

	weighMV(yfmv[j+half_len], -1.0, info);

	//wcopyframe(&pyrFrs[j+half_len], &frameH, -1.0, info);
	//wcopyframe(&pyrFrs[j+half_len], &frameH, 1.0, info);
	//2004/3/20 synthesize frameH as projection of pyrFrs[j+half_len] with yfmv
	syn_new_tH(&frameH, &pyrFrs[j+half_len], i, j, half_len, info); //2004/3/20

	if(scene_change[i][j*2+1] == NO )
	{
		//printf("scene_change[%d][%d] == NO\n",i,j*2+1);
		//temporal_synthesis(&predframe2, &tempframe, frame,
		//	pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
		temporal_synthesis(&predframe2, &tempframe, frame,
			frameH, yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
	
#ifdef INTRA_CODED_BLOCK		   
		    //PutbackMean(&pyrFrs[j+half_len], &predframe2, yfmv[j+half_len], i+1, info);
		    PutbackMean(&frameH, &predframe2, yfmv[j+half_len], i+1, info);
#else			   
		    for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
			for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			//local_temporal_synthesis2(predframe2, tempframe, pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			//	ypused, cpused, info, INTRABLOCK);
			local_temporal_synthesis2(predframe2, tempframe, frameH, dumb, yfmv[j+half_len],
				ypused, cpused, info, INTRABLOCK);
#endif
	}
	else
	{
		//printf("scene_change[%d][%d] == YES\n",i,j*2+1);
		//copyframe(&pyrFrs[j+half_len], &predframe2, info);
		// reverse the sign, since it will be reversed again when writing to file
		wcopyframe(&pyrFrs[j+half_len], &predframe2, -1.0, info);
		//copyframe(&frameH, &predframe2, info);
	}

	weighMV(yfmv[j+half_len], -1.0, info);

	// ------------- end predicting frame from the other side of GOP -------------

} /* PREDICTION = 2 */
	
	/* open file for predicted frame */
	if (!(fppred = fopen("PredFrame","wb")))
	{
		printf("synscheme3() in syn.c : cannot open PredFrame\n");
		exit(1);
	}

	/* scale and write */

	wcopyframe(&predframe, &tempframe, (float)pow(2.0, (float)tPyrLev/2.0), info);

	size = yhor*yver;
	if (fwrite(tempframe.Y, sizeof(float), size, fppred) != (unsigned)size)
	{
		printf("synscheme3() in syn.c : cannot write tempframe.Y\n");
		exit(1);
	}
	
	size = chor*cver;
	if (size)
	{
		if (fwrite(tempframe.U, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.U\n");
			exit(1);
		}
		if (fwrite(tempframe.V, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.V\n");
			exit(1);
		}
	}
	fclose(fppred);

	/* open file for predicted frame from other side of GOP */
	if (!(fppred = fopen("PredFrame2","wb")))
	{
		printf("synscheme3() in syn.c : cannot open PredFrame2\n");
		exit(1);
	}

	/* scale and write */

	// no need to scale this frame, since predicting original frames (pyramid level 0)
	// only invert sign
	wcopyframe(&predframe2, &tempframe, -1.0, info);
	//copyframe(&predframe2, &tempframe, info);

	size = yhor*yver;
	if (fwrite(tempframe.Y, sizeof(float), size, fppred) != (unsigned)size)
	{
		printf("synscheme3() in syn.c : cannot write tempframe.Y\n");
		exit(1);
	}
	
	size = chor*cver;
	if (size)
	{
		if (fwrite(tempframe.U, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.U\n");
			exit(1);
		}
		if (fwrite(tempframe.V, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.V\n");
			exit(1);
		}
	}
	fclose(fppred);

	free_frame_interior(predframe);
    free_frame_interior(tempframe);
	free_frame_interior(predframe2);
	free_frame_interior(frameH);

} /* if (PREDICTION) */



  /* clear memory */
  for (i = 0; i < tPyrLev; i++)
	  free(syn_done[i]);
  free(syn_done);
  free(ypused);
  free(ypusedtemp);
  free(cpused);
  free(cpusedtemp);

  for (i = 0; i < 2*max_half_len-1; i++)
  {
	  free(yvalid[i]);
	  free(cvalid[i]);
  }
  free(yvalid);  free(cvalid);

  for (i = 0; i < 2*max_half_len; i++)
	  free_frame_interior(fwdPred[i]);
  free(fwdPred);

  free_frame_interior(dumb);
  free_frame_interior(frame);
}

/* ---------------------------------------------------------------------- */
/*                             syn_right()                                */
/* ---------------------------------------------------------------------- */
/* IVB 4/10/03

   MC synthesis of the right half of (sub)GOP 
*/
void syn_right(int curr, videoinfo info, int ii, int jj, int **syn_done)
{
  YUVimage dumb, frame;
  int i, j, k, half_len, tPyrLev, dist;
  int yhor, yver, chor, cver;
  unsigned char *ypused, *ypusedtemp, *cpused, *cpusedtemp;  /* flag */
  YUVimage predframe, tempframe;
  FILE *fppred;
  int size, minj, maxj;
  
  yhor = info.ywidth; yver =  info.yheight;
  chor = info.cwidth; cver =  info.cheight;
  tPyrLev = info.tPyrLev;

  frame_alloc(&dumb, info);
  frame_alloc(&frame, info);

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");

  syn_done[ii][jj] = 1;
  printf("syn_right(): ii = %d, jj = %d\n",ii, jj);

  /* synthesis */

  //for(i = ii-1; i >=info.t_level; i--)
  for(i = ii-1; i >= 0; i--)
  {

     printf("syn_right(): temporal pyramid level %d\n", i+1);
	 dist = 1 << i;
	 half_len = (int)pow(2.0, (double)(tPyrLev-1-i));

	 // range of j's for right sub-tree rooted in (ii,jj)
	 if (i == ii-1)
	 {
		 minj = 2*jj+1; // right half
	 }
	 else
	 {
		 minj *= 2;
	 }

	 maxj = minj + (int)half_len/2;
	 
	 for(j = minj; j < maxj && syn_done[i][j] != 1; j++)
	 {
		 printf("syn_right(): i = %d, j = %d, maxj = %d\n", i, j, maxj);
		 syn_done[i][j] = 1;
		 if(scene_change[i][j*2+1] == NO )
		 {
			 printf("syn_right(): scene_change[%d][%d] = NO\n", i, j*2+1);
			 temporal_synthesis(&pyrTemp[i][2*j], &pyrTemp[i][2*j+1], pyrTemp[i+1][j],
				 pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);

#ifdef INTRA_CODED_BLOCK
			 //printf("INTRA_CODED_BLOCK defined!\n");
		   PutbackMean(&pyrFrs[j+half_len], &pyrTemp[i][2*j], yfmv[j+half_len], i+1, info);
#else			   
		   //printf("INTRA_CODED_BLOCK not defined!\n");
		   for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
		   for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;		
		   local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			 ypused, cpused, info, INTRABLOCK);
#endif
		 }
		 else
		 {
			 printf("syn_right(): scene_change[%d][%d] = YES\n", i, j*2+1);
			 // scene change at (i,j) => copy frames
			 if (i < ii-1)
			 {
				 printf("syn_right(): about to copyframe\n");
				 copyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], info);
			 }
			 else
			 {
				 printf("syn_right(): about to wcopyframe\n");
				 wcopyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], (float)(1.0/sqrt(2.0)), info);
			 }

			 syn_right(curr, info, i, j, syn_done);
			 // load predicted frame and copy it to pyrTemp
			 copypredframe(&pyrTemp[i][2*j],info,i);
			 syn_left(curr, info, i, j, syn_done);
		 }
	  //printf("j = %d\n", j);
	 } /* j */
  } /* i */

  j = minj; 
  //i = info.t_level;
  i = 0;

if (PREDICTION)
{
	printf("syn_right(): about to allocate memory for predframe... ");
	frame_alloc(&predframe, info);
	frame_alloc(&tempframe, info);
	printf("done\n");

if (PREDICTION == 1 )
{
	/* 1 = "replacement" */

	printf("syn_right(): copying frame pyrTemp[%d][%d]... ",i,2*j);
	copyframe(&pyrTemp[i][2*j], &predframe, info);
	printf("done\n");
}
else
{
	/* 2 = "prediction" */

	/* scale frame */
	wcopyframe(&pyrTemp[i][2*j], &frame, (float)sqrt(2.0), info);

	if(scene_change[i][2*j+1] == NO )
	{
		//printf("scene_change[i][2*j+1] == NO\n");
		temporal_synthesis(&predframe, &tempframe, frame,
			pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);

#ifdef INTRA_CODED_BLOCK		   
		    PutbackMean(&pyrFrs[j+half_len], &predframe, yfmv[j+half_len], i+1, info);
#else			   
		    for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
			for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			local_temporal_synthesis2(predframe, tempframe, pyrFrs[j+half_len], dumb, yfmv[j+half_len],
				ypused, cpused, info, INTRABLOCK);
#endif
	}
	else
	{
		//printf("scene_change[i][2*j+1] == YES\n");
		copyframe(&pyrFrs[j+half_len], &predframe, info);
	}
} /* PREDICTION = 2 */
	
	/* open file for predicted frame */
	if (!(fppred = fopen("PredFrame","wb")))
	{
		printf("synscheme3() in syn.c : cannot open PredFrame\n");
		exit(1);
	}

	/* scale and write */
	
	// predframe now has scaling for the full framerate 
	wcopyframe(&predframe, &tempframe, (float)pow(2.0, (float)tPyrLev/2.0), info);
	// now tempframe is scaled for the lowest framerate, as in synscheme3() and synconc()

	size = yhor*yver;
	if (fwrite(tempframe.Y, sizeof(float), size, fppred) != (unsigned)size)
	{
		printf("synscheme3() in syn.c : cannot write tempframe.Y\n");
		exit(1);
	}
	
	size = chor*cver;
	if (size)
	{
		if (fwrite(tempframe.U, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.U\n");
			exit(1);
		}
		if (fwrite(tempframe.V, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.V\n");
			exit(1);
		}
	}

	fclose(fppred);
	free_frame_interior(predframe);
    free_frame_interior(tempframe);

} /* if (PREDICTION) */


  /* clear memory */
  free(ypused);
  free(ypusedtemp);
  free(cpused);
  free(cpusedtemp);

  free_frame_interior(dumb);
  free_frame_interior(frame);
  printf("syn_right: i = %d, j = %d done\n",ii,jj);
}


void syn_right2(int curr, videoinfo info, int ii, int jj, int **syn_done)
{
  YUVimage dumb, frame;
  int i, j, k, half_len, tPyrLev, dist;
  int yhor, yver, chor, cver;
  unsigned char *ypused, *ypusedtemp, *cpused, *cpusedtemp;  /* flag */
  YUVimage predframe, tempframe;
  FILE *fppred;
  int size, minj, maxj;
  
  yhor = info.ywidth; yver =  info.yheight;
  chor = info.cwidth; cver =  info.cheight;
  tPyrLev = info.tPyrLev;

  frame_alloc(&dumb, info);
  frame_alloc(&frame, info);

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");

  syn_done[ii][jj] = 1;
  //printf("syn_right2(): ii = %d, jj = %d\n",ii, jj);

  /* synthesis */

  i = ii-1;
  j = 2*jj+1;

 	 dist = 1 << i;
	 half_len = (int)pow(2.0, (double)(tPyrLev-1-i));

	 if (i < 0  ||  j >= half_len)
	 {
		 return;
	 }


		 syn_done[i][j] = 1;
		 if(scene_change[i][j*2+1] == NO )
		 {
			 //printf("syn_right2(): scene_change[%d][%d] = NO\n", i, j*2+1);
			 temporal_synthesis(&pyrTemp[i][2*j], &pyrTemp[i][2*j+1], pyrTemp[i+1][j],
				 pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);

#ifdef INTRA_CODED_BLOCK
			 //printf("INTRA_CODED_BLOCK defined!\n");
		   PutbackMean(&pyrFrs[j+half_len], &pyrTemp[i][2*j], yfmv[j+half_len], i+1, info);
#else			   
		   //printf("INTRA_CODED_BLOCK not defined!\n");
		   for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
		   for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;		
		   local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			 ypused, cpused, info, INTRABLOCK);
#endif
		   syn_right2(curr, info, i, j, syn_done);
		   syn_left2(curr, info, i, j, syn_done);
		 }
		 else
		 {
			 //printf("syn_right2(): scene_change[%d][%d] = YES\n", i, j*2+1);
			 // scene change at (i,j) => copy frames
			 
			 //printf("syn_right2(): about to wcopyframe\n");
			 wcopyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], (float)(1.0/sqrt(2.0)), info);

			 syn_right2(curr, info, i, j, syn_done);
			 // load predicted frame and copy it to pyrTemp
			 copypredframe(&pyrTemp[i][2*j],info,i);
			 syn_left2(curr, info, i, j, syn_done);
		 }


if (PREDICTION && i == 0)
{
	//printf("syn_right2(): about to allocate memory for predframe... ");
	frame_alloc(&predframe, info);
	frame_alloc(&tempframe, info);
	//printf("done\n");

if (PREDICTION == 1 )
{
	/* 1 = "replacement" */

	//printf("syn_right2(): copying frame pyrTemp[%d][%d]... ",i,2*j);
	copyframe(&pyrTemp[i][2*j], &predframe, info);
	//printf("done\n");
}
else
{
	/* 2 = "prediction" */

	/* scale frame */
	wcopyframe(&pyrTemp[i][2*j], &frame, (float)sqrt(2.0), info);

	if(scene_change[i][2*j+1] == NO )
	{
		//printf("scene_change[i][2*j+1] == NO\n");
		temporal_synthesis(&predframe, &tempframe, frame,
			pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);

#ifdef INTRA_CODED_BLOCK		   
		    PutbackMean(&pyrFrs[j+half_len], &predframe, yfmv[j+half_len], i+1, info);
#else			   
		    for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
			for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			local_temporal_synthesis2(predframe, tempframe, pyrFrs[j+half_len], dumb, yfmv[j+half_len],
				ypused, cpused, info, INTRABLOCK);
#endif
	}
	else
	{
		//printf("scene_change[i][2*j+1] == YES\n");
		// 2003/6/24 copyframe(&pyrFrs[j+half_len], &predframe, info);
		copyframe(&pyrTemp[i][2*j], &predframe, info);
	}
} /* PREDICTION = 2 */
	
	/* open file for predicted frame */
	if (!(fppred = fopen("PredFrame","wb")))
	{
		printf("synscheme3() in syn.c : cannot open PredFrame\n");
		exit(1);
	}

	/* scale and write */
	
	// predframe now has scaling for the full framerate 
	wcopyframe(&predframe, &tempframe, (float)pow(2.0, (float)tPyrLev/2.0), info);
	// now tempframe is scaled for the lowest framerate, as in synscheme3() and synconc()

	size = yhor*yver;
	if (fwrite(tempframe.Y, sizeof(float), size, fppred) != (unsigned)size)
	{
		printf("synscheme3() in syn.c : cannot write tempframe.Y\n");
		exit(1);
	}
	
	size = chor*cver;
	if (size)
	{
		if (fwrite(tempframe.U, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.U\n");
			exit(1);
		}
		if (fwrite(tempframe.V, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.V\n");
			exit(1);
		}
	}

	fclose(fppred);
	free_frame_interior(predframe);
    free_frame_interior(tempframe);

} /* if (PREDICTION) */


  /* clear memory */
  free(ypused);
  free(ypusedtemp);
  free(cpused);
  free(cpusedtemp);

  free_frame_interior(dumb);
  free_frame_interior(frame);
  //printf("syn_right2(): ii = %d, jj = %d done\n",ii,jj);
}




/* ---------------------------------------------------------------------- */
/*                             syn_left()                                 */
/* ---------------------------------------------------------------------- */
/* IVB 4/10/03

   MC synthesis of the left half of (sub)GOP 
*/
void syn_left(int curr, videoinfo info, int ii, int jj, int **syn_done)
{
  YUVimage dumb, frame;
  int i, j, k, half_len, tPyrLev, dist;
  int yhor, yver, chor, cver;
  unsigned char *ypused, *ypusedtemp, *cpused, *cpusedtemp;  /* flag */
  int minj, maxj;
  
  yhor = info.ywidth; yver =  info.yheight;
  chor = info.cwidth; cver =  info.cheight;
  tPyrLev = info.tPyrLev;

  frame_alloc(&dumb, info);
  frame_alloc(&frame, info);

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");

  syn_done[ii][jj] = 1;
  printf("syn_left(): ii = %d, jj = %d\n",ii, jj);

  /* synthesis */

  //for(i = ii-1; i >=info.t_level; i--)
  for(i = ii-1; i >= 0; i--)
  {

     printf("syn_left(): temporal pyramid level %d\n", i+1);
	 dist = 1 << i;
	 half_len = (int)pow(2.0, (double)(tPyrLev-1-i));

	 // range of j's for left sub-tree rooted in (ii,jj)
	 if (i == ii-1)
	 {
		 minj = 2*jj; // right half
	 }
	 else
	 {
		 minj *= 2;
	 }

	 maxj = minj + (int)half_len/2;
	 
	 for(j = minj; j < maxj && syn_done[i][j] != 1; j++)
	 {
		 syn_done[i][j] = 1;
		 if(scene_change[i][j*2+1] == NO )
		 {
			 temporal_synthesis(&pyrTemp[i][2*j], &pyrTemp[i][2*j+1], pyrTemp[i+1][j],
				 pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);

#ifdef INTRA_CODED_BLOCK
			 //printf("INTRA_CODED_BLOCK defined!\n");
		   PutbackMean(&pyrFrs[j+half_len], &pyrTemp[i][2*j], yfmv[j+half_len], i+1, info);
#else			   
		   //printf("INTRA_CODED_BLOCK not defined!\n");
		   for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
		   for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;		
		   local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			 ypused, cpused, info, INTRABLOCK);
#endif
		 }
		 else
		 {
			 // scene change at (i,j) => copy frames
			 if (i < ii-1)
				 copyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], info);
			 else
				 wcopyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], (float)(1.0/sqrt(2.0)), info);

			 syn_right(curr, info, i, j, syn_done);
			 // load predicted frame and copy it to pyrTemp
			 copypredframe(&pyrTemp[i][2*j],info,i);
			 syn_left(curr, info, i, j, syn_done);
		 }
	  //printf("j = %d\n", j);
	 } /* j */
  } /* i */


  /* clear memory */
  free(ypused);
  free(ypusedtemp);
  free(cpused);
  free(cpusedtemp);

  free_frame_interior(dumb);
  free_frame_interior(frame);
  printf("syn_left: i = %d, j = %d done\n",ii,jj);
}


void syn_left2(int curr, videoinfo info, int ii, int jj, int **syn_done)
{
  YUVimage dumb, frame;
  int i, j, k, half_len, tPyrLev, dist;
  int yhor, yver, chor, cver;
  unsigned char *ypused, *ypusedtemp, *cpused, *cpusedtemp;  /* flag */
  int minj, maxj, size;
  YUVimage predframe, tempframe;
  FILE *fppred;
  
  yhor = info.ywidth; yver =  info.yheight;
  chor = info.cwidth; cver =  info.cheight;
  tPyrLev = info.tPyrLev;

  frame_alloc(&dumb, info);
  frame_alloc(&frame, info);

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");

  syn_done[ii][jj] = 1;
  //printf("syn_left2(): ii = %d, jj = %d\n",ii, jj);

  /* synthesis */

  i = ii-1;
  j = 2*jj;

	 dist = 1 << i;
	 half_len = (int)pow(2.0, (double)(tPyrLev-1-i));

	 if (i < 0  ||  j >= half_len)
	 {
		 return;
	 }

		 syn_done[i][j] = 1;
		 if(scene_change[i][j*2+1] == NO )
		 {
			 //printf("syn_left2(): scene_change[%d][%d] = NO\n", i, j*2+1);
			 temporal_synthesis(&pyrTemp[i][2*j], &pyrTemp[i][2*j+1], pyrTemp[i+1][j],
				 pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);

#ifdef INTRA_CODED_BLOCK
			 //printf("INTRA_CODED_BLOCK defined!\n");
		   PutbackMean(&pyrFrs[j+half_len], &pyrTemp[i][2*j], yfmv[j+half_len], i+1, info);
#else			   
		   //printf("INTRA_CODED_BLOCK not defined!\n");
		   for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
		   for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;		
		   local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			 ypused, cpused, info, INTRABLOCK);
#endif
		   syn_right2(curr, info, i, j, syn_done);
		   syn_left2(curr, info, i, j, syn_done);
		 }
		 else
		 {
			 //printf("syn_left2(): scene_change[%d][%d] = YES\n", i, j*2+1);
			 // scene change at (i,j) => copy frames
			 wcopyframe(&pyrTemp[i+1][j], &pyrTemp[i][2*j+1], (float)(1.0/sqrt(2.0)), info);

			 syn_right2(curr, info, i, j, syn_done);
			 // load predicted frame and copy it to pyrTemp
			 copypredframe(&pyrTemp[i][2*j],info,i);
			 syn_left2(curr, info, i, j, syn_done);
		 }


 if (PREDICTION && i == 0)
{
	//printf("syn_left2(): about to allocate memory for predframe... ");
	frame_alloc(&predframe, info);
	frame_alloc(&tempframe, info);
	//printf("done\n");

if (PREDICTION == 1 )
{
	/* 1 = "replacement" */

	//printf("syn_left2(): copying frame pyrTemp[%d][%d]... ",i,2*j);
	copyframe(&pyrTemp[i][2*j], &predframe, info);
	//printf("done\n");
}
else
{
	/* 2 = "prediction" */

	/* scale frame */
	wcopyframe(&pyrTemp[i][2*j], &frame, (float)sqrt(2.0), info);

	if(scene_change[i][2*j+1] == NO )
	{
		//printf("scene_change[i][2*j+1] == NO\n");
		temporal_synthesis(&predframe, &tempframe, frame,
			pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);

#ifdef INTRA_CODED_BLOCK		   
		    PutbackMean(&pyrFrs[j+half_len], &predframe, yfmv[j+half_len], i+1, info);
#else			   
		    for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
			for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			local_temporal_synthesis2(predframe, tempframe, pyrFrs[j+half_len], dumb, yfmv[j+half_len],
				ypused, cpused, info, INTRABLOCK);
#endif
	}
	else
	{
		//printf("scene_change[i][2*j+1] == YES\n");
		//2003/6/24 copyframe(&pyrFrs[j+half_len], &predframe, info);
		copyframe(&pyrTemp[i][2*j], &predframe, info);
	}
} /* PREDICTION = 2 */
	
	/* open file for predicted frame */
	if (!(fppred = fopen("PredFrame","wb")))
	{
		printf("synscheme3() in syn.c : cannot open PredFrame\n");
		exit(1);
	}

	/* scale and write */
	
	// predframe now has scaling for the full framerate 
	wcopyframe(&predframe, &tempframe, (float)pow(2.0, (float)tPyrLev/2.0), info);
	// now tempframe is scaled for the lowest framerate, as in synscheme3() and synconc()

	size = yhor*yver;
	if (fwrite(tempframe.Y, sizeof(float), size, fppred) != (unsigned)size)
	{
		printf("synscheme3() in syn.c : cannot write tempframe.Y\n");
		exit(1);
	}
	
	size = chor*cver;
	if (size)
	{
		if (fwrite(tempframe.U, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.U\n");
			exit(1);
		}
		if (fwrite(tempframe.V, sizeof(float), size, fppred) != (unsigned)size)
		{
			printf("synscheme3() in syn.c : cannot write tempframe.V\n");
			exit(1);
		}
	}

	fclose(fppred);
	free_frame_interior(predframe);
    free_frame_interior(tempframe);

} /* if (PREDICTION) */

		 
  /* clear memory */
  free(ypused);
  free(ypusedtemp);
  free(cpused);
  free(cpusedtemp);

  free_frame_interior(dumb);
  free_frame_interior(frame);
  //printf("syn_left2(): ii = %d, jj = %d done\n",ii,jj);
}




/* ---------------------------------------------------------------------- */
/*                             copypredframe()                            */
/* ---------------------------------------------------------------------- */
/* IVB 4/12/03

   Open file 'PredFrame', read predicted frame and copy to destination 
*/
void copypredframe(YUVimage *destframe, videoinfo info, int i)
{
  FILE *fppred;
  YUVimage predframe;
  int size;

  frame_alloc(&predframe, info);

  /* open file for predicted frame */
  if(!(fppred = fopen("PredFrame","rb")))
  {
 	printf("copypredframe() in syn.c : cannot open PredFrame\n");
	exit(1);
  }

  size = (info.ywidth)*(info.yheight);
  if(fread(predframe.Y, sizeof(float), size, fppred) != (unsigned)size)
  {
	  printf("copypredframe() in syn.c : cannot read predframe.Y\n"); exit(1);
  }

  size = (info.cwidth)*(info.cheight);
  if(size)
  {
	  if(fread(predframe.U, sizeof(float), size, fppred) != (unsigned)size)
	  {
		  printf("copypredframe() in syn.c : cannot read predframe.U\n"); exit(1);
	  }
	  if(fread(predframe.V, sizeof(float), size, fppred) != (unsigned)size)
	  {
		  printf("copypredframe() in syn.c : cannot read predframe.V\n"); exit(1);
	  }
  }

  //copyframe(&predframe, destframe, info); IVB 4/13/03
  // scaling by info.tPyrLev-i gives correct scale on lowest temp. freq. level
  //printf("copypredframe(): scaling n = %d\n",info.tPyrLev-i);
  wcopyframe(&predframe, destframe, (float)pow(2.0, -(double)(info.tPyrLev-i)/2.0), info);

  /* close file and clear memory */
  fclose(fppred);
  free_frame_interior(predframe);
}
/* ---------------------------------------------------------------------- */
/*                             copypredframe2()                           */
/* ---------------------------------------------------------------------- */
/* IVB 2004/3/17

   Open file 'PredFrame2', read predicted frame and copy to destination 
*/
void copypredframe2(YUVimage *destframe, videoinfo info)
{
  FILE *fppred;
  YUVimage predframe;
  int size;

  frame_alloc(&predframe, info);

  /* open file for predicted frame */
  if(!(fppred = fopen("PredFrame2","rb")))
  {
 	printf("copypredframe2() in syn.c : cannot open PredFrame2\n");
	exit(1);
  }

  size = (info.ywidth)*(info.yheight);
  if(fread(predframe.Y, sizeof(float), size, fppred) != (unsigned)size)
  {
	  printf("copypredframe2() in mctfN.c : cannot read predframe.Y\n"); exit(1);
  }

  size = (info.cwidth)*(info.cheight);
  if(size)
  {
	  if(fread(predframe.U, sizeof(float), size, fppred) != (unsigned)size)
	  {
		  printf("copypredframe2() in mctfN.c : cannot read predframe.U\n"); exit(1);
	  }
	  if(fread(predframe.V, sizeof(float), size, fppred) != (unsigned)size)
	  {
		  printf("copypredframe2() in mctfN.c : cannot read predframe.V\n"); exit(1);
	  }
  }

  copyframe(&predframe, destframe, info); 
  
  /* close file and clear memory */
  fclose(fppred);
  free_frame_interior(predframe);
}

/* ---------------------------------------------------------------------- */
/*                             syn_new_tH()                               */
/* ---------------------------------------------------------------------- */
/* IVB 2004/3/20

   Synthesize new temporal high frame for forward prediction 
*/
void syn_new_tH(YUVimage *newtH, YUVimage *tH, int i, int j, int half_len, videoinfo info)
{
	
  YUVimage dumb, tempframe, pframe, *oldtH;
  int k, tPyrLev, dist;
  int yhor, yver, chor, cver;
  enum FLAG ADAPTIVE , bi_flag;
  unsigned char *ypused, *ypusedtemp, *cpused, *cpusedtemp;  /* flag */
  

  ADAPTIVE = info.adapt_flag;
  bi_flag = info.bi_flag;
  yhor = info.ywidth; yver =  info.yheight;
  chor = info.cwidth; cver =  info.cheight;
  tPyrLev = info.tPyrLev;

  ypused = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypused");
  ypusedtemp = (unsigned char *) getarray(yhor*yver, sizeof(unsigned char), "ypusedtemp");
  cpused = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpused");
  cpusedtemp = (unsigned char *) getarray(chor*cver, sizeof(unsigned char), "cpusedtemp");

  //printf("allocating memory\n");
  frame_alloc(&dumb, info);
  frame_alloc(&tempframe, info);
  frame_alloc(&pframe, info);
  oldtH = &pframe;

  wcopyframe(&pyrFrs[j+half_len], &dumb, 0.0, info); // zero frame
  //printf("copying tH\n");
  wcopyframe(tH, oldtH, (float)sqrt(2.0), info); 


	// --------------- predicting frame from the other side of GOP ---------------
	
    
	if(ADAPTIVE == NO)
	//if(1)
	{
		//printf("ADAPTIVE == NO\n");
		/* reconstructed current frame, prev frame, tL, tH, MV*/
		//temporal_synthesis(&predframe2, &tempframe, frame,
        //        pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
		temporal_synthesis(newtH, &tempframe, *oldtH,
                dumb, yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
	}
	else  /* IVB - do we need this ?? */
	{    //ADAPTIVE == YES
		//printf("ADAPTIVE == YES\n");
		if(bi_flag == YES)
		{   	 
			//printf("bi_flag == YES\n");
			if(scene_change[i][j*2+1] == NO )
			{
				//printf("scene_change[%d][%d] == NO\n",i,j*2+1);
				//temporal_synthesis(&predframe2, &tempframe, frame,
                //     pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
				temporal_synthesis(newtH, &tempframe, *oldtH,
                     dumb, yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);

				for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
				for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
				if(scene_change[i][j*2] == NO)
				{
					//printf("scene_change[%d][%d] == NO\n",i,j*2);
					wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);
					//write_lowband(frame, info, "end", i, i);
					/*   current        , next             , high              ,low   */
					//local_temporal_synthesis2(predframe2, pfr, pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
					local_temporal_synthesis2(*newtH, *oldtH, dumb, tempframe, yfmv[j+half_len], ypused, cpused, info, REVERSE); //?
				}//scene_change[i][j*2] == NO
				else
				{  //scene_change[i][j*2] == YES
					//printf("scene_change[%d][%d] == YES\n",i,j*2);
					//local_temporal_synthesis2(predframe2, tempframe, pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
					local_temporal_synthesis2(*newtH, tempframe, dumb, *oldtH, yfmv[j+half_len], ypused, cpused, info, REVERSE); //?
					//local_temporal_synthesis2(pyrTemp[i][2*j], pyrTemp[i][2*j+1], pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
				}	//scene_change[i][j*2] == YES   	
			}//scene_change[i][j*2+1] == NO
			else
			{  //scene_change[i][j*2+1] == YES
				//printf("scene_change[%d][%d] == YES\n",i,j*2+1);
				if(scene_change[i][j*2] == NO)
				{
			        //printf("scene_change[%d][%d] == NO\n",i,j*2);
					for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;
					for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;

					wcopyframe(&end_of_lastGOP, &pfr, (float)pow(2., i/2.), info);
					//write_lowband(frame, info, "end", i, i);
					/*   current        , next             , high              ,low   */
					//local_temporal_synthesis2(predframe2, pfr, pyrFrs[j+half_len], dumb, yfmv[j+half_len], ypused, cpused, info, REVERSE);
					local_temporal_synthesis2(*newtH, *oldtH, dumb, tempframe, yfmv[j+half_len], ypused, cpused, info, REVERSE); //?
				}
				else
				{
					//printf("scene_change[%d][%d] == YES\n",i,j*2);
					//copyframe(&pyrFrs[j+half_len], &predframe2, info);
					copyframe(&dumb, newtH, info); //?
				}
			}
		} //bi_flag == YES
		else
		{  //bi_flag == NO
			//printf("bi_flag == NO\n");
			if(scene_change[i][j*2+1] == NO )
			{
				//printf("scene_change[%d][%d] == NO\n",i,j*2+1);
				//temporal_synthesis(&predframe2, &tempframe, frame,
				//	pyrFrs[j+half_len], yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
				temporal_synthesis(newtH, &tempframe, *oldtH,
					dumb, yfmv[j+half_len], ypusedtemp, cpusedtemp, i, j, info);
			}
			else
			{
				//printf("scene_change[%d][%d] == YES\n",i,j*2+1);
				//copyframe(&pyrFrs[j+half_len], &predframe2, info);
				copyframe(&dumb, newtH, info); //?
			}
		}

		if(scene_change[i][j*2+1] == NO || scene_change[i][j*2] == NO)
		{
			//printf("scene_change[%d][%d] == NO or scene_change[%d][%d] == NO\n",i,j*2+1,i,j*2);
			
#ifdef INTRA_CODED_BLOCK		   
		    //PutbackMean(&pyrFrs[j+half_len], &predframe2, yfmv[j+half_len], i+1, info);
			PutbackMean(dumb, newtH, yfmv[j+half_len], i+1, info);
#else			   
		    for(k=0 ; k<yhor*yver ; k++) ypused[k]=USED;           
			for(k=0 ; k<chor*cver ; k++) cpused[k]=USED;
			//local_temporal_synthesis2(predframe2, tempframe, pyrFrs[j+half_len], dumb, yfmv[j+half_len],
			//	ypused, cpused, info, INTRABLOCK);
			local_temporal_synthesis2(*newtH, tempframe, dumb, *oldtH, yfmv[j+half_len],
				ypused, cpused, info, INTRABLOCK);
#endif
		}
	}//ADAPTIVE == YES


	// ------------- end predicting frame from the other side of GOP -------------

	//printf("freeing memory\n");
	free_frame_interior(dumb);
	free_frame_interior(tempframe);
	free_frame_interior(*oldtH);

	wcopyframe(&pyrFrs[j+half_len], newtH, 0.0, info); // 2004/3/21 zero frame


  free(ypused);
  free(ypusedtemp);
  free(cpused);
  free(cpusedtemp);
}


/*****************************************************************************/
/*                            temporal_synthesis_IVB                         */
/*****************************************************************************/
// Same as temporal_synthesis, but returns a map of used pixels in mc_synthesis_IVB
void temporal_synthesis_IVB(YUVimage_ptr fr1, YUVimage_ptr fr0, YUVimage lfr, YUVimage hfr, vector_ptr fmv, unsigned char *ypused, unsigned char *cpused, int level, int pair, videoinfo info)
/* fr1--current, fr0--reference */
{
  int   i, x, y, X, Y, yhor, yver, chor, cver;
  int   xnum, ynum, xblk, yblk;
  float c5;
  float *ymvx, *ymvy, *cmvx, *cmvy;
  unsigned char *used;
  //long mark, elp;   // initial and elapsed time
  //double duration;


  c5=(float)(1./sqrt(2.));

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblk = info.xblk;   yblk = info.yblk;
  used = (unsigned char *)getarray(chor*cver, sizeof(unsigned char), "used");

  /* allocate the memory and initialization */
  ymvx = (float *) getarray(yhor*yver, sizeof(float), "ymvx");
  ymvy = (float *) getarray(yhor*yver, sizeof(float), "ymvy");
  cmvx = (float *) getarray(chor*cver, sizeof(float), "cmvx");
  cmvy = (float *) getarray(chor*cver, sizeof(float), "cmvy");


  /* convert the block-based vectors to the pixel-based vectors */
  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      block2pixel2(ymvx, ymvy, &fmv[Y*xnum+X], x, y, xblk, yblk, yhor, yver, DEFAULT);
    }
  }

  /* get the chrominance motion vector from the luminance vector */
  if(info.cwidth && info.cheight){
    get_cvector(cmvx, cmvy, ymvx, ymvy, yhor, yver, chor, cver, info);
  }



//  mark = clock();



  /* Y U V */
#ifdef LIFTING
  mc_synthesis_IVB(fr1->Y, fr0->Y, lfr.Y, hfr.Y, ymvx, ymvy, yhor, yver, ypused, Global, level, pair, info); 
#else
  mc_synthesis2(fr1->Y, fr0->Y, lfr.Y, hfr.Y, ymvx, ymvy, yhor, yver, ypused, Global, level, pair, info); 
#endif



//  elp = clock() - mark;   
//  duration = (double)elp / CLOCKS_PER_SEC;
//  print_time(duration);


  if(info.cwidth && info.cheight){

      for(i=0; i<cver*chor; i++)
        used[i] = cpused[i];
#ifdef LIFTING
      mc_synthesis_IVB(fr1->U, fr0->U, lfr.U, hfr.U, cmvx, cmvy, chor, cver, cpused, Global, -1, -1, info);
      mc_synthesis_IVB(fr1->V, fr0->V, lfr.V, hfr.V, cmvx, cmvy, chor, cver, used, Global, -1, -1, info);
#else
      mc_synthesis2(fr1->U, fr0->U, lfr.U, hfr.U, cmvx, cmvy, chor, cver, cpused, Global, -1, -1, info);
      mc_synthesis2(fr1->V, fr0->V, lfr.V, hfr.V, cmvx, cmvy, chor, cver, used, Global, -1, -1, info);
#endif

  }

  
//  elp = clock() - mark;   
//  duration = (double)elp / CLOCKS_PER_SEC;
//  print_time(duration);

  free(used); free(ymvx); free(ymvy); free(cmvx); free(cmvy);
}


/*****************************************************************************/
/*                         local_temporal_synthesis_IVB                      */
/*****************************************************************************/
// Same as local_temporal_synthesis2, but returns a map of used pixels in local_mc_synthesis_IVB
void local_temporal_synthesis_IVB(YUVimage fr1, YUVimage fr0, YUVimage hfr, YUVimage nextL, vector_ptr fmv, unsigned char *ypused, unsigned char *cpused, videoinfo info, enum BlockMode block_mode)
   /* fr1 -- current  fr0 -- next */  /* the data in hfr and nextL takes part int computation, and the result is put into fr1 and fr0 */
{
  int   i, x, y, X, Y, yhor, yver, chor, cver;
  int   xnum, ynum, xblk, yblk;
  float *ymvx, *ymvy, *cmvx, *cmvy;
  unsigned char *used;
  float c5;

  c5 = (float)sqrt(2.);

  yhor = info.ywidth; yver = info.yheight;
  chor = info.cwidth; cver = info.cheight;
  xnum = info.xnum;   ynum = info.ynum;
  xblk = info.xblk;   yblk = info.yblk;

  /* allocate the memory and initialization */
  used=(unsigned char *)getarray(chor*cver, sizeof(unsigned char), "used");

  ymvx = (float *) getarray(yhor*yver, sizeof(float), "ymvx");
  ymvy = (float *) getarray(yhor*yver, sizeof(float), "ymvy");
  cmvx = (float *) getarray(chor*cver, sizeof(float), "cmvx");
  cmvy = (float *) getarray(chor*cver, sizeof(float), "cmvy");

  /* convert the block-based vectors to the pixel-based vectors */
  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      block2pixel2(ymvx, ymvy, &fmv[Y*xnum+X], x, y, xblk, yblk, yhor, yver, block_mode);
    }
  }
  /* get the chrominance motion vector from the luminance vector */
  if(info.cwidth && info.cheight){
    get_cvector(cmvx, cmvy, ymvx, ymvy, yhor, yver, chor, cver, info);
  }


/*
  Y
*/
#ifdef LIFTING
  local_mc_synthesis_IVB(fr1.Y, fr0.Y, nextL.Y, hfr.Y, ymvx, ymvy, yhor, yver, ypused, Local, -1, -1, info);
#else
  mc_synthesis2(fr1.Y, fr0.Y, nextL.Y, hfr.Y, ymvx, ymvy, yhor, yver, ypused, Local, -1, -1, info);
      /* scale down the coefficients in next frame */
#endif


  if(info.cwidth && info.cheight){

    for(i = 0; i < chor*cver; i++)
      used[i] = cpused[i];
#ifdef LIFTING
    local_mc_synthesis_IVB(fr1.U, fr0.U, nextL.U, hfr.U, cmvx, cmvy, chor, cver, cpused, Local, -1, -1, info);
    local_mc_synthesis_IVB(fr1.V, fr0.V, nextL.V, hfr.V, cmvx, cmvy, chor, cver, used, Local, -1, -1, info);
#else
      /*
       U
       */

    mc_synthesis2(fr1.U, fr0.U, nextL.U, hfr.U, cmvx, cmvy, chor, cver, cpused, Local, -1, -1, info);

    /*
     V
     */
    mc_synthesis2(fr1.V, fr0.V, nextL.V, hfr.V, cmvx, cmvy, chor, cver, used, Local, -1, -1, info);
#endif
  }

  free(used);
  free(ymvx); free(ymvy); free(cmvx); free(cmvy);
}

