#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "basic.h"
#define EXTERN extern
#include "coderN.h"


/*==========================================================================*/
/*======================== file: getarray.c ================================*/
 
char *getarray(int num, int siz, char *name)
{
  char *ptr;
  
  ptr = (char *)malloc((unsigned)(num * siz));
  if (ptr == NULL) {
    printf("getarray: can't allocate <%s>\n",name); 
    exit(1);
  }
  return(ptr);
}



int rateAlloc(Rate_ptr FrsRate, int nfrs)
{
 
  FrsRate->map = (int*)getarray(nfrs, sizeof(int), "FrsR.map");
  FrsRate->mv = (int*)getarray(nfrs, sizeof(int), "FrsR.mv");
  FrsRate->ybit = (int*)getarray(nfrs, sizeof(int), "FrsR.ybit");
  FrsRate->ubit = (int*)getarray(nfrs, sizeof(int), "FrsR.ubit");
  FrsRate->vbit = (int*)getarray(nfrs, sizeof(int), "FrsR.vbit");
  FrsRate->yvar = (float*)getarray(nfrs, sizeof(float), "FrsR.yvar");
  FrsRate->uvar = (float*)getarray(nfrs, sizeof(float), "FrsR.uvar");
  FrsRate->vvar = (float*)getarray(nfrs, sizeof(float), "FrsR.vvar");
  
  return(0);
}

int free_rate(Rate_ptr FrsRate)
{

  free(FrsRate->map);
  free(FrsRate->mv);
  free(FrsRate->ybit);
  free(FrsRate->ubit);
  free(FrsRate->vbit);
  free(FrsRate->yvar);
  free(FrsRate->uvar);
  free(FrsRate->vvar);
  return(0);
}

/*****************************************************************************/
/*                                 free_child()                              */
/*****************************************************************************/
void free_child(vector_ptr fmv)
{
  /* if there is no child, then cut itself */
  /* otherwise cut the children first and parent */

  if(fmv->child){    /* having children */
    /*fmv->child=0;
    fmv->mode = DEFAULT;*/ /* move to free_vector()*/

    free_child(fmv->child0);
    free_child(fmv->child1);
    free_child(fmv->child2); 
    free_child(fmv->child3);
/*
    cfree(fmv->child0, 1, sizeof(vector));
    cfree(fmv->child1, 1, sizeof(vector));
    cfree(fmv->child2, 1, sizeof(vector));
    cfree(fmv->child3, 1, sizeof(vector));
	*/
    free(fmv->child0);
    free(fmv->child1);
    free(fmv->child2);
    free(fmv->child3);

  }
  else{
  }
}



/*****************************************************************************/
/*                               free_vector()                               */
/*****************************************************************************/
void free_vector(vector_ptr fmv, videoinfo info)
{
  int i, size;

  /* quad tree structured should be cleaned before starting the next */
  /* so, clean the structure except 1st layer */
  /* fmv->child and fmv->mode should be initialized to 0 */

  size = (info.xnum) * (info.ynum);
  for(i=0 ; i<size ; i++) {
    free_child(&fmv[i]);

	fmv[i].child=0;  //reset after free_child not before
	fmv[i].mode = DEFAULT;
	fmv[i].merge = YES;
	
  }
}

int free_mvs(vector_ptr *yfmv, videoinfo info)
{ 
  int i;
  for(i = 1; i < info.GOPsz; i++)
    free_vector(yfmv[i], info);

  return(0);
}


int free_frame_interior(YUVimage frame)
{
  free(frame.Y);
  free(frame.U);
  free(frame.V);
  
  return(0);
}

int free_frs(YUVimage_ptr *frs, int len)
{
  int i;

  for(i = 0; i < len; i++){
    free(frs[i]);
  }

  return(0);
}

/*****************************************************************************/
/*                             frame_alloc()                                 */
/*****************************************************************************/
void frame_alloc(YUVimage_ptr frame, videoinfo info)
{
  frame->Y = (float *)getarray(info.ywidth*info.yheight, sizeof(float), "frame");
  frame->U = (float *)getarray(info.cwidth*info.cheight, sizeof(float), "frame");
  frame->V = (float *)getarray(info.cwidth*info.cheight, sizeof(float), "frame");
}







void free_pyrTemp_interior(videoinfo info)
{
	int i, j, len;

	if(info.tPyrLev == 0){
		free_frame_interior(pyrTemp[0][0]);
	}
	else{
        len =info.GOPsz;              
        for(i = 0; i < info.tPyrLev; i++){  
          for(j = 0; j < len; j++){
            free_frame_interior(pyrTemp[i][j]);
		  }
          len /= 2;
		}
	}
}

void alloc_pyrTemp_interior(videoinfo info)
{
	int i, j, len;

	if(info.tPyrLev == 0){
		frame_alloc(&pyrTemp[0][0], info);
	}
	else{
       len = info.GOPsz;              
       for(i = 0; i < info.tPyrLev; i++){  
         for(j = 0; j < len; j++){
           frame_alloc(&pyrTemp[i][j], info);
		 }
         len /= 2;
	   }
	}
}

void alloc_pyrFrs_interior(videoinfo info)
{
	int i;
    for(i = 0; i < info.GOPsz; i++){  
		frame_alloc(&pyrFrs[i], info);
	}
}

void enc_destructor(videoinfo info)
{
  int i;

	free(pyrFrs);

    //len = nFrsPyr;              
    for(i = 0; i < info.tPyrLev; i++){  
		//for(j = 0; j < len; j++){
        //  free_frame_interior(pyrTemp[i][j]);
        //}
        //len /= 2;
      free(pyrTemp[i]); 
    }
    free(pyrTemp);
	
    for(i = 0; i < info.tPyrLev; i++){       
	   free(GOPscene[i]-1);
	   free(scene_change[i]);
	}     
    free(GOPscene);      
    free(scene_change);
    free(video_scene_change);

    free_frame_interior(pfr);
    free_frame_interior(cfr);
  

}

void dec_destructor(videoinfo info)
{
  int i;

	free(pyrFrs);

    //len = nFrsPyr;              
    for(i = 0; i < info.tPyrLev; i++){  
		//for(j = 0; j < len; j++){
        //  free_frame_interior(pyrTemp[i][j]);
        //}
        //len /= 2;
      free(pyrTemp[i]); 
    }
    free(pyrTemp);
	
    for(i = 0; i < info.tPyrLev; i++){       
	   free(GOPscene[i]-1);
	   free(scene_change[i]);
	}     
    free(GOPscene);      
    free(scene_change);

    free_frame_interior(pfr);
    free_frame_interior(cfr);
  

}