#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "structN.h"
#include "basic.h"
#include "bmeN.h"

#define EXTERN 

#include "arcodemv.h"
 

#define MVCODE   3       /* 1:VLC, 2:VLC+diff, 3:VLC+diff+1/2 */

#define Yes      1
#define No       0

#define DIS1     1       /* frame distance for block matching */
#define DIS2     2 
#define DIS4     4

extern enum FLAG   **scene_change;
extern int         **GOPscene;
void child_map_decode(vector_ptr fmv, int meandepth, int x, int y, int xblk, int yblk, int hor, int ver, int small, videoinfo info);

int get_numsymbol(int level, int maxx, int large, int subpel, int full);

void encode_symbol(int symbol, int num_symbol);
void update_model(int symbol, int num_symbol);
long int read_number(int with);
int read_number_core(FILE *fp);
void write_number_core(int outputbyte, FILE *fp);

/* --- IVB 2006/07/07 --- */
void child_mv_decode_zero(vector_ptr fmv, float *pmvx, float *pmvy, int num_symbol, int subpel, int x, int y, int xblk, int yblk, int hor, int ver);
long int mv_decode_zero(vector_ptr fmv, int meandepth, videoinfo info, int large, int subpel);
/* --- IVB 2006/07/07 --- */



/*
 *       putbits()
 * write rightmost n (0<=n<=32) bits of val to outfile
 * val : value needs to be output.
 * n   : rightmost n bits of val
 */
void putbits(int val, int n)
{
  int i;
  unsigned int mask;

  mask = 1 << (n-1); /* selects first (leftmost) bit */

  for (i=0; i<n; i++){
    if(val & mask){
      output_bit(1);
	}
	else{
	  output_bit(0);
	}
    mask >>= 1; /* select next bit */
  }
}


int getbits(int len)
{
  int i, bit, val=0;

  for(i=0; i<len; i++){
	val <<= 1;
	input_bit(bit);
	val |= bit;
  }
  return val;
}

/****************************************************************************/
/*                              child_mv_encode()                           */
/* encode motion vectors of blocks with modes except INTRABLOCK             */
/****************************************************************************/
void child_mv_encode(vector_ptr fmv, float *pmvx, float *pmvy, int num_symbol, int subpel, int x, int y, int xblk, int yblk, int hor, int ver)
{
  int dmvx, dmvy, symbol, cx, cy;

  if(fmv->child){
    cx=x; cy=y;
    child_mv_encode(fmv->child0, pmvx, pmvy, num_symbol, subpel, 
		    cx, cy, xblk/2, yblk/2, hor, ver);

    cx=x+xblk/2; cy=y;
    child_mv_encode(fmv->child1, pmvx, pmvy, num_symbol, subpel,
		    cx, cy, xblk/2, yblk/2, hor, ver);

    cx=x; cy=y+yblk/2;
    child_mv_encode(fmv->child2, pmvx, pmvy, num_symbol, subpel,
		    cx, cy, xblk/2, yblk/2, hor, ver);

    cx=x+xblk/2; cy=y+yblk/2;
    child_mv_encode(fmv->child3, pmvx, pmvy, num_symbol, subpel,
		    cx, cy, xblk/2, yblk/2, hor, ver);
  }
  else{
    if(x>=hor || y>=ver) return;

#ifdef INTRA_CODED_BLOCK
    if(fmv->mode == INTRABLOCK) return; //  skip motion vector
#endif

    dmvx =(MVCODE==1)? 
      (int)((1<<subpel)*(fmv->mvx)) : (int)((1<<subpel)*(fmv->mvx - *pmvx));
    dmvy =(MVCODE==1)?
      (int)((1<<subpel)*(fmv->mvy)) : (int)((1<<subpel)*(fmv->mvy - *pmvy));


/*
    dmvx = fmv->mvx;  wrong fmv->mvx is float but dmvx is integer 
    dmvy = fmv->mvy;
    if(fmv->bi == 1){
      dmvx = -dmvx;
      dmvy = -dmvy;
    }
    dmvx =(MVCODE==1)? 
      (int)((1<<subpel)*(dmvx)) : (int)((1<<subpel)*(dmvx - *pmvx));
    dmvy =(MVCODE==1)?
      (int)((1<<subpel)*(dmvy)) : (int)((1<<subpel)*(dmvy - *pmvy));
*/ /* QUEST */

    if(MVCODE==3){
      if     (dmvx >  num_symbol/2 ) dmvx -= num_symbol;
      else if(dmvx <-(num_symbol/2)) dmvx += num_symbol;
      if     (dmvy >  num_symbol/2 ) dmvy -= num_symbol;
      else if(dmvy <-(num_symbol/2)) dmvy += num_symbol;
    }

    symbol = int2sym[dmvx+num_symbol/2];  /* offset to consider - */
    encode_symbol(symbol, num_symbol);
    update_model(symbol, num_symbol);

    symbol = int2sym[dmvy+num_symbol/2];  /* offset to consider - */
    encode_symbol(symbol, num_symbol);
    update_model(symbol, num_symbol);


    *pmvx = fmv->mvx;
    *pmvy = fmv->mvy;
/*
    if(fmv->bi == 1){
      *pmvx = -(*pmvx);
      *pmvy = -(*pmvy);
    }
*//* QUEST */

  }
}




/****************************************************************************/
/*                              child_map_encode()                          */
/* encode quature structure, block modes and means(Y,U,V) of INTRABLOCKS    */
/****************************************************************************/
void child_map_encode(vector_ptr fmv, int *mapbit, int x, int y, int xblk, int yblk, int hor, int ver, int small, videoinfo info)
{
  int cx, cy;

  if(fmv->child){
    /*   printf("bit%d = 1\n", *mapbit);*/
    output_bit(1); (*mapbit)++;  /*for tree structure */

    cx=x; cy=y;
    child_map_encode(fmv->child0, mapbit, cx, cy,xblk/2,yblk/2,hor,ver, small, info);

    cx=x+xblk/2; cy=y;
    child_map_encode(fmv->child1, mapbit, cx, cy,xblk/2,yblk/2,hor,ver, small, info);

    cx=x; cy=y+yblk/2;
    child_map_encode(fmv->child2, mapbit, cx, cy,xblk/2,yblk/2,hor,ver, small, info);

    cx=x+xblk/2; cy=y+yblk/2;
    child_map_encode(fmv->child3, mapbit, cx, cy,xblk/2,yblk/2,hor,ver, small, info);
  }
  else{

    if(x>=hor || y>=ver) return;
    else{
      if(xblk > small){
         output_bit(0); (*mapbit)++;  /*for tree structure */
	  }

	  if(info.adapt_flag == YES){

        putbits(blockmodeVLC[fmv->mode].code, blockmodeVLC[fmv->mode].len); //output block mode

        (*mapbit) += blockmodeVLC[fmv->mode].len;


#ifdef INTRA_CODED_BLOCK
		if(fmv->mode == INTRABLOCK){
		  len = fmv->meandepth-BlockShift;
		  putbits(fmv->Ymean, len);(*mapbit) += len;

		  if(info.cwidth && info.cheight){
			//U
			mean = fmv->Umean;
			if(mean < 0){
			  output_bit(0);(*mapbit)++;
              mean = -mean;
			}
			else{
			  output_bit(1);(*mapbit)++;
			}
			len = fmv->meandepth-BlockShift-1;
		    putbits(mean, len); (*mapbit) += len;
			//V
			mean = fmv->Vmean;
			if(mean < 0){
			  output_bit(0);(*mapbit)++;
			  mean = -mean;
			}
			else{
			  output_bit(1);(*mapbit)++;
			}			
		    putbits(mean, len); (*mapbit) += len;
		  } // for U & V
		}// INTRABLOCK mean

#endif
	  }
    } /* Feb 23 */

  }
}

/*****************************************************************************/
/*                                mv_encode()                                */
/*****************************************************************************/

void mv_encode(int *mvbit, int *mapbit, vector_ptr fmv, videoinfo info, int large, int subpel)
{
  int   x, y, X, Y, xnum, ynum, xblk, yblk, hor, ver, pos, small, itemp;
  int   num_symbol, full;
  float pmvx, pmvy;

  /* miscellany */
  xnum=info.xnum; ynum=info.ynum;
  xblk=info.xblk; yblk=info.yblk;
  hor =info.ywidth; ver =info.yheight;
  small=xblk; itemp=info.level;
  while(itemp!=1){ small/=2; itemp--;}

  /* assign memory */
  full = (info.maxx!=1)? 1 : 0;
  num_symbol = get_numsymbol(info.level, info.maxx, large, subpel, full);
  if(MVCODE==2) num_symbol *= 2;

  /* ar encoding */
  *mapbit = 0;     /* map encoding */
  arencode_init(num_symbol, info);
  if(info.level!=1){
    for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){  /* coding loop */
      for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
	pos=Y*xnum+X;
	child_map_encode(&fmv[pos], mapbit, x, y, xblk, yblk, hor,ver,small, info);
	/*CCCCCCCC  printf("mapbit %d\n", *mapbit);**/
      }
    }
  }  

  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){  /* mv coding */
    pmvx=0.; pmvy=0.;       /* initialize to the zero per each row */

    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      pos=Y*xnum+X;
      child_mv_encode(&fmv[pos], &pmvx, &pmvy, num_symbol, subpel,
		      x, y, xblk, yblk, hor, ver);
    }
  }  
  arencode_end(num_symbol, Yes, info);
  *mvbit = 8*outbyte - *mapbit;

}


/*****************************************************************************/
/*                                mv_encoding()                              */
/*****************************************************************************/
int mv_encoding(videoinfo info, Rate FrsRate, vector_ptr *yfmv)
{
  int i, j, sum, itmp, count, nfrs, dist, nlev; 
  FILE *fpstat;

  nlev = info.tPyrLev;
  dist = (int)pow(2.0, (double)(nlev -1));

  fpstat = fopen(info.statname, "at+");
sum = 0; 


  FrsRate.mv[0] = FrsRate.map[0] = 0;
  nfrs = 1; count = 1;
  for(i = nlev-1; i >= 0; i--){ 
    for(j = 0; j < nfrs; count++, j++){//printf("i %d j %d ", i, j);
      /*if(j == nfrs-1 )
                do not estimate and output bidirectional information, flag is 0(bi_flag)
        mv_encode(&(FrsRate.mv[count]), &(FrsRate.map[count]), yfmv[count],
                  info, dist, info.subpel, 0);
      else
                estimate and output bidirectional information, flag is 1(bi_flag)
        mv_encode(&(FrsRate.mv[count]), &(FrsRate.map[count]), yfmv[count],
                  info, dist, info.subpel, 1);*/  /* June19 */

	  if(scene_change[i][j*2] == NO || scene_change[i][j*2+1] == NO || info.adapt_flag == NO){            
		  mv_encode(&(FrsRate.mv[count]), &(FrsRate.map[count]), yfmv[count],
               info, dist, info.subpel);
  
		  fprintf(fpstat, "Fr%.2d: mapbits = %4d mvbits = %5d sum = %5d\n", count, 	    
			  FrsRate.map[count], FrsRate.mv[count], 	    
			  itmp=(FrsRate.map[count] + FrsRate.mv[count]));    
		  sum += itmp;

		 // printf("NO\n");
	  }
	  else
	  {
		  fprintf(fpstat, "Fr%.2d: no motion information needed\n", count);
	  }
    }
    dist /= 2;
    nfrs *= 2;
  }


  fclose(fpstat);


  return(sum); 
}





/****************************************************************************/
/*                             get_numsymbol_()                             */
/****************************************************************************/
int get_numsymbol_(int level, int maxx, int large, int subpel, int full)
{
  int i, search, num_symbol;

  if(level==1 && full) search = large * maxx;  /* fsbm with full search */
  else{           /* fsbm with hier or hvsbm */
	switch(maxx){
 
	default:printf("error in get_numsymbol() maxx %d\n", maxx); exit(1);
	case 1:
		switch(large){
		default: printf("error in mv_encode()\n"); exit(1);
		case 1: search = 10; break;  /* 1  1.5  |  2  2.5  |  4  4.5  |  8  8.5 */
		case 2: search = 17; break;  /* 3  4.5  |  5  7.5  |  9 13.5  | 17 25.5 */
        case 4: search = 31; break;  /* 9 10.5  | 15 17.5  | 27 31.5  | 51 59.5 */
        case 8: search = 59; break;
		}
		break;

    case 2:
		switch(large){
		default: printf("error in mv_encode()\n"); exit(1);
	    case 1: search = 17; break;  /* 2  2.5  |  4  4.5  |  8  8.5  | 16 16.5*/
		case 2: search = 31; break;  /* 5  7.5  |  9 13.5  | 17 25.5  | 33 49.5*/
		case 4: search = 59; break;  /*15 17.5  | 27 31.5  | 51 59.5  | 99 115.5*/
		case 8: search = 115; break;
		} 
		break;
	case 3: 
		switch(large){
		default: printf("error in mv_encode()\n"); exit(1);
        case 1: search = 24; break;  /* 3 3.5  |  6  6.5  | 12 12.5  | 24  24.5 */
		case 2: search = 45; break;  /* 7 10.5 | 13 19.5  | 25 37.5  | 49  73.5 */
		case 4: search = 87; break;  /*21 24.5 | 39 45.5  | 75 87.5  |147 171.5 */
		case 8: search = 171; break; 
		}
		break;
	case 4:
		switch(large){
		default: printf("error in mv_encode()\n"); exit(1);
		case 1: search = 31; break;  /* 4 4.5  |  8 8.5  | 16 16.5  | 32 32.5 */
		case 2: search = 59; break;  /* 9 13.5 | 17 25.5 | 33 49.5  | 65 97.5 */
		case 4: search = 115; break; /*27 31.5 | 51 59.5 | 99 115.5 |195 227.5*/
		case 8: search = 227; break; 
		}
		break;
	case 5:
		switch(large){
		default: printf("error in mv_encode()\n"); exit(1);
		case 1: search = 38; break;  /* 5 5.5  | 10 10.5 | 20 20.5  | 40  40.5 */
		case 2: search = 73; break;  /*11 16.5 | 21 31.5 | 41 61.5  | 81 121.5 */
		case 4: search = 143; break; /*33 38.5 | 63 73.5 |123 143.5 |243 283.5*/
		case 8: search = 283; break; 
		}
		break;
	case 6:
		switch(large){
		default: printf("error in mv_encode()\n"); exit(1);
		case 1: search = 45; break;  /* 6 6.5  | 12 12.5 | 24 24.5  | 48  48.5 */
		case 2: search = 87; break;  /*13 19.5 | 25 37.5 | 49 73.5  | 97 145.5 */
		case 4: search = 171; break; /*39 45.5 | 75 87.5 |147 171.5 |291 339.5*/
		case 8: search = 339; break; 
		}
		break;
	}
  }
  num_symbol = search; 
  for(i=0; i<subpel; i++){
    num_symbol = 2*num_symbol+1;
  }
  num_symbol *= 2;                       /* - , + */
  num_symbol += 1;                       /* origin */

  return num_symbol;
}


/****************************************************************************/
/*                             get_numsymbol()                              */
/****************************************************************************/
int get_numsymbol(int level, int maxx, int large, int subpel, int full)
{
  int i, search, num_symbol;

  /* calculate the number of motion vectors */
  /* example */
  /* if maxx = 7, -7 to +7   for full-pixel */
  /*               0 to +14  for positive */
  /*            num_symbol = 15  */

  /* if maxx = 7, -7.5 to +7.5  for half-pixel */
  /*              -15 to +15    for integer */
  /*               0  to  +30   for positive */
  /*            num_symbol = 31 */

  if(level==1 && full) search = large * maxx;  /* fsbm with full search */
  else{           /* fsbm with hier or hvsbm */

	  search = (1+maxx_refine)*2+1+maxx_refine; 
/* 0  0.5  */
/* 1  2.5  */
/* 5  6  */

	  search = search + (maxx * large)*4;
  }

  num_symbol = search; 

  for(i=0; i<subpel; i++){
    num_symbol = 2*num_symbol+1;
  }


  num_symbol *= 2;                       /* - , + */
  num_symbol += 1;                       /* origin */

  return num_symbol;
}


/*
 *  get_blockmode()
 * get block mode and if in INTRABLOCK, also get means
 */
void get_blockmode(vector_ptr fmv, int meandepth, videoinfo info)
{
  int bit;
  
  if(info.adapt_flag == YES){
    input_bit(bit);
    if(bit == 0) fmv->mode = DEFAULT;
    else{
  	  input_bit(bit);
	  if(bit==0) fmv->mode = INTRABLOCK;
	  else       fmv->mode = REVERSE;
	}

#ifdef INTRA_CODED_BLOCK

    if(fmv->mode == INTRABLOCK){
 	  fmv->Ymean = getbits(meandepth-BlockShift);
	  if(info.cwidth && info.cheight){
	    //U
	    input_bit(bit);
	    if(bit == 0)
	 	  sign = -1;
	    else 
		  sign = 1;
	    len = meandepth-BlockShift - 1;
	    fmv->Umean = sign *getbits(len);
	    //V
	    input_bit(bit);
	    if(bit == 0)
		  sign = -1;
	    else 
		  sign = 1;
	    fmv->Vmean = sign *getbits(len);
	  }
	}
#endif

  }
  else{
    fmv->mode = DEFAULT;
  }
}



void alloc_vector( vector_ptr *mv, int meandepth, int cx, int cy, int xblk, int yblk, int hor, int ver, int small, videoinfo info)
{
  *mv = (vector_ptr) getarray(1, sizeof(vector), "mv");
   
  if(cx<hor && cy<ver){  /* Feb23 */
    if(xblk>small){
      child_map_decode(*mv, meandepth, cx, cy, xblk, yblk, hor, ver, small, info);
    }
    else{
      (*mv)->child = 0;	
	  get_blockmode(*mv, meandepth, info);
	}
  }
  else{	  
	(*mv)->child = 0;
  }
}


/****************************************************************************/
/*                              child_map_decode()                          */
/* decode quature structure, block modes and means(Y,U,V) of INTRABLOCKS    */
/****************************************************************************/
void child_map_decode(vector_ptr fmv, int meandepth, int x, int y, int xblk, int yblk, int hor, int ver, int small, videoinfo info)
{
  int bit, cx, cy;

  /*printf("bits_to_go = %d inbyte = %d buffer = %o", bits_to_go, inbyte, buffer);*/
  input_bit(bit);
  fmv->child = bit;
  
  if(fmv->child){

    cx=x; cy=y;
	alloc_vector(&(fmv->child0), meandepth, cx, cy, xblk/2, yblk/2, hor, ver, small, info);

    cx=x+xblk/2; cy=y;
	alloc_vector(&(fmv->child1), meandepth, cx, cy, xblk/2, yblk/2, hor, ver, small, info);

    cx=x; cy=y+yblk/2;
	alloc_vector(&(fmv->child2), meandepth, cx, cy, xblk/2, yblk/2, hor, ver, small, info);

    cx=x+xblk/2; cy=y+yblk/2;
	alloc_vector(&(fmv->child3), meandepth, cx, cy, xblk/2, yblk/2, hor, ver, small, info);
  }
  else{  /* Feb23 */
	get_blockmode(fmv, meandepth, info);
  }
}

/****************************************************************************/
/*                              child_mv_decode()                           */
/* decode motion vectors of blocks with modes except INTRABLOCK             */
/****************************************************************************/
void child_mv_decode(vector_ptr fmv, float *pmvx, float *pmvy, int num_symbol, int subpel, int x, int y, int xblk, int yblk, int hor, int ver)
{
  int dmvx, dmvy, symbol, cx, cy;

  if(fmv->child){// printf("%d x %d y %d xblk %d yblk %d\n", fmv->child, x, y, xblk, yblk);
    cx=x; cy=y;
    child_mv_decode(fmv->child0, pmvx, pmvy, num_symbol, subpel,
                    cx, cy, xblk/2, yblk/2, hor, ver);

    cx=x+xblk/2; cy=y;
    child_mv_decode(fmv->child1, pmvx, pmvy, num_symbol, subpel,
                    cx, cy, xblk/2, yblk/2, hor, ver);

    cx=x; cy=y+yblk/2;
    child_mv_decode(fmv->child2, pmvx, pmvy, num_symbol, subpel,
                    cx, cy, xblk/2, yblk/2, hor, ver);

    cx=x+xblk/2; cy=y+yblk/2;
    child_mv_decode(fmv->child3, pmvx, pmvy, num_symbol, subpel,
                    cx, cy, xblk/2, yblk/2, hor, ver);
  }
  else{
    if(x>=hor || y>=ver) return;

#ifdef INTRA_CODED_BLOCK
    if(fmv->mode == INTRABLOCK) return; //skip motion vectors
#endif

    symbol = decode_symbol();  /* decode the mvx */
    if(symbol==num_symbol+1){
      printf("child_mv_decode: EOF\n"); 
      exit(1);    /* exit loop if EOF symbol */
    }
    dmvx = sym2int[symbol]-num_symbol/2;

    if(MVCODE==3){
      if     (dmvx >  num_symbol/2 -(int)((1<<subpel)* *pmvx)) dmvx -= num_symbol;
      else if(dmvx <-(num_symbol/2)-(int)((1<<subpel)* *pmvx)) dmvx += num_symbol;
    }
    fmv->mvx=(MVCODE==1)? (float)dmvx/(1<<subpel) : (float)dmvx/(1<<subpel) + *pmvx;
    update_model(symbol, num_symbol);

    symbol = decode_symbol();  /* decode the mvy */
    if(symbol==num_symbol+1){
      printf("child_mv_decode: EOF\n"); 
      exit(1);    /* exit loop if EOF symbol */
    }
    dmvy = sym2int[symbol]-num_symbol/2;

    if(MVCODE==3){
      if     (dmvy >  num_symbol/2 -(int)((1<<subpel)* *pmvy)) dmvy -= num_symbol;
      else if(dmvy <-(num_symbol/2)-(int)((1<<subpel)* *pmvy)) dmvy += num_symbol;
    }
    fmv->mvy=(MVCODE==1)? (float)dmvy/(1<<subpel) : (float)dmvy/(1<<subpel) + *pmvy;
    update_model(symbol, num_symbol);

    *pmvx = fmv->mvx;
    *pmvy = fmv->mvy;
  }
}


/****************************************************************************/
/*                              mv_decode()                                 */
/****************************************************************************/
long int mv_decode(vector_ptr fmv, int meandepth, videoinfo info, int large, int subpel)
{
  int   x, y, X, Y, xnum, ynum, xblk, yblk, hor, ver, pos, small, itemp;
  int   num_symbol, full;
  float pmvx, pmvy;
  long int  mvBytes = 0;

  /* miscellany */
  xnum=info.xnum; ynum=info.ynum;
  xblk=info.xblk; yblk=info.yblk;
  hor =info.ywidth; ver=info.yheight;
  small=xblk; itemp=info.level;
  while(itemp!=1){ small/=2; itemp--;}

  /* assign memory */
  full = (info.maxx!=1)? 1 : 0;
  num_symbol = get_numsymbol(info.level, info.maxx, large, subpel, full);
  if(MVCODE==2) num_symbol *= 2;

  mvBytes = read_number(Yes); bits_to_go=0; garbage_bits=0; //printf("mvBytes = %d\n", mvBytes);
  /*  printf(".............inbyte= %d\n", inbyte); */
  if(info.level!=1){
    for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){  /* coding loop */
      for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
	/*	printf("x = %d y = %d\n", X, Y);*/
	pos=Y*xnum+X;
	child_map_decode(&fmv[pos], meandepth, x, y, xblk, yblk, hor, ver, small, info);
      }
    }
  }  
  /*
  printf("done...................\n");*/
  /* coding loop */
  ardecode_init(num_symbol);
  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    pmvx=0.; pmvy=0.;           /* initialize to the zero per each row */

    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      pos=Y*xnum+X;
      child_mv_decode(&fmv[pos], &pmvx, &pmvy, num_symbol, subpel,
		      x, y, xblk, yblk, hor, ver);
    }
  }  
  ardecode_end();

  return mvBytes;
}


/*****************************************************************************/
/*                              mv_dencoding()                               */
/*****************************************************************************/
long int mv_decoding(videoinfo info, vector_ptr *yfmv)
{
  int i, j, count, nfrs, dist, nlev, meandepth; 
  long int mvBytes = 0;

  nlev = info.tPyrLev;
  dist = (int)pow(2.0, (double)(nlev -1));

  /*
  printf("dist = %d\n", dist); */
  nfrs = 1; count = 1;
  for(i = nlev-1; i >= 0; i--){
	meandepth = info.pixeldepth + (i+1+1)/2; // i+1 is the tPyrLev
    for(j = 0; j < nfrs; count++, j++){
      /*  printf("count = %d\n", count);*/

      /*if(j == nfrs-1)
        mv_decode(yfmv[count], info, dist, info.subpel, 0);
      else
        mv_decode(yfmv[count], info, dist, info.subpel, 1);*/ /* June19 */

	  if(scene_change[i][j*2] == NO || scene_change[i][j*2+1] == NO || info.adapt_flag == NO){            
		  //if (i <= nlev -6)
			  //mvBytes += mv_decode_zero(yfmv[count], meandepth, info, dist, info.subpel);
		  //else
			  mvBytes += mv_decode(yfmv[count], meandepth, info, dist, info.subpel);

	  }
    }

    dist /= 2;
    nfrs *= 2;
  }
  return mvBytes;
}


/*****************************************************************************/
/*                             child_mv_compare                              */
/*****************************************************************************/
void child_mv_compare(vector_ptr fmv1, vector_ptr fmv2, videoinfo info)
{
  if(fmv1->child){
    child_mv_compare(fmv1->child0, fmv2->child0, info);
    child_mv_compare(fmv1->child1, fmv2->child1, info);
    child_mv_compare(fmv1->child2, fmv2->child2, info);
    child_mv_compare(fmv1->child3, fmv2->child3, info);
  }
  else{
    if(fmv1->mvx!=fmv2->mvx) { printf("error x\n"); exit(1);}
    if(fmv1->mvy!=fmv2->mvy) { printf("error y\n"); exit(1);}
  }
}


/*****************************************************************************/
/*                               mv_compare                                  */
/*****************************************************************************/
void mv_compare(vector_ptr fmv1, vector_ptr fmv2, videoinfo info)
{
  int i;

  for(i=0 ; i<info.xnum*info.ynum ; i++){
    if(fmv1[i].child){
      if(fmv1[i].child!=fmv2[i].child){ 
	printf("error map %d\n", i); 
	exit(1);
      }

      child_mv_compare(&fmv1[i], &fmv2[i], info);
    }
    else{
      if(fmv1[i].mvx != fmv2[i].mvx){ printf("error x %d\n", i); exit(1);}
      if(fmv1[i].mvy != fmv2[i].mvy){ printf("error y %d\n", i); exit(1);}
    }
  }
  printf("no error\n");
}



/****************************************************************************/
/*                              write_number()                              */
/****************************************************************************/
void write_number()
{

  if(outbyte<0){
    printf("error in write_number() outbyte = %d\n", outbyte); 
    exit(1);
  }
/*
  if     (outbyte<128)  putc(outbyte, fpbit);
  else if(outbyte<32786) {
    outbyte |= 0x8000;     make the MSB "1" 
    tmpbyte = (outbyte & 0xff00)>>8; putc(tmpbyte, fpbit);
    tmpbyte = outbyte & 0x00ff; putc(tmpbyte, fpbit);
    outbyte &= 0x7fff;
  }
else {printf("error in write_number() outbyte=%d\n", outbyte); exit(1);}
*/
  if(outbyte<=0x7fffffff){
    write_number_core(outbyte, fpbit);
    //printf("in write_number() outbyte=%d\n", outbyte);
  }
  else {printf("error in write_number() outbyte=%d\n", outbyte); exit(1);}

}




/****************************************************************************/
/*                                 read_number()                            */
/****************************************************************************/
long int read_number(int with)
{

  if(with){
/*
    tmpbyte = getc(fpbit);
    if(!(tmpbyte & 0x0080)) inbyte = tmpbyte;  1 byte
    else{                                      2 bytes
      tmpbyte &= 0x7f;    clear MSB 
      inbyte = 256 * tmpbyte;
      inbyte += getc(fpbit);
    }
*/
    inbyte = read_number_core(fpbit);
  }
  else inbyte=65535;

  //printf("inbyte = %d ..............(arcodemv.c)\n", inbyte);
  return (inbyte+4);  // 4 bytes for the value of inbytes
}

int write_GOPheader(enum FLAG **scene_change, videoinfo info)
{
  int i, j, len, tPyrLev;
  
  encode_init(info);

  len = info.GOPsz;         
  tPyrLev = info.tPyrLev;
  for(i=0; i<tPyrLev; i++){
	  for(j=0; j<len; j++){
		  if(scene_change[i][j] == YES){
		    output_bit(1);		   
			//printf("YES\n");
		  }
		  else{
		    output_bit(0);
			//printf("NO\n");
		  }
	  }
	  len /= 2;
  }
  encode_end(0, info);

  return outbyte;
}










int read_GOPheader(enum FLAG **scene_change, videoinfo info)
{
  int i, j, len, tPyrLev, bit, GOPheader_bytes, count = 0;
  
  decode_init();

  len = info.GOPsz;         
  tPyrLev = info.tPyrLev;

  for(i=0; i<tPyrLev; i++){
	  for(j=0; j<len; j++){
		  count++;
	  }
	  len /= 2;
  }

  GOPheader_bytes = (count + 7)/8;
  inbyte = GOPheader_bytes;

  len = info.GOPsz;         
  tPyrLev = info.tPyrLev;
  for(i=0; i<tPyrLev; i++){
	  for(j=0; j<len; j++){
		          
		  input_bit(bit);

		  if(bit == 1){
		    scene_change[i][j] = YES; 
			//printf("YES\n");
		  }
		  else{
		    scene_change[i][j] = NO;
			//printf("NO\n");
		  }
	  }
	  len /= 2;
  }

  decode_end();

  return GOPheader_bytes;
}


/* ---- IVB 2006/07/07 ---- */
/* Setting some MVs to zero */

/****************************************************************************/
/*                              child_mv_decode_zero()                      */
/* decode motion vectors of blocks with modes except INTRABLOCK             */
/****************************************************************************/
void child_mv_decode_zero(vector_ptr fmv, float *pmvx, float *pmvy, int num_symbol, int subpel, int x, int y, int xblk, int yblk, int hor, int ver)
{
  int dmvx, dmvy, symbol, cx, cy;

  if(fmv->child){// printf("%d x %d y %d xblk %d yblk %d\n", fmv->child, x, y, xblk, yblk);
    cx=x; cy=y;
    child_mv_decode_zero(fmv->child0, pmvx, pmvy, num_symbol, subpel,
                    cx, cy, xblk/2, yblk/2, hor, ver);

    cx=x+xblk/2; cy=y;
    child_mv_decode_zero(fmv->child1, pmvx, pmvy, num_symbol, subpel,
                    cx, cy, xblk/2, yblk/2, hor, ver);

    cx=x; cy=y+yblk/2;
    child_mv_decode_zero(fmv->child2, pmvx, pmvy, num_symbol, subpel,
                    cx, cy, xblk/2, yblk/2, hor, ver);

    cx=x+xblk/2; cy=y+yblk/2;
    child_mv_decode_zero(fmv->child3, pmvx, pmvy, num_symbol, subpel,
                    cx, cy, xblk/2, yblk/2, hor, ver);
  }
  else{
    if(x>=hor || y>=ver) return;

#ifdef INTRA_CODED_BLOCK
    if(fmv->mode == INTRABLOCK) return; //skip motion vectors
#endif

    symbol = decode_symbol();  /* decode the mvx */
    if(symbol==num_symbol+1){
      printf("child_mv_decode: EOF\n"); 
      exit(1);    /* exit loop if EOF symbol */
    }
    dmvx = sym2int[symbol]-num_symbol/2;

    if(MVCODE==3){
      if     (dmvx >  num_symbol/2 -(int)((1<<subpel)* *pmvx)) dmvx -= num_symbol;
      else if(dmvx <-(num_symbol/2)-(int)((1<<subpel)* *pmvx)) dmvx += num_symbol;
    }
    fmv->mvx=(MVCODE==1)? (float)dmvx/(1<<subpel) : (float)dmvx/(1<<subpel) + *pmvx;
	fmv->mvx=0.0; // IVB 2006/07/07
    update_model(symbol, num_symbol);

    symbol = decode_symbol();  /* decode the mvy */
    if(symbol==num_symbol+1){
      printf("child_mv_decode: EOF\n"); 
      exit(1);    /* exit loop if EOF symbol */
    }
    dmvy = sym2int[symbol]-num_symbol/2;

    if(MVCODE==3){
      if     (dmvy >  num_symbol/2 -(int)((1<<subpel)* *pmvy)) dmvy -= num_symbol;
      else if(dmvy <-(num_symbol/2)-(int)((1<<subpel)* *pmvy)) dmvy += num_symbol;
    }
    fmv->mvy=(MVCODE==1)? (float)dmvy/(1<<subpel) : (float)dmvy/(1<<subpel) + *pmvy;
	fmv->mvy=0.0; // IVB 2006/07/07
    update_model(symbol, num_symbol);

    *pmvx = fmv->mvx;
    *pmvy = fmv->mvy;
  }
}


/****************************************************************************/
/*                              mv_decode_zero()                            */
/****************************************************************************/
long int mv_decode_zero(vector_ptr fmv, int meandepth, videoinfo info, int large, int subpel)
{
  int   x, y, X, Y, xnum, ynum, xblk, yblk, hor, ver, pos, small, itemp;
  int   num_symbol, full;
  float pmvx, pmvy;
  long int  mvBytes = 0;

  /* miscellany */
  xnum=info.xnum; ynum=info.ynum;
  xblk=info.xblk; yblk=info.yblk;
  hor =info.ywidth; ver=info.yheight;
  small=xblk; itemp=info.level;
  while(itemp!=1){ small/=2; itemp--;}

  /* assign memory */
  full = (info.maxx!=1)? 1 : 0;
  num_symbol = get_numsymbol(info.level, info.maxx, large, subpel, full);
  if(MVCODE==2) num_symbol *= 2;

  mvBytes = read_number(Yes); bits_to_go=0; garbage_bits=0; //printf("mvBytes = %d\n", mvBytes);
  /*  printf(".............inbyte= %d\n", inbyte); */
  if(info.level!=1){
    for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){  /* coding loop */
      for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
	/*	printf("x = %d y = %d\n", X, Y);*/
	pos=Y*xnum+X;
	child_map_decode(&fmv[pos], meandepth, x, y, xblk, yblk, hor, ver, small, info);
      }
    }
  }  
  /*
  printf("done...................\n");*/
  /* coding loop */
  ardecode_init(num_symbol);
  for(y=0, Y=0 ; Y<ynum ; y+=yblk, Y++){
    pmvx=0.; pmvy=0.;           /* initialize to the zero per each row */

    for(x=0, X=0 ; X<xnum ; x+=xblk, X++){
      pos=Y*xnum+X;
      child_mv_decode_zero(&fmv[pos], &pmvx, &pmvy, num_symbol, subpel,
		      x, y, xblk, yblk, hor, ver);
    }
  }  
  ardecode_end();

  return mvBytes;
}
