#include "basic.h"
#include "usrinclude.h"
#define  EXTERN extern
#include "coderN.h"
#include "bmeN.h"
#define ANAL 0
#define SYN 1


int next_roundtrip_index(int curr_i, float *array, int length, int *direction)
{
  int next_i;

  if (*direction == 1) { /** --> **/
    if (curr_i == length - 1) {  /** last point **/
      next_i = MY_MAX(curr_i - 1, 0);
      *direction = -1;   /** reverse the direction **/
    }else {
      next_i = curr_i + 1;
    }
  }else if (*direction == -1) {  /**  <--- **/
    if (curr_i == 0) {  /** last point(on left) **/
      next_i = MY_MIN(curr_i + 1, length - 1);
      *direction = 1;
    }else {
      next_i = curr_i - 1;
    }
  }else {
    fprintf(stderr, "Roundtrip direction %d not allowed (-1,1 only)\n",
	    *direction);
    exit(-1);
  }

  return(next_i);
}


void extend_line(float *orig_line, int orig_len, int margin,
			  int algorithm, int flag, float *new_line)
{
  int i;
  int direction, orig_i;

  /** default to border repeat if length of signal is too short for 
      symmetrical extension **/
  /*if (orig_len < margin + 1 && algorithm == 2) {
    algorithm = 1;
  }*/


  /** copy original data within border **/
  for (i = 0; i < orig_len; i++) {
    new_line[i] = orig_line[i];
  }

  /** fill in left and righ extensions depending on algorithm **/
  switch(algorithm) {
  default:
    fprintf(stderr, "Line extension algorithm %d undefined\n", algorithm);
    exit(-1);
    break;
  case 1:         /* repeat border */
    if (flag == ANAL) {                /* analysis: just repeat */
      for (i = -margin; i < 0; i++) {
	new_line[i] = orig_line[0];
      }
      for (i = orig_len; i < orig_len + margin; i++) {
	new_line[i] = orig_line[orig_len - 1];
      }
    }else {                             /* synthesis: alternate 0's!! */
      
      if (orig_line[1] == 0.0 && orig_line[3] == 0.0) {
	for (i = -margin; i < 0; i++) {
	  if ( -i % 2) new_line[i] = 0.0;
	  else         new_line[i] = orig_line[0];
	}
      }else {
	for (i = -margin; i < 0; i++) {
	  if (-i % 2) new_line[i] = orig_line[1];
	  else        new_line[i] = 0.0;
	}
      }
      
      if (orig_line[orig_len - 1] == 0.0 && orig_line[orig_len - 3] == 0.0){
	for (i = orig_len; i < orig_len + margin; i += 2) {
	  new_line[i] = orig_line[orig_len - 2];
	}
	for (i = orig_len + 1; i < orig_len + margin; i += 2) {
	  new_line[i] = 0.0;
	}
      }else {
	for (i = orig_len + 1; i < orig_len + margin; i += 2) {
	  new_line[i] = orig_line[orig_len - 1];
	}
	for (i = orig_len; i < orig_len + margin; i += 2) {
	  new_line[i] = 0.0;
	}
      }
    }
    break;
  case 2:       /** symmetric extension: mirror **/
    if (flag == ANAL) {
      orig_i = 0;
      direction = 1;  /** start at point 0, going --> direction **/
      for (i = -1; i >= -margin; i--) {
	    orig_i = next_roundtrip_index(orig_i, orig_line, orig_len, &direction);
	    new_line[i] = orig_line[orig_i];
      }
      orig_i = orig_len - 1; 
      direction = -1;  /** start at point orig_leng - 1, going <-- **/
      for (i = orig_len; i < orig_len + margin; i++) {
	    orig_i = next_roundtrip_index(orig_i, orig_line, orig_len, &direction);
	    new_line[i] = orig_line[orig_i];
      }
    }
    else { /** synthesis, see p.41 fig (b) **/
      if (orig_len != 1) {
	    orig_i = 0;
	    direction = 1;  /** start at point 0, going --> direction **/
	    for (i = -1; i >= -margin; i--) {
	      orig_i = next_roundtrip_index(orig_i, orig_line, orig_len, &direction);
	      new_line[i] = orig_line[orig_i];
		}
	    orig_i = orig_len - 1; 
	    direction = -1;  /** start at point orig_leng - 1, going <-- **/
	    for (i = orig_len; i < orig_len + margin; i++) {
	      orig_i = next_roundtrip_index(orig_i, orig_line, orig_len, &direction);
	      new_line[i] = orig_line[orig_i];
		}
	  }else {
	    for (i = -1; i >= -margin; i--) {
	      new_line[i] = (-i % 2) ? 0.0 : orig_line[0];
		}
	    for (i = 1; i < orig_len + margin; i++) {
	      new_line[i] = (i % 2) ? 0.0 : orig_line[0];
		}
	  }
    }
    break;      
  }

}


void line_convolve(float *input, float *extension, int length, float *fco, int flength,
		     int analsyn_flag, float *output)
{
  int n, k, half_length;
  
  half_length = (flength - 1) / 2; /* assume odd length */

  /* printf("le = %d\n", length);*/
  extend_line(input, length, half_length, 2, 
			  analsyn_flag, extension );

  /* printf("len = %d\n", length); */

  /* printf("lendth = %d\n", length);*/
  for (n = 0; n < length; n++) {
    output[n] = 0.0;
    for (k = -half_length; k <= half_length; k++) {
      output[n] += extension[n + k] * fco[k];
    }
  }

}



/*
 * interpolate_filter
 * initialize filter coefficients for sub-pixel interpolation
 */
void interpolate_filter()
{
  FIR14[0] = -0.0110;
  FIR14[1] =  0.0452;
  FIR14[2] = -0.1437;
  FIR14[3] =  0.8950;
  FIR14[4] =  0.2777;
  FIR14[5] = -0.0812;
  FIR14[6] =  0.0233;
  FIR14[7] = -0.0053;

  FIR12[0] = FIR12[7] = -0.0105;
  FIR12[1] = FIR12[6] =  0.0465;
  FIR12[2] = FIR12[5] = -0.1525;
  FIR12[3] = FIR12[4] =  0.6165;
  
  FIR34[0] = -0.0053;
  FIR34[1] =  0.0233;
  FIR34[2] = -0.0812;
  FIR34[3] =  0.2777;
  FIR34[4] =  0.8950;
  FIR34[5] = -0.1437;
  FIR34[6] =  0.0452;
  FIR34[7] = -0.0110;

  FIR18[0] = FIR78[7] = -0.0072;
  FIR18[1] = FIR78[6] =  0.0284;
  FIR18[2] = FIR78[5] = -0.0902;
  FIR18[3] = FIR78[4] =  0.9742;
  FIR18[4] = FIR78[3] =  0.1249;
  FIR18[5] = FIR78[2] = -0.0380;
  FIR18[6] = FIR78[1] =  0.0105;
  FIR18[7] = FIR78[0] = -0.0026;

  FIR38[0] = FIR58[7] = -0.0117;
  FIR38[1] = FIR58[6] =   0.0505;
  FIR38[2] = FIR58[5] = -0.1624;
  FIR38[3] = FIR58[4] =  0.7713;
  FIR38[4] = FIR58[3] =  0.4465;
  FIR38[5] = FIR58[2] = -0.1224;
  FIR38[6] = FIR58[1] =  0.0363;
  FIR38[7] = FIR58[0] = -0.0081;
  


  FIR1hex[0] = FIR15hex[7] = -0.0039;
  FIR1hex[1] = FIR15hex[6] =  0.0156;
  FIR1hex[2] = FIR15hex[5] = -0.0497;
  FIR1hex[3] = FIR15hex[4] =  0.9941;
  FIR1hex[4] = FIR15hex[3] =  0.0584;
  FIR1hex[5] = FIR15hex[2] = -0.0181;
  FIR1hex[6] = FIR15hex[1] =  0.0049;
  FIR1hex[7] = FIR15hex[0] = -0.0013;

  FIR3hex[0] = FIR13hex[7] = -0.0095;
  FIR3hex[1] = FIR13hex[6] =  0.0383;
  FIR3hex[2] = FIR13hex[5] = -0.1215;
  FIR3hex[3] = FIR13hex[4] =  0.9409;
  FIR3hex[4] = FIR13hex[3] =  0.1985;
  FIR3hex[5] = FIR13hex[2] = -0.0595;
  FIR3hex[6] = FIR13hex[1] =  0.0168;
  FIR3hex[7] = FIR13hex[0] = -0.0040;

  FIR5hex[0] = FIR11hex[7] = -0.0117;
  FIR5hex[1] = FIR11hex[6] =  0.0492;
  FIR5hex[2] = FIR11hex[5] = -0.1571;
  FIR5hex[3] = FIR11hex[4] =  0.8380;
  FIR5hex[4] = FIR11hex[3] =  0.3610;
  FIR5hex[5] = FIR11hex[2] = -0.1026;
  FIR5hex[6] = FIR11hex[1] =  0.0300;
  FIR5hex[7] = FIR11hex[0] = -0.0068;

  FIR7hex[0] = FIR9hex[7] = -0.0113;
  FIR7hex[1] = FIR9hex[6] =  0.0495;
  FIR7hex[2] = FIR9hex[5] = -0.1605;
  FIR7hex[3] = FIR9hex[4] =  0.6968;
  FIR7hex[4] = FIR9hex[3] =  0.5322;
  FIR7hex[5] = FIR9hex[2] = -0.1393;
  FIR7hex[6] = FIR9hex[1] =  0.0420;
  FIR7hex[7] = FIR9hex[0] = -0.0094;



  /*FIR14[0] = -3. /256.;
  FIR14[1] =  12./256.;
  FIR14[2] = -37./256.;
  FIR14[3] = 229./256.;
  FIR14[4] =  71./256.;
  FIR14[5] = -21./256.;
  FIR14[6] =  6. /256.;
  FIR14[7] = -1. /256.;

  FIR12[0] = FIR12[7] = -0.04;
  FIR12[1] = FIR12[6] =  0.08;
  FIR12[2] = FIR12[5] = -0.17;
  FIR12[3] = FIR12[4] =  0.63;
  
  FIR34[0] = -1. /256.;
  FIR34[1] =  6. /256.;
  FIR34[2] = -21./256.;
  FIR34[3] =  71./256.;
  FIR34[4] = 229./256.;
  FIR34[5] = -37./256.;
  FIR34[6] =  12./256.;
  FIR34[7] = -3. /256.;*/

}

/*****************************************************************************/
/*                              FIRinterpolate                               */
/*****************************************************************************/
float FIRinterpolate(float fx, float fy, float *frame, int length, int hor, int ver)
{
  int    i, j, lx, ux, ly, uy;
  float  *temp, pixel, value; 
  int    len2;
  float  *FIRx, *FIRy;
  int    rx, ry; // IVB 2004/3/18



  temp = (float *) getarray(length, sizeof(float), "temp");
  len2 = length/2-1;

  lx = floor(fx); ux = ceil(fx);
  ly = floor(fy); uy = ceil(fy);

  // --- IVB 2004/3/18 -----------------
  //printf("%d\n",((int)(fx*16))%16);
  /*rx = ((int)(fx*16))%16;
  if (rx < 0)
	  //rx += 16;
	  rx = 0;

  switch(rx){ */
  // --- IVB 2004/3/18 -----------------
  switch(((int)(fx*16))%16){
      case 0:
		break;
	  case 1:
		FIRx=FIR1hex;
		break;
	  case 2:
		FIRx=FIR18;
		break;
	  case 3:
		FIRx=FIR3hex;
		break;
	  case 4:
		FIRx=FIR14;
		break;
	  case 5:
		FIRx=FIR5hex;
		break;
	  case 6:
		FIRx=FIR38;
		break;
	  case 7:
		FIRx=FIR7hex;
		break;
	  case 8:
		FIRx=FIR12;
		break;
	  case 9:
		FIRx=FIR9hex;
		break;
	  case 10:
		FIRx=FIR58;
		break;
	  case 11:
		FIRx=FIR11hex;
		break;
	  case 12:
		FIRx=FIR34;
		break;
	  case 13:
		FIRx=FIR13hex;
		break;
	  case 14:
		FIRx=FIR78;
		break;
	  case 15:
		FIRx=FIR15hex;
		break;
	  default:
		printf("motion vector error (bmeN.c)!\n");
		exit(1);
		break;
  }

  // --- IVB 2004/3/18 -----------------
  //printf("%d\n",((int)(fy*16))%16);
  /*ry = ((int)(fy*16))%16;
  if (ry < 0)
	  //ry += 16;
	  ry = 0;
  
  switch(ry){ */
  // --- IVB 2004/3/18 -----------------
  switch(((int)(fy*16))%16){
      case 0:
		break;
	  case 1:
		FIRy=FIR1hex;
		break;
	  case 2:
		FIRy=FIR18;
		break;
	  case 3:
		FIRy=FIR3hex;
		break;
	  case 4:
		FIRy=FIR14;
		break;
	  case 5:
		FIRy=FIR5hex;
		break;
	  case 6:
		FIRy=FIR38;
		break;
	  case 7:
		FIRy=FIR7hex;
		break;
	  case 8:
		FIRy=FIR12;
		break;
	  case 9:
		FIRy=FIR9hex;
		break;
	  case 10:
		FIRy=FIR58;
		break;
	  case 11:
		FIRy=FIR11hex;
		break;
	  case 12:
		FIRy=FIR34;
		break;
	  case 13:
		FIRy=FIR13hex;
		break;
	  case 14:
		FIRy=FIR78;
		break;
	  case 15:
		FIRy=FIR15hex;
		break;
	  default:
		printf("motion vector error (bmeN.c)!\n");
		exit(1);
		break;
  }


  pixel = 0.;
  for(i=0 ; i<length ; i++) temp[i]=0.;

  if(lx!=ux){
    if(ly!=uy) {

	  //horizontal interpolation

      for(i=0 ; i<length ; i++){ //vertical
		for(j=0 ; j<length ; j++){ //horizontal
	      if(ly-len2+i<0){
	        if     (lx-len2+j<0)     value = frame[0];
			else if(lx-len2+j>hor-1) value = frame[hor-1];
			else                     value = frame[(lx-len2+j)];
		  }
	      else if(ly-len2+i>ver-1) {
			if     (lx-len2+j<0)     value = frame[(ver-1)*hor];
	        else if(lx-len2+j>hor-1) value = frame[(ver-1)*hor+(hor-1)];
	        else                     value = frame[(ver-1)*hor+(lx-len2+j)];
		  }
	      else {
	        if     (lx-len2+j<0)     value = frame[(ly-len2+i)*hor];
	        else if(lx-len2+j>hor-1) value = frame[(ly-len2+i)*hor+(hor-1)];
	        else                    value = frame[(ly-len2+i)*hor+(lx-len2+j)];
		  }
	  
		  // IVB 2004/3/23 -----------
		  //temp[i] += value * FIRx[j];
		  if (temp[i] < Infinity && value < Infinity)
			  temp[i] += value * FIRx[j];
		  else
			  temp[i] = Infinity;
		  // IVB 2004/3/23 --- end ---
		}
	  }

	  //vertical interpolation

      for(i=0 ; i<length ; i++){
		  // IVB 2004/3/23 -----------
	      //pixel += temp[i] * FIRy[i];
		  if (pixel < Infinity && temp[i] < Infinity)
			  pixel += temp[i] * FIRy[i];
		  else
			  pixel = Infinity;
		// IVB 2004/3/23 --- end ---
      }
    }  /* if ly */
    else {
      for(j=0 ; j<length ; j++){
	if     (lx-len2+j<0)     value = frame[ly*hor];
	else if(lx-len2+j>hor-1) value = frame[ly*hor+(hor-1)];
	else                     value = frame[ly*hor+(lx-len2+j)];
	// IVB 2004/3/23 -----------
	//pixel += value * FIRx[j];
	if (pixel < Infinity && value < Infinity)
		pixel += value * FIRx[j];
	else
	    pixel = Infinity;
	// IVB 2004/3/23 --- end ---
      }
    }  /* if ly */
  }    /* if lx */
  else{
    if(ly!=uy) {
      for(i=0 ; i<length ; i++){
	if     (ly-len2+i<0)     value = frame[             lx];
	else if(ly-len2+i>ver-1) value = frame[(ver-1)*hor +lx];
	else                     value = frame[(ly-len2+i)*hor+lx];
	// IVB 2004/3/23 -----------
	//pixel += value * FIRy[i];
	if (pixel < Infinity && value < Infinity)
		pixel += value * FIRy[i];
	else
	    pixel = Infinity;
	// IVB 2004/3/23 --- end ---
      }
    }
    else pixel = frame[ly*hor+lx];
  }

  free(temp);
  return pixel;
}



/*****************************************************************************/
/*                               interpolate                                 */
/*****************************************************************************/
float interpolate(float fx, float fy, float *frame, int hor, int ver, int type)
{
  int x1, x2, y1, y2, pos11, pos12, pos21, pos22;
  float pixel; 

  /* spatial interpolation for half-pixel accurate */
  /*  motion-compensated temporal filtering */

  if(type==BILINEAR){   /* bilinear interpolation */
    x1=ceil(fx); x2=floor(fx);
    y1=ceil(fy); y2=floor(fy);
 
    if(x1>=hor || x2<0 || y1>=ver || y2<0){ /* Self-Test*/
      printf("error:x1=%d x2=%d y1=%d y2=%d hor=%d ver=%d(interpolate)\n", x1, x2, y1, y2, hor, ver);
      exit(1);
    }
 
    pos11 = y1*hor+x1; pos12 = y1*hor+x2;
    pos21 = y2*hor+x1; pos22 = y2*hor+x2;

    pixel = (frame[pos11]+frame[pos12]+frame[pos21]+frame[pos22])/4.;
  }
  else if(type==FIR88){ /* 8x8 FIR filter interpolation */
    pixel = FIRinterpolate(fx, fy, frame, 8, hor, ver);
  }
  else{
    printf("error in interpolate()\n");
    exit(1);
  }

  return pixel;
}

/*
 * Interpolate_frame
 * interpolate subpixels for sub-pixel accurate motion estimation
 */
void Interpolate_frame(float *frame, int hor, int ver, float **upframe, int *uph, int *upv, int subpel)
{
  int x, y, x0, y0, k, uphor, upver, scale;
  float *upsamp_x, *upsamp;

  if(subpel < 1 || subpel > 4){
	printf("subpel %d error\n", subpel);
	exit(1);
  }

  scale = 1 << subpel;

  uphor = *uph = (hor-1) * scale + 1;
  upver = *upv = (ver-1) * scale + 1;

  upsamp_x = (float *)getarray(uphor*ver, sizeof(float), "upsamp_x");
  upsamp = (float *)getarray(uphor*upver, sizeof(float), "upsamp");

  // horizontal
  for(y=0; y<ver; y++){
    for(x=0; x<hor-1; x++){
      x0 = x*scale;
      y0 = y;

      upsamp_x[y0*uphor + x0] = frame[y*hor+x];

	  for(k=1; k< scale; k++){
         upsamp_x[y0*uphor+(x0+k)] = interpolate((float)k/(float)scale+x,(float)y,frame,hor,ver,TYPE);
	  }

    }
    upsamp_x[y0*uphor+(hor-1)*scale] = frame[y*hor+hor-1];
  }

  // vertical
  for(x=0; x<uphor; x++){
    for(y=0; y<ver-1; y++){
      x0 = x;
      y0 = y*scale;

      upsamp[y0*uphor + x0] = upsamp_x[y*uphor+x];

	  for(k=1; k<scale; k++){
        upsamp[(y0+k)*uphor+x0] = interpolate((float)x,y+(float)k/(float)scale,upsamp_x,uphor,ver,TYPE);
	  }
    }
    upsamp[(ver-1)*scale*uphor+x0] = upsamp_x[(ver-1)*uphor+x];
  }

  free(upsamp_x);
  *upframe = upsamp;
}

/*void Interpolate_frame2(float *frame, int hor, int ver, float **upframe, int *uph, int *upv )
{
  int x, y, x0, y0, uphor, upver;
  float *upsamp;
  float half = 1./2.;

  uphor = *uph = (hor-1) * 2 + 1;
  upver = *upv = (ver-1) * 2 + 1;

  upsamp = (float *)getarray(uphor*upver, sizeof(float), "upsamp");
  for(y=0; y<ver-1; y++){
    for(x=0; x<hor-1; x++){
      x0 = x*2;
      y0 = y*2;
      upsamp[y0*uphor + x0] = frame[y*hor+x];
      upsamp[(y0+1)*uphor+(x0)] = interpolate((float)x,half+y,frame,hor,ver,TYPE);
      upsamp[(y0)*uphor+(x0+1)] = interpolate(half+x,(float)y,frame,hor,ver,TYPE);
      upsamp[(y0+1)*uphor+(x0+1)] = interpolate(half+x,half+y,frame,hor,ver,TYPE);

    }
  }

  y = ver-1;
  for(x = 0; x < hor-1; x++){
    x0 = x*2;
    y0 = y*2;
    upsamp[y0*uphor + x0] = frame[y*hor+x];
    //hx = 1; hy = 0;
    upsamp[y0*uphor+(x0+1)] = interpolate(half+x,(float)y,frame,hor,ver,TYPE);
  }

  x = hor-1;
  for(y = 0; y < ver-1; y++){
    x0 = x*2;
    y0 = y*2;
    upsamp[y0*uphor + x0] = frame[y*hor+x];
    //hx = 0; hy = 1;
    upsamp[(y0+1)*uphor+x0] = interpolate((float)x,half+y,frame,hor,ver,TYPE);
  }
  upsamp[uphor*upver-1] = frame[ver*hor-1];
  *upframe = upsamp;
}
void Interpolate_frame4(float *frame, int hor, int ver, float **upframe, int *uph, int *upv )
{
  int x, y, x0, y0, uphor, upver;
  float *upsamp_x, *upsamp;
  float quater=1./4., half = 2./4., quater3=3./4.;

  uphor = *uph = (hor-1) * 4 + 1;
  upver = *upv = (ver-1) * 4 + 1;

  upsamp_x = (float *)getarray(uphor*ver, sizeof(float), "upsamp_x");
  upsamp = (float *)getarray(uphor*upver, sizeof(float), "upsamp");

  for(y=0; y<ver; y++){
    for(x=0; x<hor-1; x++){
      x0 = x*4;
      y0 = y;
      upsamp_x[y0*uphor + x0] = frame[y*hor+x];
      upsamp_x[y0*uphor+(x0+1)] = interpolate(quater+x,(float)y,frame,hor,ver,TYPE);
      upsamp_x[y0*uphor+(x0+2)] = interpolate(half+x,(float)y,frame,hor,ver,TYPE);
      upsamp_x[y0*uphor+(x0+3)] = interpolate(quater3+x,(float)y,frame,hor,ver,TYPE);
    }
    upsamp_x[y0*uphor+(hor-1)*4] = frame[y*hor+hor-1];
  }

  for(x=0; x<uphor; x++){
    for(y=0; y<ver-1; y++){
      x0 = x;
      y0 = y*4;
      upsamp[y0*uphor + x0] = upsamp_x[y*uphor+x];
      upsamp[(y0+1)*uphor+x0] = interpolate((float)x,y+quater,upsamp_x,uphor,ver,TYPE);
      upsamp[(y0+2)*uphor+x0] = interpolate((float)x,y+half,upsamp_x,uphor,ver,TYPE);
      upsamp[(y0+3)*uphor+x0] = interpolate((float)x,y+quater3,upsamp_x,uphor,ver,TYPE);
    }
    upsamp[(ver-1)*4*uphor+x0] = upsamp_x[(ver-1)*uphor+x];
  }

  free(upsamp_x);
  *upframe = upsamp;
}*/
