
# Pull 512 kbps out of GOPs 0-1, 3-4, and 130 kbps out of GOP 2
pull moYGOP0.bit -r 512
pull moYGOP1.bit -r 512
pull moYGOP2.bit -r 130
pull moYGOP3.bit -r 512
pull moYGOP4.bit -r 512
pull moYGOP5.bit -r 512


# Decode GOP 0 with no concealment
3dsbcde_nc moYGOP0_512.bit moYdec%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP0.txt

# Decode GOP 1 with no concealment
3dsbcde_nc moYGOP1_512.bit moYdec%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP1.txt

# GOP 2 can be decoded in five different ways
# 1: --- No concealment ---
3dsbcde_nc moYGOP2_130.bit moYdec_nc%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP2_nc.txt
# 2: --- 1-dir replacement ---
#    First need to decode the next GOP (i.e., GOP 3) to generate the predicted temporal LL band of the current GOP with replacement
3dsbcde_r moYGOP3_512.bit moYdec%%03d c:\sequence\sif\mobile\mo%%03d psnr_moYGOP3.txt
#    Then decode GOP 2 with 1-directional replacement
3dsbcde_ec1r moYGOP2_130.bit moYdec_ec1r%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP2_ec1r.txt
# 3: --- 2-dir replacement ---
#    First decode previous GOP (i.e., GOP 1) with replacement 
3dsbcde_r moYGOP1_512.bit moYdec%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP1.txt
#    Copy the predicted frame to PredTemp
copy PredFrame2 PredTemp
#    Then decode the next GOP (i.e., GOP 3) to generate the predicted temporal LL band of the current GOP with replacement
3dsbcde_r moYGOP3_512.bit moYdec%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP3.txt
#    Copy PredTemp back to PredFrame2
copy PredTemp PredFrame2
#    Finally, decode the current GOP with bi-directional concealment 
3dsbcde_ec2r moYGOP2_130.bit moYdec_ec2r%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP2_ec2r.txt
# 4: --- 1-dir prediction ---
#    First need to decode the next GOP (i.e., GOP 3) to generate the predicted temporal LL band of the current GOP with prediction
3dsbcde_p moYGOP3_512.bit moYdec%%03d c:\sequence\sif\mobile\mo%%03d psnr_moYGOP3.txt
#    Then decode GOP 2 with 1-directional prediction
3dsbcde_ec1p moYGOP2_130.bit moYdec_ec1p%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP2_ec1p.txt
# 5: --- 2-dir replacement ---
#    First decode previous GOP (i.e., GOP 1) with prediction 
3dsbcde_p moYGOP1_512.bit moYdec%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP1.txt
#    Copy the predicted frame to PredTemp
copy PredFrame2 PredTemp
#    Then decode the next GOP (i.e., GOP 3) to generate the predicted temporal LL band of the current GOP with prediction
3dsbcde_p moYGOP3_512.bit moYdec%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP3.txt
#    Copy PredTemp back to PredFrame2
copy PredTemp PredFrame2
#    Finally, decode the current GOP with bi-directional concealment 
3dsbcde_ec2p moYGOP2_130.bit moYdec_ec2p%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP2_ec2p.txt

# GOP 3 was already decoded above
#3dsbcde_nc moYGOP3_512.bit moYdec%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP3.txt 

# Decode GOP 4 with no concealment
3dsbcde_nc moYGOP4_512.bit moYdec%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP4.txt

# Decode GOP 5 with no concealment
3dsbcde_nc moYGOP5_512.bit moYdec%%03d i:\sequence\sif\mobile\mo%%03d psnr_moYGOP5.txt

# Convert decoded frames to Sun rasterfile format
yuv2ras -s 352 240 0 0 moYdec%%03d moYdec%%03d.ras 1 32
yuv2ras -s 352 240 0 0 moYdec%%03d moYdec%%03d.ras 49 96
yuv2ras -s 352 240 0 0 moYdec_nc%%03d moYdec_nc%%03d.ras 33 48
yuv2ras -s 352 240 0 0 moYdec_ec1r%%03d moYdec_ec1r%%03d.ras 33 48
yuv2ras -s 352 240 0 0 moYdec_ec2r%%03d moYdec_ec2r%%03d.ras 33 48
yuv2ras -s 352 240 0 0 moYdec_ec1p%%03d moYdec_ec1p%%03d.ras 33 48
yuv2ras -s 352 240 0 0 moYdec_ec2p%%03d moYdec_ec2p%%03d.ras 33 48
