function MDLTPC_Lena_3578
% This program generates the results of MDLTPC for Lenna with D0=35.78dB.
% The base rate of the single description TDLT is 0.346 dB, achieved by lt96151_new.dat.
% Redundancy rate distortion summary:
% D1        R       Redundancy Ratio
% 29.63     0.401   16.02%   
% 27.94     0.380   9.88%
% 25.453    0.361   4.38%


%R* of single description TDLT: 0.346 bpp
dos('iencoder.exe c:\research\images\lena.pgm z.out lt96151_new.dat 30.113');
dos('idecoder.exe z.out dec.pgm lt96151_new.dat');
dos('imgcmp -f c:\research\images\lena.pgm -F dec.pgm -m psnr');
msg = dir('z.out');
Rstar = msg.bytes * 8 / 512 / 512;
disp(sprintf('R*=%f bpp\n', Rstar));

%MDC with D0 = 35.78 dB and D1 = 29.630 dB
MDLTPC_codec_2DES_new('c:\research\images\lena.pgm','mdpredictn8_1_2_new.dat',27.25,204.4);
msg00 = dir('MDLTPC_Zip_00.out');
msg01 = dir('MDLTPC_Zip_01.out');
msg10 = dir('MDLTPC_Zip_10.out');
msg11 = dir('MDLTPC_Zip_11.out');

%R = 0.401 bpp, 16.02%
R = (msg00.bytes + msg01.bytes + msg10.bytes + msg11.bytes) * 8 / 512 / 512;
disp(sprintf('R=%f bpp, redundancy is %f%%\n', R, (R - Rstar) / Rstar * 100));

%MDC with D0 = 35.78 dB and D1 = 27.94 dB
MDLTPC_codec_2DES_new('c:\research\images\lena.pgm','mdpredictn8_1_2_new.dat',27.25,333.5);
msg00 = dir('MDLTPC_Zip_00.out');
msg01 = dir('MDLTPC_Zip_01.out');
msg10 = dir('MDLTPC_Zip_10.out');
msg11 = dir('MDLTPC_Zip_11.out');

% R = 0.380 bpp, 9.88%: This rate includes the overhead at file header (12 bytes per file)
R = (msg00.bytes + msg01.bytes + msg10.bytes + msg11.bytes) * 8 / 512 / 512;
disp(sprintf('R=%f bpp, redundancy is %f%%\n', R, (R - Rstar) / Rstar * 100));

%R1 = 0: lowest redundancy
%MDC with D0 = 35.78 dB and D1 = 25.453 dB
MDLTPC_codec_2DES_new('c:\research\images\lena.pgm','mdpredictn8_1_2_new.dat',27.25,1e6);
msg00 = dir('MDLTPC_Zip_00.out');
msg01 = dir('MDLTPC_Zip_01.out');
msg10 = dir('MDLTPC_Zip_10.out');
msg11 = dir('MDLTPC_Zip_11.out');

% R = 0.3612 bpp, 4.38%
R = (msg00.bytes + msg01.bytes + msg10.bytes + msg11.bytes) * 8 / 512 / 512;
disp(sprintf('R=%f bpp, redundancy is %f%%\n', R, (R - Rstar) / Rstar * 100));