function MDLTPC_psnr_2DES_new
% Plot the image coding performance of various MDC algorithms at 1bpp (with fat subimage):
% Usage: MDLTPC_psnr_2DES_new
% Images used: Barb2, Boat, Baboon, Goldhill, Lena, peppers.
% Six methods are compared for each image:
% 1. MDLT-PC with 8x16 Wiener filter (N=8)
% 2. MDLT-PC with 8x2 Wiener filter (N=1)
% 3. TDLT-PC: use the coding gain optimized TDLT in single description coding (9.62dB)
% 4. DCT-PC: use DCT as the transform
% 5. MMDSQ by Chao Tian and S. Hemami.
% 6. The RD-MDC by Tillo et al.
% 
% Please see comments below for the parameters used in each case.
% They can be used to reproduce all results in the paper.
%
% Jie Liang, Simon Fraser University, Canada, jiel@sfu.ca, July 2008

global lt_88_1_2 lt_81_1_2 lt96151 dctonly chao_d1d0 olmo_d1d0;

if nargin == 0
    showtext = 0;
end
 
% Barb2:
% Data format in each row: D1, D0, q0, q1, r0, r1
% q0 and q1 can be used to reproduce the result. Example: 
%   MDLTPC_codec_2DES_new('barb2.pgm','mdpredictn8_1_2_new.dat',19, 96) generates the 4th result.
lt_88_1_2 = [
	  23.183,   38.359,   14.400, 1000000.000,    1.000,    0.001; ...      
	  25.741,   38.060,   15.150,  300.000,    0.962,    0.040; ...
	  27.402,   37.764,   16.000,  195.000,    0.921,    0.079; ...
	  30.374,   36.812,   19.000,   96.000,    0.808,    0.192; ...
	  31.802,   36.002,   22.000,   68.000,    0.722,    0.277; ...
	  32.928,   34.875,   27.000,   47.700,    0.615,    0.386; ...
	  33.358,   33.689,   33.500,   36.700,    0.516,    0.486; ...
];

%fixed on 20080722
lt_81_1_2 = [
	  22.819,   38.394,   14.800, 1000000.000,    0.999,    0.001; ...
	  27.174,   37.721,   16.730,  195.000,    0.910,    0.090; ...
	  29.510,   37.001,   19.040,  115.000,    0.824,    0.176; ...      
	  31.228,   36.172,   22.250,   78.000,    0.733,    0.268; ...      
	  32.390,   35.206,   26.500,   57.000,    0.640,    0.360; ...      
	  33.063,   34.031,   32.700,   43.000,    0.542,    0.460; ...      
];      


lt96151 = [
	  22.399,   38.222,   16.050, 1000000.000,    0.999,    0.001; ...
	  26.039,   37.801,   17.250,  300.000,    0.946,    0.055; ...
 	  28.439,   37.281,   19.000,  167.000,    0.879,    0.122; ...
	  30.752,   36.414,   22.300,   97.000,    0.780,    0.222; ...
	  32.162,   35.470,   26.500,   67.000,    0.683,    0.318; ...
	  33.007,   34.322,   32.600,   49.000,    0.580,    0.420; ...            
];

% Fixed 20080722, W has 2 columns of nonzero only, W1 one column (all 1). Diff by 0.0* dB only
dctonly = [
	  24.387,   36.638,   16.250, 1000000.000,    1.000,    0.001; ...
	  25.234,   36.425,   16.800,  248.000,    0.975,    0.024; ...
	  27.573,   35.650,   19.100,  125.000,    0.887,    0.111; ...
	  29.369,   34.654,   22.600,   82.000,    0.781,    0.214; ...      
	  30.588,   33.614,   26.900,   60.000,    0.683,    0.311; ...      
	  31.323,   32.351,   33.400,   45.000,    0.574,    0.419; ...      
      ];    

%chao tian: max d0: 36.77dB, d1: 15.6dB
chao_d1d0 = [ ...
        21.860  21.754   36.71; %Q: 120
        24.019  24.022   36.30; %q=60
        25.903  25.885   35.86; %q=40
        27.451  27.470   35.47; %q=30
        29.768  29.830   34.82; %q=20
%       30.730  30.769   34.30; %q=17
        31.096  31.125,  34.25; %q=16
];

%olmo_d1 = [27.7133   29.6678   30.7882   31.4277   31.7759   31.9396   32.1803];
%olmo_d0 = [36.0738   35.2375   34.6016   34.0567   33.4746   33.0128   32.6162];
olmo_d1d0  = [
   36.0738   35.2375   34.6016   34.0567   33.4746   33.0128   32.6162 
   27.5969   29.5980   31.1411   31.6777   31.9745   32.0526   32.3416 
   27.8297   29.7376   30.4353   31.1776   31.5772   31.8267   32.0189 
];

plot_psnr_new(showtext, 'Barbara');

%boat: 
lt_88_1_2 = [
	  24.830,   39.682,   12.070, 1000000.000,    0.999,    0.001; ...
	  29.605,   39.177,   13.200,  158.000,    0.930,    0.069; ...
	  32.015,   38.500,   14.850,   84.000,    0.846,    0.154; ...
	  33.625,   37.701,   17.200,   54.800,    0.750,    0.249; ...
	  34.534,   36.872,   20.000,   41.000,    0.666,    0.335; ...
	  35.127,   35.324,   26.600,   28.500,    0.526,    0.476; ...
];

lt_81_1_2 = [
	  24.595,   39.777,   12.300, 1000000.000,    1.002,    0.001; ...
	  28.632,   39.373,   13.200,  203.000,    0.947,    0.052; ...
	  31.474,   38.686,   14.900,   97.000,    0.859,    0.140; ...
	  33.345,   37.856,   17.300,   60.000,    0.761,    0.240; ...      
	  34.250,   37.134,   19.800,   46.000,    0.684,    0.316; ...      
	  34.927,   36.154,   23.700,   35.000,    0.590,    0.413; ...      
];

lt96151= [
	  23.845,   39.612,   13.300, 1000000.000,    1.000,    0.001; ...
	  29.532,   38.979,   14.860,  169.000,    0.917,    0.084; ...      
	  32.176,   38.173,   17.200,   87.000,    0.816,    0.185; ...
	  33.516,   37.449,   19.700,   61.000,    0.734,    0.270; ...      
	  34.435,   36.509,   23.400,   45.000,    0.640,    0.361; ...
	  34.913,   35.548,   28.000,   35.000,    0.553,    0.453; ...      
    ];

dctonly = [ %20080722
	  27.165,   38.901,   12.100, 1000000.000,    0.998,    0.001; ...
	  30.583,   38.344,   13.300,  104.000,    0.926,    0.076; ...
	  32.355,   37.637,   15.000,   63.000,    0.841,    0.158; ...
	  33.568,   36.797,   17.300,   44.000,    0.750,    0.251; ...
	  34.183,   35.984,   19.950,   35.000,    0.669,    0.331; ...
      
	  34.508,   35.096,   23.300,   28.500,    0.585,    0.414; ...
];

%chao tian
chao_d1d0 = [ ...
    22.585  22.663,  39.06;  %q=150
    24.805  24.866,  38.98;  %q=80
    25.904  26.016,  38.93;  %q=60
    29.005  29.006,  38.48;  %q=30
    31.003  30.999,  38.01;  %q=20
    32.486  32.494,  37.40;  %q=15
];

%olmo_d1 = [30.3886   32.2811   33.3502   33.8523   34.1907   34.3169   34.5074];
%olmo_d0 = [38.3079   37.5449   36.8823   36.2471   35.7409   35.2695   34.9186];
olmo_d1d0 = [
    38.3079   37.5449   36.8823   36.2471   35.7409   35.2695   34.9186
   29.6581   32.1330   33.3428   33.8520   34.3160   34.5988   34.6734 
   31.1192   32.4293   33.3576   33.8527   34.0654   34.0351   34.3414 
];

plot_psnr_new(showtext, 'Boat');

%baboon: 1bpp
lt_88_1_2 = [
	  21.212,   29.497,   36.500, 1000000.000,    0.999,    0.001; ...      
	  22.409,   29.169,   38.400,  279.000,    0.950,    0.049; ...
	  23.617,   28.661,   41.700,  176.000,    0.874,    0.130; ...      
	  24.665,   27.865,   47.500,  123.000,    0.763,    0.240; ...      
	  25.223,   27.220,   52.900,   99.000,    0.676,    0.327; ...      
	  25.702,   25.986,   66.300,   73.000,    0.521,    0.482; ...      
];

lt_81_1_2 = [
	  20.842,   29.503,   37.600, 1000000.000,    1.000,    0.001; ...    
%	  21.347,   29.406,   38.200,  447.000,    0.985,    0.017; ...
	  22.966,   28.842,   41.800,  214.000,    0.900,    0.103; ...
	  24.195,   28.060,   47.500,  143.000,    0.789,    0.211; ...
	  24.877,   27.431,   52.800,  113.000,    0.704,    0.299; ...
	  25.278,   26.876,   58.000,   96.000,    0.633,    0.373; ...
	  25.554,   26.182,   66.000,   81.000,    0.545,    0.460; ...            
];

lt96151 = [
	  20.484,   29.296,   40.700, 1000000.000,    1.001,    0.001; ...    
	  21.453,   29.111,   41.900,  428.000,    0.972,    0.030; ...
	  23.353,   28.369,   47.400,  204.000,    0.862,    0.140; ...
	  24.261,   27.726,   52.800,  149.000,    0.773,    0.229; ...
	  24.815,   27.171,   58.200,  122.000,    0.697,    0.305; ...
	  25.283,   26.444,   66.400,   98.000,    0.601,    0.400; ...      
];

dctonly = [   
	  22.260,   29.041,   34.700, 1000000.000,    1.000,    0.001; ...
      23.469,   28.404,   38.300,  154.000,    0.905,    0.096; ...
	  24.236,   27.806,   42.100,  116.000,    0.819,    0.182; ...
      24.861,   27.054,   47.600,   91.000,    0.715,    0.286; ...      
	  25.186,   26.421,   53.000,   78.000,    0.634,    0.366; ...
	  25.346,   25.876,   58.200,   69.000,    0.566,    0.437; ...
];

%chao tian
chao_d1d0 = [ ...
    19.332  19.523,  29.14;  %q=150
    20.053 20.216,  29.09;  %q=100
%   20.610  20.747,  28.98;  %q=80
    21.219  21.339,  28.91;  %q=65
    22.378  22.396,  28.63;  %q=48
%   23.174  23.170,  28.25;  %q=40
    23.411  23.401, 28.17;   %q=38
%   23.791  23.793,  28.03;  %q=35
    24.241  24.236,  27.81;  %q=32
];

%olmo_d1 = [23.6575   24.5013   24.9023   25.1689   25.3653   25.4602   25.5502];
%olmo_d0 = [28.2763   27.6563   27.2650   26.9048   26.5238   26.1512   25.8439];
olmo_d1d0 = [
   28.2763   27.6563   27.2650   26.9048   26.5238   26.1512   25.8439
   23.5178   24.9669   25.5138   25.2875   25.3904   25.5226   25.5836
   23.7973   24.0358   24.2908   25.0504   25.3403   25.3978   25.5167
];

plot_psnr_new(showtext, 'Baboon');

%goldhill: 1bpp
lt_88_1_2 = [
	  26.755,   36.952,   15.200, 1000000.000,    0.999,    0.001; ...    
	  29.839,   36.604,   16.100,  135.000,    0.943,    0.060; ...      
	  31.622,   36.012,   17.800,   72.000,    0.850,    0.153; ...
	  32.412,   35.504,   19.500,   54.000,    0.773,    0.228; ...
	  33.008,   34.914,   21.800,   42.000,    0.688,    0.312; ...
	  33.383,   34.256,   24.700,   34.000,    0.600,    0.404; ...      
%	  33.497,   33.569,   28.400,   29.000,    0.516,    0.486; ...      
];

lt_81_1_2 = [
	  26.597,   36.988,   15.600, 1000000.000,    1.001,    0.001; ...
	  28.533,   36.818,   16.050,  216.000,    0.974,    0.029; ...      
	  30.981,   36.202,   17.800,   88.000,    0.876,    0.125; ...      
	  32.006,   35.683,   19.500,   62.000,    0.796,    0.205; ...
	  32.806,   35.036,   22.000,   46.000,    0.702,    0.300; ...
	  33.244,   34.352,   25.050,   37.000,    0.610,    0.390; ...
	  33.427,   33.637,   28.800,   31.000,    0.523,    0.477; ...      
];

lt96151 = [
	  25.783,   36.835,   16.800, 1000000.000,    0.999,    0.001; ...
	  29.132,   36.502,   17.800,  178.000,    0.944,    0.055; ...
	  30.992,   35.979,   19.500,   94.000,    0.860,    0.140; ...      
	  32.150,   35.367,   21.900,   63.000,    0.767,    0.235; ...      
	  32.854,   34.658,   25.000,   47.000,    0.668,    0.335; ...
	  33.307,   33.521,   31.500,   34.000,    0.523,    0.481; ...
];

dctonly = [
	  28.659,   36.301,   14.900, 1000000.000,    0.998,    0.001; ...
	  30.844,   35.808,   16.150,   79.000,    0.920,    0.079; ...
	  31.801,   35.301,   17.600,   54.000,    0.844,    0.157; ...
	  32.421,   34.756,   19.350,   42.000,    0.764,    0.236; ...
	  32.990,   33.627,   23.750,   30.000,    0.613,    0.387; ...
%	  33.038,   33.035,   26.600,   26.500,    0.542,    0.458; ...
];

%chao tian
chao_d1d0 = [ ...
    22.570  22.689,  36.59;  %q=200
    24.507  24.578,  36.54;  %q=100
    25.581  25.638,  36.48;  %q=70
%    26.063 26.110,  36.41;  %q=60
    27.992  27.953,  36.25;  %q=35
    28.585  28.549,  36.11;  %q=30
    30.232  30.263,  35.75;  %q=20
];

% first point (9,72), side PSNR: 29.61, 30.99, 1.4 dB difference.
%olmo_d1 = [30.3045   31.7956   32.3611   32.7242   32.8981   33.0424   33.1762];
%olmo_d0 = [35.7854   35.2604   34.7688   34.3376   33.9594   33.7206   33.4752];
olmo_d1d0 = [
   35.7854   35.2604   34.7688   34.3376   33.9594   33.7206   33.4752
   29.6142   32.0745   32.6043   32.9684   33.0083   33.1293   33.1774
   30.9947   31.5167   32.1178   32.4800   32.7878   32.9555   33.1751
];

plot_psnr_new(showtext, 'Goldhill');

%lena: 1bpp
lt_88_1_2 = [
	  25.640,   40.457,    9.780, 1000000.000,    1.000,    0.001; ...    
	  30.104,   40.242,   10.150,  200.000,    0.960,    0.042; ...
      32.452,   40.000,   10.600,  107.000,    0.915,    0.090; ...
	  34.723,   39.556,   11.550,   58.000,    0.832,    0.171; ...      
	  36.731,   38.588,   14.100,   29.000,    0.670,    0.330; ...
	  37.323,   37.392,   18.500,   19.000,    0.510,    0.492; ...      
];

lt_81_1_2 = [
	  25.451,   40.508,   10.000, 1000000.000,    1.000,    0.001; ...
	  31.294,   40.186,   10.600,  141.000,    0.936,    0.070; ...      
	  33.965,   39.732,   11.550,   71.000,    0.852,    0.149; ...      
	  35.563,   39.246,   12.700,   45.000,    0.767,    0.235; ...      
	  36.507,   38.723,   14.200,   32.000,    0.679,    0.322; ...      
	  37.052,   38.169,   16.100,   25.000,    0.597,    0.405; ...      
];

lt96151 = [
	  24.401,   40.367,   10.750, 1000000.000,    1.001,    0.001; ...
	  31.360,   39.964,   11.600,  153.000,    0.924,    0.077; ...      
	  34.205,   39.492,   12.700,   73.000,    0.837,    0.165; ...      
	  35.702,   38.985,   14.150,   46.000,    0.748,    0.254; ...
	  36.586,   38.459,   15.900,   33.000,    0.661,    0.342; ...      
	  37.082,   37.781,   18.600,   25.000,    0.563,    0.438; ...      
];

dctonly = [
	  28.481,   39.881,    9.640, 1000000.000,    0.999,    0.001; ...
	  33.182,   39.349,   10.620,   71.000,    0.903,    0.098; ...
	  34.750,   38.903,   11.550,   45.000,    0.829,    0.174; ...
	  35.663,   38.418,   12.700,   33.000,    0.753,    0.247; ...
	  36.258,   37.892,   14.100,   26.000,    0.678,    0.321; ...
	  36.582,   37.347,   15.800,   21.500,    0.608,    0.392; ...
%	  36.677,   36.863,   17.500,   19.000,    0.553,    0.449; ...
];

%chao tian, same 1st tage rate as in his paper
chao_d1d0 = [ ...
    27.214  27.150   40.31; %q=65
    30.608  30.621,  40.04; %q=30
    32.509  32.413,  39.76; %q=20
    34.412  34.442,  39.49; %q=13
    35.586  35.623   39.23; %q=10    
    36.609  36.604,  38.91; %q=8
];

%olmo_d1 = [32.8684   35.0387   36.1053   36.6316      36.9536   37.1372];
%olmo_d0 = [39.4947   39.0571   38.7329   38.3823      37.6874   37.4388];
olmo_d1d0 = [
   39.4947   39.0571   38.7329   38.3823   37.9968   37.6874   37.4388  
   32.6350   35.1927   36.3065   36.8898   36.9976   36.9941   37.2008  
   33.1018   34.8848   35.9042   36.3733   36.6577   36.9130   37.0736  
];

plot_psnr_new(showtext, 'Lena');

%peppers: 1bpp
lt_88_1_2 = [
	  25.893,   38.255,   12.450, 1000000.000,    1.002,    0.001; ...
      31.203,   37.947,   13.100,  144.000,    0.945,    0.057; ...
	  33.583,   37.500,   14.150,   65.000,    0.860,    0.143; ...      
	  34.699,   37.006,   15.500,   40.000,    0.767,    0.235; ...      
	  35.430,   36.108,   18.700,   25.000,    0.604,    0.399; ...      
	  35.516,   35.582,   21.100,   21.500,    0.518,    0.485; ...      
];

lt_81_1_2 = [
	  25.878,   38.293,   12.750, 1000000.000,    1.003,    0.001; ...
	  29.767,   38.121,   13.100,  225.000,    0.970,    0.034; ...
	  32.914,   37.653,   14.200,   82.000,    0.881,    0.119; ...
	  34.448,   37.125,   15.600,   45.000,    0.782,    0.221; ...
	  35.114,   36.611,   17.300,   32.000,    0.686,    0.318; ...      
	  35.403,   36.129,   19.200,   26.000,    0.599,    0.402; ...      
	  35.506,   35.646,   21.500,   22.500,    0.519,    0.483; ...      
];

lt96151= [
	  24.666,   38.109,   13.650, 1000000.000,    0.999,    0.001; ...
	  30.163,   37.876,   14.200,  211.000,    0.953,    0.049; ...
	  33.378,   37.360,   15.600,   75.000,    0.850,    0.152; ...
	  34.618,   36.822,   17.300,   44.000,    0.746,    0.255; ...
	  35.130,   36.371,   19.100,   33.000,    0.658,    0.342; ...
	  35.403,   35.800,   21.800,   26.000,    0.556,    0.446; ...      
];    

dctonly = [
	  28.687,   37.762,   12.080, 1000000.000,    0.999,    0.001; ...
	  32.825,   37.280,   13.100,   71.000,    0.908,    0.092; ...
	  34.106,   36.834,   14.200,   42.000,    0.824,    0.176; ...
	  34.658,   36.486,   15.200,   32.000,    0.759,    0.243; ...
	  35.033,   35.975,   16.800,   25.000,    0.669,    0.333; ...
	  35.197,   35.322,   19.400,   20.400,    0.559,    0.441; ...
    ];

%chao tian
chao_d1d0 = [ ...
    29.352  29.128   38.11; %q=40
    30.575  30.441,  38.04;  %q=30
    32.165  32.190   37.81; %q=20
    33.244  33.239,  37.51;  %q=15
    34.698  34.723   37.16; %q=10
    35.082  34.997   36.95; %q=9
];

%olmo_d1 = [32.5653   34.3186   35.0731   35.4111   35.5415   35.6428   35.7507   ];
%olmo_d0 = [37.6207   37.2156   36.8549   36.5887   36.3262   36.1538   35.9533   ];
olmo_d1d0 = [
   37.6207   37.2156   36.8549   36.5887   36.3262   36.1538   35.9533 
   32.2362   34.2943   35.1599   35.5065   35.6458   35.7350   35.8392 
   32.8944   34.3429   34.9862   35.3158   35.4372   35.5505   35.6622 
];

plot_psnr_new(showtext, 'Peppers');
