function MDLTPC_psnr_2DES_new_025
% Plot the image coding performance of various MDC algorithms at 0.25 bpp (with fat subimage):
% Usage: MDLTPC_psnr_2DES_new
% Images used: Barb2, Boat, Baboon, Goldhill, Lena, peppers.
% Six methods are compared for each image:
% 1. MDLT-PC with 8x16 Wiener filter (N=8)
% 2. MDLT-PC with 8x2 Wiener filter (N=1)
% 3. TDLT-PC: use the coding gain optimized TDLT in single description coding (9.62dB)
% 4. DCT-PC: use DCT as the transform
% 5. MMDSQ by Chao Tian and S. Hemami.
% 6. The RD-MDC by Tillo et al.
% 
% Please see comments below for the parameters used in each case.
% They can be used to reproduce all results in the paper.
%
% Jie Liang, Simon Fraser University, Canada, jiel@sfu.ca, July 2008

global lt_88_1_2 lt_81_1_2 lt96151 dctonly chao_d1d0;
global olmo_d1d0;

%barb2
% data format in each row: D1, D0, q0, q1, r0, r1
lt_88_1_2 = [
	  22.675,   29.272,   76.500, 1000000.000,    0.250,    0.001; ...
	  24.213,   28.629,   86.000,  366.000,    0.222,    0.029; ...
	  24.821,   28.285,   92.000,  293.000,    0.207,    0.043; ...
	  25.552,   27.517,  107.000,  210.000,    0.178,    0.072; ...
	  25.806,   26.929,  120.500,  178.000,    0.158,    0.092; ...
	  25.951,   26.134,  142.000,  148.000,    0.132,    0.118; ...
];

lt_81_1_2 = [
	  22.396,   29.199,   79.700, 1000000.000,    0.249,    0.001; ...
	  24.026,   28.513,   90.500,  360.000,    0.219,    0.032; ...      
	  24.585,   28.127,   97.500,  293.000,    0.204,    0.046; ...
	  25.346,   27.259,  116.000,  210.000,    0.170,    0.081; ...
	  25.557,   26.591,  131.000,  180.000,    0.150,    0.101; ...
	  25.611,   25.928,  150.000,  158.000,    0.130,    0.120; ...      
];      
      
lt96151 = [
	  22.018,   29.118,   86.000, 1000000.000,    0.250,    0.001; ...
	  24.228,   28.333,  100.500,  390.000,    0.213,    0.037; ...
	  25.152,   27.692,  115.000,  275.000,    0.187,    0.064; ...
	  25.449,   27.229,  125.000,  236.000,    0.171,    0.079; ...      
	  25.692,   26.677,  141.000,  200.000,    0.152,    0.098; ...
	  25.799,   25.936,  163.000,  170.000,    0.131,    0.120; ...            
];

dctonly = [
	  23.239,   27.208,   81.000, 1000000.000,    0.249,    0.001; ...
	  23.901,   26.675,   89.500,  250.000,    0.223,    0.027; ...
	  24.280,   26.228,   98.100,  200.000,    0.201,    0.049; ...
	  24.634,   25.466,  113.500,  155.000,    0.167,    0.083; ...
	  24.663,   25.133,  121.500,  145.000,    0.155,    0.095; ...
];    

%chao tian
chao_d1d0 = [ ...
%    13.386 13.386,  27.96;  %q=10000
    20.553  20.644,  27.78;  %q=200
	21.860  21.754,  27.69;  %q=120
    22.318  22.210,  27.54;  %q=100
    22.616  22.525,  27.43;  %q=90
    23.425  23.390   26.93;  %q=70
    24.019  24.022,  26.66;  %q=60
];

% Parameters for RD-MDC: r0 = [33, 34, 37:4:64]; r1 = [1056 544 237 146 111 92 81 73 67];
olmo_d1d0 = [
   28.1795   28.00  27.6422   27.1182   26.7419   26.3924   26.0087   25.7455   
   17.3392   22.34  23.5330   24.1681   24.8659   25.1652   25.2340   25.3203   
   22.4903   22.70  24.4873   24.7438   25.0571   25.2172   25.3107   25.2944   
];

plot_psnr_new(showtext, 'Barbara');

%boat: 
lt_88_1_2 = [
	  24.303,   31.060,   60.000, 1000000.000,    0.249,    0.001; ...
	  25.955,   30.638,   65.000,  375.000,    0.230,    0.020; ...
	  26.817,   30.315,   69.000,  260.000,    0.216,    0.035; ...
	  27.386,   29.960,   75.000,  200.000,    0.199,    0.051; ...
	  27.836,   29.406,   83.000,  155.000,    0.178,    0.073; ...
	  28.096,   28.146,  108.000,  110.000,    0.135,    0.115; ...      
];

lt_81_1_2 = [
	  24.150,   31.083,   61.400, 1000000.000,    0.249,    0.001; ...
	  25.906,   30.670,   66.600,  375.000,    0.230,    0.021; ...
	  26.736,   30.371,   71.000,  265.000,    0.215,    0.036; ...
	  27.235,   30.014,   76.000,  210.000,    0.200,    0.050; ...
	  27.667,   29.537,   83.400,  170.000,    0.181,    0.069; ...
	  28.031,   28.159,  110.500,  115.000,    0.135,    0.115; ...      
];

lt96151= [
	  23.470,   30.935,   68.000, 1000000.000,    0.250,    0.001; ...    
	  25.827,   30.440,   75.500,  400.000,    0.225,    0.026; ...      
	  26.566,   30.116,   80.500,  300.000,    0.210,    0.040; ...
	  27.427,   29.425,   92.000,  200.000,    0.183,    0.068; ...
	  27.817,   28.523,  110.000,  150.000,    0.152,    0.098; ...
	  27.908,   27.981,  125.000,  130.000,    0.133,    0.117; ...      
    ];

dctonly = [
	  25.821,   30.067,   58.500, 1000000.000,    0.249,    0.001; ...
	  26.079,   29.989,   59.500,  350.000,    0.245,    0.005; ...
	  26.524,   29.752,   62.000,  250.000,    0.234,    0.016; ...
	  27.379,   29.120,   71.000,  150.000,    0.203,    0.048; ...
	  27.601,   28.434,   81.000,  120.000,    0.178,    0.072; ...
	  27.647,   28.121,   86.700,  110.000,    0.166,    0.084; ...
];

%chao tian
chao_d1d0 = [ ...
    18.513  19.248,  31.05;  %q=500
    20.368  20.673,  30.94;  %q=300
    22.585  22.663,  30.82;  %q=150
    24.805  24.866,  30.53;  %q=80
    26.655  26.790,  30.05;  %q=50
];

%olmo_d1 = [19.8835  23.7786 24.9359 25.9571   26.8922   27.5376   27.7753   27.9041];
%olmo_d0 = [30.8603  30.7385 30.5602 30.3115   29.8091   29.4907   29.1058   28.6624];
olmo_d1d0 = [
   30.8603  30.7385  30.3115   29.8091   29.4907   29.1058   28.6624   28.4193   28.1021
   22.9991  23.8173  26.0223   26.7392   27.4497   27.9230   27.8527   28.0166   28.1021
   16.7680  23.7400  25.8919   27.0453   27.6254   27.6276   27.9556   28.0268   27.9054
];

plot_psnr_new(showtext, 'Boat');


%baboon: 0.25 bpp
lt_88_1_2 = [
	  20.292,   23.256,  116.500, 1000000.000,    0.249,    0.001; ...
	  20.736,   22.998,  123.500,  385.000,    0.229,    0.022; ...
	  20.914,   22.838,  127.800,  324.000,    0.216,    0.034; ...      
	  21.242,   22.459,  140.000,  250.000,    0.186,    0.064; ...
      21.343,   22.198,  149.000,  225.000,    0.169,    0.081; ...
	  21.479,   21.859,  163.500,  195.000,    0.144,    0.106; ...
%	  21.499,   21.616,  174.000,  182.000,    0.130,    0.121; ...      
];

lt_81_1_2 = [
	  20.056,   23.228,  120.500, 1000000.000,    0.249,    0.001; ...
	  20.518,   22.973,  127.500,  418.000,    0.229,    0.021; ...
	  20.779,   22.787,  133.000,  340.000,    0.214,    0.037; ...
	  21.156,   22.302,  149.000,  251.000,    0.178,    0.072; ...
	  21.403,   21.734,  172.000,  200.000,    0.139,    0.112; ...
	  21.444,   21.593,  180.000,  190.000,    0.128,    0.122; ...      
];

lt96151 = [
	  19.740,   23.054,  134.000, 1000000.000,    0.249,    0.001; ...
	  20.571,   22.648,  148.000,  400.000,    0.215,    0.036; ...
	  20.869,   22.396,  157.900,  330.000,    0.194,    0.055; ...
	  21.059,   22.090,  170.000,  280.000,    0.173,    0.077; ...
	  21.249,   21.676,  190.500,  235.000,    0.145,    0.105; ...
	  21.314,   21.450,  204.700,  215.000,    0.128,    0.122; ...      
];

dctonly = [   
	  20.778,   22.814,  105.200, 1000000.000,    0.249,    0.001; ...
	  20.956,   22.632,  109.700,  280.000,    0.233,    0.017; ...
	  21.162,   22.246,  119.700,  211.000,    0.202,    0.048; ...
	  21.286,   21.735,  135.300,  171.000,    0.164,    0.086; ...
%	  21.301,   21.455,  144.800,  158.000,    0.145,    0.105; ...
%	  21.296,   21.295,  150.500,  153.000,    0.135,    0.115; ...
];

%chao tian
chao_d1d0 = [ ...
    18.769  18.819,  23.28;  %q=250
    19.332  19.523,  23.15;  %q=150   
    20.053, 20.216  22.91;  %q=100
    20.610  20.747  22.82;  %q=80
    20.997  21.109,  22.71;  %q=70
];

%r0 = 33:4:64;
%r1 = [1056 237 146 111 92 81 73 67];
%olmo_d1 = [19.4052   21.1995   21.4277   21.4966   21.6083   21.6460   21.6354   21.6437];
%olmo_d0 = [23.0421   22.8322   22.5539   22.3416   22.2060   22.0208   21.8213   21.7548];
%olmo_d1 = [19.4052 20.75  21.1995   21.4277   21.6083   21.6460];
%olmo_d0 = [23.0421 23.04  22.8322   22.5539   22.2060   22.0208];
olmo_d1d0 = [
   23.0421   23.0421    22.8322   22.5539   22.3416   22.2060   22.0208   21.8213
   18.0951   20.8924    21.1110   21.5277   21.4649   21.5185   21.6699   21.6494
   20.7141   20.6217    21.2880   21.3276   21.5284   21.6980   21.6220   21.6215
];

%(32,1500), (34,544), (34,490), 
%olmo_d1 = [18.44 20.75    21.40   21.59   21.69];
%olmo_d0 = [23.16 23.04    22.65   22.24   21.69];

plot_psnr_new(showtext, 'Baboon');

%goldhill: 0.25 bpp
lt_88_1_2 = [
	  26.013,   30.661,   54.200, 1000000.000,    0.249,    0.001; ...
	  27.228,   30.379,   58.000,  260.000,    0.230,    0.020; ...
	  27.779,   30.116,   62.000,  187.000,    0.215,    0.036; ...
	  28.193,   29.739,   68.000,  141.000,    0.193,    0.057; ...
	  28.423,   29.327,   75.000,  116.000,    0.172,    0.079; ...
	  28.528,   28.753,   86.900,   96.000,    0.145,    0.106; ...      
];

lt_81_1_2 = [
	  25.948,   30.659,   55.600, 1000000.000,    0.249,    0.001; ...
	  27.096,   30.378,   59.600,  270.000,    0.230,    0.020; ...
	  27.629,   30.142,   63.300,  195.000,    0.216,    0.034; ...
	  28.014,   29.853,   68.000,  155.000,    0.198,    0.052; ...
	  28.358,   29.317,   77.000,  120.000,    0.171,    0.079; ...
	  28.485,   28.767,   88.500,  100.000,    0.145,    0.105; ...      
];

lt96151 = [
	  25.244,   30.569,   61.400, 1000000.000,    0.249,    0.001; ...
	  26.895,   30.212,   67.000,  300.000,    0.225,    0.025; ...
	  27.541,   29.943,   72.000,  214.000,    0.208,    0.042; ...
	  27.901,   29.666,   77.000,  174.000,    0.192,    0.058; ...
	  28.054,   29.3830   82.000,  152.000,    0.179,    0.071; ...      
	  28.372,   28.593,  101.000,  112.000,    0.139,    0.111; ...      
];

dctonly = [
	  27.083,   29.821,   52.700, 1000000.000,    0.249,    0.001; ...
	  27.334,   29.706,   54.100,  235.000,    0.242,    0.008; ...
	  27.507,   29.616,   55.200,  190.000,    0.236,    0.014; ...
	  27.864,   29.268,   59.700,  130.000,    0.215,    0.035; ...
	  28.029,   29.004,   63.500,  110.000,    0.199,    0.051; ...
	  28.138,   28.288,   75.500,   85.000,    0.162,    0.087; ...
];

%chao tian
chao_d1d0 = [ ...
    20.295  20.165,  30.60;  %q=500
    24.507  24.578,  30.35; %q=100
    26.063  26.110,  30.18;  %q=60
    27.514  27.474,  29.87;  %q=40
    27.704  27.953   29.48;  %q=35 max redundancy
];

%diff to control the rate and side psnr
%with (34, 544), rate: (4072+3995) = .2462bpp, 24.90 (24.48, 25.33), 30.3483 dB,
%with (34, 490), rate: (4127+4052) = .2496bpp, 25.71 (24.46, 26.96), 30.3483 dB.
%diff by 2.5 dB
%olmo_d1 = [21.3549 24.9031 26.9360   27.6965   28.2696   28.3386   28.4268];
%olmo_d0 = [30.3483 30.3483 30.1273   29.7812   29.2216   28.9989   28.5586];
olmo_d1d0 = [
   30.3483   30.3483    30.1273   29.7812   29.4527   29.2216   28.9989   28.8014   28.5586
   17.8363   24.4800    26.3795   27.5597   28.1185   28.2447   28.3312   28.3309   28.3933
   24.8735   25.3261    27.4925   27.8334   27.9236   28.2946   28.3461   28.2941   28.4603
];

plot_psnr_new(showtext, 'Goldhill');

%lena: 0.25 bpp
lt_88_1_2 = [
	  25.310,   34.027,   41.550, 1000000.000,    0.249,    0.001; ...    
	  28.107,   33.526,   46.500,  290.000,    0.225,    0.025; ...
	  29.492,   32.947,   52.600,  180.000,    0.202,    0.048; ...
	  30.136,   32.509,   58.200,  140.000,    0.184,    0.066; ...
	  30.491,   32.157,   62.800,  120.000,    0.171,    0.080; ...
	  30.806,   31.375,   74.800,   95.000,    0.146,    0.104; ...      
];

lt_81_1_2 = [
	  25.207,   34.101,   42.300, 1000000.000,    0.249,    0.001; ...
	  28.072,   33.532,   48.100,  290.000,    0.223,    0.027; ...
	  29.362,   33.023,   53.800,  190.000,    0.201,    0.049; ...
	  30.040,   32.500,   60.000,  144.000,    0.182,    0.068; ...
	  30.437,   32.045,   66.800,  120.000,    0.165,    0.085; ...
	  30.795,   31.238,   80.000,   95.000,    0.140,    0.110; ...      
];

lt96151 = [
	  24.220,   34.008,   46.600, 1000000.000,    0.249,    0.001; ...
	  28.180,   33.287,   55.000,  300.000,    0.215,    0.035; ...
	  28.804,   33.049,   58.200,  245.000,    0.206,    0.045; ...
	  29.379,   32.776,   62.000,  204.000,    0.194,    0.056; ...
	  29.928,   32.322,   68.000,  164.000,    0.178,    0.073; ...
	  30.572,   31.244,   86.000,  114.000,    0.143,    0.107; ...      
];

dctonly = [
	  27.485,   32.725,   42.600, 1000000.000,    0.249,    0.001; ...
	  28.363,   32.423,   45.300,  230.000,    0.236,    0.014; ...
	  29.116,   32.061,   49.000,  160.000,    0.219,    0.031; ...
	  29.645,   31.544,   54.400,  120.000,    0.199,    0.051; ...
	  29.942,   31.070,   60.000,  100.000,    0.181,    0.069; ...
	  30.057,   30.444,   68.000,   85.000,    0.161,    0.089; ...
];

%chao tian, same 1st tage rate as in his paper
chao_d1d0 = [ ...
    19.478  19.653,  34.17;  %q=500
    22.819  22.833,  34.08;  %q=200
    25.417  25.454,  33.92;  %q=100
    28.343  28.331,  33.48;  %q=50
    30.585  30.621,  32.79;  %q=30    
];

%olmo_d1 = [20.8613  26.3973 28.1974   29.7908   30.0522   30.4853   30.6809   30.8368];
%olmo_d0 = [33.8550  33.5878 33.3396   32.7741   32.5261   32.1150   31.7106   31.4367];
olmo_d1d0 = [
   33.8550   33.7290    33.3396   32.7741   32.5261   32.1150   31.7106   31.4367
   23.6307   25.2294    27.7157   29.4969   30.0347   30.5175   30.6761   30.8965
   18.0919   25.5993    28.6791   29.4015   30.0697   30.4531   30.6857   30.7771
];

plot_psnr_new(showtext, 'Lena');

%peppers: 0.25 bpp
lt_88_1_2 = [
	  25.505,   33.082,   42.700, 1000000.000,    0.249,    0.001; ...
	  28.291,   32.698,   47.400,  300.000,    0.227,    0.023; ...
	  29.731,   32.166,   55.600,  160.000,    0.199,    0.051; ...
	  30.243,   31.622,   63.600,  120.000,    0.176,    0.074; ...
	  30.447,   31.098,   73.200,  100.000,    0.157,    0.093; ...
	  30.467,   30.699,   81.000,   90.000,    0.144,    0.106; ...      
];

lt_81_1_2 = [
	  25.534,   33.140,   43.600, 1000000.000,    0.249,    0.001; ...
	  28.436,   32.728,   49.100,  280.000,    0.225,    0.026; ...
	  29.267,   32.441,   53.200,  200.000,    0.210,    0.041; ...
	  29.856,   32.046,   59.000,  150.000,    0.191,    0.059; ...
	  30.231,   31.558,   66.800,  120.000,    0.172,    0.078; ...
	  30.442,   30.535,   86.000,   90.000,    0.138,    0.112; ...      
];

lt96151= [
	  24.430,   33.102,   47.200, 1000000.000,    0.249,    0.001; ...
	  28.257,   32.620,   54.600,  320.000,    0.219,    0.030; ...
	  29.112,   32.300,   59.400,  220.000,    0.204,    0.046; ...
	  29.929,   31.717,   69.500,  152.000,    0.178,    0.072; ...
	  30.251,   31.236,   79.800,  124.000,    0.158,    0.092; ...
	  30.384,   30.658,   92.000,  105.000,    0.140,    0.110; ...      
];    

dctonly = [
	  27.619,   32.020,   45.000, 1000000.000,    0.249,    0.001; ...
	  28.805,   31.672,   49.000,  200.000,    0.231,    0.018; ...
	  29.247,   31.342,   53.000,  150.000,    0.217,    0.032; ...
	  29.629,   30.912,   58.800,  115.000,    0.198,    0.052; ...
	  29.798,   29.954,   72.600,   85.000,    0.165,    0.085; ...      
    ];

%chao tian
chao_d1d0 = [ ...
%    16.04,  33.54;  %q=1000
%    18.95,  33.52;  %q=500
    22.261  22.307,  33.43;  %q=200
%    23.37,  33.30;  %q=150
    25.237  24.769,  33.28;  %q=100
%    26.02,  33.09;  %q=80
    27.596  27.067,  32.98;  %q=60
%    29.24,  32.60;  %q=40
    29.915  29.741,  32.40;  %q=35
];

%olmo_d1 = [20.3084   27.1293   28.8347   29.8032   30.3048   30.4985   30.5761   ];
%olmo_d0 = [33.3770   32.8841   32.4479   32.1835   31.8023   31.4837   31.1706   ];
olmo_d1d0 = [
   33.3770   33.2097    32.8841   32.4479   32.1835   31.8023   31.4837   31.1706   30.9555
   16.9374   23.6351    26.8297   28.7616   29.6254   30.4521   30.5141   30.5708   30.7933
   23.6794   25.1164    27.4289   28.9079   29.9809   30.1574   30.4829   30.5813   30.7362
];

plot_psnr_new(showtext, 'Peppers');
