function newimg = PrePostLT(img, flt, M)
% Apply LT pre/post-filtering to the input image.
% Usage: newimg = PrePostLT(img, preflt, M)
%   img:    a matrix that contains the input image data, not an input file name,
%   flt:    prefilter or postfilter,
%   M:      block size.
%   newimg: Filtered data.
% Jie Liang, 06/24/2004

if nargin < 3
    help PrePostLT;
    rerturn;
end

[row, col] = size(img);
rowblk = row / M;
colblk = col / M;
N = size(flt, 1);
N2 = N / 2;

newimg = img;

%org order: col, row
          
% column transform
for blk = 1 :  rowblk - 1
   	idx = blk * M - (N2-1) : blk * M - (N2-1) + (N-1);
    newimg(idx, :) = flt * newimg(idx, :);
end

% row transform
for blk = 1 :  colblk - 1
    idx = blk * M - (N2-1) : blk * M - (N2-1) + (N-1);
    newimg(:, idx) = (flt * newimg(:, idx)' )';
end

