function [PreFilter, PostFilter, ErrorPostFilter, FixedWiener,Wiener1Nbr] = ReadPrePostFile(cfgfile)
% Read prefilter and Wiener filter from the input data file.
% Usage: [PreFilter, PostFilter, ErrorPostFilter, FixedWiener] = ReadPrePostFile(cfgfile)
%   cfgfile:    input data file name (generated by MDLTPC_design.m)
%   PreFilter:  Prefilter P,
%   PostFilter: Postfilter inv(P),
%   ErrorPostFilter: Used by Wiener filter-only error resilient lapped transform.
%   FixedWiener:M x 2M Wiener filter,
%   Wiener1Nbr: M x M boundary Wiener filter.
% The format here can be used by both the Prediction-only method in our TIP-2007 paper and the latest MDLT-PC paper.
% Jie Liang, Simon Fraser University, Canada, 2008

if nargin < 1
    help ReadPrePostFile;
    return;
end

%read pre/postfilters
fid = fopen(cfgfile, 'rb');
M = fread(fid, 1, 'int');   
PreFilter = fread(fid, [M, M], 'float');   
PreFilter = PreFilter';
PostFilter = fread(fid, [M, M], 'float');   
PostFilter = PostFilter';

MatrixSize = fread(fid, 1, 'int');   
if MatrixSize == 2 * M
    disp('2M x 2M error concealment is not supported by this program.');
    ErrorPostFilter = [];
    FixedWiener = [];
    return;
else
    if MatrixSize == M
        ErrorPostFilter = fread(fid, [M, M], 'float');   
        ErrorPostFilter = ErrorPostFilter'; %used to be PostFilter'. Wrong.
    else 
        ErrorPostFilter = [];
    end
    
    tmp = fread(fid, 1, 'int');   %should be M
    if tmp ~= M
        disp('Wrong format');
        return;
    end
    FixedWiener = fread(fid, [2*M, M], 'float');   
    FixedWiener = FixedWiener'  ;
end
tmp = fread(fid,1,'int');
if tmp~=M
    disp('Wrong format 2');
end 
Wiener1Nbr = fread(fid,[M,M], 'float');
Wiener1Nbr = Wiener1Nbr';
fclose(fid);
