function WritePrePostFile(outfile, M, postcfg, DCTrecon, equivG, Preflt, PrPostflt, ErrPostflt, DCTwiener, DCTWiener1Nbr)
% Write pre/post filters to data file for CEB codec.

%Data format: should be consistent with idecoder.cpp
%part 1: "m -> mxm pre -> mxm pr post"
%part 2: 2nd postfilter:
%       "0": pr
%       "m -> mxm 2nd postfilter"
%       "2m -> 2mx2m general wiener"
%part 3: DCT estimation method
%       "0": if mean reconstruction method
%       "0": if 2m x 2m general wiener is used.
%       "m -> mx2m Wiener filter".
%part 4: DCT estimation method from 1 nbr, always needed
%       "m x m Wiener filter"
%
% The format here can be used by both the Prediction-only method in our TIP-2007 paper and the latest MDLT-PC paper.
% Jie Liang, Simon Fraser University, Canada, 2008

fid = fopen(outfile, 'wb');

%part 1
fwrite(fid, M, 'int');   
fwrite(fid, Preflt', 'float');   
fwrite(fid, PrPostflt', 'float');   

if DCTrecon == 0
    %2M x 2M general wiener
    fwrite(fid, M * 2, 'int');      
    fwrite(fid, equivG', 'float');
    fwrite(fid, 0, 'int');      % no M x 2M wiener
else
    %2nd postfilter if any
    if postcfg > 0
        % non-pr, switch postfilter
        fwrite(fid, M, 'int');  
        fwrite(fid, ErrPostflt', 'float');
    else
        fwrite(fid, 0, 'int');      % pr system
    end

    %part 3: how to est DCT
    fwrite(fid, M, 'int');   % has M x 2M Wiener filter for DCT
    fwrite(fid, DCTwiener', 'float');            
end

%part 4: M x M Wiener for estimating from 1 nbr
%%filter for top/left nbr
fwrite(fid, M, 'int');   % has M x M Wiener filter for DCT
fwrite(fid, DCTWiener1Nbr', 'float');    
%%filter for bot/right nbr
fwrite(fid, fliplr(flipud(DCTWiener1Nbr))', 'float');    

fclose(fid);
