function bp=bplot(P,G,L);
% functions to plot basis functions of biorthogonal FB P & G
% bp=bplot(P,G);

% Trac D. Tran 
% ECE Department, The Johns Hopkins University
% 3400 North Charles Street, 105 Barton Hall,
% Baltimore, MD 21218
% E-mail: trac@jhu.edu
% - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
% Copyright (c) 2000 Trac D Tran
% This program is Copyright (c) by Trac D Tran.
% It may not be redistributed without the consent of the copyright
% holders. In no circumstances may the copyright notice be removed.
% The program may not be sold for profit nor may they be incorporated
% in commercial programs without the written permission of the copyright
% holders. This program is provided as is, without any express or
% implied warranty, without even the warranty of fitness for a
% particular purpose.
%-----------------------------------------------------------------------

figure;
%whitebg('black');
[M,lth]=size(P);
if nargin == 2
    %use default lth
    L = lth;
    range = [1 : lth];
else    
    range = [(lth-L)/2 + 1 : lth - (lth-L)/2]; %skip zeros at the boundary.
end    
pmax = max(max(P));pmin = min(min(P));
gmax = max(max(G));gmin = min(min(G));
scale = 1.2;

for i=1:M
  subplot(M,2,2*i-1);
  stem(P(i,range));
  axis([1 L pmin*scale, pmax*scale]);
  axis('off');
  subplot(M,2,2*i);
  stem(G(i,range));
  axis([1 L gmin*scale, gmax*scale]);
  axis('off');
end;
