function newimg = imgdct(img, M, doinv)
% newimg = imgdct(img, M, doinv)
% Apply 2-D DCt to the input image.
%   img:    input image,
%   M:      DCT size,
%   doinv:  1 for inverse DCT, 0 for fwd DCT.
% Jie Liang, 06/24/2004

if nargin < 2
    help imgdct;
    return;
end

[row, col] = size(img);
rowblk = row / M;
colblk = col / M;

C = dct(eye(M));
if nargin < 3
    %fwd transform
    FwdT = kron(eye(rowblk), C);
    InvT = kron(eye(colblk), C');
else
    %inv transform   
    FwdT = kron(eye(rowblk), C');
    InvT = kron(eye(colblk), C);
end

newimg = FwdT * img * InvT;
