function plot_psnr_new(showtext, imgname)
% Called by MDLTPC_psnr_2DES_new.m and MDLTPC_psnr_2DES_new_025.m.
% Jie Liang, Simon Fraser University, Canada, jiel@sfu.ca, July 2008

global lt_88_1_2 lt_81_1_2 lt96151 dctonly chao_d1d0;
global olmo_d1d0;

chao_d1mse = (255^2 * 10.^(-chao_d1d0(:,1) / 10) + 255^2 * 10.^(-chao_d1d0(:,2) / 10)) / 2;
chao_d1 = 10*log10(255^2 ./ chao_d1mse);

olmo_d1mse = (255^2 * 10.^(-olmo_d1d0(2,:) / 10) + 255^2 * 10.^(-olmo_d1d0(3,:) / 10)) / 2;
olmo_d1 = 10*log10(255^2 ./ olmo_d1mse);

figure;
plot(lt_88_1_2(:, 1), lt_88_1_2(:, 2), '-o',  ...
     lt_81_1_2(:, 1), lt_81_1_2(:, 2), '-.o',  ...
	 lt96151(:, 1),  lt96151(:,2), '-s', ...
	 dctonly(:,1),   dctonly(:,2), '-.s', ...
	 chao_d1, chao_d1d0(:,3), '-^', ...
	 olmo_d1, olmo_d1d0(1,:), 'k-.^', ...
     'LineWidth', 1);
grid on;
xlabel('Side PSNR (dB)');
ylabel('Central PSNR (dB)');
legend('MDLT-PC: N=8', 'MDLT-PC: N=1', 'TDLT-PC', 'DCT-PC', 'MMDSQ', 'RD-MDC');
title(imgname);
