function psnr = psnr(img1, img2,showtext)
% Calculate the PSNR between two images (muct be recognized by imread)
% function psnr = psnr(img1, img2)
%
% Author:	Jie Liang
%
% Created:	April 2006
%
% Input:
%	img1:   	data of the first image,
%  img2:    data fo the second image,
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if nargin < 2
    help psnr;
    return;
end

if nargin < 3
    showtext = 0;
end

if ischar(img1)   
    x = imread(img1);
else
    x = img1;
end

x = double(x);

if ischar(img2)
    y = imread(img2);
else
    y = img2;
end
y = double(y);

err= (x - y).^2;
mse = sum(sum(err)) / size(x,1) / size(x,2);
psnr = 10 * log10(255*255/mse);
s=sprintf('PSNR: %f dB',psnr);
if showtext==1
    disp(s);
end
