/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class CylinderGenerator
extends GeometryGenerator {
    private static final float DEFAULT_HEIGHT = 2.0f;
    private static final float DEFAULT_RADIUS = 1.0f;
    private static final int DEFAULT_FACETS = 16;
    private float cylinderHeight;
    private float radius;
    private boolean useEnds;
    private int facetCount;
    private float[] baseCoordinates;
    private int numBaseValues;
    private boolean baseChanged;
    private Vector3f normal;

    public CylinderGenerator() {
        this(2.0f, 1.0f, 16, true);
    }

    public CylinderGenerator(boolean bl) {
        this(2.0f, 1.0f, 16, bl);
    }

    public CylinderGenerator(int n) {
        this(2.0f, 1.0f, n, true);
    }

    public CylinderGenerator(int n, boolean bl) {
        this(2.0f, 1.0f, n, bl);
    }

    public CylinderGenerator(float f, float f2) {
        this(f, f2, 16, true);
    }

    public CylinderGenerator(float f, float f2, int n) {
        this(f, f2, n, true);
    }

    public CylinderGenerator(float f, float f2, boolean bl) {
        this(f, f2, 16, bl);
    }

    public CylinderGenerator(float f, float f2, int n, boolean bl) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        this.facetCount = n;
        this.cylinderHeight = f;
        this.radius = f2;
        this.useEnds = bl;
        this.baseChanged = true;
        this.normal = new Vector3f();
    }

    public boolean hasEnds() {
        return this.useEnds;
    }

    public float[] getDimensions() {
        return new float[]{this.cylinderHeight, this.radius};
    }

    public void setDimensions(float f, float f2, boolean bl) {
        if (this.cylinderHeight != f || this.radius != f2) {
            this.baseChanged = true;
            this.cylinderHeight = f;
            this.radius = f2;
        }
        this.useEnds = bl;
    }

    public void setFacetCount(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        this.facetCount = n;
        this.baseChanged = true;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 1: {
                n = this.facetCount * 6;
                if (!this.useEnds) break;
                n <<= 1;
                break;
            }
            case 2: {
                n = this.facetCount * 4;
                if (!this.useEnds) break;
                n *= 3;
                break;
            }
            case 3: {
                n = (this.facetCount + 1) * 2;
                if (!this.useEnds) break;
                n *= 3;
                break;
            }
            case 4: {
                n = this.facetCount * 4;
                if (this.useEnds) {
                    n += (this.facetCount + 2) * 2;
                }
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n = this.facetCount * 2;
                if (!this.useEnds) break;
                n += 2 + this.facetCount * 2;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            case 2: {
                this.unindexedQuads(geometryData);
                break;
            }
            case 3: {
                this.triangleStrips(geometryData);
                break;
            }
            case 4: {
                this.triangleFans(geometryData);
                break;
            }
            case 5: {
                this.indexedQuads(geometryData);
                break;
            }
            case 6: {
                this.indexedTriangles(geometryData);
                break;
            }
            case 7: {
                this.indexedTriangleStrips(geometryData);
                break;
            }
            case 8: {
                this.indexedTriangleFans(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedQuadCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedQuadNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = geometryData.vertexCount * 4;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.facetCount;
        while (--n4 > 0) {
            nArray[n2++] = n3;
            nArray[n2++] = n3 + 1;
            nArray[n2++] = n3 + 3;
            nArray[n2++] = n3 + 2;
            n3 += 2;
        }
        nArray[n2++] = n3++;
        nArray[n2++] = n3++;
        nArray[n2++] = 0;
        nArray[n2++] = 1;
        if (this.useEnds) {
            int n5 = n3++;
            int n6 = this.facetCount;
            while (--n6 > 0) {
                nArray[n2++] = n5;
                nArray[n2++] = n3++;
                nArray[n2++] = n3;
                nArray[n2++] = n5;
            }
            nArray[n2++] = n5;
            nArray[n2++] = n3++;
            nArray[n2++] = n5 + 1;
            nArray[n2++] = n5;
            n5 = n3++;
            int n7 = this.facetCount;
            while (--n7 > 0) {
                nArray[n2++] = n5;
                nArray[n2++] = n3 + 1;
                nArray[n2++] = n3++;
                nArray[n2++] = n5;
            }
            nArray[n2++] = n5;
            nArray[n2++] = n5 + 1;
            nArray[n2++] = n3;
            nArray[n2++] = n5;
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = geometryData.vertexCount * 3;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.facetCount;
        while (--n4 > 0) {
            nArray[n2++] = n3;
            nArray[n2++] = n3 + 1;
            nArray[n2++] = n3 + 3;
            nArray[n2++] = n3 + 3;
            nArray[n2++] = n3 + 2;
            nArray[n2++] = n3;
            n3 += 2;
        }
        nArray[n2++] = n3;
        nArray[n2++] = n3 + 1;
        nArray[n2++] = 1;
        nArray[n2++] = 1;
        nArray[n2++] = 0;
        nArray[n2++] = n3;
        n3 += 2;
        if (this.useEnds) {
            int n5 = n3++;
            int n6 = this.facetCount;
            while (--n6 > 0) {
                nArray[n2++] = n5;
                nArray[n2++] = n3 + 1;
                nArray[n2++] = n3++;
            }
            nArray[n2++] = n5;
            nArray[n2++] = n5 + 1;
            nArray[n2++] = n3;
            n5 = n3++;
            int n7 = this.facetCount;
            while (--n7 > 0) {
                nArray[n2++] = n5;
                nArray[n2++] = n3 + 1;
                nArray[n2++] = n3++;
            }
            nArray[n2++] = n5;
            nArray[n2++] = n5 + 1;
            nArray[n2++] = n3;
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriStripCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriStripNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = 3;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        geometryData.stripCounts[0] = (1 + this.facetCount) * 2;
        geometryData.stripCounts[1] = geometryData.stripCounts[0];
        geometryData.stripCounts[2] = geometryData.stripCounts[0];
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriFanCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriFanNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.facetCount + 2;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = this.facetCount;
        while (--n2 >= 0) {
            geometryData.stripCounts[n2] = 4;
        }
        geometryData.stripCounts[n - 2] = this.facetCount + 2;
        geometryData.stripCounts[n - 1] = this.facetCount + 2;
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = (this.facetCount + 1) * 2 * (this.useEnds ? 3 : 1);
        int n2 = 1 + (this.useEnds ? 2 : 0);
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n2];
        } else if (geometryData.stripCounts.length < n2) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n2);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n;
        geometryData.numStrips = n2;
        int n3 = 0;
        int n4 = 0;
        nArray2[0] = (this.facetCount + 1) * 2;
        int n5 = this.facetCount;
        while (--n5 >= 0) {
            nArray[n3++] = n4++;
            nArray[n3++] = n4++;
        }
        nArray[n3++] = 0;
        nArray[n3++] = this.facetCount;
        if (this.useEnds) {
            nArray2[1] = (this.facetCount + 1) * 2;
            nArray2[2] = (this.facetCount + 1) * 2;
            int n6 = n4++;
            int n7 = this.facetCount;
            while (--n7 >= 0) {
                nArray[n3++] = n6;
                nArray[n3++] = n4++;
            }
            nArray[n3++] = n6 + 1;
            nArray[n3++] = n6;
            n6 = n4++;
            int n8 = this.facetCount;
            while (--n8 >= 0) {
                nArray[n3++] = n4++;
                nArray[n3++] = n6;
            }
            nArray[n3++] = n6 + 1;
            nArray[n3++] = n6;
        }
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.facetCount * 4 + (this.useEnds ? 2 * (this.facetCount + 2) : 0);
        int n2 = this.facetCount + (this.useEnds ? 2 : 0);
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n2];
        } else if (geometryData.stripCounts.length < n2) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n2);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n;
        geometryData.numStrips = n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.facetCount;
        while (--n5 > 0) {
            nArray[n3++] = n4;
            nArray[n3++] = n4 + 1;
            nArray[n3++] = n4 + 3;
            nArray[n3++] = n4 + 2;
            nArray2[n5] = 4;
            n4 += 2;
        }
        nArray[n3++] = n4;
        nArray[n3++] = n4 + 1;
        nArray[n3++] = 1;
        nArray[n3++] = 0;
        n4 += 2;
        nArray2[0] = 4;
        if (this.useEnds) {
            int n6 = n4++;
            nArray[n3++] = n6;
            nArray2[n2 - 2] = this.facetCount + 2;
            int n7 = this.facetCount;
            while (--n7 >= 0) {
                nArray[n3++] = n4++;
            }
            nArray[n3++] = n6 + 1;
            n6 = n4++;
            nArray[n3++] = n6;
            nArray2[n2 - 1] = this.facetCount + 2;
            n4 = geometryData.vertexCount - 1;
            int n8 = this.facetCount;
            while (--n8 >= 0) {
                nArray[n3++] = n4--;
            }
            nArray[n3++] = geometryData.vertexCount - 1;
        }
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.facetCount * 6;
        if (this.useEnds) {
            n <<= 1;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = this.cylinderHeight / 2.0f;
        n3 = this.facetCount;
        while (--n3 > 0) {
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[n4 + 2];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 3];
            fArray[n2++] = this.baseCoordinates[n4 + 2];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 3];
            fArray[n2++] = this.baseCoordinates[n4 + 2];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 3];
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            n4 += 2;
        }
        fArray[n2++] = this.baseCoordinates[n4];
        fArray[n2++] = -f;
        fArray[n2++] = this.baseCoordinates[n4 + 1];
        fArray[n2++] = this.baseCoordinates[0];
        fArray[n2++] = -f;
        fArray[n2++] = this.baseCoordinates[1];
        fArray[n2++] = this.baseCoordinates[0];
        fArray[n2++] = f;
        fArray[n2++] = this.baseCoordinates[1];
        fArray[n2++] = this.baseCoordinates[0];
        fArray[n2++] = f;
        fArray[n2++] = this.baseCoordinates[1];
        fArray[n2++] = this.baseCoordinates[n4];
        fArray[n2++] = f;
        fArray[n2++] = this.baseCoordinates[n4 + 1];
        fArray[n2++] = this.baseCoordinates[n4];
        fArray[n2++] = -f;
        fArray[n2++] = this.baseCoordinates[n4 + 1];
        if (this.useEnds) {
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                fArray[n2++] = 0.0f;
                fArray[n2++] = f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                fArray[n2++] = 0.0f;
                fArray[n2++] = -f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[1];
        }
    }

    private void generateUnindexedTriStripCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = (this.facetCount + 1) * 2;
        if (this.useEnds) {
            n *= 3;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        float f = this.cylinderHeight / 2.0f;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = this.facetCount;
        while (--n4 >= 0) {
            fArray[n2++] = this.baseCoordinates[n3];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n3 + 1];
            fArray[n2++] = this.baseCoordinates[n3];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n3 + 1];
            n3 += 2;
        }
        fArray[n2++] = this.baseCoordinates[0];
        fArray[n2++] = f;
        fArray[n2++] = this.baseCoordinates[1];
        fArray[n2++] = this.baseCoordinates[0];
        fArray[n2++] = -f;
        fArray[n2++] = this.baseCoordinates[1];
        if (this.useEnds) {
            n3 = 0;
            n4 = this.facetCount;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = this.baseCoordinates[n3++];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n3++];
            }
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
            n3 = 0;
            n4 = this.facetCount;
            while (--n4 >= 0) {
                fArray[n2++] = this.baseCoordinates[n3++];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n3++];
                fArray[n2++] = 0.0f;
                fArray[n2++] = -f;
                fArray[n2++] = 0.0f;
            }
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
        }
    }

    private void generateUnindexedTriFanCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.facetCount * 4;
        if (this.useEnds) {
            n += (this.facetCount + 2) * 2;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = this.cylinderHeight / 2.0f;
        n3 = this.facetCount;
        while (--n3 > 0) {
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[n4 + 2];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 3];
            fArray[n2++] = this.baseCoordinates[n4 + 2];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 3];
            n4 += 2;
        }
        fArray[n2++] = this.baseCoordinates[n4];
        fArray[n2++] = f;
        fArray[n2++] = this.baseCoordinates[n4 + 1];
        fArray[n2++] = this.baseCoordinates[n4];
        fArray[n2++] = -f;
        fArray[n2++] = this.baseCoordinates[n4 + 1];
        fArray[n2++] = this.baseCoordinates[0];
        fArray[n2++] = -f;
        fArray[n2++] = this.baseCoordinates[1];
        fArray[n2++] = this.baseCoordinates[0];
        fArray[n2++] = f;
        fArray[n2++] = this.baseCoordinates[1];
        if (this.useEnds) {
            n4 = 0;
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            n3 = this.facetCount;
            while (--n3 >= 0) {
                fArray[n2++] = this.baseCoordinates[n4++];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4++];
            }
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
            n4 = this.numBaseValues - 1;
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            n3 = this.facetCount;
            while (--n3 >= 0) {
                fArray[n2++] = this.baseCoordinates[n4 - 1];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4];
                n4 -= 2;
            }
            fArray[n2++] = this.baseCoordinates[this.numBaseValues - 2];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[this.numBaseValues - 1];
        }
    }

    private void generateUnindexedQuadCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.facetCount * 4;
        if (this.useEnds) {
            n *= 3;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = this.cylinderHeight / 2.0f;
        n3 = this.facetCount;
        while (--n3 > 0) {
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[n4 + 2];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 3];
            fArray[n2++] = this.baseCoordinates[n4 + 2];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 3];
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            n4 += 2;
        }
        fArray[n2++] = this.baseCoordinates[n4];
        fArray[n2++] = -f;
        fArray[n2++] = this.baseCoordinates[n4 + 1];
        fArray[n2++] = this.baseCoordinates[0];
        fArray[n2++] = -f;
        fArray[n2++] = this.baseCoordinates[1];
        fArray[n2++] = this.baseCoordinates[0];
        fArray[n2++] = f;
        fArray[n2++] = this.baseCoordinates[1];
        fArray[n2++] = this.baseCoordinates[n4];
        fArray[n2++] = f;
        fArray[n2++] = this.baseCoordinates[n4 + 1];
        if (this.useEnds) {
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                fArray[n2++] = 0.0f;
                fArray[n2++] = f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[1];
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 > 0) {
                fArray[n2++] = this.baseCoordinates[n4];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 1];
                fArray[n2++] = 0.0f;
                fArray[n2++] = -f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = -f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = this.baseCoordinates[n4 + 2];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4 + 3];
                n4 += 2;
            }
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            fArray[n2++] = this.baseCoordinates[0];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[1];
        }
    }

    private void generateIndexedCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.facetCount * 2;
        if (this.useEnds) {
            n += 2 + this.facetCount * 2;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        float f = this.cylinderHeight / 2.0f;
        n3 = this.facetCount;
        while (--n3 >= 0) {
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            fArray[n2++] = this.baseCoordinates[n4];
            fArray[n2++] = -f;
            fArray[n2++] = this.baseCoordinates[n4 + 1];
            n4 += 2;
        }
        if (this.useEnds) {
            fArray[n2++] = 0.0f;
            fArray[n2++] = f;
            fArray[n2++] = 0.0f;
            n4 = 0;
            n3 = this.facetCount;
            while (--n3 >= 0) {
                fArray[n2++] = this.baseCoordinates[n4++];
                fArray[n2++] = f;
                fArray[n2++] = this.baseCoordinates[n4++];
            }
            n4 = 0;
            fArray[n2++] = 0.0f;
            fArray[n2++] = -f;
            fArray[n2++] = 0.0f;
            n3 = this.facetCount;
            while (--n3 >= 0) {
                fArray[n2++] = this.baseCoordinates[n4++];
                fArray[n2++] = -f;
                fArray[n2++] = this.baseCoordinates[n4++];
            }
        }
    }

    private void generateUnindexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = 0;
        this.createRadialFlatNormal(n3++);
        int n4 = this.facetCount;
        while (--n4 > 0) {
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            fArray[n2 + 9] = this.normal.x;
            fArray[n2 + 10] = this.normal.y;
            fArray[n2 + 11] = this.normal.z;
            fArray[n2 + 12] = this.normal.x;
            fArray[n2 + 13] = this.normal.y;
            fArray[n2 + 14] = this.normal.z;
            this.createRadialFlatNormal(n3++);
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            n2 += 6;
        }
        fArray[n2++] = this.normal.x;
        fArray[n2++] = this.normal.y;
        fArray[n2++] = this.normal.z;
        fArray[n2 + 9] = this.normal.x;
        fArray[n2 + 10] = this.normal.y;
        fArray[n2 + 11] = this.normal.z;
        fArray[n2 + 12] = this.normal.x;
        fArray[n2 + 13] = this.normal.y;
        fArray[n2 + 14] = this.normal.z;
        this.createRadialFlatNormal(0);
        fArray[n2++] = this.normal.x;
        fArray[n2++] = this.normal.y;
        fArray[n2++] = this.normal.z;
        fArray[n2++] = this.normal.x;
        fArray[n2++] = this.normal.y;
        fArray[n2++] = this.normal.z;
        fArray[n2++] = this.normal.x;
        fArray[n2++] = this.normal.y;
        fArray[n2++] = this.normal.z;
        n2 += 6;
        if (this.useEnds) {
            n4 = this.facetCount;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
            }
            n4 = this.facetCount;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
            }
        }
    }

    private void generateUnindexedTriStripNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.facetCount;
        while (--n4 >= 0) {
            this.createRadialFlatNormal(n3++);
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
        }
        fArray[n2++] = fArray[0];
        fArray[n2++] = fArray[1];
        fArray[n2++] = fArray[2];
        fArray[n2++] = fArray[3];
        fArray[n2++] = fArray[4];
        fArray[n2++] = fArray[5];
        if (this.useEnds) {
            n4 = this.facetCount + 1;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
            }
            n4 = this.facetCount + 1;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
            }
        }
    }

    private void generateUnindexedTriFanNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = 0;
        this.createRadialFlatNormal(n3++);
        int n4 = this.facetCount;
        while (--n4 > 0) {
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            this.createRadialFlatNormal(n3++);
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
        }
        fArray[n2++] = this.normal.x;
        fArray[n2++] = this.normal.y;
        fArray[n2++] = this.normal.z;
        fArray[n2++] = this.normal.x;
        fArray[n2++] = this.normal.y;
        fArray[n2++] = this.normal.z;
        fArray[n2++] = fArray[0];
        fArray[n2++] = fArray[1];
        fArray[n2++] = fArray[2];
        fArray[n2++] = fArray[3];
        fArray[n2++] = fArray[4];
        fArray[n2++] = fArray[5];
        if (this.useEnds) {
            n4 = this.facetCount + 2;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
            }
            n4 = this.facetCount + 2;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
            }
        }
    }

    private void generateUnindexedQuadNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = 0;
        this.createRadialFlatNormal(n3++);
        int n4 = this.facetCount;
        while (--n4 > 0) {
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            fArray[n2 + 6] = this.normal.x;
            fArray[n2 + 7] = this.normal.y;
            fArray[n2 + 8] = this.normal.z;
            this.createRadialFlatNormal(n3++);
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            n2 += 3;
        }
        fArray[n2++] = this.normal.x;
        fArray[n2++] = this.normal.y;
        fArray[n2++] = this.normal.z;
        fArray[n2 + 6] = this.normal.x;
        fArray[n2 + 7] = this.normal.y;
        fArray[n2 + 8] = this.normal.z;
        this.createRadialFlatNormal(0);
        fArray[n2++] = this.normal.x;
        fArray[n2++] = this.normal.y;
        fArray[n2++] = this.normal.z;
        fArray[n2++] = this.normal.x;
        fArray[n2++] = this.normal.y;
        fArray[n2++] = this.normal.z;
        n2 += 3;
        if (this.useEnds) {
            n4 = this.facetCount;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
            }
            n4 = this.facetCount;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
            }
        }
    }

    private void generateIndexedNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.facetCount;
        while (--n4 >= 0) {
            this.createRadialFlatNormal(n3++);
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
            fArray[n2++] = this.normal.x;
            fArray[n2++] = this.normal.y;
            fArray[n2++] = this.normal.z;
        }
        if (this.useEnds) {
            n4 = this.facetCount + 1;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = 1.0f;
                fArray[n2++] = 0.0f;
            }
            n4 = this.facetCount + 1;
            while (--n4 >= 0) {
                fArray[n2++] = 0.0f;
                fArray[n2++] = -1.0f;
                fArray[n2++] = 0.0f;
            }
        }
    }

    private void generateTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private final void regenerateBase() {
        if (!this.baseChanged) {
            return;
        }
        this.baseChanged = false;
        if (this.baseCoordinates == null || this.facetCount * 2 > this.baseCoordinates.length) {
            this.baseCoordinates = new float[this.facetCount * 2];
        }
        this.numBaseValues = this.facetCount * 2;
        double d = Math.PI * 2 / (double)this.facetCount;
        int n = 0;
        int n2 = this.facetCount;
        while (--n2 >= 0) {
            double d2 = d * (double)n2;
            float f = (float)((double)this.radius * Math.cos(d2));
            float f2 = (float)((double)this.radius * Math.sin(d2));
            this.baseCoordinates[n++] = f;
            this.baseCoordinates[n++] = f2;
        }
    }

    private void createRadialFlatNormal(int n) {
        float f = this.baseCoordinates[n * 2];
        float f2 = this.baseCoordinates[n * 2 + 1];
        float f3 = f * f + f2 * f2;
        if ((double)f3 != 0.0) {
            f3 = 1.0f / (float)Math.sqrt(f3);
            this.normal.x = f * f3;
            this.normal.y = 0.0f;
            this.normal.z = f2 * f3;
        } else {
            this.normal.x = 0.0f;
            this.normal.y = 0.0f;
            this.normal.z = 0.0f;
        }
    }
}

