/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.overlay;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.event.EventListenerList;
import org.j3d.geom.overlay.ScreenComponent;

public class ComponentMouseManager
implements MouseListener,
MouseMotionListener {
    private EventListenerList listenerList = new EventListenerList();
    private ScreenComponent subComponent;
    private boolean mouseOver = false;
    private boolean clicked = false;
    static /* synthetic */ Class class$java$awt$event$MouseListener;
    static /* synthetic */ Class class$java$awt$event$MouseMotionListener;

    public ComponentMouseManager(Component component, ScreenComponent screenComponent) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        this.subComponent = screenComponent;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.subComponent.getBounds().contains(mouseEvent.getPoint())) {
            if (!this.mouseOver) {
                this.mouseOver = true;
                this.fireMouseEntered(mouseEvent);
            }
            this.fireMouseMoved(mouseEvent);
        } else if (this.mouseOver) {
            this.mouseOver = false;
            this.fireMouseExited(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.subComponent.getBounds().contains(mouseEvent.getPoint())) {
            if (!this.mouseOver) {
                this.mouseOver = true;
                this.fireMouseEntered(mouseEvent);
            }
            this.fireMouseDragged(mouseEvent);
        } else if (this.mouseOver) {
            this.mouseOver = false;
            this.fireMouseExited(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseOver) {
            this.mouseOver = false;
            this.fireMouseExited(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mouseOver) {
            this.clicked = true;
            this.fireMousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseOver) {
            this.fireMouseReleased(mouseEvent);
            if (this.clicked) {
                this.clicked = false;
                this.fireMouseClicked(mouseEvent);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.listenerList.add(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = ComponentMouseManager.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener, mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.listenerList.remove(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = ComponentMouseManager.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener, mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.listenerList.add(class$java$awt$event$MouseMotionListener == null ? (class$java$awt$event$MouseMotionListener = ComponentMouseManager.class$("java.awt.event.MouseMotionListener")) : class$java$awt$event$MouseMotionListener, mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.listenerList.remove(class$java$awt$event$MouseMotionListener == null ? (class$java$awt$event$MouseMotionListener = ComponentMouseManager.class$("java.awt.event.MouseMotionListener")) : class$java$awt$event$MouseMotionListener, mouseMotionListener);
    }

    private void fireMouseMoved(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$MouseMotionListener == null ? ComponentMouseManager.class$("java.awt.event.MouseMotionListener") : class$java$awt$event$MouseMotionListener)) {
                ((MouseMotionListener)objectArray[n + 1]).mouseMoved(mouseEvent);
            }
            n -= 2;
        }
    }

    private void fireMouseDragged(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$MouseMotionListener == null ? ComponentMouseManager.class$("java.awt.event.MouseMotionListener") : class$java$awt$event$MouseMotionListener)) {
                ((MouseMotionListener)objectArray[n + 1]).mouseDragged(mouseEvent);
            }
            n -= 2;
        }
    }

    private void fireMouseEntered(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$MouseListener == null ? ComponentMouseManager.class$("java.awt.event.MouseListener") : class$java$awt$event$MouseListener)) {
                ((MouseListener)objectArray[n + 1]).mouseEntered(mouseEvent);
            }
            n -= 2;
        }
    }

    private void fireMouseExited(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$MouseListener == null ? ComponentMouseManager.class$("java.awt.event.MouseListener") : class$java$awt$event$MouseListener)) {
                ((MouseListener)objectArray[n + 1]).mouseExited(mouseEvent);
            }
            n -= 2;
        }
    }

    private void fireMouseClicked(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$MouseListener == null ? ComponentMouseManager.class$("java.awt.event.MouseListener") : class$java$awt$event$MouseListener)) {
                ((MouseListener)objectArray[n + 1]).mouseClicked(mouseEvent);
            }
            n -= 2;
        }
    }

    private void fireMousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$MouseListener == null ? ComponentMouseManager.class$("java.awt.event.MouseListener") : class$java$awt$event$MouseListener)) {
                ((MouseListener)objectArray[n + 1]).mousePressed(mouseEvent);
            }
            n -= 2;
        }
    }

    private void fireMouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = this.subComponent.getBounds();
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$awt$event$MouseListener == null ? ComponentMouseManager.class$("java.awt.event.MouseListener") : class$java$awt$event$MouseListener)) {
                ((MouseListener)objectArray[n + 1]).mouseReleased(mouseEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

