/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.overlay;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.media.j3d.Canvas3D;
import org.j3d.geom.overlay.OverlayBase;
import org.j3d.geom.overlay.UpdateManager;

public class LabelOverlay
extends OverlayBase {
    private static final Font DEFAULT_FONT = new Font("Helvetica", 0, 14);
    private static final Color DEFAULT_COLOR = Color.red;
    private AttributedString text;
    private int visibleLength;
    private Font font;
    private Color color;

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle) {
        this(canvas3D, rectangle, "");
    }

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle, String string) {
        this(canvas3D, rectangle, string, DEFAULT_FONT, DEFAULT_COLOR, null);
    }

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle, String string, Font font, Color color) {
        this(canvas3D, rectangle, string, font, color, null);
    }

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle, String string, Font font, Color color, UpdateManager updateManager) {
        super(canvas3D, rectangle, updateManager);
        this.font = font;
        this.color = color;
        this.setText(string);
        this.visibleLength = string.length();
    }

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle, AttributedString attributedString) {
        this(canvas3D, rectangle, attributedString, null);
    }

    public LabelOverlay(Canvas3D canvas3D, Rectangle rectangle, AttributedString attributedString, UpdateManager updateManager) {
        super(canvas3D, rectangle, updateManager);
        this.setText(attributedString);
        this.setBackgroundColor(new Color(0, 0, 0, 0));
        this.visibleLength = attributedString.getIterator().getEndIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D graphics2D) {
        if (this.text == null) {
            return;
        }
        AttributedString attributedString = this.text;
        synchronized (attributedString) {
            AttributedCharacterIterator attributedCharacterIterator = this.text.getIterator(null, 0, this.visibleLength);
            if (attributedCharacterIterator.getEndIndex() > 0) {
                graphics2D.setColor(this.color);
                graphics2D.drawString(attributedCharacterIterator, 0, this.overlayBounds.height * 3 / 4);
            }
        }
    }

    public void setColor(Color color) {
        if (!this.color.equals(color)) {
            this.color = color;
            if (this.text != null) {
                this.text.addAttribute(TextAttribute.FOREGROUND, this.color);
                this.repaint();
            }
        }
    }

    public void setFont(Font font) {
        if (!this.font.equals(font)) {
            this.font = font;
            if (this.text != null) {
                this.text.addAttribute(TextAttribute.FONT, this.font);
                this.repaint();
            }
        }
    }

    public void setText(String string) {
        if (string != null) {
            this.setText(this.createAttributedString(string, this.font, this.color));
        }
    }

    public void setText(AttributedString attributedString) {
        if (attributedString != null) {
            this.text = attributedString;
        }
    }

    public int getVisibleLength() {
        return this.visibleLength;
    }

    public void setVisibleLength(int n) {
        this.visibleLength = n < 0 ? 0 : n;
    }

    private AttributedString createAttributedString(String string, Font font, Color color) {
        AttributedString attributedString = null;
        if (string.length() > 0) {
            attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, font);
            attributedString.addAttribute(TextAttribute.FOREGROUND, color);
        }
        return attributedString;
    }
}

