/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.overlay;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Point3d;
import org.j3d.geom.overlay.OverlayBase;
import org.j3d.geom.overlay.UpdateManager;

public class MouseOverlay
extends OverlayBase {
    private WakeupOnAWTEvent critter;
    private boolean processAllEvents;

    public MouseOverlay(Canvas3D canvas3D, Rectangle rectangle) {
        super(canvas3D, rectangle);
    }

    public MouseOverlay(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        super(canvas3D, rectangle);
        this.init(bl, bl2, bl3);
    }

    public MouseOverlay(Canvas3D canvas3D, Rectangle rectangle, UpdateManager updateManager) {
        super(canvas3D, rectangle, updateManager);
    }

    public MouseOverlay(Canvas3D canvas3D, Rectangle rectangle, UpdateManager updateManager, boolean bl, boolean bl2, boolean bl3) {
        super(canvas3D, rectangle, updateManager);
        this.init(bl, bl2, bl3);
    }

    public MouseOverlay(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(canvas3D, rectangle, bl, bl2);
        this.init(bl3, bl4, bl5);
    }

    public MouseOverlay(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2, UpdateManager updateManager, boolean bl3, boolean bl4, boolean bl5) {
        super(canvas3D, rectangle, bl, bl2, updateManager);
        this.init(bl3, bl4, bl5);
    }

    public MouseOverlay(Canvas3D canvas3D, Rectangle rectangle, boolean bl, boolean bl2, UpdateManager updateManager, int n, boolean bl3, boolean bl4, boolean bl5) {
        super(canvas3D, rectangle, bl, bl2, updateManager, n);
        this.init(bl3, bl4, bl5);
    }

    private void init(boolean bl, boolean bl2, boolean bl3) {
        this.processAllEvents = bl3;
        this.setEventTypes(bl, bl2);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.addChild((Node)new EventBehavior());
        this.consoleBG.addChild((Node)branchGroup);
    }

    public void setEventTypes(boolean bl, boolean bl2) {
        long l = 0L;
        if (bl2) {
            l = 32L;
        }
        if (bl) {
            l |= 0x10L;
        }
        this.critter = new WakeupOnAWTEvent(l);
    }

    public void initialize() {
        this.setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private class EventBehavior
    extends Behavior {
        public EventBehavior() {
            Point3d point3d = new Point3d();
            BoundingSphere boundingSphere = new BoundingSphere(point3d, Double.POSITIVE_INFINITY);
            this.setSchedulingBounds((Bounds)boundingSphere);
            this.setEnable(true);
        }

        public void initialize() {
            this.wakeupOn((WakeupCondition)MouseOverlay.this.critter);
        }

        public void processStimulus(Enumeration enumeration) {
            WakeupOnAWTEvent wakeupOnAWTEvent = (WakeupOnAWTEvent)enumeration.nextElement();
            AWTEvent[] aWTEventArray = wakeupOnAWTEvent.getAWTEvent();
            if (MouseOverlay.this.processAllEvents) {
                int n = 0;
                while (n < aWTEventArray.length) {
                    this.sendEvent((MouseEvent)aWTEventArray[n]);
                    ++n;
                }
            } else {
                this.sendEvent((MouseEvent)aWTEventArray[aWTEventArray.length - 1]);
            }
            this.wakeupOn((WakeupCondition)MouseOverlay.this.critter);
        }

        private void sendEvent(MouseEvent mouseEvent) {
            try {
                switch (mouseEvent.getID()) {
                    case 500: {
                        MouseOverlay.this.mouseClicked(mouseEvent);
                        break;
                    }
                    case 501: {
                        MouseOverlay.this.mousePressed(mouseEvent);
                        break;
                    }
                    case 502: {
                        MouseOverlay.this.mouseReleased(mouseEvent);
                        break;
                    }
                    case 504: {
                        MouseOverlay.this.mouseEntered(mouseEvent);
                        break;
                    }
                    case 505: {
                        MouseOverlay.this.mouseExited(mouseEvent);
                        break;
                    }
                    case 506: {
                        MouseOverlay.this.mouseDragged(mouseEvent);
                        break;
                    }
                    case 503: {
                        MouseOverlay.this.mouseMoved(mouseEvent);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Error sending mouse event to overlay");
                exception.printStackTrace();
            }
        }
    }
}

