/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.overlay;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.media.j3d.Canvas3D;
import org.j3d.geom.overlay.LineData;
import org.j3d.geom.overlay.LineDetails;
import org.j3d.geom.overlay.MouseOverlay;

public class ScribbleOverlay
extends MouseOverlay {
    private ArrayList lineList = new ArrayList();
    private Color currentColor;
    private LineData currentLine;
    private LineDetails currentLineDetails;
    private Point worldPoint = new Point();

    public ScribbleOverlay(Canvas3D canvas3D, Rectangle rectangle) {
        this(canvas3D, rectangle, Color.white);
    }

    public ScribbleOverlay(Canvas3D canvas3D, Rectangle rectangle, Color color) {
        super(canvas3D, rectangle, true, true, true, true, true);
        this.currentColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        this.currentLineDetails = new LineDetails(this.currentColor);
        this.lineList.add(this.currentLineDetails);
    }

    public void paint(Graphics2D graphics2D) {
        int n = this.lineList.size();
        int n2 = 0;
        while (n2 < n) {
            LineDetails lineDetails = (LineDetails)this.lineList.get(n2);
            int n3 = lineDetails.lines.size();
            graphics2D.setColor(lineDetails.color);
            int n4 = 0;
            while (n4 < n3) {
                LineData lineData = (LineData)lineDetails.lines.get(n4);
                graphics2D.drawPolyline(lineData.xPoints, lineData.yPoints, lineData.numPoints);
                ++n4;
            }
            ++n2;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.currentLine = this.currentLineDetails.addLine();
        Point point = mouseEvent.getPoint();
        this.currentLine.addPoint(point.x, point.y);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.currentLine.addPoint(point.x, point.y);
        this.currentLine = null;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.currentLine.addPoint(point.x, point.y);
    }

    public void setLineColor(Color color) {
        this.currentColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        this.currentLineDetails = new LineDetails(this.currentColor);
        this.lineList.add(this.currentLineDetails);
    }

    public void clear() {
        this.lineList.clear();
        this.currentLineDetails = new LineDetails(this.currentColor);
        this.lineList.add(this.currentLineDetails);
        this.repaint();
    }
}

