/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;

public abstract class Particle {
    long totalAge = 0L;
    int cycleAge = 0;
    double surfaceArea = 0.004;
    double energy = 0.0;
    double mass = 1.0E-7;
    double electrostaticCharge = 0.0;
    Vector3d resultantForce = new Vector3d();
    Vector3d velocity = new Vector3d();
    Point3d position = new Point3d();
    Point3d previousPosition = new Point3d();
    private BoundingBox boundingBox = new BoundingBox();
    protected Color4f color = new Color4f();

    public void setPosition(double d, double d2, double d3) {
        this.previousPosition.set((Tuple3d)this.position);
        this.position.set(d, d2, d3);
    }

    public void getPosition(Tuple3d tuple3d) {
        tuple3d.set((Tuple3d)this.position);
    }

    public void getPreviousPosition(Tuple3d tuple3d) {
        tuple3d.set((Tuple3d)this.previousPosition);
    }

    public double getPositionX() {
        return this.position.x;
    }

    public double getPositionY() {
        return this.position.y;
    }

    public double getPositionZ() {
        return this.position.z;
    }

    public void getColor(Color4f color4f) {
        color4f.set((Tuple4f)this.color);
    }

    public float getColorRed() {
        return this.color.x;
    }

    public float getColorGreen() {
        return this.color.y;
    }

    public float getColorBlue() {
        return this.color.z;
    }

    public float getColorAlpha() {
        return this.color.w;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
    }

    public void setAlpha(float f) {
        this.color.w = f;
    }

    public double getWidth() {
        return 0.2;
    }

    public double getHeight() {
        return 0.2;
    }

    public double getDepth() {
        return 0.2;
    }

    public Bounds getBounds() {
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.getDepth();
        this.boundingBox.setLower(this.position.x - d, this.position.y - d2, this.position.z - d3);
        this.boundingBox.setUpper(this.position.x + d, this.position.y + d2, this.position.z + d3);
        return this.boundingBox;
    }

    public void incAge() {
        ++this.totalAge;
        ++this.cycleAge;
    }

    public long getTotalAge() {
        return this.totalAge;
    }

    public int getCycleAge() {
        return this.cycleAge;
    }

    public void setCycleAge(int n) {
        this.cycleAge = n;
    }
}

