/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.j3d.Node;
import org.j3d.geom.particle.MovementFunction;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleFactory;
import org.j3d.geom.particle.ParticleInitializer;

public abstract class ParticleSystem
implements ParticleFactory {
    public static final String PARTICLE_TEXTURE = "texture";
    private int systemType;
    protected List particles;
    protected int particleCount;
    protected List movementFunctions = new ArrayList();
    protected ParticleInitializer particleInitializer = null;
    protected ParticleFactory particleFactory = null;
    protected boolean running = false;
    protected Map environment;

    public ParticleSystem(int n, Map map) {
        this.systemType = n;
        this.environment = new HashMap(map);
        this.particleFactory = this;
    }

    protected void createParticles(ParticleInitializer particleInitializer, int n) {
        this.particleCount = n;
        this.particleInitializer = particleInitializer;
        this.particles = new ArrayList();
        int n2 = 0;
        while (n2 < n) {
            Particle particle = this.particleFactory.createParticle(n2);
            this.initParticle(particle);
            this.particles.add(n2, particle);
            ++n2;
        }
    }

    public void setParticleInitializer(ParticleInitializer particleInitializer) {
        this.particleInitializer = particleInitializer;
    }

    public boolean updateParticle(int n, Particle particle) {
        if (this.particleInitializer.isAlive(particle)) {
            MovementFunction movementFunction = null;
            int n2 = this.movementFunctions.size() - 1;
            while (n2 >= 0) {
                movementFunction = (MovementFunction)this.movementFunctions.get(n2);
                this.running |= movementFunction.apply(particle);
                --n2;
            }
        } else {
            this.running |= this.particleInitializer.initialize(particle);
        }
        return this.running;
    }

    public void initParticle(Particle particle) {
        this.particleInitializer.initialize(particle);
    }

    public void addMovementFunction(MovementFunction movementFunction) {
        this.movementFunctions.add(movementFunction);
    }

    public abstract boolean update();

    public abstract Node getNode();

    public abstract Particle createParticle(int var1);
}

