/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.Map;
import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color4f;
import org.j3d.geom.particle.ByRefParticleSystem;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleInitializer;
import org.j3d.geom.particle.QuadArrayByRefParticle;

public class QuadArrayByRefParticleSystem
extends ByRefParticleSystem {
    public static final int QUAD_ARRAY_BYREF_PARTICLE_SYSTEM = 1;
    private static PolygonAttributes polygonAttributes = new PolygonAttributes(2, 0, 0.0f);
    private static TransparencyAttributes transparencyAttributes = new TransparencyAttributes(1, 0.0f);
    private static TextureAttributes textureAttributes = new TextureAttributes(5, new Transform3D(), new Color4f(), 0);

    public QuadArrayByRefParticleSystem(int n, ParticleInitializer particleInitializer, Map map) {
        super(1, particleInitializer, n, map);
    }

    public GeometryArray createGeometryArray() {
        QuadArray quadArray = new QuadArray(this.particleCount * 4, 175);
        return quadArray;
    }

    public Appearance createAppearance() {
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(polygonAttributes);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setTextureAttributes(textureAttributes);
        Object v = this.environment.get("texture");
        Texture texture = null;
        if (!(v instanceof String) && v instanceof Texture) {
            texture = (Texture)v;
        }
        appearance.setTexture(texture);
        return appearance;
    }

    public Particle createParticle(int n) {
        return new QuadArrayByRefParticle(this.shape, n, this.positionRefArray, this.colorRefArray, this.textureCoordRefArray, this.normalRefArray);
    }

    protected int getVertexCount() {
        return 4;
    }
}

