/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.spline;

import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class NurbsPatchGenerator
extends GeometryGenerator {
    private static final int DEFAULT_FACETS = 16;
    private int facetCount;
    private float[][] knotCoordinates;
    private float[] patchCoordinates;
    private int numPatchValues;
    private boolean patchChanged;

    public NurbsPatchGenerator() {
    }

    public NurbsPatchGenerator(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        this.patchChanged = true;
        this.facetCount = n;
    }

    public void setFacetCount(int n) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of facets is < 3");
        }
        if (this.facetCount != n) {
            this.patchChanged = true;
        }
        this.facetCount = n;
    }

    public void setPatchKnots(float[][] fArray) {
        int n = fArray[0].length;
        if (fArray.length < 3 || fArray[0].length < 3) {
            throw new IllegalArgumentException("Depth patch size < 3");
        }
        int n2 = 1;
        while (n2 < fArray.length) {
            if (fArray[n2].length != n) {
                throw new IllegalArgumentException("Non-equal array lengths");
            }
            ++n2;
        }
        if (fArray.length != this.knotCoordinates.length && n != this.knotCoordinates[0].length) {
            if (fArray.length != this.knotCoordinates.length) {
                this.knotCoordinates = new float[fArray.length][n];
            } else {
                n2 = 0;
                while (n2 < fArray.length) {
                    this.knotCoordinates[n2] = new float[n];
                    ++n2;
                }
            }
        }
        n2 = 0;
        while (n2 < fArray.length) {
            System.arraycopy(fArray[n2], 0, this.knotCoordinates[n2], 0, n);
            ++n2;
        }
        this.patchChanged = true;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 1: {
                n = this.facetCount * this.facetCount * 3;
                break;
            }
            case 2: {
                n = this.facetCount * this.facetCount * 4;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n = this.facetCount * this.facetCount;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regeneratePatch();
    }

    private void generateIndexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regeneratePatch();
    }

    private void generateUnindexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
    }

    private void generateIndexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
    }

    private void generateTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private final void regeneratePatch() {
        if (!this.patchChanged) {
            return;
        }
        this.patchChanged = false;
        this.numPatchValues = (this.facetCount + 1 << 1) * 3;
        if (this.patchCoordinates == null || this.numPatchValues > this.patchCoordinates.length) {
            this.patchCoordinates = new float[this.numPatchValues];
        }
    }
}

