/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders;

import java.awt.Rectangle;
import javax.media.j3d.Texture;
import javax.vecmath.Point2d;
import org.j3d.loaders.HeightMapLoader;
import org.j3d.terrain.TerrainData;

public class HeightMapTerrainData
implements TerrainData {
    private float[][] heightMap;
    private Point2d gridStep;
    private Texture texture = null;
    private boolean hasTiledTextures;
    private final int gridWidth;
    private final int gridDepth;

    public HeightMapTerrainData(HeightMapLoader heightMapLoader) {
        this.heightMap = heightMapLoader.getHeights();
        this.gridStep = heightMapLoader.getGridStep();
        this.hasTiledTextures = false;
        this.gridDepth = this.heightMap.length;
        this.gridWidth = this.heightMap[0].length;
    }

    public HeightMapTerrainData(float[][] fArray, boolean bl, Point2d point2d) {
        if (bl) {
            int n = fArray.length;
            int n2 = fArray[0].length;
            this.heightMap = new float[n][n2];
            int n3 = 0;
            while (n3 < n) {
                System.arraycopy(fArray[n3], 0, this.heightMap[n3], 0, n2);
                ++n3;
            }
            this.gridDepth = n;
            this.gridWidth = n2;
        } else {
            this.heightMap = fArray;
            this.gridDepth = this.heightMap.length;
            this.gridWidth = this.heightMap[0].length;
        }
        this.gridStep = new Point2d(point2d);
        this.hasTiledTextures = false;
    }

    public float getHeight(float f, float f2) {
        float f3 = f / (float)this.gridStep.x;
        float f4 = f2 / (float)this.gridStep.y;
        int n = (int)Math.floor(f3);
        int n2 = (int)Math.floor(f4);
        if (n < 0 || n2 < 0 || n + 1 >= this.gridWidth || n2 + 1 >= this.gridDepth) {
            return Float.NaN;
        }
        float f5 = this.heightMap[n][n2];
        float f6 = this.heightMap[n][n2 + 1];
        float f7 = this.heightMap[n + 1][n2];
        float f8 = this.heightMap[n + 1][n2 + 1];
        return (f5 + f6 + f7 + f8) * 0.25f;
    }

    public void getCoordinate(float[] fArray, int n, int n2) {
        fArray[0] = (float)n * (float)this.gridStep.x;
        fArray[1] = this.heightMap[n][n2];
        fArray[2] = (float)(-n2) * (float)this.gridStep.y;
    }

    public void getCoordinateWithTexture(float[] fArray, float[] fArray2, int n, int n2) {
        fArray[0] = (float)n * (float)this.gridStep.x;
        fArray[1] = this.heightMap[n][n2];
        fArray[2] = (float)(-n2) * (float)this.gridStep.y;
        if (!this.hasTiledTextures) {
            fArray2[0] = (float)n / (float)this.heightMap[0].length;
            fArray2[1] = (float)n2 / (float)this.heightMap.length;
        }
    }

    public void getCoordinateWithColor(float[] fArray, float[] fArray2, int n, int n2) {
        fArray[0] = (float)n * (float)this.gridStep.x;
        fArray[1] = this.heightMap[n][n2];
        fArray[2] = (float)(-n2) * (float)this.gridStep.y;
        fArray2[0] = 0.0f;
        fArray2[1] = 0.5f;
        fArray2[2] = 0.0f;
    }

    public boolean hasTexture() {
        return this.texture != null;
    }

    public void setTiledTextures(boolean bl) {
        this.hasTiledTextures = bl;
    }

    public boolean isTiledTextures() {
        return this.hasTiledTextures;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public Texture getTexture(Rectangle rectangle) {
        return this.texture;
    }

    public float getHeightFromGrid(int n, int n2) {
        return this.heightMap[n][n2];
    }

    public int getGridWidth() {
        return this.heightMap[0].length;
    }

    public int getGridDepth() {
        return this.gridDepth;
    }

    public double getGridXStep() {
        return this.gridStep.x;
    }

    public double getGridYStep() {
        return this.gridStep.y;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }
}

