/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d.parser;

import java.io.BufferedReader;
import java.io.IOException;
import org.j3d.loaders.ac3d.parser.LineTokenizer;
import org.j3d.loaders.ac3d.parser.TokenHandler;
import org.j3d.loaders.ac3d.parser.exceptions.IncompatibleTokenHandlerException;

public class Ac3dParser {
    public static final String HEADER_PREAMBLE = "AC3D";
    public static final int SUPPORTED_FORMAT_VERSION = 11;
    private BufferedReader bufferedReader;
    private TokenHandler tokenHandler;

    public void parse() {
        try {
            String string;
            this.primeHeader();
            this.tokenHandler.reset();
            while ((string = this.bufferedReader.readLine()) != null) {
                String[] stringArray = LineTokenizer.enumerateTokens(string);
                this.tokenHandler.handle(stringArray);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
        }
    }

    private void primeHeader() throws IOException {
        String string = this.bufferedReader.readLine();
        if (string.length() < 5) {
            System.out.println("AC3D data stream header too short.");
            throw new RuntimeException();
        }
        if (string.substring(0, 3).equals(HEADER_PREAMBLE)) {
            System.out.println("Data stream did not contain the preamble.");
            throw new RuntimeException();
        }
        int n = Integer.valueOf(string.substring(4, string.length()), 16);
        if (n > 11) {
            System.out.println("Format version in data stream grater than supported.");
            throw new RuntimeException();
        }
    }

    public void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    public void setTokenHandler(TokenHandler tokenHandler) throws IncompatibleTokenHandlerException {
        if (tokenHandler.getVersion() > 11) {
            throw new IncompatibleTokenHandlerException("TokenHandler not compatible");
        }
        this.tokenHandler = tokenHandler;
    }
}

