/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.vterrain;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point2d;
import org.j3d.geom.GeometryData;
import org.j3d.geom.terrain.ElevationGridGenerator;
import org.j3d.loaders.HeightMapLoader;
import org.j3d.loaders.vterrain.BTHeader;
import org.j3d.loaders.vterrain.BTParser;

public class BTLoader
extends HeightMapLoader {
    private BufferedInputStream input;
    private BTParser parser;
    private ElevationGridGenerator generator;
    private Point2d gridStepData;

    public BTLoader() {
    }

    public BTLoader(int n) {
        super(n);
    }

    public Scene load(Reader reader) throws IncorrectFormatException {
        throw new IncorrectFormatException("Loader only handles binary data");
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException("File is a directory");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.input = new BufferedInputStream(fileInputStream);
        return this.load();
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        try {
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            this.input = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        return this.load();
    }

    private Scene load() throws IncorrectFormatException, ParsingErrorException {
        float[][] fArray = null;
        try {
            if (this.parser == null) {
                this.parser = new BTParser(this.input);
            } else {
                this.parser.reset(this.input);
            }
            fArray = this.parser.parse();
            this.input = null;
        }
        catch (IOException iOException) {
            throw new ParsingErrorException("Error parsing stream: " + iOException);
        }
        BTHeader bTHeader = this.parser.getHeader();
        float f = (float)(bTHeader.rightExtent - bTHeader.leftExtent);
        float f2 = (float)(bTHeader.topExtent - bTHeader.bottomExtent);
        this.gridStepData = new Point2d((double)(f / (float)bTHeader.rows), (double)(f2 / (float)bTHeader.columns));
        if (this.generator == null) {
            this.generator = new ElevationGridGenerator(f, f2, bTHeader.rows, bTHeader.columns, fArray, 0.0f);
        } else {
            this.generator.setDimensions(f, f2, bTHeader.rows, bTHeader.columns);
            this.generator.setTerrainDetail(fArray, 0.0f);
        }
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 3;
        geometryData.geometryComponents = 6;
        this.generator.generate(geometryData);
        SceneBase sceneBase = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        int n = 35;
        TriangleStripArray triangleStripArray = new TriangleStripArray(geometryData.vertexCount, n, geometryData.stripCounts);
        triangleStripArray.setCoordinates(0, geometryData.coordinates);
        triangleStripArray.setNormals(0, geometryData.normals);
        triangleStripArray.setTextureCoordinates(0, geometryData.textureCoordinates);
        Appearance appearance = new Appearance();
        Shape3D shape3D = new Shape3D((Geometry)triangleStripArray, appearance);
        branchGroup.addChild((Node)shape3D);
        sceneBase.setSceneGroup(branchGroup);
        return sceneBase;
    }

    public BTHeader getHeader() {
        return this.parser.getHeader();
    }

    public float[][] getHeights() {
        return this.parser.getHeights();
    }

    public Point2d getGridStep() {
        return this.gridStepData;
    }
}

