/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain;

import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import org.j3d.terrain.Canvas3DFrustum;

public class ViewFrustum {
    private Point4d[] frustumPoints;
    private Canvas3D[] canvases;
    private Canvas3DFrustum[] frustums;
    private Transform3D leftInverseProjection;
    private Transform3D rightInverseProjection;
    private Vector3d tVec1;
    private Vector3d tVec2;
    private Vector3d tVec3;
    private Matrix4d tMatrix;
    private Point3d tmpP1 = new Point3d();
    private Point3d tmpP2 = new Point3d();
    private Point3d tmpP3 = new Point3d();
    public static final int IN = 1;
    public static final int OUT = 2;
    public static final int CLIPPED = 4;

    public ViewFrustum(Canvas3D canvas3D) {
        this.canvases = new Canvas3D[1];
        this.canvases[0] = canvas3D;
        this.init();
    }

    public ViewFrustum(Canvas3D[] canvas3DArray) {
        this.canvases = canvas3DArray;
        this.init();
    }

    public void viewingPlatformMoved() {
        int n = 0;
        while (n < this.canvases.length) {
            this.computeFrustumPlanes(n);
            ++n;
        }
    }

    public int isTriangleInFrustum(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.tmpP1.set((double)f, (double)f2, (double)f3);
        this.tmpP2.set((double)f4, (double)f5, (double)f6);
        this.tmpP3.set((double)f7, (double)f8, (double)f9);
        return this.isTriangleInFrustum(this.tmpP1, this.tmpP2, this.tmpP3);
    }

    public int isTriangleInFrustum(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        int n = 0;
        while (n < this.frustums.length) {
            if (this.frustums[n].isTriangleInFrustum(point3d, point3d2, point3d3) != 2) {
                return 1;
            }
            ++n;
        }
        return 2;
    }

    public int isPointInFrustum(Point3d point3d) {
        int n = 0;
        while (n < this.frustums.length) {
            if (this.frustums[n].isPointInFrustum(point3d)) {
                return 1;
            }
            ++n;
        }
        return 2;
    }

    private void init() {
        this.tMatrix = new Matrix4d();
        this.tVec1 = new Vector3d();
        this.tVec2 = new Vector3d();
        this.tVec3 = new Vector3d();
        this.tmpP1 = new Point3d();
        this.tmpP2 = new Point3d();
        this.tmpP3 = new Point3d();
        this.leftInverseProjection = new Transform3D();
        this.rightInverseProjection = new Transform3D();
        this.frustumPoints = new Point4d[8];
        this.frustumPoints[0] = new Point4d();
        this.frustumPoints[1] = new Point4d();
        this.frustumPoints[2] = new Point4d();
        this.frustumPoints[3] = new Point4d();
        this.frustumPoints[4] = new Point4d();
        this.frustumPoints[5] = new Point4d();
        this.frustumPoints[6] = new Point4d();
        this.frustumPoints[7] = new Point4d();
        this.frustums = new Canvas3DFrustum[this.canvases.length];
        int n = 0;
        while (n < this.frustums.length) {
            this.frustums[n] = new Canvas3DFrustum();
            ++n;
        }
    }

    private void computeFrustumPlanes(int n) {
        this.frustumPoints[0].set(-1.0, -1.0, 1.0, 1.0);
        this.frustumPoints[1].set(-1.0, 1.0, 1.0, 1.0);
        this.frustumPoints[2].set(1.0, 1.0, 1.0, 1.0);
        this.frustumPoints[3].set(1.0, -1.0, 1.0, 1.0);
        this.frustumPoints[4].set(-1.0, -1.0, -1.0, 1.0);
        this.frustumPoints[5].set(-1.0, 1.0, -1.0, 1.0);
        this.frustumPoints[6].set(1.0, 1.0, -1.0, 1.0);
        this.frustumPoints[7].set(1.0, -1.0, -1.0, 1.0);
        this.canvases[n].getInverseVworldProjection(this.leftInverseProjection, this.rightInverseProjection);
        this.leftInverseProjection.get(this.tMatrix);
        int n2 = 0;
        while (n2 < this.frustumPoints.length) {
            this.tMatrix.transform((Tuple4d)this.frustumPoints[n2]);
            double d = 1.0 / this.frustumPoints[n2].w;
            this.frustumPoints[n2].x *= d;
            this.frustumPoints[n2].y *= d;
            this.frustumPoints[n2].z *= d;
            ++n2;
        }
        this.computePlaneEq(this.frustumPoints[0], this.frustumPoints[4], this.frustumPoints[5], this.frustumPoints[1], this.frustums[n].frustumPlanes[0]);
        this.computePlaneEq(this.frustumPoints[3], this.frustumPoints[2], this.frustumPoints[6], this.frustumPoints[7], this.frustums[n].frustumPlanes[1]);
        this.computePlaneEq(this.frustumPoints[1], this.frustumPoints[5], this.frustumPoints[6], this.frustumPoints[2], this.frustums[n].frustumPlanes[2]);
        this.computePlaneEq(this.frustumPoints[0], this.frustumPoints[3], this.frustumPoints[7], this.frustumPoints[4], this.frustums[n].frustumPlanes[3]);
        this.computePlaneEq(this.frustumPoints[0], this.frustumPoints[1], this.frustumPoints[2], this.frustumPoints[3], this.frustums[n].frustumPlanes[4]);
        this.computePlaneEq(this.frustumPoints[4], this.frustumPoints[7], this.frustumPoints[6], this.frustumPoints[5], this.frustums[n].frustumPlanes[5]);
    }

    private void computePlaneEq(Point4d point4d, Point4d point4d2, Point4d point4d3, Point4d point4d4, Vector4d vector4d) {
        this.tVec1.x = point4d3.x - point4d.x;
        this.tVec1.y = point4d3.y - point4d.y;
        this.tVec1.z = point4d3.z - point4d.z;
        this.tVec2.x = point4d2.x - point4d.x;
        this.tVec2.y = point4d2.y - point4d.y;
        this.tVec2.z = point4d2.z - point4d.z;
        this.tVec3.cross(this.tVec2, this.tVec1);
        this.tVec3.normalize();
        vector4d.x = this.tVec3.x;
        vector4d.y = this.tVec3.y;
        vector4d.z = this.tVec3.z;
        vector4d.w = -(vector4d.x * point4d.x + vector4d.y * point4d.y + vector4d.z * point4d.z);
    }
}

