/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.ViewFrustum;
import org.j3d.terrain.roam.QueueManager;
import org.j3d.terrain.roam.TreeNode;
import org.j3d.terrain.roam.VarianceTree;
import org.j3d.terrain.roam.VertexData;

class Patch
implements GeometryUpdater {
    private final int PATCH_SIZE;
    TreeNode NWTree;
    TreeNode SETree;
    private VarianceTree NWVariance;
    private VarianceTree SEVariance;
    private Shape3D shape3D;
    private int xOrig;
    private int yOrig;
    private TerrainData terrainData;
    private Patch westPatchNeighbour;
    private Patch southPatchNeighbour;
    private VertexData vertexData;
    private TriangleArray geom;
    private float maxY;
    private float minY;

    Patch(TerrainData terrainData, int n, int n2, int n3, Appearance appearance, ViewFrustum viewFrustum, Patch patch, Patch patch2) {
        int n4 = n3 + n;
        int n5 = n2 + n;
        this.xOrig = n2;
        this.yOrig = n3;
        this.PATCH_SIZE = n;
        this.terrainData = terrainData;
        this.westPatchNeighbour = patch;
        this.southPatchNeighbour = patch2;
        boolean bl = appearance.getTexture() != null;
        this.vertexData = new VertexData(this.PATCH_SIZE, bl);
        int n6 = 129;
        n6 = bl ? (n6 |= 0x20) : (n6 |= 4);
        this.geom = new TriangleArray(this.PATCH_SIZE * this.PATCH_SIZE * 2 * 3, n6);
        this.geom.setCapability(19);
        this.geom.setCapability(20);
        this.geom.setCoordRefFloat(this.vertexData.getCoords());
        if (bl) {
            this.geom.setTexCoordRefFloat(0, this.vertexData.getTextureCoords());
        } else {
            this.geom.setColorRefByte(this.vertexData.getColors());
        }
        this.NWVariance = new VarianceTree(terrainData, this.PATCH_SIZE, n2, n3, n5, n4, n2, n4);
        this.NWTree = new TreeNode(n2, n3, n5, n4, n2, n4, 1, terrainData, viewFrustum, -1, 1, this.NWVariance);
        this.SEVariance = new VarianceTree(terrainData, this.PATCH_SIZE, n5, n4, n2, n3, n5, n3);
        this.SETree = new TreeNode(n5, n4, n2, n3, n5, n3, 1, terrainData, viewFrustum, -1, 1, this.SEVariance);
        this.maxY = Math.max(this.NWVariance.getMaxY(), this.SEVariance.getMaxY());
        this.minY = Math.min(this.NWVariance.getMinY(), this.SEVariance.getMinY());
        this.NWTree.baseNeighbour = this.SETree;
        this.SETree.baseNeighbour = this.NWTree;
        if (patch != null) {
            this.NWTree.leftNeighbour = patch.SETree;
            patch.SETree.leftNeighbour = this.NWTree;
        }
        if (patch2 != null) {
            this.SETree.rightNeighbour = patch2.NWTree;
            patch2.NWTree.rightNeighbour = this.SETree;
        }
        Point3d point3d = new Point3d((double)n2 * terrainData.getGridXStep(), (double)this.minY, (double)(-(n3 + n4)) * terrainData.getGridYStep());
        Point3d point3d2 = new Point3d((double)(n2 + n5) * terrainData.getGridXStep(), (double)this.maxY, (double)(-n3) * terrainData.getGridYStep());
        this.shape3D = new Shape3D((Geometry)this.geom, appearance);
        this.shape3D.setBoundsAutoCompute(false);
        this.shape3D.setBounds((Bounds)new BoundingBox(point3d, point3d2));
        this.shape3D.setUserData((Object)terrainData);
    }

    public void updateData(Geometry geometry) {
        this.createGeometry((TriangleArray)geometry);
    }

    void reset(ViewFrustum viewFrustum) {
        this.NWTree.reset(viewFrustum);
        this.SETree.reset(viewFrustum);
        this.NWTree.baseNeighbour = this.SETree;
        this.SETree.baseNeighbour = this.NWTree;
        if (this.westPatchNeighbour != null) {
            this.NWTree.leftNeighbour = this.westPatchNeighbour.SETree;
            this.westPatchNeighbour.SETree.leftNeighbour = this.NWTree;
        }
        if (this.southPatchNeighbour != null) {
            this.SETree.rightNeighbour = this.southPatchNeighbour.NWTree;
            this.southPatchNeighbour.NWTree.rightNeighbour = this.SETree;
        }
    }

    void setView(Tuple3f tuple3f, ViewFrustum viewFrustum, QueueManager queueManager) {
        this.NWTree.updateTree(tuple3f, viewFrustum, this.NWVariance, -1, queueManager);
        this.SETree.updateTree(tuple3f, viewFrustum, this.SEVariance, -1, queueManager);
    }

    void updateGeometry() {
        if (this.NWTree.visible != 2 || this.SETree.visible != 2 || this.vertexData.getVertexCount() != 0) {
            this.geom.updateData((GeometryUpdater)this);
        }
    }

    int getTriangleCount() {
        return this.vertexData.getVertexCount() / 3;
    }

    Shape3D getShape3D() {
        return this.shape3D;
    }

    private void createGeometry(TriangleArray triangleArray) {
        this.vertexData.reset();
        if (this.NWTree.visible != 2) {
            this.NWTree.getTriangles(this.vertexData);
        }
        if (this.SETree.visible != 2) {
            this.SETree.getTriangles(this.vertexData);
        }
        triangleArray.setValidVertexCount(this.vertexData.getVertexCount());
    }
}

