/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.terrain.Landscape;
import org.j3d.terrain.TerrainData;
import org.j3d.terrain.ViewFrustum;
import org.j3d.terrain.roam.Patch;
import org.j3d.terrain.roam.TreeNode;
import org.j3d.terrain.roam.TreeQueueManager;

public class SplitMergeLandscape
extends Landscape {
    static final int PATCH_SIZE = 64;
    private ArrayList patches = new ArrayList();
    private TreeQueueManager queueManager = new TreeQueueManager();
    private int triCount = 0;

    public SplitMergeLandscape(ViewFrustum viewFrustum, TerrainData terrainData) {
        super(viewFrustum, terrainData);
        this.createPatches();
    }

    public void setView(Tuple3f tuple3f, Vector3f vector3f) {
        this.queueManager.clear();
        this.landscapeView.viewingPlatformMoved();
        float f = (float)Math.toRadians(0.1);
        int n = this.patches.size();
        int n2 = 0;
        while (n2 < n) {
            Patch patch = (Patch)this.patches.get(n2);
            patch.setView(tuple3f, this.landscapeView, this.queueManager);
            ++n2;
        }
        boolean bl = false;
        while (!bl) {
            TreeNode treeNode = this.queueManager.getSplitCandidate();
            TreeNode treeNode2 = this.queueManager.getMergeCandidate();
            if (treeNode2 == null && treeNode != null) {
                if (treeNode.variance > f) {
                    this.triCount += treeNode.split(tuple3f, this.landscapeView, this.queueManager);
                    continue;
                }
                bl = true;
                continue;
            }
            if (treeNode2 != null && treeNode == null) {
                if (treeNode2.diamondVariance < f) {
                    this.triCount -= treeNode2.merge(this.queueManager);
                    continue;
                }
                bl = true;
                continue;
            }
            if (treeNode2 != null && treeNode != null && (treeNode.variance > f || treeNode.variance > treeNode2.diamondVariance)) {
                if (treeNode.variance > f) {
                    this.triCount += treeNode.split(tuple3f, this.landscapeView, this.queueManager);
                    continue;
                }
                if (!(treeNode2.diamondVariance < f)) continue;
                this.triCount -= treeNode2.merge(this.queueManager);
                continue;
            }
            bl = true;
        }
        int n3 = 0;
        while (n3 < n) {
            Patch patch = (Patch)this.patches.get(n3);
            patch.updateGeometry();
            ++n3;
        }
    }

    private void createPatches() {
        int n = this.terrainData.getGridDepth() - 64;
        int n2 = this.terrainData.getGridWidth() - 64;
        Appearance appearance = new Appearance();
        appearance.setTexture(this.terrainData.getTexture());
        Material material = new Material();
        material.setLightingEnable(true);
        appearance.setMaterial(material);
        Patch[] patchArray = new Patch[n2];
        Patch patch = null;
        Patch patch2 = null;
        int n3 = 0;
        while (n3 <= n2) {
            int n4 = 0;
            while (n4 <= n) {
                patch2 = new Patch(this.terrainData, 64, n3, n4, appearance, this.landscapeView, patchArray[n4 / 64], patch);
                this.patches.add(patch2);
                this.triCount += 2;
                this.addChild((Node)patch2.getShape3D());
                patch = patch2;
                patchArray[n4 / 64] = patch2;
                n4 += 64;
            }
            patch = null;
            n3 += 64;
        }
    }
}

